<?php
    $note = __("#siteName may send you communications, you may change your preferences in your account settings. We'll never post without your permission.");
    $welcomeText = __('Welcome back #name!');
    $termOfUse = '<a target="_blank" href="/terms-of-service-n5.html">' . __('Terms of Use') . '</a>';
    $privacyPolicy = '<a target="_blank" href="/privacy-policy-n13.html">' . __('Privacy Policy') . '</a>';
    $policyTextRegister = str_replace("#name", config("app.name"), __("By clicking Register, you agree to #name's #term and #privacyPolicy."));
    $policyTextContinue = str_replace("#name", config("app.name"), __("By clicking Continue, you agree to #name's #term and #privacyPolicy."));
    $policyTextRegister = str_replace("#term", $termOfUse, $policyTextRegister);
    $policyTextRegister = str_replace("#privacyPolicy", $privacyPolicy, $policyTextRegister);
    $policyTextContinue = str_replace("#term", $termOfUse, $policyTextContinue);
    $policyTextContinue = str_replace("#privacyPolicy", $privacyPolicy, $policyTextContinue);
?>
<div class="guest-popup-container" ng-show="isShowLoginModal">
    <div class="guest-popup-content">
        <div class="guest-popup-title">
            <span>{{ __('Go to checkout') }}</span>
            <label class="close-popup" for="guest-pop" ng-click="closeModalLogin()">
                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                    <path d="M18 6l-12 12" />
                    <path d="M6 6l12 12" />
                </svg>
            </label>
        </div>
        <div class="guest-popup-item @{{ !isSubmitEmail ? 'active' : '' }}" data-guest="your-account">
            <div class="guest-popup-button-wrap">
                <a class="guest-popup-button" href="{{ route('module::cart::checkout') }}">
                    {{ __('Continue as a guest')}}
                </a>
            </div>
            <div class="guest-or">
                <span>{{ __('OR')}}</span>
            </div>
            <div class="guest-popup-form">
                <div class="errorLogin">
                    @{{ errorLogin }}
                </div>
                <h3 class="guest-popup-subtitle">
                    {{ __('Sign in or register')}}
                </h3>
                <div class="guest-popup-gr">
                    <label for="email" class="guest-popup-label">
                        {{ __('Email address')}}
                    </label>
                    <input type="text" id="email" name="email" class="guest-popup-input" ng-model="emailLogin">
                </div>
                <div class="guest-popup-button-contain">
                    <div id="aria-privacy-policy" class="privacy-policy">
                        {!! $policyTextContinue !!}
                    </div>
                    <button type="button" class="guest-popup-button-submit" ng-click="continueLogin()">
                        {{ __('Continue')}}
                    </button>
                </div>
                <div class="guest-or login-with">
                    <span>{{ __('or login with')}}</span>
                </div>
                <div class="guest-popup-button-social">
                    <a class="guest-popup-button-social-item guest-popup-button-google" href="{{ route('user:google:login') }}?continue=<?= route('module::cart::checkout') ?>">
                        <svg width="22" height="22" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
                            <path fill="#EA4335" d="M24 9.5c3.54 0 6.71 1.22 9.21 3.6l6.85-6.85C35.9 2.38 30.47 0 24 0 14.62 0 6.51 5.38 2.56 13.22l7.98 6.19C12.43 13.72 17.74 9.5 24 9.5z" />
                            <path fill="#4285F4" d="M46.98 24.55c0-1.57-.15-3.09-.38-4.55H24v9.02h12.94c-.58 2.96-2.26 5.48-4.78 7.18l7.73 6c4.51-4.18 7.09-10.36 7.09-17.65z" />
                            <path fill="#FBBC05" d="M10.53 28.59c-.48-1.45-.76-2.99-.76-4.59s.27-3.14.76-4.59l-7.98-6.19C.92 16.46 0 20.12 0 24c0 3.88.92 7.54 2.56 10.78l7.97-6.19z" />
                            <path fill="#34A853" d="M24 48c6.48 0 11.93-2.13 15.89-5.81l-7.73-6c-2.15 1.45-4.92 2.3-8.16 2.3-6.26 0-11.57-4.22-13.47-9.91l-7.98 6.19C6.51 42.62 14.62 48 24 48z" />
                            <path fill="none" d="M0 0h48v48H0z" />
                        </svg>
                        <span>{{ __('Google')}}</span>
                    </a>
                    <a class="guest-popup-button-social-item guest-popup-button-facebook" href="{{ route('user:facebook:login') }}?continue=<?= route('module::cart::checkout') ?>">
                        <svg width="22" height="22" viewBox="0 0 27 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_7)">
                                <path d="M26.5 13.0795C26.5 5.85586 20.6797 0 13.5 0C6.32029 0 0.5 5.85586 0.5 13.0795C0.5 19.6078 5.25391 25.0188 11.4688 26V16.8602H8.16798V13.0795H11.4688V10.1979C11.4688 6.91984 13.4096 5.10917 16.379 5.10917C17.8014 5.10917 19.2891 5.36462 19.2891 5.36462V8.58339H17.6498C16.0349 8.58339 15.5313 9.59161 15.5313 10.626V13.0795H19.1367L18.5604 16.8602H15.5312V26C21.7461 25.0188 26.5 19.6078 26.5 13.0795" fill="#1877F2" />
                            </g>
                            <clipPath id="clip0_1_7">
                                <rect width="26" height="26" fill="white" transform="translate(0.5)" />
                            </clipPath>
                        </svg>
                        <span>{{ __('Facebook')}}</span>
                    </a>
                </div>
                <div class="guest-popup-subtext">
                    {{ str_replace('#siteName', config('app.name'), $note) }}
                </div>
            </div>
        </div>
        <div class="guest-popup-item @{{ isSubmitEmail && !isRegister ? 'active' : '' }}" data-guest="guest-signin">
            <div class="guest-avatar-contain">
                <div class="guest-avatar-image">
                    <img src="{{ asset('/modules/cart/images/avatar.png') }}" alt="avatar">
                </div>
                <div class="guest-avatar-info">
                    <small>@{{ emailLogin }}</small>
                    <div class="back-guest" ng-click="changeEmailLogin()">
                        {{ __('Use a different email address.') }}
                    </div>
                </div>
            </div>
            <div class="guest-popup-form">
                <div class="errorLogin">
                    @{{ errorLogin }}
                </div>
                <h3 class="guest-popup-subtitle">
                    {{ __('Create your account')}}
                </h3>
                <div class="guest-popup-gr">
                    <label for="first_name" class="guest-popup-label">
                        {{ __('Name')}}
                    </label>
                    <input type="text" id="first_name" name="first_name" class="guest-popup-input" ng-model="firstNameLogin">
                </div>
                <div class="guest-popup-gr">
                    <label for="password" class="guest-popup-label">
                        {{ __('Password')}}
                    </label>
                    <input type="password" id="password" name="password" class="guest-popup-input" ng-model="passLogin">
                </div>
                <div class="guest-popup-gr">
                    <label for="password" class="guest-popup-label">
                        {{ __('Confirm password')}}
                    </label>
                    <input type="password" id="password" name="password" class="guest-popup-input" ng-model="cfPassLogin">
                </div>
                <div class="guest-popup-button-contain">
                    <div id="aria-privacy-policy" class="privacy-policy">
                        {!! $policyTextRegister !!}
                    </div>
                    <button type="button" class="guest-popup-button-submit" ng-click="signUp()">
                        {{ __('Register')}}
                    </button>
                    <small>
                        {{ str_replace('#siteName', config('app.name'), $note) }}
                    </small>
                </div>
            </div>
        </div>
        <div class="guest-popup-item @{{ isSubmitEmail && isRegister ? 'active' : '' }}" data-guest="create-account">
            <div class="guest-avatar-contain">
                <div class="guest-avatar-image">
                    <img src="{{ asset('/modules/cart/images/avatar.png') }}" alt="avatar">
                </div>
                <div class="guest-avatar-info">
                    <small>@{{ emailLogin }}</small>
                    <div class="back-guest" ng-click="changeEmailLogin()">
                        {{ __('Not your email? Go back.') }}
                    </div>
                </div>
            </div>
            <div class="guest-popup-form">
                <div class="errorLogin">
                    @{{ errorLogin }}
                </div>
                <h3 class="guest-popup-subtitle">
                    @{{ welcomeText.replace('#name', customerLogin.full_name ? customerLogin.full_name : customerLogin.email ) }}
                </h3>
                <div class="guest-popup-gr">
                    <label for="password" class="guest-popup-label">
                        {{ __('Password')}}
                    </label>
                    <input type="password" id="password" name="password" class="guest-popup-input" ng-model="passLogin">
                </div>
                <div class="guest-popup-button-exten">
                    <label class="form-check-label" for="stay-signin">
                        <input type="checkbox" id="stay-signin" class="form-check-input">
                        <span>
                            {{ __('Stay signed in')}}
                        </span>
                    </label>
                    <a href="/user/forgot-password" target="_blank" rel="noopener noreferrer">
                        {{ __('Forgot password?')}}
                    </a>
                </div>
                <div class="guest-popup-button-contain">
                    <button type="button" class="guest-popup-button-submit" ng-click="login()">
                        {{ __('Sign in')}}
                    </button>
                </div>
                <div class="guest-or">
                    <span>{{ __('OR') }}</span>
                </div>
                <div class="guest-popup-button-social">
                    <a class="guest-popup-button-social-item guest-popup-button-google" href="{{ route('user:google:login') }}?continue=<?= route('module::cart::checkout') ?>">
                        <svg width="22" height="22" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
                            <path fill="#EA4335" d="M24 9.5c3.54 0 6.71 1.22 9.21 3.6l6.85-6.85C35.9 2.38 30.47 0 24 0 14.62 0 6.51 5.38 2.56 13.22l7.98 6.19C12.43 13.72 17.74 9.5 24 9.5z" />
                            <path fill="#4285F4" d="M46.98 24.55c0-1.57-.15-3.09-.38-4.55H24v9.02h12.94c-.58 2.96-2.26 5.48-4.78 7.18l7.73 6c4.51-4.18 7.09-10.36 7.09-17.65z" />
                            <path fill="#FBBC05" d="M10.53 28.59c-.48-1.45-.76-2.99-.76-4.59s.27-3.14.76-4.59l-7.98-6.19C.92 16.46 0 20.12 0 24c0 3.88.92 7.54 2.56 10.78l7.97-6.19z" />
                            <path fill="#34A853" d="M24 48c6.48 0 11.93-2.13 15.89-5.81l-7.73-6c-2.15 1.45-4.92 2.3-8.16 2.3-6.26 0-11.57-4.22-13.47-9.91l-7.98 6.19C6.51 42.62 14.62 48 24 48z" />
                            <path fill="none" d="M0 0h48v48H0z" />
                        </svg>
                        <span>{{ __('Google')}}</span>
                    </a>
                    <a class="guest-popup-button-social-item guest-popup-button-facebook" href="{{ route('user:facebook:login') }}?continue=<?= route('module::cart::checkout') ?>">
                        <svg width="22" height="22" viewBox="0 0 27 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_7)">
                                <path d="M26.5 13.0795C26.5 5.85586 20.6797 0 13.5 0C6.32029 0 0.5 5.85586 0.5 13.0795C0.5 19.6078 5.25391 25.0188 11.4688 26V16.8602H8.16798V13.0795H11.4688V10.1979C11.4688 6.91984 13.4096 5.10917 16.379 5.10917C17.8014 5.10917 19.2891 5.36462 19.2891 5.36462V8.58339H17.6498C16.0349 8.58339 15.5313 9.59161 15.5313 10.626V13.0795H19.1367L18.5604 16.8602H15.5312V26C21.7461 25.0188 26.5 19.6078 26.5 13.0795" fill="#1877F2" />
                            </g>
                            <clipPath id="clip0_1_7">
                                <rect width="26" height="26" fill="white" transform="translate(0.5)" />
                            </clipPath>
                        </svg>
                        <span>{{ __('Facebook')}}</span>
                    </a>
                </div>
                <div class="guest-popup-subtext">
                    {{ str_replace('#siteName', config('app.name'), $note) }}
                </div>
                <!-- <div class="guest-popup-button-contain" ng-show="!isSubmitEmail">
                    <button type="button" class="guest-popup-sign-in">
                        {{ __('Email me a sign-in link')}}
                    </button>
                    <small>
                        {{ __("You won't lose checkout progress when you click the sign-in link.") }}
                    </small>
                    <small>
                        <a href="/help/article/18?ref=signin" class="wt-text-gray">{{ __("Trouble signing in?") }}</a>
                    </small>
                </div> -->
            </div>
        </div>
        <div class="guest-popup-change-step-loading" ng-show="loading">
            <div class="guest-popup-loader"></div>
        </div>
    </div>
    <label for="guest-pop" class="guest-popup-background"></label>
</div>