<div class="checkout-popup-wrapper" ng-show="currentProduct && currentProduct.id" ng-controller="MakeChangeController" style="display: none;">
    <div class="checkout-popup-content">
        <span class="close-update-item">
            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
        </span>
        <div class="checkout-popup-item flex-b">
            <a target="_blank" class="checkout-popup-item-link" href="@{{ getImageCdn(currentProduct.image_url) }}">
                <img ng-src="@{{ getImageCdn(currentProduct.image_url, 630, 630, true) }}" alt="" referrerpolicy="no-referrer">
            </a>
            <div class="checkout-popup-info">
                <div class="checkout-popup-item-head">
                    @{{ currentProduct.name }}
                </div>
                <div class="checkout-popup-update-item" ng-if="currentProduct && currentProduct.id">
                    <div class="flex-b align-c">
                        <div class="flex-b column" style="line-height: 1.2">
                            <span style="color: #C52C29; font-weight: 500;">
                                @{{ formatPrice(currentProduct.show_price) }}
                            </span>
                            <small style="color: #888; font-weight: 300; text-decoration:line-through" ng-if="currentProduct.high_price > currentProduct.price">
                                @{{ formatPrice(currentProduct.show_high_price) }}
                            </small>
                        </div>
                        <div class="checkout-quantity flex-b align-c">
                            <span>&times;</span>
                            <input class="checkout-control" type="text" ng-model="newItem.quantity" ng-disabled="originOrder" ng-change="changeQuantity()" ng-model-options="{ debounce: 500 }">
                        </div>
                        <div class="checkout-popup-update-subtotal" style="color: #C52C29; font-weight: 500; font-size: 1.1rem;">
                            @{{ formatPrice(getCurrentVariantTotalAmount(currentProduct), 0, false) }}
                        </div>
                    </div>
                    <div class="checkout-popup-variant-wrapper">
                        <sku-chosen 
                            id="js-btg-item-sku-chosen"
                            product-id="@{{ currentProduct.id }}" 
                            default-sku-id="@{{ currentVariant.id }}" 
                            choose-size-text="{{ __('Choose a size') }}" 
                            multiple-size="false"
                            api-url="{{ env('API_URL') }}"
                            auto-init="false"
                            default-overwrite-key=""
                            style-note-config = '{!! json_encode(getOption("product.style_note", []))  !!}'
                            women-text = "{{ __('women') }}"
                            print-location-data="currentVariant.printLocationData"
                            validate-choose-size="false"
                            ng-model="currentVariant"
                            ng-change="onChangeSku"
                            use-size-select="true"
                            class-prefix="sku-chosen__"
                            is-push-event="false"
                            enable-buy-more="false"
                        ></sku-chosen>
                    </div>
                    <div ng-show="currentProduct.is_valid_print_back">
                        @include('inc.product.components.print-location-options', [
                            'categoryIds' => 'currentProduct.category_ids', 
                            'isPushEvent' => false, 
                            'ngModel' => 'currentVariant.printLocationData',
                            'defaultPosition' => 'currentProduct.print_location',
                            'ngChange' => 'onChangePrintLocation',
                        ])
                    </div>
                </div>
            </div>
        </div>
        <div class="checkout-popup-action-wrapper flex-b align-c">
            <button class="btn update-product" type="button" ng-click="addItemToCart('update')" ng-disabled="loading" ng-show="currentProduct.variant_default.length == 0 || currentVariant.status == 'ACTIVE'">
                {{ __('Update item')}}
            </button>
            <button class="btn add-product" type="button" ng-click="addItemToCart()" ng-disabled="loading" ng-show="currentProduct.variant_default.length == 0 || currentVariant.status == 'ACTIVE'">
                {{ __('Add item')}}
            </button>
            <button id="js-checkout-cancel" class="btn light" type="button">
                {{ __('Cancel')}}
            </button>
        </div>
    </div>
    <span class="checkout-popup-background"></span>
</div>