<a class="mini-cart-link flex-b align-c flex-c" href="{{ clroute('/checkout') }}" id="mini-cart" rel="nofollow" aria-label="{{ __('View cart') }}">
    <span>
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-bag" viewBox="0 0 16 16">
            <path d="M8 1a2.5 2.5 0 0 1 2.5 2.5V4h-5v-.5A2.5 2.5 0 0 1 8 1zm3.5 3v-.5a3.5 3.5 0 1 0-7 0V4H1v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V4h-3.5zM2 5h12v9a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V5z"></path>
        </svg>
        <span class="js-mini-cart-count" style="display: none;"> 0 </span>
    </span>
</a>

<link rel="stylesheet" href="@asset('cart/css/mini-shopping.css')?v=<?= config('sa.version') ?>">

@section('js')
<script src="//js.stripe.com/v3/"></script>
<script>
    let isMobileHeader = false
    @mobile
        isMisMobileHeaderobile = true
    @endmobile
    var transactionFeeText = "{{ __('Transaction fee') }}";
    var betweenFromToText = "{{ __('#key between #from - #to') }}";
    var shippingFeeText = "{{ __('Shipping fee') }}";
    var totalText = "{{ __('Total') }}";
    var subtotalText = "{{ __('Subtotal') }}";
    var printLocationText = "{{ __('Print Location') }}";
    var errorTryAgainText = "{{ __('Error. Please try again later!') }}";
    var viewText = "{{ __('View') }}";
    var keyStripe = "<?=config('cart::stripe.public_key')?>";
    var keyStripeTest = "<?=config('cart::stripe.test_public_key')?>";
    var useCheckoutInSidebar = "<?=config('cart::stripe.use_checkout_in_sidebar', false)?>";
    var base_api_url_header = "<?= config('sa.api_url'); ?>";
    var currencyUnitAddToCartHeader = "{{ isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit') }}";
    var defaultcurrencyUnitAddToCartHeader = "{{ config('default.currency_unit') }}";
    var prefixLocaleUrlMiniCart = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var priceConfigForMiniCart = <?= json_encode(getPriceConfig()) ?>;
    var printLocationsPriceMiniCart = <?= json_encode(getPrintLocationPriceConfig()) ?>;
    var priceTemplate = "{{ getCurrencyTemplate() }}";
    var priceTempate = "{{ getCurrencyTemplate() }}";
    var currentRouteName  = "{{ \Route::currentRouteName() }}";
    var locale = '';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
        locale = '/' + localePrefix;
    }
    var minicart = 255;
    var multiItem = minicart * 1.5;
    var viewportHeight = $(window).height();
    let imageSize = 360;
    if (typeof jsNotMobile !== "undefined" && jsNotMobile) {
        imageSize = 360;
    }
    var printLocationsMiniCartHeader = <?= json_encode(getPrintLocationConfig()) ?>;
    let listRelated = [];
    let isScrollBottomSidebar = false;
    let isScrollBottomSidebarRecommend = false;
    let isTimeOut = false;
    var isValidExpressCheckoutHeader = false;
    let cartItemHeader = [];
    var validCountryHeader = <?= json_encode(config('cart::sa.valid_country', [])) ?>;
    var countryByIpHeader = null;
    var tokenHeader = null
    let modeHeader = null;
    let stripeHeader = null;
    let elementsStripeHeader = null;
    var keepOriginalHeader = <?= json_encode(config('cart::sa.keep_original_price', [])) ?>;
    var stripeElementStyleHeader = {};
    let shippingInfoByPaymentRequestButtonHeader = {};
    let isShowExpressCheckout = false;
    let shippingTypeHeader = "standard";
    var cartAmountHeader = 0;
    var stripeFeeHeader = "<?= config("cart::stripe.applepay_include_fee", 0) ?>";
    const monthNamesHeader = [
        "{{ __('Jan. #date') }}", "{{ __('Feb. #date') }}", "{{ __('Mar. #date') }}", "{{ __('Apr. #date') }}", "{{ __('May. #date') }}", "{{ __('Jun. #date') }}",
        "{{ __('Jul. #date') }}", "{{ __('Aug. #date') }}", "{{ __('Sep. #date') }}", "{{ __('Oct. #date') }}", "{{ __('Nov. #date') }}", "{{ __('Dec. #date') }}"
    ];
    var cjeventCookieHeader = "{{ isset($_COOKIE['cje']) ? $_COOKIE['cje'] : '' }}";
    let selectedShippingHeader = [];
    var countriesHeader = [];
    window.HireDesignerCartText = "{{ __('Hire Artist For Customization') }}";
    var miniCartTranslateText = {
        front: "{{ __('Front') }}",
        back: "{{ __('Back') }}",
        left: "{{ __('Left') }}",
        right: "{{ __('Right') }}",
        top: "{{ __('Top') }}",
        bottom: "{{ __('Bottom') }}"
    };

    function decimalAdjust(type, value) {
        let matches = priceTemplate.match(/{money}{([^a-zA-z0-9]+)}{([0-9]+)}/);
        let exp = -2;
        if (matches.length == 3) {
            exp = parseInt(matches[2] * (matches[2] ? -1 : 1));
        }
        // If the exp is undefined or zero...
        if (typeof exp === 'undefined' || +exp === 0) {
        return Math[type](value);
        }
        value = +value;
        exp = +exp;
        // If the value is not a number or the exp is not an integer...
        if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
            return NaN;
        }
        // Shift
        value = value.toString().split('e');
        value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
        // Shift back
        value = value.toString().split('e');
        return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
    }
    function formatPriceByCurrency(amount, $type = 'round') {
        let retval = amount;
        let acceptRound = ['JPY', "KRW", "VND"];
        if (acceptRound.includes(currencyUnitAddToCartHeader) && $type == 'round') {
            retval = Math.round(amount);
        } else if (!keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(((retval * 100) * 100) / 100);
        } else if (keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(retval);
        }
        return retval;
    }
</script>
<script src="{{ asset('modules/cart/js/mini-cart-header.js') }}?v={{ config('sa.version') }}"></script>
@append

