<a class="mini-cart-link flex-b align-c flex-c" href="{{ clroute('/cart') }}" id="mini-cart" rel="nofollow" aria-label="{{ __('View cart') }}">
    <span>
        <svg id="Layer_1" xmlns="http://www.w3.org/2000/svg" width="23.5" height="24.5" viewBox="0 0 23.5 20.87"><path d="M7.73,4.29c.51-.18,1.07,.09,1.25,.6,.4,1.14,1.49,1.96,2.77,1.96s2.36-.82,2.77-1.96c.18-.51,.74-.78,1.25-.6,.51,.18,.78,.74,.6,1.25-.67,1.9-2.48,3.26-4.61,3.26s-3.94-1.36-4.61-3.26c-.18-.51,.09-1.07,.6-1.25ZM12.22,1.96h-.94c-2.12,0-3.53,0-4.6,.14-1.02,.13-1.48,.34-1.81,.62-.33,.27-.63,.69-.94,1.67-.33,1.03-.59,2.41-.98,4.5-.55,2.92-.92,4.91-.98,6.4-.06,1.44,.18,2.05,.52,2.46,.34,.41,.9,.76,2.32,.96,1.48,.21,3.5,.22,6.47,.22h.94c2.97,0,4.99,0,6.47-.22,1.43-.2,1.99-.55,2.32-.96,.34-.41,.58-1.02,.52-2.46-.07-1.49-.43-3.48-.98-6.4-.39-2.08-.65-3.47-.98-4.5-.31-.97-.61-1.39-.94-1.67-.33-.27-.8-.49-1.81-.62-1.07-.13-2.48-.14-4.6-.14ZM3.62,1.2c-1.45,1.2-1.83,3.24-2.59,7.31-1.07,5.72-1.61,8.59-.05,10.47,1.56,1.89,4.48,1.89,10.3,1.89h.94c5.82,0,8.74,0,10.3-1.89,1.56-1.89,1.03-4.75-.05-10.47-.76-4.07-1.14-6.11-2.59-7.31-1.45-1.2-3.52-1.2-7.66-1.2h-.94C7.14,0,5.07,0,3.62,1.2Z" style="fill:#0a0a0a; fill-rule:evenodd;"/></svg>
        <span class="js-mini-cart-count" style="display: none;"> 0 </span>
    </span>
</a>

<link rel="stylesheet" href="@asset('cart/css/mini-shopping.css')?v=<?= config('sa.version') ?>">

@section('js')
<script src="//js.stripe.com/v3/"></script>
<?php
$paypalKey = getPaypalKey();
$paypalKeyTest = config('cart::paypal.sandbox_clientId');
$currency = isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit');
$defaultCurrency = config('default.currency_unit');
$locale = env('APP_LOCALE');
if ($locale == '') {
    $locale = 'us';
}
?>
@if ($defaultCurrency == $currency)
    @if (isset($_GET['mode']) && $_GET['mode'] == 'test')
    <script src="https://www.paypal.com/sdk/js?components=buttons&client-id=<?=$paypalKeyTest?>&commit=true&currency=<?=$currency?>&enable-funding=paylater"></script>
    @else
    <script src="https://www.paypal.com/sdk/js?components=buttons&client-id=<?=$paypalKey['clientId']?>&commit=true&currency=<?=$currency?>&enable-funding=paylater"></script>
    @endif
@endif
<script>
    let isMobileHeader = false
    @mobile
        isMisMobileHeaderobile = true
    @endmobile
    var transactionFeeText = "{{ __('Handling fee') }}";
    var betweenFromToText = "{{ __('#key between #from - #to') }}";
    var shippingFeeText = "{{ __('Shipping fee') }}";
    var totalText = "{{ __('Total') }}";
    var subtotalText = "{{ __('Subtotal') }}";
    var printLocationText = "{{ __('Print Location') }}";
    var errorTryAgainText = "{{ __('Error. Please try again later!') }}";
    var viewText = "{{ __('View') }}";
    var keyStripe = "<?=config('cart::stripe.public_key')?>";
    var keyStripeTest = "<?=config('cart::stripe.test_public_key')?>";
    var useCheckoutInSidebar = "<?=config('cart::stripe.use_checkout_in_sidebar', false)?>";
    var usePaypalInSidebar = "<?=config('cart::paypal.use_paypal_in_sidebar', false)?>";
    var isValidPaypalExpressCheckout = usePaypalInSidebar;
    var base_api_url_header = "<?= config('sa.api_url'); ?>";
    var currencyUnitAddToCartHeader = "{{ isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit') }}";
    var defaultcurrencyUnitAddToCartHeader = "{{ config('default.currency_unit') }}";
    var prefixLocaleUrlMiniCart = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var priceConfigForMiniCart = <?= json_encode(getPriceConfig()) ?>;
    var printLocationsPriceMiniCart = <?= json_encode(getPrintLocationPriceConfig()) ?>;
    var priceTemplate = "{{ getCurrencyTemplate() }}";
    var priceTempate = "{{ getCurrencyTemplate() }}";
    var currentRouteName  = "{{ \Route::currentRouteName() }}";
    var locale = '';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
        locale = '/' + localePrefix;
    }
    var minicart = 255;
    var multiItem = minicart * 1.5;
    var viewportHeight = $(window).height();
    let imageSize = 360;
    if (typeof jsNotMobile !== "undefined" && jsNotMobile) {
        imageSize = 360;
    }
    var printLocationsMiniCartHeader = <?= json_encode(getPrintLocationConfig()) ?>;
    let listRelated = [];
    let isScrollBottomSidebar = false;
    let isScrollBottomSidebarRecommend = false;
    let isTimeOut = false;
    var isValidExpressCheckoutHeader = false;
    let cartItemHeader = [];
    var validCountryHeader = <?= json_encode(config('cart::sa.valid_country', [])) ?>;
    var countryByIpHeader = null;
    var tokenHeader = null
    let modeHeader = null;
    let stripeHeader = null;
    let elementsStripeHeader = null;
    var keepOriginalHeader = <?= json_encode(config('cart::sa.keep_original_price', [])) ?>;
    var stripeElementStyleHeader = {};
    let shippingInfoByPaymentRequestButtonHeader = {};
    let isShowExpressCheckout = false;
    let isShowPaypalExpressCheckout = false;
    var paypalAccountHeader = null;
    let shippingTypeHeader = "standard";
    var cartAmountHeader = 0;
    var stripeFeeHeader = "<?= config("cart::stripe.applepay_include_fee", 0) ?>";
    var paypalFeeHeader = "<?=config('cart::paypal.include_fee')?>";
    const monthNamesHeader = [
        "{{ __('Jan. #date') }}", "{{ __('Feb. #date') }}", "{{ __('Mar. #date') }}", "{{ __('Apr. #date') }}", "{{ __('May. #date') }}", "{{ __('Jun. #date') }}",
        "{{ __('Jul. #date') }}", "{{ __('Aug. #date') }}", "{{ __('Sep. #date') }}", "{{ __('Oct. #date') }}", "{{ __('Nov. #date') }}", "{{ __('Dec. #date') }}"
    ];
    var cjeventCookieHeader = "{{ isset($_COOKIE['cje']) ? $_COOKIE['cje'] : '' }}";
    let selectedShippingHeader = [];
    let selectedCountryHeader = null;
    var countriesHeader = [];
    window.HireDesignerCartText = "{{ __('Hire Artist For Customization') }}";
    var otherTaxFeeHeader = "<?= config("cart::sa.other_tax_fee", 0) ?>";
    var otherFeeTextHeader = "{{ __('International Emergency Economic Powers Act (IEEPA)') }}";
    var miniCartTranslateText = {
        front: "{{ __('Front') }}",
        back: "{{ __('Back') }}",
        left: "{{ __('Left') }}",
        right: "{{ __('Right') }}",
        top: "{{ __('Top') }}",
        bottom: "{{ __('Bottom') }}"
    };
    var tenancyToken = "{{ request()->header('tenancy_token') ? request()->header('tenancy_token') : '' }}";
    var useSpecialShippingFee = "<?= config("cart::sa.use_special_shipping_fee", false) ?>";
    var shouldUseNewInterface = "a";
    var shippingFeeByLevel = [4.99, 0];
    if (shouldUseNewInterface == 'b') {
        shippingFeeByLevel = [5.99, 0];
    }
    @if (isset($_GET['ab_testing']) && $_GET['ab_testing'] == '1')
        useSpecialShippingFee = true;
    @endif
    function decimalAdjust(type, value) {
        let matches = priceTemplate.match(/{money}{([^a-zA-z0-9]+)}{([0-9]+)}/);
        let exp = -2;
        if (matches.length == 3) {
            exp = parseInt(matches[2] * (matches[2] ? -1 : 1));
        }
        // If the exp is undefined or zero...
        if (typeof exp === 'undefined' || +exp === 0) {
        return Math[type](value);
        }
        value = +value;
        exp = +exp;
        // If the value is not a number or the exp is not an integer...
        if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
            return NaN;
        }
        // Shift
        value = value.toString().split('e');
        value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
        // Shift back
        value = value.toString().split('e');
        return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
    }
    function formatPriceByCurrency(amount, $type = 'round') {
        let retval = amount;
        let acceptRound = ['JPY', "KRW", "VND"];
        if (acceptRound.includes(currencyUnitAddToCartHeader) && $type == 'round') {
            retval = Math.round(amount);
        } else if (!keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(((retval * 100) * 100) / 100);
        } else if (keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(retval);
        }
        return retval;
    }
</script>
<script src="{{ asset('modules/cart/js/mini-cart-header.js') }}?v={{ config('sa.version') }}"></script>
@append

