<?php
    $shoppingRating = getOption('shopping-ratings');
    $shoppingRatingCount = getOption('shopping-ratings-count');
    $currentLocale = strtoupper(env('APP_LOCALE'));
    if (empty($currentLocale)) {
        $currentLocale = 'US';
    }
    $shoppingUrl = getOption('general.google_customer_review_url', "https://customerreviews.google.com/v/merchant?q=printerval.com&v=19&hl=en&c=") . $currentLocale;
    $isShowGuarantee = config("cart::sa.show_guarantee", true);
    $designFee = config('cart::sa.design_fee', 0);
    $useTaxes = config('cart::sa.use_taxes', false);
    $rewardsPercent = config('cart::sa.rewards_percent', 0);
?>
<div id="cart-module-content">
    <div class="container-indent" ng-app="myApp" ng-controller="CartController" ng-cloak>
        <nav aria-label="Breadcrumb" ng-show="items.length > 0 || firstLoadingCart">
            <ol class="checkout-breadcrumb breadcrumb--center" role="list">
                <li class="breadcrumb__item breadcrumb__item--current flex-b flex-c align-c">
                    <span class="icon-cart flex-b flex-c align-c active">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M5.94708 4.86192C6.20743 4.76989 6.4931 4.90636 6.58512 5.16672C6.79128 5.74999 7.34757 6.16667 7.9999 6.16667C8.65222 6.16667 9.20852 5.74999 9.41467 5.16672C9.5067 4.90636 9.79236 4.76989 10.0527 4.86192C10.3131 4.95394 10.4495 5.2396 10.3575 5.49996C10.0146 6.47028 9.08919 7.16667 7.9999 7.16667C6.9106 7.16667 5.98524 6.47028 5.64228 5.49996C5.55026 5.2396 5.68672 4.95394 5.94708 4.86192ZM8.24016 3.66667H7.75937C6.67551 3.66667 5.95411 3.66845 5.40775 3.73596C4.88886 3.80007 4.64969 3.91153 4.48185 4.05082C4.314 4.19012 4.16037 4.40466 4.00174 4.90284C3.8347 5.4274 3.70001 6.13612 3.50026 7.20142C3.22028 8.69468 3.03256 9.70894 2.99921 10.4729C2.96707 11.2093 3.09047 11.5223 3.26372 11.7311C3.43698 11.9398 3.72192 12.1188 4.4516 12.2229C5.20861 12.3309 6.24009 12.3333 7.75937 12.3333H8.24016C9.75944 12.3333 10.7909 12.3309 11.5479 12.2229C12.2776 12.1188 12.5626 11.9398 12.7358 11.7311C12.9091 11.5223 13.0325 11.2093 13.0003 10.4729C12.967 9.70894 12.7793 8.69468 12.4993 7.20142C12.2995 6.13612 12.1648 5.4274 11.9978 4.90284C11.8392 4.40466 11.6855 4.19012 11.5177 4.05082C11.3498 3.91153 11.1107 3.80007 10.5918 3.73596C10.0454 3.66845 9.32403 3.66667 8.24016 3.66667ZM3.84321 3.28131C3.10261 3.89596 2.90754 4.93635 2.51739 7.01713C1.96877 9.94309 1.69447 11.4061 2.49421 12.3697C3.29396 13.3333 4.78243 13.3333 7.75937 13.3333H8.24016C11.2171 13.3333 12.7056 13.3333 13.5053 12.3697C14.3051 11.4061 14.0308 9.94309 13.4821 7.01713C13.092 4.93635 12.8969 3.89596 12.1563 3.28131C11.4157 2.66667 10.3572 2.66667 8.24016 2.66667H7.75937C5.64233 2.66667 4.58381 2.66667 3.84321 3.28131Z" fill="white"/> </svg>
                    </span>
                    <span class="breadcrumb__text cart-text">{{ __('Cart') }}</span>
                    <small class="active"></small>
                </li>
                <li class="breadcrumb__item breadcrumb__item--blank flex-b flex-c align-c" aria-current="step">
                    <span class="icon-cart flex-b flex-c align-c">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 9h.01" /><path d="M11 12h1v4h1" /></svg>
                    </span>
                    <span class="breadcrumb__text">{{ __('Order Information') }}</span>
                    <small></small>
                </li>
                <li class="breadcrumb__item breadcrumb__item--blank flex-b flex-c align-c">
                    <span class="icon-cart flex-b flex-c align-c">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 12l5 5l10 -10" /><path d="M2 12l5 5m5 -5l5 -5" /></svg>
                    </span>
                    <span class="breadcrumb__text">{{ __('Complete') }}</span>
                </li>
            </ol>
        </nav>

        <div id="container-cart ">
            <div class="cart-list-product-box" ng-show="items.length > 0 || firstLoadingCart">
                <!-- Deliver Section -->
                <div id="container-country">
                    <div class="content-ct flex-b flex-s align-c" ng-click="openSelectCountry()">
                        <span class="country-txt">
                            {{ __('Deliver to:') }}
                        </span>
                        <div class="box-country flex-b align-c flex-e">
                            <span id="selectedCountry">
                                @{{ selectedCountry.nicename }}
                            </span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M6.02928 13.8617C5.80651 13.6707 5.78071 13.3354 5.97165 13.1126L9.92531 8.5L5.97165 3.8874C5.78071 3.66463 5.80651 3.32926 6.02928 3.13831C6.25204 2.94737 6.58742 2.97317 6.77837 3.19594L11.0284 8.15427C11.1989 8.35322 11.1989 8.64679 11.0284 8.84573L6.77836 13.8041C6.58742 14.0268 6.25204 14.0526 6.02928 13.8617Z" fill="currentColor"/>
                            </svg>
                        </div>
                    </div>
                </div>

                <div class="form-shopcart">
                    <!-- Cart left col -->
                    <div class="cart-left-wrapper @{{ loadingRemoveItem ? 'loading-remove-item' : ''}}">
                        @if($currentLocale == 'US' || $currentLocale == 'UK' || $currentLocale == 'CA' || $currentLocale == 'AU')
                            <div class="loyalty-noti-wrapper" ng-show="showLoyaltyNoti && morePoint > 0">
                                <div class="loyalty-noti-content">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M3 8m0 1a1 1 0 0 1 1 -1h16a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-16a1 1 0 0 1 -1 -1z" />
                                        <path d="M12 8l0 13" />
                                        <path d="M19 12v7a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-7" />
                                        <path d="M7.5 8a2.5 2.5 0 0 1 0 -5a4.8 8 0 0 1 4.5 5a4.8 8 0 0 1 4.5 -5a2.5 2.5 0 0 1 0 5" />
                                    </svg>
                                    <div class="loyalty-noti">
                                        {{ __('Buy') }} <b class="text-bold">@{{ moreAmount }}</b> @{{ textMoreAmount.replace("#point", morePoint) }}
                                    </div>
                                </div>
                                <span class="loyalty-noti-close" ng-click="closeLoyaltyNoti()">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                        <path d="M18 6l-12 12" />
                                        <path d="M6 6l12 12" />
                                    </svg>
                                </span>
                            </div>
                        @endif

                        <div class="flex-box shopcart-row shopcart-content" ng-show="firstLoadingCart" ng-repeat="n in range(1, totalCartItem)">
                            <div class="shopcart-item shopcart-name">
                                <div class="shopcart-item shopcart-name">
                                    <span class="skeleton-box" style="width:100px; min-width: 100px; height: 100px"></span>
                                    <div class="shopcart-info" style="display: flex; grid-gap: 3px; flex-wrap: wrap">
                                        <span class="skeleton-box" style="width:100%;"></span>
                                        <span class="skeleton-box" style="width:10%;"></span>
                                        <div class="skeleton-box" style="width: 20%; padding: 10px 0;"></div>
                                        <div class="shopcart-item shopcart-price" style="height: 16px">
                                            <span class="skeleton-box" style="width:100%;"></span>
                                        </div>
                                        <div class="shopcart-item shopcart-qty" style="height: 16px">
                                            <span class="skeleton-box" style="width:92%;"></span>
                                        </div>
                                        <div class="shopcart-item shopcart-subtotal" style="height: 16px">
                                            <span class="skeleton-box" style="width:100%;"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex-box shopcart-row shopcart-content"
                            data-cart-item-id="@{{ item.id }}"
                            id="tr-item-cart-@{{ item.id }}"
                            data-product-id="@{{ item.product_id }}"
                            ng-repeat="item in items"
                        >
                            <div class="shopcart-item shopcart-name">
                                <a href="@{{ item.force_url ? item.force_url : (item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url) }}" target="_blank" class="shopcart-image flex-box align-c flex-c">
                                    <img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="@{{ item.product_name }}" title="@{{ item.product_name }}" referrerpolicy="no-referrer">
                                </a>

                                <div class="shopcart-info">
                                    <a class="shopcart-item-link" ng-bind-html="item.product_name | safeHtml" href="@{{ item.force_url ? item.force_url : (item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url) }}" target="_blank"></a>
                                    {{-- detail-product --}}
                                    <div class="shopcart-configurations">
                                        <div class="cart-item-name-variant js-open-popover" ng-click="openFormChangeVariant(item)" ng-show="item.name_variant">
                                            <span>@{{ item.name_variant }}</span>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" ng-show="!item.disable_make_change">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M2.95339 5.67464C3.1331 5.46498 3.44875 5.4407 3.65841 5.62041L7.99968 9.3415L12.341 5.62041C12.5506 5.4407 12.8663 5.46498 13.046 5.67464C13.2257 5.88431 13.2014 6.19996 12.9917 6.37967L8.32508 10.3797C8.13783 10.5402 7.86153 10.5402 7.67429 10.3797L3.00762 6.37967C2.79796 6.19996 2.77368 5.88431 2.95339 5.67464Z" fill="currentColor" />
                                            </svg>
                                            <div class="loading-background" ng-show="item.loadingMakeChange"></div>
                                        </div>
                                        
                                        <div class="config-item" ng-repeat="(key, value) in item.configurations">
                                            <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee' && key != 'hire_designer'">
                                                @{{ key }}: @{{ value }}
                                            </div>
                                            <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                            </div>
                                        </div>
                                        
                                        <div ng-if="item.preview_url">
                                            {{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
                                        </div>
                                    </div>
                                    
                                    <div class="shopcart-configurations">
                                        <div class="discount-box shopcart-discount-code"></div>
                                    </div>
                                    <div class="shopcart-configurations">
                                        <i style="color: #ff7300;" class="buy-more-text"></i>
                                    </div>
                                    <div class="shopcart-configurations">
                                        <i style="color: #ff7300;" class="buy-more-text-title"></i>
                                    </div>
                                    <div class="flex-b align-c make-change-wrap" ng-hide="freeshipPackageProduct && freeshipPackageProduct.id == item.product_id">
                                        <span class="make-change-button-item @{{ item.is_wishlist ? 'active-wishlist' : '' }}" id="js-update-item" ng-click="addToWishlist(item)">
                                            <svg class="wishlist-active-icon" xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                                <path d="M5.74227 12.9249C3.75321 11.3924 1.41699 9.59241 1.41699 6.47214C1.41699 3.02756 5.31294 0.584734 8.50033 3.89631L9.91699 5.31202C10.1245 5.51945 10.4609 5.51939 10.6683 5.31188C10.8757 5.10438 10.8757 4.76801 10.6682 4.56058L9.29965 3.19257C12.303 0.993883 15.5837 3.31124 15.5837 6.47214C15.5837 9.59241 13.2474 11.3924 11.2584 12.9249C11.0516 13.0842 10.8487 13.2405 10.6524 13.3952C9.91699 13.975 9.20866 14.5209 8.50033 14.5209C7.79199 14.5209 7.08366 13.975 6.34822 13.3952C6.15199 13.2405 5.94901 13.0842 5.74227 12.9249Z" fill="#FF6600"/>
                                            </svg>
                                            <svg class="wishlist-not-active-icon" xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.98425 3.13386C2.80913 3.67101 1.94824 4.94864 1.94824 6.47217C1.94824 8.02866 2.58519 9.22839 3.49828 10.2566C4.25084 11.104 5.16183 11.8063 6.05029 12.4912C6.26131 12.6539 6.47106 12.8156 6.67711 12.9781C7.04971 13.2718 7.38209 13.5296 7.70247 13.7168C8.02301 13.9041 8.28103 13.9896 8.50033 13.9896C8.71963 13.9896 8.97764 13.9041 9.29819 13.7168C9.61856 13.5296 9.95094 13.2718 10.3235 12.9781C10.5296 12.8156 10.7393 12.6539 10.9504 12.4912C11.8388 11.8063 12.7498 11.104 13.5024 10.2566C14.4155 9.22839 15.0524 8.02866 15.0524 6.47217C15.0524 4.94864 14.1915 3.67101 13.0164 3.13386C11.9728 2.65683 10.6014 2.73135 9.26 3.90458L10.2926 4.93678C10.5001 5.14421 10.5001 5.48057 10.2927 5.68808C10.0853 5.89558 9.74891 5.89564 9.54141 5.68821L8.12474 4.27206L8.11757 4.26475C6.65984 2.75022 5.12587 2.61202 3.98425 3.13386ZM8.50033 3.15839C6.86262 1.69315 5.02876 1.48817 3.54253 2.16753C1.97283 2.88505 0.885742 4.55112 0.885742 6.47217C0.885742 8.36026 1.67234 9.8006 2.70383 10.9621C3.52986 11.8922 4.5409 12.6707 5.43383 13.3582C5.63624 13.5141 5.83259 13.6653 6.01933 13.8125C6.38216 14.0985 6.77167 14.4035 7.16641 14.6342C7.56098 14.8647 8.01129 15.0521 8.50033 15.0521C8.98936 15.0521 9.43968 14.8647 9.83424 14.6342C10.229 14.4035 10.6185 14.0985 10.9813 13.8125C11.1681 13.6653 11.3644 13.5141 11.5668 13.3582C12.4598 12.6707 13.4708 11.8922 14.2968 10.9621C15.3283 9.8006 16.1149 8.36026 16.1149 6.47217C16.1149 4.55112 15.0278 2.88505 13.4581 2.16753C11.9719 1.48817 10.138 1.69315 8.50033 3.15839Z" fill="currentColor"/>
                                            </svg>
                                            <span>{{ __('Save for later') }}</span>
                                        </span>
                                        <span class="make-change-button-item" id="js-delete-item" ng-click="openModalRemoveCartItem(item)" class="flex-b align-c">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.62477 5.49079C3.91752 5.47127 4.17066 5.69277 4.19018 5.98552L4.51597 10.8724C4.57962 11.8271 4.62497 12.4914 4.72454 12.9912C4.82112 13.476 4.95594 13.7327 5.14961 13.9139C5.34328 14.095 5.60831 14.2125 6.09847 14.2766C6.6038 14.3427 7.26964 14.3438 8.22649 14.3438H8.77428C9.73113 14.3438 10.397 14.3427 10.9023 14.2766C11.3925 14.2125 11.6575 14.095 11.8512 13.9139C12.0448 13.7327 12.1796 13.476 12.2762 12.9912C12.3758 12.4914 12.4211 11.8271 12.4848 10.8724L12.8106 5.98552C12.8301 5.69277 13.0832 5.47127 13.376 5.49079C13.6688 5.5103 13.8903 5.76345 13.8707 6.0562L13.5425 10.9804C13.4819 11.889 13.433 12.6229 13.3183 13.1988C13.199 13.7976 12.9961 14.2977 12.577 14.6897C12.158 15.0818 11.6455 15.2509 11.0401 15.3301C10.4578 15.4063 9.72226 15.4063 8.81164 15.4063H8.18913C7.27851 15.4063 6.54294 15.4063 5.96066 15.3301C5.35529 15.2509 4.84277 15.0818 4.42373 14.6897C4.00468 14.2977 3.8018 13.7976 3.68252 13.1988C3.56779 12.6229 3.51887 11.889 3.45831 10.9803L3.13003 6.0562C3.11052 5.76345 3.33202 5.5103 3.62477 5.49079Z" fill="currentColor"/>
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.33536 1.59378L7.30279 1.59376C7.14951 1.59367 7.01598 1.59358 6.88988 1.61372C6.39171 1.69327 5.96062 2.00398 5.72761 2.45143C5.66864 2.56469 5.62649 2.69141 5.57811 2.83685L5.56783 2.86775L5.49906 3.07406C5.4856 3.11441 5.48185 3.12553 5.47859 3.13455C5.35455 3.47746 5.03295 3.70925 4.66841 3.71849C4.65882 3.71874 4.64708 3.71878 4.60455 3.71878H2.47949C2.18609 3.71878 1.94824 3.95663 1.94824 4.25003C1.94824 4.54343 2.18609 4.78128 2.47949 4.78128L4.61062 4.78128L4.62248 4.78128H12.3783L12.3902 4.78128L14.5212 4.78128C14.8146 4.78128 15.0525 4.54343 15.0525 4.25003C15.0525 3.95663 14.8146 3.71878 14.5212 3.71878H12.3962C12.3537 3.71878 12.3419 3.71874 12.3324 3.71849C11.9678 3.70925 11.6462 3.47745 11.5222 3.13453C11.5189 3.12558 11.5151 3.11421 11.5017 3.07406L11.4329 2.86774L11.4227 2.83683C11.3743 2.69139 11.3321 2.56468 11.2732 2.45143C11.0402 2.00398 10.6091 1.69327 10.1109 1.61372C9.98479 1.59358 9.85126 1.59367 9.69798 1.59376L9.66541 1.59378H7.33536ZM6.47773 3.49596C6.44992 3.57286 6.41759 3.64722 6.3811 3.71878H10.6197C10.5832 3.64722 10.5509 3.57287 10.523 3.49598L10.4956 3.41569L10.425 3.20374C10.3604 3.00999 10.3455 2.97049 10.3308 2.94216C10.2531 2.79301 10.1094 2.68944 9.94335 2.66292C9.91181 2.65789 9.86963 2.65628 9.66541 2.65628H7.33536C7.13114 2.65628 7.08896 2.65789 7.05742 2.66292C6.89136 2.68944 6.74767 2.79301 6.67 2.94216C6.65525 2.97049 6.64038 3.01 6.5758 3.20374L6.50511 3.41582C6.49446 3.44776 6.48618 3.47261 6.47773 3.49596Z" fill="currentColor"/>
                                            </svg>
                                            <span>{{ __('Remove')}}</span>
                                        </span>
                                    </div>
                                    <div ng-if="item.hire_designer != undefined" class="buydesign-item">
                                        <div  class="flex-b buydesign-content-item hiredesign-content-item">
                                            <label for="hire-designer-@{{ item.id }}" class="checkbox-label buydesign-action">
                                                <input 
                                                    type="checkbox" 
                                                    name="buy-designer" 
                                                    class="checkbox-input" 
                                                    id="hire-designer-@{{ item.id }}" 
                                                    ng-model="item.hire_designer" 
                                                    ng-checked="item.hire_designer" 
                                                    ng-change="onChangeHireDesigner(item)"
                                                />
                                                <span class="input-type-checkbox"></span>
                                                <div class="buydesign-content-text">
                                                    {{ __('Hire Artist For Customization') }}
                                                </div>
                                            </label>
                                        </div>
                                    </div>

                                    <div class="shopcart-contain shopcart-contai-new">
                                        <div class="shopcart-item shopcart-price shopcart-price1 " ng-class="{'has-save-price': item.discount_value}" data-unit-price="@{{ item.price }}">
                                            <span class="shopping-price" style="color: #C52C29;">
                                                @{{ formatPrice(item.price) }}
                                            </span>
                                            <del class="shopping-hight-price" ng-if="item.high_price && item.high_price > item.price">
                                                @{{ formatPrice(item.high_price) }}
                                            </del>
                                            <small class="shopping-save-price" ng-if="item.discount_value">
                                                <?= sprintf(__('Save %s'), '{{ formatPrice(item.discount_value) }}') ?>
                                            </small>
                                        </div>
                                        <div class="shopcart-item shopcart-qty">
                                            <div class="shopcart-qty flex-box align-s flex-c button-new ">
                                                <button class="shopcart-button minus" type="button" name="button" ng-click="changeQuantity(item, item.quantity, 'decrease')" ng-disabled="loading">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-dash-lg" viewBox="0 0 16 16">
                                                        <path d="M0 8a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2H1a1 1 0 0 1-1-1z" />
                                                    </svg>
                                                </button>
                                                <input type="text" ng-value="item.quantity" class="quantity shopcart-input number-input" ng-model="item.quantity" autocomplete="off" ng-change="changeCustomQuantity(item, item.quantity)" ng-model-options="{ debounce: 500 }">
                                                <button class="shopcart-button plus" type="button" name="button" ng-click="changeQuantity(item, item.quantity, 'increase')" ng-disabled="loading">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                                                        <path d="M8 0a1 1 0 0 1 1 1v6h6a1 1 0 1 1 0 2H9v6a1 1 0 1 1-2 0V9H1a1 1 0 0 1 0-2h6V1a1 1 0 0 1 1-1z"></path>
                                                    </svg>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="cart-buyDesign" ng-hide="item.disable_make_change || checkValidDownloadDesign(item) || item.is_custom_design == 1 || item.is_valid_buy_design == 0 || item.hire_designer != undefined || designFeeByProducts[item.product_id] == 0">
                                        <input type="checkbox" name="buydesign" class="checkbox-input" id="open-buyDesign-@{{ item.id }}">
    									<div class="buydesign-item" id="buy-this-design-@{{ item.id }}">
    										<div class="flex-b buydesign-content-item buydesign-content-1">
                                                <label for="buydesign-@{{ item.id }}" class="checkbox-label buydesign-action">
                                                    <input type="checkbox" class="checkbox-input" id="buydesign-@{{ item.id }}" ng-model="item.buy_design" ng-checked="item.buy_design" ng-change="buyDesign(item)">
                                                    <span class="input-type-checkbox"></span>
                                                    <div class="buydesign-content-text">
                                                        @{{ textBuyDesign }} <span style="font-weight: 500;" ng-show="designFeeByProducts[item.product_id] + getIncludeDesignFee(item) > 0">+ @{{formatPrice(designFeeByProducts[item.product_id] + getIncludeDesignFee(item))}}</span>
                                                    </div>
                                                </label>
                                                <label for="open-buyDesign-@{{ item.id }}" class="checkbox-label">
                                                    <svg xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-right">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <path d="M9 6l6 6l-6 6" />
                                                    </svg>
                                                </label>
    										</div>
                                            <div class="this-design-background"></div>
    										<div class="this-design-wrapper">
                                                <div class="this-design-content">
                                                    <div class="cart-header-popup">
                                                        <span>{{ __("Love this design?") }}</span>
                                                        <label class="close-body-open-button" for="open-buyDesign-@{{ item.id }}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                                                                <path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="currentColor" stroke-width="2" stroke-linecap="round"></path>
                                                            </svg> 
                                                        </label>
                                                    </div>
                                                    <div class="cart-popup-content flex-b">
                                                        <div class="design-box-title">
                                                            <span>{{ __("Download the original design file") }}</span>
                                                            <span class="design-price">+ @{{formatPrice(designFeeByProducts[item.product_id] + getIncludeDesignFee(item))}}</span>
                                                        </div>
                                                        <a href="{{ clroute(getOption('general.buy_design_policy', '#')) }}" class="buydesign-help" target="_blank">
                                                            {{ __('You will receive the link to download the original design file of this item within 24 hours')}}
                                                        </a>
                                                        <div class="design-template" ng-if="item.design_url">
                                                            <img src="@{{ getImageCdn(item.design_url, 540, 540, true) }}" alt="" width="358" height="358" referrerpolicy="no-referrer">
                                                        </div>
                                                        <div class="design-template no-design-img" ng-if="!item.design_url">
                                                            <img src="@{{ getImageCdn(item.image_url, 540, 540, true) }}" alt="" width="358" height="358" referrerpolicy="no-referrer">
                                                        </div>
                                                        <!--<button class="btn update-product" type="button" ng-if="!item.buy_design" ng-click="buyDesign(item)">
                                                            {{ __("Add to cart") }}
                                                        </button>-->
                                                    </div>
                                                </div>
    										</div>
    									</div>
                                        <label class="close-buyDesign" for="open-buyDesign-@{{ item.id }}"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- <div id="container-voucher"  ng-click="openSelectCountry()">
                        <div class="content-ct content-voucher content-ctn flex-b align-c" >
                            <img src="@asset('cart/images/promotion.svg')" width="24" height="24" alt="{{ __('Voucher') }}">
                            <span>{{ __('Voucher') }}</span>
                            <span class="box-free">{{ __('Free ship')}}</span>
                            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M6.02928 13.8617C5.80651 13.6707 5.78071 13.3354 5.97165 13.1126L9.92531 8.5L5.97165 3.8874C5.78071 3.66463 5.80651 3.32926 6.02928 3.13831C6.25204 2.94737 6.58742 2.97317 6.77837 3.19594L11.0284 8.15427C11.1989 8.35322 11.1989 8.64679 11.0284 8.84573L6.77836 13.8041C6.58742 14.0268 6.25204 14.0526 6.02928 13.8617Z" fill="currentColor"/>
                            </svg>
                        </div>
                    </div> -->
                    <!-- End Cart left col -->
                    <div class="cart-check-container" ng-show="items.length > 0 || firstLoadingCart">
                        <div class="cart-check-action flex-b align-c flex-e">
                            <div class="cart-paymennt-detail js-open-cart-popup" data-target="bottomCheck" ng-click="addBodyClass($event)">
                                <div class="cart-check-content">
                                    <div class="cart-check-content-footer flex-b align-c flex-e cart-checkout-total">
                                        <small>{{ __('Total:')}}</small>
                                        <span> @{{ formatPrice(getCartAmount(false), 0, false) }}</span>
                                    </div>
                                    <div class="cart-check-content-footer flex-b align-c flex-e">
                                        <!-- <div class="flex-b align-c flex-e">
                                            <small>{{ __('Save:')}}</small>
                                            <span class="text-checkout">-40$</span>
                                        </div> -->
                                        {{-- <strong ng-show="customerRewards.showRewards && pointEarn > 0"></strong> --}}
                                        <div class="flex-b align-c flex-e" ng-show="customerRewards.showRewards && pointEarn > 0">
                                            <small>{{ __('Earn') }} </small>
                                            <span>@{{ pointEarn }}CP</span>
                                        </div>
                                    </div>
                                </div>
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.0466 10.8254C12.8669 11.035 12.5513 11.0593 12.3416 10.8796L8.00032 7.15853L3.65905 10.8796C3.44938 11.0593 3.13373 11.035 2.95402 10.8254C2.77431 10.6157 2.79859 10.3001 3.00825 10.1204L7.67492 6.12036C7.86217 5.95987 8.13847 5.95987 8.32571 6.12036L12.9924 10.1204C13.202 10.3001 13.2263 10.6157 13.0466 10.8254Z" fill="currentColor"/></svg>
                            </div>
                            <button class="checkout-btn-new" ng-click="processCheckout()" ng-disabled="loading">
                                <!-- <span class="checkout-loader" ng-if="loading"></span> -->
								<span>{{ __('Checkout')}}</span>
                            </button>
                        </div>
                        <div class="button-contain flex-box align-c flex-e">
                            <div id="paypal-button-container" style="width: 100%;"></div>
                            <p id="result-message"></p>
                        </div>
                    </div>
                    {{-- popup-paymentdetail --}}
                    
                </div>
            </div>

            <div id="isEmptyCart" class="tt-empty-cart" ng-show="isEmptyCart">
                <style>
                    #isEmptyCart {display: flex; flex-direction: column;justify-content: center;align-items: center;padding: 32px 0; text-align: center;}
                    .empty-header { font-size: calc(19px + (29 - 19) * ((100vw - 300px)/(1920 - 300))); text-transform: uppercase;}
                    .empty-image { display: block;margin: 16px;}
                    .empty-sub-header {font-size: calc(17px + (25 - 15) * ((100vw - 300px)/(1920 - 300))); font-weight: 500;margin-bottom: 16px;}
                    .empty-sub-description {width: 94%;max-width: 700px; margin: 2px auto;font-size: calc(16px + (18 - 16) * ((100vw - 300px)/(1920 - 300)))}
                    .return-to-shop { background-color: #0072bb; color: #fff; border-radius: 24px; cursor: pointer; user-select: none; display: block; width: fit-content; width: -moz-fit-content;padding: 12px 24px;font-weight: 500;user-select: none;margin-top: 16px;}
                    .return-to-shop:hover {color: #fff; box-shadow: 0 0 0 0.2rem rgb(0 123 255 / 50%);}
                    @@media (max-width: 780px) { #isEmptyCart { border-top: 1px solid #f1f1f1;} }
                </style>
                <h1 class="empty-header">
                    {{ __('Shopping Cart')}}
                </h1>
                <div class="empty-image">
                    <img src="@asset('cart/images/cart-empty.gif')" alt="" ng-class="isEmptyCart ? 'cart-is-empty' : ''">
                </div>
                <div class="empty-sub-header">
                    {{ __('Your Cart is currently empty!')}}
                </div>
                <div class="empty-sub-description">
                    {{ __('Before proceed to checkout you must add some products to your shopping cart. You will find a lot of interesting products on our "shop" page') }}
                </div>
                <a href="{{ route('home') }}" class="return-to-shop">
                    {{ __('Tiếp tục mua sắm') }}
                </a>
            </div>

            <div class="autocomplate-content content-select-country" ng-show="isShowSelectCountry">
                <div class="content-select-country-content">
                    <div class="cart-header-popup">
                        <span>
                            {{ __('Shipping Country') }}
                        </span>
                        <button class="close-body-open-button" ng-click="closeSelectCountry()">
                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" />
                            </svg>
                        </button>
                    </div>

                    <div class="content-select-country-wrapper">
                        {{-- <span class="form-control select" ng-click="openSearchCountry()">
                            @{{ tmpSelectedCountry.nicename }}
                        </span> --}}
                        <div class="list-country">
                            <div class="select-country">
                                <input type="text" class="form-control" placeholder="{{ __('Choose your country or region') }}" ng-model="filterCountry" ng-change="searchCountry()" ng-model-options="{ debounce: 500 }" value="@{{ tmpSelectedCountry.nicename }}">
                            </div>
                            <div class="country-region-item"
                                ng-repeat="item in listSearchCountries"
                                ng-click="selectCountry(item)"
                                ng-class="{'selected': item.id == tmpSelectedCountry.id}">
                                <small class="choose-country-icon"></small>
                                <span>@{{ item.nicename }}</span>
                            </div>
                            <div class="country-region-empty" ng-if="!listSearchCountries || listSearchCountries.length == 0">
                                <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 60 60" fill="none"> <g clip-path="url(#clip0_3258_6059)"> <path d="M29.2972 7.5C35.1005 7.5 40.3545 9.85236 44.1577 13.6555C47.9608 17.4586 50.3131 22.7126 50.3131 28.5159C50.3131 29.7557 50.2051 30.9724 49.998 32.157C49.8119 33.2218 49.5437 34.2631 49.2001 35.2742C49.0286 35.0747 48.8498 34.8817 48.6639 34.6958C48.4776 34.5095 48.2842 34.3304 48.0843 34.1586C48.3024 33.4302 48.4798 32.6816 48.6137 31.9153C48.8064 30.8132 48.9069 29.6774 48.9069 28.5159C48.9069 23.1008 46.712 18.1984 43.1634 14.6497C39.6148 11.1011 34.7123 8.9062 29.2972 8.9062C23.8821 8.9062 18.9796 11.1011 15.4311 14.6497C11.8824 18.1983 9.68754 23.1008 9.68754 28.5159C9.68754 33.931 11.8824 38.8335 15.4311 42.382C18.9797 45.9306 23.8822 48.1256 29.2972 48.1256C30.0522 48.1256 30.7901 48.0841 31.509 48.0034C31.8788 47.9619 32.2444 47.9104 32.6058 47.8492C32.8986 48.2883 33.2238 48.7041 33.5781 49.0929C32.9468 49.2239 32.3079 49.3263 31.6628 49.3987C30.8793 49.4866 30.0898 49.5318 29.2972 49.5318C23.4939 49.5318 18.24 47.1795 14.4367 43.3763C10.6336 39.5732 8.28125 34.3192 8.28125 28.5159C8.28125 22.7126 10.6336 17.4587 14.4367 13.6555C18.2399 9.85232 23.4938 7.5 29.2972 7.5Z" fill="#A3A3A3"/> <path d="M14.4282 15.731C16.5544 16.7782 18.8308 17.6025 21.2154 18.1725C23.7194 18.7711 26.3317 19.0885 29.0027 19.0885C31.7584 19.0885 34.4475 18.7523 37.0163 18.1191C39.4667 17.5152 41.8057 16.6389 43.9866 15.5249C43.7211 15.2249 43.4466 14.9329 43.1634 14.6497C43.1014 14.5877 43.0388 14.5262 42.976 14.465C41.0013 15.4392 38.8907 16.2122 36.6813 16.7568C34.2289 17.3613 31.6525 17.6822 29.0027 17.6822C26.4264 17.6822 23.9233 17.3801 21.5394 16.8102C19.4036 16.2996 17.3544 15.5731 15.4255 14.6553C15.0799 15.0013 14.7473 15.3602 14.4282 15.731Z" fill="#A3A3A3"/> <path d="M9.84882 25.9902C12.5113 27.5757 15.4165 28.8359 18.49 29.7166C21.8247 30.6721 25.3606 31.1843 29.0027 31.1843C32.7562 31.1843 36.3989 30.6393 39.8269 29.6248C42.9995 28.6858 45.9846 27.3447 48.7003 25.6613C48.6271 25.1599 48.5351 24.6645 48.4247 24.1762C45.6914 25.9324 42.6622 27.3227 39.4314 28.2789C36.1363 29.2542 32.6269 29.778 29.0027 29.778C25.4908 29.778 22.0844 29.2851 18.8745 28.3653C15.7298 27.4642 12.7761 26.1564 10.0986 24.504C9.99693 24.993 9.91332 25.4886 9.84882 25.9902Z" fill="#A3A3A3"/> <path d="M13.7673 40.4905C15.7875 41.2627 17.8882 41.8851 20.0506 42.3439C22.9407 42.9571 25.9398 43.2799 29.0028 43.2799C29.3846 43.2799 29.8199 43.2725 30.3075 43.2579C30.7666 43.2441 31.202 43.2248 31.6138 43.2001C32.0006 43.1774 32.2957 42.8453 32.273 42.4585C32.2503 42.0717 31.9182 41.7766 31.5314 41.7993C31.0903 41.8258 30.6693 41.8451 30.269 41.8571C29.9026 41.8681 29.4808 41.8737 29.0028 41.8737C26.0315 41.8737 23.1302 41.5622 20.3417 40.9706C17.5533 40.3789 14.8761 39.509 12.3527 38.3918C12.7797 39.1228 13.2524 39.8237 13.7673 40.4905Z" fill="#A3A3A3"/> <path d="M29.2972 7.5C31.9946 7.5 34.3813 9.93738 36.0594 13.878C37.6605 17.6375 38.6508 22.814 38.6508 28.516C38.6508 29.2659 38.6318 30.0341 38.5947 30.8167C38.5758 31.2172 38.5517 31.6158 38.5228 32.012C38.0245 32.1488 37.5411 32.3216 37.0755 32.5274C37.1257 31.9476 37.1653 31.355 37.1939 30.7507C37.2274 30.0444 37.2446 29.2992 37.2446 28.516C37.2446 22.9996 36.2983 18.0195 34.7686 14.4274C33.3159 11.0162 31.3773 8.9062 29.2972 8.9062C27.2172 8.9062 25.2785 11.0162 23.8259 14.4274C22.2961 18.0196 21.3499 22.9996 21.3499 28.516C21.3499 34.0323 22.2961 39.0124 23.8259 42.6046C25.2785 46.0158 27.2172 48.1256 29.2972 48.1256C29.8207 48.1256 30.3316 47.9931 30.8241 47.7416C31.2338 47.5324 31.6363 47.2398 32.0279 46.8713C32.2483 47.2955 32.4968 47.7027 32.7712 48.0902C32.3514 48.4561 31.914 48.7574 31.4613 48.9886C30.7645 49.3444 30.0405 49.5318 29.2972 49.5318C26.5998 49.5318 24.2131 47.0945 22.535 43.1539C20.934 39.3944 19.9436 34.218 19.9436 28.516C19.9436 22.814 20.934 17.6376 22.535 13.878C24.2131 9.93741 26.5998 7.5 29.2972 7.5Z" fill="#A3A3A3"/> <path d="M41.2891 31.641C44.1691 31.641 46.7765 32.8084 48.6639 34.6958C50.5512 36.5831 51.7187 39.1906 51.7187 42.0706C51.7187 44.9505 50.5512 47.5579 48.6639 49.4453C46.7765 51.3327 44.1691 52.5001 41.2891 52.5001C38.4091 52.5001 35.8017 51.3327 33.9143 49.4453C32.027 47.5579 30.8595 44.9505 30.8595 42.0706C30.8595 39.1906 32.027 36.5832 33.9143 34.6958C35.8017 32.8084 38.4091 31.641 41.2891 31.641ZM47.6696 35.6901C46.0368 34.0572 43.7809 33.0473 41.2891 33.0473C38.7973 33.0473 36.5414 34.0572 34.9086 35.6901C33.2758 37.3229 32.2658 39.5788 32.2658 42.0706C32.2658 44.5623 33.2758 46.8182 34.9086 48.451C36.5414 50.0839 38.7973 51.0938 41.2891 51.0938C43.7809 51.0938 46.0368 50.0839 47.6696 48.451C49.3024 46.8182 50.3124 44.5623 50.3124 42.0706C50.3124 39.5788 49.3024 37.3229 47.6696 35.6901Z" fill="#A3A3A3"/> <path d="M36.8237 36.6109C36.5492 36.3364 36.104 36.3364 35.8294 36.6109C35.5549 36.8854 35.5549 37.3306 35.8294 37.6052L45.7544 47.5301C46.0289 47.8047 46.4741 47.8047 46.7487 47.5301C47.0232 47.2556 47.0232 46.8104 46.7487 46.5359L36.8237 36.6109Z" fill="#A3A3A3"/> <path d="M35.8295 46.5359C35.5549 46.8104 35.5549 47.2556 35.8295 47.5301C36.104 47.8047 36.5492 47.8047 36.8238 47.5301L46.7487 37.6052C47.0233 37.3306 47.0233 36.8854 46.7487 36.6109C46.4742 36.3364 46.029 36.3364 45.7545 36.6109L35.8295 46.5359Z" fill="#A3A3A3"/> </g> <defs> <clipPath id="clip0_3258_6059"> <rect width="60" height="60" fill="white"/> </clipPath> </defs> </svg>
                                {{ __("Country not found") }}
                            </div>
                        </div>
                    </div>

                    <div class="content-select-country-action cart-check-box">
                        <button class="submit saveSelectCountry" type="submit" ng-click="saveSelectCountry()">{{ __('Update') }}</button>
                    </div>
                </div>
                <label ng-show="isSearch" ng-click="openSearchCountry()" class="openSearchCountry" for="select-country"></label>
            </div>

            <div class="great-taste"></div>
            @php
                $footerPaymentsList = getOption('payments-list', '');
            @endphp
            {!!$footerPaymentsList!!}

            @if ($shoppingRatingCount > 0 && false)
                <div class="cart-customer-review flex-b align-c flex-c flex-w">
                    <?php
                        $text = __('#value out of 5 based on #reviews_count#reviews_text');
                        $text = str_replace("#value", $shoppingRating, $text);
                        $text = str_replace("#reviews_count", $shoppingRatingCount, $text);
                        $reviewText = '<strong class="cart-customer-review-item">' . __('reviews') . '</strong>';
                        $text = str_replace("#reviews_text", $reviewText, $text);
                    ?>
                        <a href="{{ $shoppingUrl }}" target="_blank">
                            {{ __('Our customers are saying: ') }}
                        </a>
                        <a href="{{ $shoppingUrl }}" target="_blank">

                        <span class="star-review-wrapp flex-b align-c">
                            <?php
                                for ($i = 1; $i <= 5; $i++) {
                                    if ($i <= round($shoppingRating)) {
                                        echo '<svg viewBox="0 0 576 512" width="100" title="star">
                                                    <path d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z" />
                                                </svg>';
                                    } else {
                                        echo '<svg viewBox="0 0 576 512" width="100" title="star">
                                                <path d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z" />
                                            </svg>';
                                    }
                                }
                            ?>
                            <div class="cover" style="--rating:{{ $shoppingRating }}"></div>
                        </span>
                        </a>
                        <a href="{{ $shoppingUrl }}" target="_blank">
                            <span><?= $text ?></span>
                        </a>
                        <img class="cart-customer-review-item" src="/modules/cart/images/google.svg" height="24" alt="">
                        <a href="{{ $shoppingUrl }}" target="_blank">
                            <strong>{{ __('Google Customer Reviews') }}</strong>
                        </a>
                    <?php
                        $customerReviewText = __("Our customer say #excellent_text #star_image 4.4 out of 5 based on 184,96 #reviews_text #branch_image");
                        $excellentText = '<strong class="cart-customer-review-item">' . __('Excellent') . '</strong>';
                        $starImage = '';
                        $branchImage = '<img class="cart-customer-review-item" src="/modules/cart/images/google.svg" height="24" alt="">';
                        $reviewText = '<strong class="cart-customer-review-item">' . __('reviews') . '</strong>';
                        $customerReviewText = str_replace('#excellent_text', $excellentText, $customerReviewText);
                        $customerReviewText = str_replace('#star_image', $starImage, $customerReviewText);
                        $customerReviewText = str_replace('#reviews_text', $reviewText, $customerReviewText);
                        $customerReviewText = str_replace('#branch_image', $branchImage, $customerReviewText);
                    ?>

                </div>
            @endif

            @if ($isShowGuarantee)
                <div class="product-detail-row flex-b align-c product-detail-addon">
                    <img class="p-2" width="60px" height="60px" style="margin-right: 15px;" src="/modules/cart/images/guarantee.png" alt="" style="padding: 2px">
                        <div>
                            <span class="product-row-text addition-head">{{ __('Don’t love it? We’ll fix it. For free.') }}</span>
                            <br>
                            <a class="product-row-text addition-head addition-col" href="{{ getOption('guarantee_url', '/the-printerval-guarantee-n629.html') }}" target="_blank"
                            style="color: var(--secondary)"
                            >
                            {{ formatString(__('%s Guarantee'), getOption('general.store_name', 'Printerval')) }} »
                        </a>
                    </div>
                </div>
            @endif
            
            @include('cart::new-theme.includes.make-change')
            @include('cart::new-theme.includes.payment-detail')

            <div class="delete-item-wrapper @{{ showModalRemoveCartItem ? 'show-remove-modal' : '' }}" ng-show="showModalRemoveCartItem">
                <div class="delete-item-content delete-item-content-new">
                    <div class="delete-item-content-top">
                        <div class="delete-item-title">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
                                <path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
                                <path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
                            </svg>
                            <span>{{ __('Remove item') }}</span>
                            <span class="close-pop" ng-click="closeModalRemoveCartItem()">
                                <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
                            </span>
                        </div>
                        <div class="delete-item-content-block">
                            <div class="delete-item-desc total-product-sale" ng-if="totalProductSale > 0">
                                @{{ totalProductSale }} {{ __('customers purchased this') }}.
                            </div>
                            <div class="delete-item-desc">
                                <span class="delete-item-icon flex-b align-c flex-c">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
                                </span>
                                <span>{{ __('Are you sure you want to remove this item?') }}</span>
                            </div>
                            <div class="delete-item-product">
                                <img ng-src="@{{ itemRemove.image_url }}" width="60" height="60" alt="@{{ itemRemove.product_name }}">
                                <div class="delete-item-product-info">
                                    <div>@{{ itemRemove.product_name }}</div>
                                    <div>@{{ itemRemove.name_variant }}</div>
                                </div> 
                            </div>
                        </div>
                        <div class="delete-item-action">
                            <a href="javascript:;" class="delete-item-action-button delete-item-action-cancel" ng-click="closeModalRemoveCartItem()">{{ __('Cancel') }}</a>
                            <a href="javascript:;" class="delete-item-action-button delete-item-action-delete" ng-click="removeCartItems(itemRemove)">{{ __('Remove') }}</a>
                        </div>
                    </div>
                    {{-- <div class="delete-item-content-bottom">
                        <div class="delete-item-title" ng-show="comments.length > 0">
                            <svg width="16" height="16" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
                                <path fill="#FFB636" d="m252.5 381l-128 49c-5.9 2.2-12.1-2.3-11.8-8.6l7-136.9c.1-2.1-.6-4.2-1.9-5.9L31.6 172c-4-4.9-1.6-12.2 4.5-13.9l132.4-35.6c2.1-.6 3.9-1.9 5-3.7L248.3 4c3.4-5.3 11.2-5.3 14.6 0l74.8 114.9c1.2 1.8 3 3.1 5 3.7l132.4 35.6c6.1 1.6 8.5 9 4.5 13.9l-86.1 106.6c-1.3 1.7-2 3.8-1.9 5.9l7 136.9c.3 6.3-5.9 10.8-11.8 8.6l-128-49c-2.1-.8-4.3-.8-6.3-.1z"/>
                                <path fill="#FFD469" d="m456.1 51.7l-41-41c-1.2-1.2-2.8-1.7-4.4-1.5c-1.6.2-3.1 1.2-3.9 2.6l-42.3 83.3c-1.2 2.1-.8 4.6.9 6.3c1 1 2.4 1.5 3.7 1.5c.9 0 1.8-.2 2.6-.7L454.9 60c1.4-.8 2.4-2.2 2.6-3.9c.3-1.6-.3-3.2-1.4-4.4zm-307 43.5l-42.3-83.3c-.8-1.4-2.2-2.4-3.9-2.6c-1.6-.2-3.3.3-4.4 1.5l-41 41c-1.2 1.2-1.7 2.8-1.5 4.4c.2 1.6 1.2 3.1 2.6 3.9l83.3 42.3c.8.5 1.7.7 2.6.7c1.4 0 2.7-.5 3.7-1.5c1.7-1.8 2-4.4.9-6.4zm140.7 410l-29-88.8c-.2-.9-.7-1.7-1.3-2.3c-1-1-2.3-1.5-3.7-1.5c-2.4 0-4.4 1.6-5.1 3.9l-29 88.8c-.4 1.6-.1 3.3.9 4.6c1 1.3 2.5 2.1 4.2 2.1h57.9c1.6 0 3.2-.8 4.2-2.1c1.1-1.4 1.4-3.1.9-4.7z"/>
                            </svg>
                            <span>{{ __('Product Review Best Practices') }}</span>
                        </div>
                        <div class="cart-revew-slider" ng-show="comments.length > 0">
                            <div class="cart-review-item-list">
                                <div class="swiper-wrapper">
                                    <div class="cart-review-item-item swiper-slide" ng-repeat="comment in comments">
                                        <img class="cart-review-item-rate" src="{{ asset('modules/cart/images/star-list.svg') }}" height="14" height="78">
                                        <div class="cart-review-item-title">@{{ comment.name }}</div>
                                        <div class="cart-review-item-content">@{{ comment.content ? comment.content : comment.title }}</div>
                                    </div>
                                </div>
                                <div class="swiper-button-next cart-revew-next"></div>
                                <div class="swiper-button-prev cart-revew-prev"></div> 
                                <div class="swiper-pagination cart-pagination"></div>
                            </div>
                        </div>
                    </div> --}}
                </div>
                <div class="delete-item-background" ng-click="closeModalRemoveCartItem()"></div>
            </div>
            @include('cart::includes.guest-popup')
            
        </div>
        <div class="md-also-bought-content" id="also-bought-content">
            <div class="md-also-bought-heading">
                {{ __('You may also like')}}
            </div>
            <div class="md-also-bought-slide">
                <div class="md-also-bought-list">
                </div>
            </div>
        </div>
    </div>
    @view('cart.tracking', ['cartItems' => $cartItems])
    <div class="close-body-open-background"></div>
</div>
<script>
    let cartItems = {!! json_encode($cartItems) !!}
    window.dataLayer.push({'currency': "<?= env('CURRENCY_UNIT', 'USD') ?>"});
</script>
