<?php
    $checkoutLocale = env('APP_LOCALE', 'us');
    if (!$checkoutLocale) {
        $checkoutLocale = 'us';
    }
    $paypalExpressCheckout = config("cart::paypal.express_checkout", false);
    $usePaypalExpressCheckout = config("cart::paypal.use_paypal_express_checkout", false);
?>
<script type="text/javascript">
    var token = '{{ getFingerprint() }}';
    var cartCdnIgnoreUrl = <?= json_encode(config('cdn.ignore', [])); ?>;
    var priceConfig = <?= json_encode(getPriceConfig()) ?>;
    var priceTemplate = "{{ getCurrencyTemplate() }}";
    var cartCdnAllowUrl = <?= json_encode(config('cdn.allow', [])); ?>;
    var user = <?= json_encode($user); ?>;
    var appUrl = "<?= config("app.url") ?>";
    var prefixLocaleUrl = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var paypalFee = "<?= config("cart::paypal.include_fee", 0) ?>";
</script>
<script src="{{ asset('modules/cart/js/angular.min.js') }}"></script>
<script src="{{ asset('modules/cart/js/angular-sanitize.min.js') }}"></script>
<script src="{{ asset('modules/cart/js/html2canvas.min.js') }}"></script>
<script>
    var siteBaseUrl = "{{ route('home') }}";
    var base_api_url = "<?= config('cart::sa.api_url') ?>";
    var ignoreOptionIds = <?= json_encode(config('pod::sa.custom_ignore_option_id.' . $checkoutLocale, [])) ?>;
    var useDiscount = "<?= config("discount::sa.use_discount", false) ?>";
    var useDiscountCart = "<?= config("discount::sa.use_discount_cart", false) ? 1 : 0?>";
    var usePaypalExpressCheckout = "<?= config("cart::paypal.use_paypal_express_checkout", false) ? 1 : 0?>";
    var designFee = "<?= config('cart::sa.design_fee') ?>";
    var includeDesignFee = "<?= config('cart::sa.design_include_fee') ?>";
    var countryByIp = "{{ config('app.locale_shipping') }}";
    if (!countryByIp) {
        countryByIp = "{{ \App\Utils::countryFromIp() }}";
    }
    var monthNames = [
        "{{ __('Jan. #date') }}", "{{ __('Feb. #date') }}", "{{ __('Mar. #date') }}", "{{ __('Apr. #date') }}", "{{ __('May. #date') }}", "{{ __('Jun. #date') }}",
        "{{ __('Jul. #date') }}", "{{ __('Aug. #date') }}", "{{ __('Sep. #date') }}", "{{ __('Oct. #date') }}", "{{ __('Nov. #date') }}", "{{ __('Dec. #date') }}"
    ];
    var deliveryText = "{{ __('Deliver to #country') }}";
    var textBusinessDays = "{{ __('#date business days with tracking') }}";
    var textBuyDesign = "{{ __('Love this design? Purchase Licensed Design File.') }}";
    var copyText = "{{ __('Copy') }}";
    var invalidQuantityText = "{{ __('Invalid quantity!') }}";
    var addedToCartText = "{{ __('Added to Cart!') }}";
    var confirmRemoveItemText = "{{ __('Are you sure you want to remove this item?') }}";
    var coppiedText = "{{ __('Copied to clipboard') }}";
    var removeItemText = "{{ __('Item removed successfully!') }}";
    var sameInCartText = "{{  __('You have great taste! #quantity customers have chosen products just like yours.') }}";
    var freeshipText = "{{  __('Free Standard Shipping for Orders #amount+ with Code: #code') }}";
    var cartTranslateText = {
        front: "{{ __('Front') }}",
        back: "{{ __('Back') }}",
        left: "{{ __('Left') }}",
        right: "{{ __('Right') }}",
        top: "{{ __('Top') }}",
        bottom: "{{ __('Bottom') }}"
    };
    var printLocations = <?= json_encode(getPrintLocationConfig()) ?>;
    var printLocationsPrice = <?= json_encode(getPrintLocationPriceConfig()) ?>;
    var rewardsPercent = "<?= config('cart::sa.rewards_percent', 0) ?>";
    var showRewards = "<?= config('cart::sa.show_rewards', false) ?>";
    var tenancyToken = "<?= !empty($tenancyToken) ? $tenancyToken : '' ?>";
    var isMobile = true;
    @mobile
    @elsemobile
        isMobile = false;
    @endmobile
    var mySwiper = new Swiper ('.cart-review-item-list', {
        loop: true,
        slidesPerView: 1,
        spaceBetween: 0,
        autoplay:  2500,
        navigation: {
            nextEl: ".cart-revew-next",
            prevEl: ".cart-revew-prev",
        },
    })
    window.PodHireDesignerFee = {{ config('pod::sa.hire_designer_fee', 3) }};
    var cjeventCookie = "{{ isset($_COOKIE['cje']) ? $_COOKIE['cje'] : '' }}";
    var checkoutUrl = "<?= route('module::cart::checkout') ?>";
    var loginUrl = "{{ route('user:sign-in') }}?is_checkout=1&ignore_localization=1";
    var signUpUrl = "{{ route('user:sign-up') }}?is_checkout=1&ignore_localization=1";
    var continueLoginUrl = "{{ route('cart::continue-login') }}?ignore_localization=1";
    var csrfToken = "{{ csrf_token() }}";
    var enterEmailText = "{{ __('Please enter your email and password') }}";
    var enterValidEmailText = "{{ __('Please enter a valid email') }}";
    var enterValidFirstNameText = "{{ __('Please enter first name') }}";
    var enterPasswordText = "{{ __('Please enter your password') }}";
    var enterConfirmPasswordText = "{{ __('Please enter your confirm password') }}";
    var enterMatchPasswordText = "{{ __('Password and confirm password do not match') }}";
    var donotMatchText = "{{ __('Email and password do not match') }}";
    var welcomeText = "{{ __('Welcome back #name!') }}";
    var earnPointText = "{{ __('Earn #point loyalty points with every purchase and redeem them for exclusive rewards in your account. Stay tuned for more exciting benefits with the Printerval Loyalty Program!') }}";
    var moreAmountText = "{{ __('more to get #point CP bonus points') }}"
    var betweenFromToText = "{{ __('#key between #from - #to') }}";
    var heightPaypalButton = 46;
</script>
<script src="{{ asset('modules/cart/js/cart.js') }}?v={{ config('sa.version') }}"></script>
<script src="{{ '/assets/js/controllers/sku-controller.js?v=' . config('sa.version') }}"></script>
<script src="{{ '/assets/js/controllers/print-location-controller.js?v=' . config('sa.version') }}"></script>
<script>
    var makeChangeApp = app;
</script>
<script src="{{ asset('modules/cart/new-theme/js/make-change.js') }}?v={{ config('sa.version') }}"></script>
