<?php
$shippingPolicyUrl = getOption('checkout.shipping.url');
if (!$shippingPolicyUrl) {
	$shippingPolicyUrl = "javascript:;";
}
$paypalFee = config("cart::paypal.include_fee");
$usePaypal = config("cart::paypal.use_paypal", false);
$useLian = config("cart::lian.use_lian", false);
$paypalExpressCheckout = config("cart::paypal.express_checkout", false);
$stripeFee = config("cart::stripe.include_fee");
$giropayFee = config("cart::stripe.giropay_include_fee");
$applepayFee = config("cart::stripe.applepay_include_fee");
$klarnaFee = config("cart::stripe.klarna_include_fee");
$afterpayFee = config("cart::stripe.afterpay_include_fee");
$codFee = config("cart::sa.cod_include_fee");
$adyenFee = config("cart::adyen.include_fee");
$useGiropay = config("cart::stripe.use_giropay", false);
$useApplepay = config("cart::stripe.use_applepay", false);
$useExpressCheckout = config("cart::stripe.use_express_checkout", false);
$useKlarna = config("cart::stripe.use_klarna", false);
$useAfterpay = config("cart::stripe.use_afterpay", false);
$useCOD = config("cart::sa.use_cod", false);
$useBusinessDay = config('cart::sa.use_business_day', false);
$useTaxes = config('cart::sa.use_taxes', false);
$buyNowPayLaterText = __("Buy now, pay later via #type");
$checkoutViaText = __("Checkout via #type");
$isShowTransactionFee = true;
$isShowGuarantee = config('cart::sa.is_show_guarantee', true);
$designFee = config('cart::sa.design_fee', 0);
$rewardsPercent = config('cart::sa.rewards_percent', 0);
$isShowFreeShippingPackage = config('cart::sa.is_show_freeship_package', true);
$cardForm = config('cart::sa.card_form', 'stripe');
if (isset($_GET["mode"]) && $_GET["mode"] == "paypal") {
	$cardForm = "paypal";
}
if ($stripeFee == 0) {
	$allZero = true;
	if ($usePaypal && $paypalFee > 0) {
		$allZero = false;
	}
	if ($useGiropay && $giropayFee > 0) {
		$allZero = false;
	}
	if ($useKlarna && $klarnaFee > 0) {
		$allZero = false;
	}
	if ($useAfterpay && $afterpayFee > 0) {
		$allZero = false;
	}
	if ($useApplepay && $applepayFee > 0) {
		$allZero = false;
	}
	if ($useCOD && $codFee > 0) {
		$allZero = false;
	}
	if ($allZero) {
		$isShowTransactionFee = false;
	}
}
$handlingFeeText = __("Handling fee is the fulfillment fee. This is the fee you pay to process an order.");
$otherFeeText = __("In accordance with the International Emergency Economic Powers Act (IEEPA)");

$filePath = base_path('app/Modules/Cart/Setting/phone.json');
$jsonContent = trim(file_get_contents($filePath));
$allCountries = json_decode($jsonContent, true);
?>

<div class="container-indent flex-box flex-w" ng-app="myApp" ng-controller="CheckOutController" ng-cloak style="margin: 0 auto">
	<div class="cart-center-col">
		<div class="checkout-address-container checkout-address-container" id="form-checkout">
			<div class="checkout-address-form">
				<nav aria-label="Breadcrumb">
					<ol class="checkout-breadcrumb breadcrumb--center" role="list">
						<li class="breadcrumb__item breadcrumb__item--current flex-b flex-c align-c" aria-current="step">
							<span class="icon-cart flex-b flex-c align-c active">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M5.94708 4.86192C6.20743 4.76989 6.4931 4.90636 6.58512 5.16672C6.79128 5.74999 7.34757 6.16667 7.9999 6.16667C8.65222 6.16667 9.20852 5.74999 9.41467 5.16672C9.5067 4.90636 9.79236 4.76989 10.0527 4.86192C10.3131 4.95394 10.4495 5.2396 10.3575 5.49996C10.0146 6.47028 9.08919 7.16667 7.9999 7.16667C6.9106 7.16667 5.98524 6.47028 5.64228 5.49996C5.55026 5.2396 5.68672 4.95394 5.94708 4.86192ZM8.24016 3.66667H7.75937C6.67551 3.66667 5.95411 3.66845 5.40775 3.73596C4.88886 3.80007 4.64969 3.91153 4.48185 4.05082C4.314 4.19012 4.16037 4.40466 4.00174 4.90284C3.8347 5.4274 3.70001 6.13612 3.50026 7.20142C3.22028 8.69468 3.03256 9.70894 2.99921 10.4729C2.96707 11.2093 3.09047 11.5223 3.26372 11.7311C3.43698 11.9398 3.72192 12.1188 4.4516 12.2229C5.20861 12.3309 6.24009 12.3333 7.75937 12.3333H8.24016C9.75944 12.3333 10.7909 12.3309 11.5479 12.2229C12.2776 12.1188 12.5626 11.9398 12.7358 11.7311C12.9091 11.5223 13.0325 11.2093 13.0003 10.4729C12.967 9.70894 12.7793 8.69468 12.4993 7.20142C12.2995 6.13612 12.1648 5.4274 11.9978 4.90284C11.8392 4.40466 11.6855 4.19012 11.5177 4.05082C11.3498 3.91153 11.1107 3.80007 10.5918 3.73596C10.0454 3.66845 9.32403 3.66667 8.24016 3.66667ZM3.84321 3.28131C3.10261 3.89596 2.90754 4.93635 2.51739 7.01713C1.96877 9.94309 1.69447 11.4061 2.49421 12.3697C3.29396 13.3333 4.78243 13.3333 7.75937 13.3333H8.24016C11.2171 13.3333 12.7056 13.3333 13.5053 12.3697C14.3051 11.4061 14.0308 9.94309 13.4821 7.01713C13.092 4.93635 12.8969 3.89596 12.1563 3.28131C11.4157 2.66667 10.3572 2.66667 8.24016 2.66667H7.75937C5.64233 2.66667 4.58381 2.66667 3.84321 3.28131Z" fill="white"/> </svg>
							</span>
							<a class="breadcrumb__link" href="{{ clroute('/cart') }}">{{ __('Cart') }}</a>
							<small class=""></small>
						</li>
						<li class="breadcrumb__item breadcrumb__item--current flex-b flex-c align-c">
							<span class="icon-cart flex-b flex-c align-c active">
								<svg  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 9h.01" /><path d="M11 12h1v4h1" /></svg>
                    		</span>
							<span class="breadcrumb__text">{{ __('Order Information') }}</span>
							<small></small>
						</li>
						<li class="breadcrumb__item breadcrumb__item--blank flex-b flex-c align-c">
							<span class="icon-cart icon-cl flex-b flex-c align-c">
								<svg  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 12l5 5l10 -10" /><path d="M2 12l5 5m5 -5l5 -5" /></svg>
                    		</span>
							<span class="breadcrumb__text">{{ __('Complete') }}</span>
						</li>
					</ol>
				</nav>
				@if ($paypalExpressCheckout)
				<div class="dynamic-checkout" ng-show="modeCheckout == 'test'">
					<h2 class="dynamic-checkout-title">
				        {{ __('Express checkout')}}
				    </h2>
					<div id="paypal-button-container-sidebar" target="_self"></div>
				    <div class="dynamic-checkout-or">
				        {{ __('or')}}
				    </div>
				</div>
				@endif

				<div class="common-title">
					<span class="font-big font-bold mx-lg-5">{{ __("Billing information") }}</span>
				</div>
				<form class="address-container" novalidate="novalidate" action="/checkout" ng-cloak autocomplete="nope">
					<div class="address-row">
						<div class="address-col" id="first_name_parent">
							<input id="first_name" name="name" type="text" class="form-control" ng-class="class('first_name')" ng-model="first_name" ng-change="change('first_name')" ng-blur="blurAction('first_name', first_name)" placeholder="{{ __('First name') }}">
							<div class="invalid-feedback" ng-if="hasError('first_name')" ng-bind="getErrorMsg('first_name')"></div>
						</div>
					</div>
					<div class="address-row">
						<div class="address-col" id="last_name_parent">
							<input id="last_name" name="name" type="text" class="form-control" ng-class="class('last_name')" ng-model="last_name" ng-change="change('last_name')" ng-blur="blurAction('last_name', last_name)" placeholder="{{ __('Last name') }}">
							<div class="invalid-feedback" ng-if="hasError('last_name')" ng-bind="getErrorMsg('last_name')"></div>
						</div>
					</div>
					<div class="address-row">
						<div class="phone-container">
							<div class="suggestion-phone" id="suggestion-phone">
								<div class="phone-group">
									<div class="code-gr" id="code-gr">
										<img id="selectedFlag" src="" class="country-flag" width="24" height="24" alt="" style="display: none">
										<span id="selectedCode" class="code"></span>
									</div>
									<div class="code-text address-col" id="phone_parent" style="margin: 0; padding-right: 0">
										<input type="tel" id="phone" placeholder="{{ __('Phone number') }} " ng-model="phone" ng-class="class('phone')" ng-change="change('phone')"
											   ng-blur="handleBlurPhone(); blurAction('phone', phone)" class="code-text-input form-control">
										<div class="invalid-feedback" ng-if="hasError('phone')" ng-bind-html="getErrorMsg('phone')"></div>
										<div class="address-tooltip">
											<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
												<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
											</svg>
											<div class="address-tooltip-content">
												{{ __('In case we need to contact you about your order') }}
											</div>
										</div>
									</div>
								</div>
								<div class="suggestion-list">
									<div class="suggestion-sticky">
										<div class="suggestion-input-gp">
											<button>
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none" /> <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0" /> <path d="M21 21l-6 -6" /></svg>
											</button>
											<input id="jsSearchPhone"  type="text" placeholder="{{ __('Please enter name of country...') }}" class="code-text-input">
										</div>
									</div>
									<ul class="list-phone" id="list-phone">
										@if (!empty($allCountries))
											@foreach($allCountries ?? [] as $country)
												@if (!empty($country['image']) && !empty($country['name']) && !empty($country['phone_code']))
													<li class="phone-item phone-item-1" data-locale="{{ $country['code'] }}">
														<img src="{{ htmlspecialchars($country['image']) }}"
												 			alt="{{ htmlspecialchars($country['name']) }}" width="24" height="24">
														<span class="country-name">{{ htmlspecialchars($country['name']) }}</span>
														<span class="country-code">+{{ htmlspecialchars($country['phone_code']) }}</span>
													</li>
												@endif
											@endforeach
										@else
										<li class="no-data">No countries available.</li>
										@endif
									</ul>
								</div>
							</div>
						</div>
					</div>
					<div class="address-row">
						<div class="address-col" id="email_parent">
							<input id="email" name="email" type="text" class="form-control" ng-class="class('email')" ng-model="email" ng-change="change('email')" ng-blur="verifyEmail(); getCustomerInfo(); blurAction('email', email)" ng-disabled="isDisableEmail" placeholder="{{ __('Email') }}">
							<div class="invalid-feedback" ng-if="hasError('email')" ng-bind-html="getErrorMsg('email')"> </div>
							<div class="address-tooltip">
								<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
									<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
								</svg>
								<div class="address-tooltip-content">
									{{ __('We will update the status of your order via this email address') }}
								</div>
							</div>
						</div>
					</div>

					<div class="common-title">
						<span class="font-big font-bold mx-lg-5">{{ __('Shipping Address') }}</span>
					</div>

					<span class="fill-from-address-book-wrapper" ng-if="addressBook && addressBook.length">
						<button class="btn-open-fill-from-address-book" type="button" ng-click="openAddressBook()">
							{{ __('Fill from address book') }}
						</button>
					</span>

					<input class="gift-checkbox" id="gift-infomation" type="checkbox" ng-checked="gift.is_check" autocomplete="off" ng-click="openSendGift()">
					<label class="gift-infomation" for="gift-infomation">
						<small class="checkbox"></small>
						<span class="gift-title">
							{{ __('Send to your friend') }}
						</span>
					</label>
					<div class="gift-content">
						<div class="address-row">
							<div class="address-col" id="sender-name">
								<input id="sender-name-input" placeholder="{{ __("Recipient's full name") }}" name="name" type="text" class="form-control"  ng-class="class('name', 'gift')" ng-model="gift.name" ng-change="change('name', 'gift')" autocomplete="off">
								<div class="invalid-feedback" ng-if="hasError('name', 'gift')" ng-bind="getErrorMsg('name', 'gift')"></div>
							</div>
						</div>
						<div class="address-row">
							<div class="phone-container">
								<div class="suggestion-phone" id="suggestion-phone-friend">
									<div class="phone-group">
										<div class="code-gr" id="code-gr-friend">
											<img id="selectedFlagFriend" src="" class="country-flag" width="24" height="24" alt="" style="display: none">
											<span id="selectedCodeFriend" class="code"></span>
										</div>
										<div class="code-text address-col" id="phone-gift-parent" style="margin: 0; padding-right: 0">
											<input id="sender-phone-input" placeholder="{{ __("Recipient's phone") }}" name="phone" type="text" class="form-control" ng-class="class('phone', 'gift')" ng-model="gift.phone" ng-change="change('phone', 'gift')" autocomplete="off">
											<div class="invalid-feedback" ng-if="hasError('phone', 'gift')" ng-bind-html="getErrorMsg('phone', 'gift')"></div>
											<div class="address-tooltip">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
													<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
												</svg>
												<div class="address-tooltip-content">
													{{ __("If you're sending this order as a gift, we'll use this phone number to coordinate the delivery with the recipient and clarify any details if needed.") }}
												</div>
											</div>
										</div>
									</div>
									<div class="suggestion-list">
										<div class="suggestion-sticky">
											<div class="suggestion-input-gp">
												<button>
													<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none" /> <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0" /> <path d="M21 21l-6 -6" /></svg>
												</button>
												<input id="jsSearchPhoneFriend"  type="text" placeholder="{{ __('Please enter name of country...') }}" class="code-text-input">
											</div>
										</div>
										<ul class="list-phone" id="list-phone-friend">
											@if (!empty($allCountries))
												@foreach($allCountries ?? [] as $country)
													@if (!empty($country['image']) && !empty($country['name']) && !empty($country['phone_code']))
														<li class="phone-item phone-item-2" data-locale="{{ $country['code'] }}">
															<img src="{{ htmlspecialchars($country['image']) }}"
																 alt="{{ htmlspecialchars($country['name']) }}" width="24" height="24">
															<span class="country-name">{{ htmlspecialchars($country['name']) }}</span>
															<span class="country-code">+{{ htmlspecialchars($country['phone_code']) }}</span>
														</li>
													@endif
												@endforeach
											@else
												<li class="no-data">No countries available.</li>
											@endif
										</ul>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div ng-class="{ 'address-row' : true, 'custom-state' : shipingLocation.province && shipingLocation.province.id == -1 }" id="shipping-info-area">
						<div class="address-col" ng-class="class('country')" style="z-index: 12" id="country_parent">
							<input autocomplete="off" class="input-text input-dropdown filter-country @{{ isShowSelectCountry ? 'selected' : '' }}" readonly value="@{{ shipingLocation.country.nicename }}" placeholder="{{ __('Country / Region') }}" type="text" ng-click="openSelectCountry()">
							<span class="js-close-search-filter" ng-click="closeSelectCountry()" ng-show="isShowSelectCountry">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
									<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
								</svg>
							</span>
							<div class="autocomplate-content content-select-country" ng-show="isShowSelectCountry">
								<div class="search">
									<input class="autocomplate-search filter-country input-text" placeholder="{{ __('Enter Country / Region to search')}}" type="text" value="" autocomplete="none">
								</div>
								<ul class="list-filter-item">
									<li class="search-filter-item" ng-repeat="item in countries" ng-click="selectCountry(item, true);">@{{ item.nicename }}</li>
								</ul>
							</div>

							<div class="invalid-feedback" ng-if="hasError('country')" ng-bind="getErrorMsg('country')"> </div>
							<div class="background-select-country" ng-show="isShowSelectCountry" ng-click="closeSelectCountry()"></div>
						</div>
					</div>
					<div class="address-row address-suggestion flex-box flex-s flex-w">
						<div class="address-col" id="address_parent">
							<input id="address"
								type="text"
								class="form-control"
								ng-class="class('address')"
								ng-model="address"
								ng-change="change('address');"
								placeholder="{{ __('Address') }}"
								autocomplete="shipping street-address"
								ng-model-options="{ debounce: 500 }"
								ng-blur="blurAction('address', address)"
							>
							<div class="invalid-feedback" ng-if="hasError('address')" ng-bind="getErrorMsg('address')"> </div>
						</div>
					</div>
					<div class="address-row flex-box flex-s flex-w">
						<div class="address-col" id="optional_address_parent">
							<input
								id="optional_address"
								name="optional_address"
								type="text"
								class="form-control"
								ng-class="class('optional_address')"
								placeholder="{{ __('Apartment, suite, etc. (optional)') }}"
								autocomplete="none"
								ng-model="shipingLocation.optional_address"
								ng-change="change('optional_address')"
								ng-blur="blurAction('optional_address', shipingLocation.optional_address)"
							>
						</div>
					</div>
					<div id="shipingLocationCountry" class="address-row flex-box flex-s flex-w">
						<div class="address-col" ng-show="shipingLocation.country && shipingLocation.country.iso != 'VN'" id="city_name_parent">
							<input
								name="city_name"
								class="form-control"
								type="text"
								ng-class="class('city_name')"
								placeholder="{{ __('City / Suburb') }}"
								id="city_name"
								ng-model="shipingLocation.city_name"
								ng-change="change('city_name')"
								ng-blur="blurAction('city_name', shipingLocation.city_name)"
							/>
							<div class="invalid-feedback" ng-if="hasError('city_name')" ng-bind="getErrorMsg('city_name')"> </div>
						</div>
						<div class="address-col" ng-class="class('province')" ng-show="shipingLocation.country && provinces && provinces.length > 0" id="province_parent">
							<input autocomplete="off" class="input-text input-dropdown filter-province @{{ isShowSelectProvince ? 'selected' : '' }}" readonly value="@{{ shipingLocation.province.name }}" placeholder="{{ __('State / Province')}}" type="text" ng-click="openSelectProvince()">
							<span class="js-close-search-filter" ng-click="closeSelectProvince()" ng-show="isShowSelectProvince">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
									<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
								</svg>
							</span>
							<div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectProvince">
								<div class="search">
									<input class="autocomplate-search filter-province input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
								</div>
								<ul class="list-filter-item">
									<li class="search-filter-item" ng-repeat="item in provinces" ng-click="selectProvince(item);">@{{ item.name }}</li>
								</ul>
							</div>
							<div class="invalid-feedback" ng-if="hasError('province')" ng-bind="getErrorMsg('province')"> </div>
							<div class="background-select-province" ng-show="isShowSelectProvince" ng-click="closeSelectProvince()"></div>
						</div>
						<div class="address-col" ng-class="class('district')" ng-show="shipingLocation.province && districts && districts.length > 0" id="district_parent">
							<input autocomplete="off" class="input-text input-dropdown filter-district @{{ isShowSelectDistrict ? 'selected' : '' }}" readonly name="" value="@{{ shipingLocation.district.name }}" placeholder="{{ __('District / Town') }}" type="text" ng-click="openSelectDistrict()">
							<span class="js-close-search-filter" ng-click="closeSelectDistrict()" ng-show="isShowSelectDistrict">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
									<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
								</svg>
							</span>
							<div class="autocomplate-content content-select-country select-state" ng-show="isShowSelectDistrict">
								<div class="search">
									<input class="autocomplate-search filter-district input-text" placeholder="{{ __('Enter to search')}}" type="text" value="" autocomplete="none">
								</div>
								<ul class="list-filter-item">
									<li class="search-filter-item" ng-repeat="item in districts" ng-click="selectDistrict(item);">@{{ item.name }}</li>
								</ul>
							</div>
							<div class="invalid-feedback" ng-if="hasError('district')" ng-bind="getErrorMsg('district')"> </div>
							<div class="background-select-district" ng-show="isShowSelectDistrict" ng-click="closeSelectDistrict()"></div>
						</div>
						<div ng-class="{ 'address-col' : true, 'active' : shipingLocation.state_name != '' || isFocusStateName }" ng-show="shipingLocation.province && shipingLocation.province.id == -1" id="state_name_parent">
							<input
								name="state_name"
								class="form-control"
								type="text"
								ng-class="class('state_name')"
								placeholder="{{ __('Other State / Province') }}"
								id="state_name"
								ng-model="shipingLocation.state_name"
								ng-change="change('state_name');changeSateName();"
								ng-focus="changeFocusStateName(true)"
								ng-blur="changeFocusStateName(false); blurAction('state_name', shipingLocation.state_name)"
							/>
							<div class="invalid-feedback" ng-if="hasError('state_name')" ng-bind="getErrorMsg('state_name')"> </div>
						</div>
						<div class="address-col" id="zipcode_parent">
							<input
								id="zipcode"
								name="zipcode"
								type="text"
								class="form-control"
								placeholder="{{ __('ZIP / Postal code') }}"
								ng-class="class('zipcode')"
								ng-model="shipingLocation.zipcode"
								ng-change="change('zipcode');"
								ng-blur="blurAction('zipcode', shipingLocation.zipcode)"
							>
							<div class="invalid-feedback" ng-if="hasError('zipcode')" ng-bind="getErrorMsg('zipcode')"> </div>
						</div>
					</div>
					<div class="address-row flex-box flex-s flex-w">
						<div class="address-col" id="delivery_note_parent">
							<textarea
								id="delivery_note"
								name="delivery_note"
								type="text"
								class="form-control"
								placeholder="{{ __('Order notes (optional)') }}"
								ng-model="delivery_note"
								ng-change="change('delivery_note')"
								ng-blur="blurAction('delivery_note', delivery_note)"
							>
							</textarea>
							<div class="invalid-feedback" ng-if="hasError('delivery_note')" ng-bind="getErrorMsg('delivery_note')"> </div>
						</div>
					</div>

					<!-- Billing -->
					<div class="BillingAddressWrapper">
						<div class="billing-address-head">
							<div class="billing-address-title">
								<div class="common-title">
									<span class="font-big font-bold mx-lg-5">{{ __('Billing address') }}</span>
								</div>
								<div ng-if="!isDiffirentBillingAddress" class="billing-address-subtitle">{{ __('Billing address matches shipping address')}}</div>
								<div ng-if="isDiffirentBillingAddress" class="billing-address-subtitle">{{ __('Different billing address')}}</div>
							</div>
							<label class="toggleBillingAddress" for="toggleBillingAddress" ng-click="changeBillingAddress()">
								{{ __('Change')}}
							</label>
						</div>
						<input id="toggleBillingAddress" type="checkbox">
						<div class="billing-address-content">
							<div class="address-row">
								<div class="address-col" style="width: 100%">
									<input id="billing-name" placeholder="{{ __('Name') }}" name="name" type="text" class="form-control" ng-model="billingAddress.name" ng-class="class('name', 'billing')" ng-change="change('name', 'billing')">
									<div class="invalid-feedback"></div>
								</div>
							</div>

							<div ng-class="{ 'address-row' : true, 'custom-state' : billingAddress.province && billingAddress.province.id == -1 }">
								<div class="address-col" ng-class="class('country', 'billing')">
									<ui-select ng-model="billingAddress.country" theme="select2" ng-disabled="!countries" title="{{ __('Select Country/Region') }}" placeholder="{{ __('Select Country/Region') }}" style="width: 100%" ng-change="changeCountry('billing'); change('country', 'billing')">
										<ui-select-match placeholder="{{ __('Select Country/Region') }}">@{{$select.selected.nicename}}</ui-select-match>
										<ui-select-choices repeat="item in countries | filter: $select.search">
											<div ng-bind-html="item.nicename | highlight: $select.search"></div>
										</ui-select-choices>
									</ui-select>

									<div class="invalid-feedback" ng-if="hasError('country', 'billing')" ng-bind="getErrorMsg('country', 'billing')"> </div>
								</div>
							</div>
							<div class="address-row flex-box flex-s flex-w">
								<div class="address-col">
									<input id="billing-address" name="address" type="text" class="form-control" ng-class="class('address', 'billing')" placeholder="{{ __('Address') }}" autocomplete="none" ng-model="billingAddress.address" ng-change="change('address', 'billing')">
									<div class="invalid-feedback"> </div>
								</div>
							</div>
							<div class="address-row flex-box flex-s flex-w">
								<div class="address-col">
									<input id="billing-optional_address" name="billing-optional_address" type="text" class="form-control" ng-class="class('optional_address', 'billing')" placeholder="{{ __('Apartment, suite, etc. (optional)') }}" autocomplete="none" ng-model="billingAddress.optional_address" ng-change="change('optional_address', 'billing')">
								</div>
							</div>
							<div class="address-row flex-box flex-s flex-w">
								<div class="address-col" ng-if="billingAddress.country">
									<input name="city_name" placeholder="{{ __('City / Suburb') }}" class="form-control" type="text" ng-class="class('city_name', 'billing')" id="billing-city_name" ng-model="billingAddress.city_name" ng-change="change('city_name', 'billing')"/>
									<div class="invalid-feedback"> </div>
								</div>
								<div class="address-col" ng-class="class('province', 'billing')" ng-if="billingAddress.country && provincesBillings && provincesBillings.length">
									<ui-select ng-model="billingAddress.province" ng-disabled="!provincesBillings || !provincesBillings.length" class="select-country" theme="select2" title="{{ __('Select Country/Region') }}" style="width: 100%" ng-change="changeProvince('billing'); change('province', 'billing')">
										<ui-select-match>@{{$select.selected.name}}</ui-select-match>
										<ui-select-choices repeat="item in provincesBillings | filter: $select.search">
											<div ng-bind-html="item.name | highlight: $select.search"></div>
										</ui-select-choices>
									</ui-select>
									<div class="invalid-feedback" ng-if="hasError('province', 'billing')" ng-bind="getErrorMsg('province', 'billing')"> </div>
								</div>
								<div ng-class="{ 'address-col' : true, 'active' : billingAddress.state_name != '' || isFocusStateName }" ng-if="billingAddress.province && billingAddress.province.id == -1">
									<input name="state_name" class="form-control" placeholder="{{ __('Other State / Province') }}" type="text" ng-class="class('state_name', 'billing')" id="billing-state_name" ng-model="billingAddress.state_name" ng-change="change('state_name', 'billing')"/>
									<div class="invalid-feedback"></div>
								</div>
								<div class="address-col">
									<input id="billing-zipcode" placeholder="{{ __('ZIP / Postal code') }}" name="zipcode" type="text" class="form-control" ng-class="class('zipcode', 'billing')" ng-model="billingAddress.zipcode" ng-change="change('zipcode', 'billing')">
									<div class="invalid-feedback"> </div>
								</div>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>

	</div>
	<div class="cart-sidebar" ng-cloak>
		<div class="sidebar-content">
			<div class="shopcart-fixed-sidebar-container">
				<div class="cart-list-product-box" ng-cloak>
					<div class="common-title">
						<span class="font-big font-bold mx-lg-5">{{ __('Order Review') }}</span>
					</div>
					<div ng-show="firstLoadingCart.is_show" class="loading-item-box">
						<div class="form-shopcart checkout-item-box" ng-repeat="n in range(1, totalCartItem)">
							<div class="shopcart-item shopcart-name">
								<span class="shopcart-image-load">
									<span class="skeleton-box" style="width:100px; min-width: 100px; height: 100px"></span>
								</span>
									<div class="shopcart-info" style="display: flex; flex-wrap: wrap;">
									<span class="skeleton-box" style="width:100%; margin-bottom: 3px"></span>
									<div style="display: flex;flex-direction: column;margin-top: 10px;">
										<span class="skeleton-box" style="width:80px; margin-bottom: 3px"></span>
										<span class="skeleton-box" style="width:60px;"></span>
									</div>
										<div style="display: flex; flex-direction: column; margin-top: 16px">
										<span class="skeleton-box" style="width: 160px;margin-bottom: 3px"></span>
									</div>
								</div>
							</div>
						</div>
						<div class="order-item-shiping-method order-selected-shiping" style="border-color: #ddd; background-color: #f9f9f9; margin-top: 16px">
							<div class="order-item-shiping-method-content flex-b flex-dc">
							<div class="flex-b flex-s" style="width: 100%; margin-bottom: 10px">
									<span class="skeleton-box" style="width:70%"></span>
								<span class="skeleton-box" style="width:12%;"></span>
							</div>
							<span class="skeleton-box" style="width:30%; margin-bottom: 10px;"></span>
							<span class="skeleton-box" style="width:60%;"></span>
							</div>
						</div>
					</div>
					<div class="form-shopcart checkout-item-box @{{ loadingRemoveItem ? 'loading-remove-item' : ''}}" ng-repeat="shippingInfo in shippingInfos" ng-show="shippingInfos.length > 0 && !firstLoadingCart.is_show">
						<div class="shopcart-row shopcart-content" ng-repeat='item in shippingInfo.cartItems'>
							<div class="shopcart-item shopcart-name">
								<span class="checkout-image">
									<a target="_blank" class="shopcart-item-img-link" href="@{{ item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url }}">
										<img ng-src="@{{ getImageCdn(item.image_url, 540, 540, false) }}" alt="@{{ item.product_name }}" title="@{{ item.product_name }}" referrerpolicy="no-referrer">
									</a>
								</span>
								<div class="shopcart-info checkout-info">
									<a target="_blank" ng-bind-html="item.product_name | safeHtml" class="shopcart-item-link" href="@{{ item.product_sku_id ? item.url + '?spid=' + item.product_sku_id : item.url }}">
									</a>
									<div class="shopcart-configurations">
                                        <div class="cart-item-name-variant js-open-popover" ng-click="openFormChangeVariant(item)" ng-show="item.name_variant">
                                            <span class="config-item">@{{ item.name_variant }}</span>
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" ng-show="!item.disable_make_change">
												<path stroke="none" d="M0 0h24v24H0z" fill="none"/>
												<path d="M6 9l6 6l6 -6" />
											</svg>
                                            <div class="loading-background" ng-show="item.loadingMakeChange"></div>
                                        </div>
										<div class="config-item" ng-repeat="(key, value) in item.configurations">
                                            <div ng-if="key != 'print_location' && key != 'previewUrl' && key != 'buy_design' && key != 'design_fee' && key != 'hire_designer' && key != 'hire_designer'">
                                                @{{ key }}: @{{ value }}
                                            </div>
                                            <div ng-if="key == 'print_location' && getByField(printLocations, 'value', value)">
                                                {{ __('Print Location') }}: @{{ getByField(printLocations, 'value', value).name }}
                                            </div>
                                        </div>

                                        <div ng-if="item.print_location_3d">
                                            {{ __('Print Location') }}: @{{ item.print_location_3d }}
                                        </div>
                                       
										<div ng-if="item.preview_url">
											{{ __('Preview url') }}: <a href="@{{ item.preview_url }}" target="_blank">{{ __('View') }}</a>
										</div>
									</div>
									{{-- @if (Config::get('cart::sa.allow_update_checkout_item', true))
									<div class="flex-b align-c make-change-wrap" ng-hide="freeshipPackageProduct && freeshipPackageProduct.id == item.product_id">
										<div id="js-update-item" ng-hide="item.disable_make_change" ng-click="openFormChangeVariant(item)">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" ng-show="item.loadingMakeChange" viewBox="0 0 16 16" class="bi bi-arrow-repeat active">
                                                <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41zm-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9z"></path>
                                                <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5.002 5.002 0 0 0 8 3zM3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9H3.1z"></path>
                                            </svg>   
											<svg ng-show="!item.loadingMakeChange"  xmlns="http://www.w3.org/2000/svg"  width="16"  height="16"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" /><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" /><path d="M16 5l3 3" /></svg>
                                            <span>{{ __('Edit')}}</span>
                                        </div>
										<div id="js-delete-item" ng-click="openModalRemoveCartItem(item)" class="flex-b align-c">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M4 7l16 0"></path><path d="M10 11l0 6"></path><path d="M14 11l0 6"></path><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path></svg>
											<span>{{ __('Remove')}}</span>
										</div>
									</div>
									@endif --}}
									<div class="shopcart-contain-checkout">
										<div class="shopcart-item shopcart-price primary-text shopcart-item-checkout">
											<div class="shopping-item-quantity">
												<span>&times;</span>
												<span>@{{item.quantity}}</span>
											</div>
											<div class="shopping-item-price-box">
												<span class="shopping-item-price">
													@{{ formatPrice(item.price) }}
												</span>
												<del class="shopping-hight-price" ng-if="item.high_price && item.high_price > item.price">
													@{{ formatPrice(item.high_price) }}
												</del>
											</div>
											<!-- <small class="shopping-save-price" ng-if="item.discount_value">
												<?php  // echo sprintf(__('Save %s'), '{{ formatPrice(item.discount_value * item.quantity) }}') ?>
											</small> -->
										</div>
										{{-- <div class="shopcart-item shopcart-subtotal primary-text">
											@{{ formatPrice(item.total_amount, 0, false) }}
										</div> --}}
									</div>
									
									<!-- <div class="loading-buyDesign" id="loading-buyDesign-@{{ item.id }}" style="display: none;">
                                    </div> -->
									<div ng-if="item.hire_designer != undefined" class="buydesign-item">
										<div  class="flex-b buydesign-content-item hiredesign-content-item">
											<label for="hire-designer-@{{ item.id }}" class="checkbox-label buydesign-action">
												<input 
													type="checkbox" 
													name="buy-designer" 
													class="checkbox-input" 
													id="hire-designer-@{{ item.id }}" 
													ng-model="item.hire_designer" 
													ng-checked="item.hire_designer" 
													ng-change="onChangeHireDesigner(item)"
												/>
												<span class="input-type-checkbox"></span>
												<div>
													{{ __('Hire Artist For Customization') }}
												</div>
											</label>
										</div>
									</div>
									<div class="checkout-buyDesign" id="buy-this-design-@{{ item.id }}" ng-hide="item.disable_make_change || checkValidDownloadDesign(item) || item.is_custom_design == 1 || item.is_valid_buy_design == 0 || item.hire_designer != undefined || designFeeByProducts[item.product_id] == 0">
										<input type="checkbox" name="buydesign" class="checkbox-input" id="open-buyDesign-@{{ item.id }}">
    									<div class="buydesign-item" id="buy-this-design-@{{ item.id }}">
    										<div class="flex-b buydesign-content-item">
                                                <label for="buydesign-@{{ item.id }}" class="checkbox-label buydesign-action">
                                                    <input type="checkbox" class="checkbox-input" id="buydesign-@{{ item.id }}" ng-model="item.buy_design" ng-checked="item.buy_design" ng-change="buyDesign(item)">
                                                    <span class="input-type-checkbox"></span>
													<div class="buydesign-content-text">
                                                        @{{ textBuyDesign }} <span style="font-weight: 500;" ng-show="designFeeByProducts[item.product_id] + getIncludeDesignFee(item) > 0">+ @{{formatPrice(designFeeByProducts[item.product_id] + getIncludeDesignFee(item))}}</span>
                                                    </div>
                                                </label>
                                                <label for="open-buyDesign-@{{ item.id }}" class="checkbox-label">
													<svg xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-chevron-right">
                                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                                        <path d="M9 6l6 6l-6 6" />
                                                    </svg>
												</label>
    										</div>
											<div class="this-design-background"></div>
    										<div class="this-design-wrapper">
												<div class="this-design-content">
													<div class="cart-header-popup">
                                                        <span>{{ __("Love this design?") }}</span>
                                                        <label class="close-body-open-button" for="open-buyDesign-@{{ item.id }}">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                                                                <path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="currentColor" stroke-width="2" stroke-linecap="round"></path>
                                                            </svg> 
                                                        </label>
                                                    </div>
                                                    <div class="cart-popup-content flex-b">
                                                        <div class="design-box-title">
                                                            <span>{{ __("Download the original design file") }}</span>
                                                            <span class="design-price">+ @{{formatPrice(designFeeByProducts[item.product_id] + getIncludeDesignFee(item))}}</span>
                                                        </div>
                                                        <a href="{{ clroute(getOption('general.buy_design_policy', '#')) }}" class="buydesign-help" target="_blank">
                                                            {{ __('You will receive the link to download the original design file of this item within 24 hours')}}
                                                        </a>
                                                        <div class="design-template" ng-if="item.design_url">
                                                            <img src="@{{ getImageCdn(item.design_url, 540, 540, true) }}" alt="" width="358" height="358" referrerpolicy="no-referrer">
                                                        </div>
                                                        <div class="design-template no-design-img" ng-if="!item.design_url">
                                                            <img src="@{{ getImageCdn(item.image_url, 540, 540, true) }}" alt="" width="358" height="358" referrerpolicy="no-referrer">
                                                        </div>
                                                        <!--<button class="btn update-product" type="button" ng-if="!item.buy_design" ng-click="buyDesign(item)">
                                                            {{ __("Add to cart") }}
                                                        </button>-->
                                                    </div>
												</div>
    										</div>
    									</div>
                                        <label class="close-buyDesign" for="open-buyDesign-@{{ item.id }}"></label>
									</div>

									<div class="flex-b align-c make-change-wrap" ng-hide="freeshipPackageProduct && freeshipPackageProduct.id == item.product_id">
										<span class="make-change-button-item" id="js-delete-item" ng-click="openModalRemoveCartItem(item)" class="flex-b align-c">
											<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
												<path fill-rule="evenodd" clip-rule="evenodd" d="M3.62477 5.49079C3.91752 5.47127 4.17066 5.69277 4.19018 5.98552L4.51597 10.8724C4.57962 11.8271 4.62497 12.4914 4.72454 12.9912C4.82112 13.476 4.95594 13.7327 5.14961 13.9139C5.34328 14.095 5.60831 14.2125 6.09847 14.2766C6.6038 14.3427 7.26964 14.3438 8.22649 14.3438H8.77428C9.73113 14.3438 10.397 14.3427 10.9023 14.2766C11.3925 14.2125 11.6575 14.095 11.8512 13.9139C12.0448 13.7327 12.1796 13.476 12.2762 12.9912C12.3758 12.4914 12.4211 11.8271 12.4848 10.8724L12.8106 5.98552C12.8301 5.69277 13.0832 5.47127 13.376 5.49079C13.6688 5.5103 13.8903 5.76345 13.8707 6.0562L13.5425 10.9804C13.4819 11.889 13.433 12.6229 13.3183 13.1988C13.199 13.7976 12.9961 14.2977 12.577 14.6897C12.158 15.0818 11.6455 15.2509 11.0401 15.3301C10.4578 15.4063 9.72226 15.4063 8.81164 15.4063H8.18913C7.27851 15.4063 6.54294 15.4063 5.96066 15.3301C5.35529 15.2509 4.84277 15.0818 4.42373 14.6897C4.00468 14.2977 3.8018 13.7976 3.68252 13.1988C3.56779 12.6229 3.51887 11.889 3.45831 10.9803L3.13003 6.0562C3.11052 5.76345 3.33202 5.5103 3.62477 5.49079Z" fill="currentColor"/>
												<path fill-rule="evenodd" clip-rule="evenodd" d="M7.33536 1.59378L7.30279 1.59376C7.14951 1.59367 7.01598 1.59358 6.88988 1.61372C6.39171 1.69327 5.96062 2.00398 5.72761 2.45143C5.66864 2.56469 5.62649 2.69141 5.57811 2.83685L5.56783 2.86775L5.49906 3.07406C5.4856 3.11441 5.48185 3.12553 5.47859 3.13455C5.35455 3.47746 5.03295 3.70925 4.66841 3.71849C4.65882 3.71874 4.64708 3.71878 4.60455 3.71878H2.47949C2.18609 3.71878 1.94824 3.95663 1.94824 4.25003C1.94824 4.54343 2.18609 4.78128 2.47949 4.78128L4.61062 4.78128L4.62248 4.78128H12.3783L12.3902 4.78128L14.5212 4.78128C14.8146 4.78128 15.0525 4.54343 15.0525 4.25003C15.0525 3.95663 14.8146 3.71878 14.5212 3.71878H12.3962C12.3537 3.71878 12.3419 3.71874 12.3324 3.71849C11.9678 3.70925 11.6462 3.47745 11.5222 3.13453C11.5189 3.12558 11.5151 3.11421 11.5017 3.07406L11.4329 2.86774L11.4227 2.83683C11.3743 2.69139 11.3321 2.56468 11.2732 2.45143C11.0402 2.00398 10.6091 1.69327 10.1109 1.61372C9.98479 1.59358 9.85126 1.59367 9.69798 1.59376L9.66541 1.59378H7.33536ZM6.47773 3.49596C6.44992 3.57286 6.41759 3.64722 6.3811 3.71878H10.6197C10.5832 3.64722 10.5509 3.57287 10.523 3.49598L10.4956 3.41569L10.425 3.20374C10.3604 3.00999 10.3455 2.97049 10.3308 2.94216C10.2531 2.79301 10.1094 2.68944 9.94335 2.66292C9.91181 2.65789 9.86963 2.65628 9.66541 2.65628H7.33536C7.13114 2.65628 7.08896 2.65789 7.05742 2.66292C6.89136 2.68944 6.74767 2.79301 6.67 2.94216C6.65525 2.97049 6.64038 3.01 6.5758 3.20374L6.50511 3.41582C6.49446 3.44776 6.48618 3.47261 6.47773 3.49596Z" fill="currentColor"/>
											</svg>
											<span>{{ __('Remove')}}</span>
										</span>
									</div>
								</div>
							</div>
						</div>
						<div class="order-shiping-method-wrapper order-shiping-method-mobile" ng-show="shippingInfo.cartItems && shippingInfo.cartItems.length > 0">
							<div class="order-list-item-shiping-method" ng-hide="shippingInfo.selectedShipping.minTime == 0 && shippingInfo.selectedShipping.maxTime == 0">
								<div class="order-item-shiping-method order-selected-shiping">
									<div class="order-item-shiping-method-content flex-b align-c flex-w">
										<div class="shipping-information">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33334 10.945C4.87309 10.945 4.5 11.3108 4.5 11.762C4.5 12.2132 4.87309 12.579 5.33334 12.579C5.79357 12.579 6.16666 12.2132 6.16666 11.762C6.16666 11.3108 5.79357 10.945 5.33334 10.945ZM3.5 11.762C3.5 10.7693 4.3208 9.9646 5.33334 9.9646C6.34586 9.9646 7.16666 10.7693 7.16666 11.762C7.16666 12.7547 6.34586 13.5594 5.33334 13.5594C4.3208 13.5594 3.5 12.7547 3.5 11.762Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0003 10.945C11.5401 10.945 11.167 11.3108 11.167 11.762C11.167 12.2132 11.5401 12.579 12.0003 12.579C12.4606 12.579 12.8337 12.2132 12.8337 11.762C12.8337 11.3108 12.4606 10.945 12.0003 10.945ZM10.167 11.762C10.167 10.7693 10.9878 9.9646 12.0003 9.9646C13.0128 9.9646 13.8337 10.7693 13.8337 11.762C13.8337 12.7547 13.0128 13.5594 12.0003 13.5594C10.9878 13.5594 10.167 12.7547 10.167 11.762Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M0.166992 4.57247C0.166992 4.30173 0.390849 4.08228 0.666993 4.08228H9.60032C10.0974 4.08228 10.5003 4.47732 10.5003 4.96463V12.2522H6.70032C6.4242 12.2522 6.20032 12.0327 6.20032 11.762C6.20032 11.4913 6.4242 11.2718 6.70032 11.2718H9.50032V5.06267H0.666993C0.390849 5.06267 0.166992 4.84319 0.166992 4.57247Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M2 7.677C2.27614 7.677 2.5 7.89648 2.5 8.1672V11.2718H3.76666C4.04282 11.2718 4.26666 11.4912 4.26666 11.762C4.26666 12.0327 4.04282 12.2522 3.76666 12.2522H2.4C1.90294 12.2522 1.5 11.8571 1.5 11.3698V8.1672C1.5 7.89648 1.72386 7.677 2 7.677Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M0.833984 6.53329C0.833984 6.26254 1.05784 6.04309 1.33398 6.04309H4.00065C4.27678 6.04309 4.50065 6.26254 4.50065 6.53329C4.50065 6.804 4.27678 7.02348 4.00065 7.02348H1.33398C1.05784 7.02348 0.833984 6.804 0.833984 6.53329Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 6.53329C9.5 6.26254 9.72387 6.04309 10 6.04309H13.7401C14.0957 6.04309 14.418 6.24842 14.5625 6.56708L15.7558 9.19933C15.8069 9.31214 15.8333 9.43421 15.8333 9.55766V11.3699C15.8333 11.8572 15.4304 12.2522 14.9333 12.2522H13.6667C13.3905 12.2522 13.1667 12.0328 13.1667 11.762C13.1667 11.4913 13.3905 11.2718 13.6667 11.2718H14.8333V9.5785L13.6751 7.02348H10C9.72387 7.02348 9.5 6.804 9.5 6.53329Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 11.762C9.5 11.4913 9.72387 11.2719 10 11.2719H10.6667C10.9428 11.2719 11.1667 11.4913 11.1667 11.762C11.1667 12.0328 10.9428 12.2522 10.6667 12.2522H10C9.72387 12.2522 9.5 12.0328 9.5 11.762Z" fill="#525252"/> </svg>
											<span class="order-choose-item-method-shiping" ng-if="shippingInfo.selectedShipping.location">@{{ shippingFromText.replace("#type", shippingInfo.selectedShipping.name_shipping) }}</span>
											<span class="order-choose-item-method-shiping" ng-if="!shippingInfo.selectedShipping.location">@{{ shippingText.replace("#type", shippingInfo.selectedShipping.name_shipping) }}</span>
											@if ($shippingPolicyUrl != 'javascript:;')
											<a class="flex-b address-tooltip shipping-policy-help" target="_blank" href="{{ $shippingPolicyUrl }}" onclick="event.stopPropagation();">
												<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none"> <g clip-path="url(#clip0_982_3381)"> <path d="M8.5 0.885864C12.7054 0.885864 16.1143 4.2947 16.1143 8.50012C16.1143 12.7055 12.7054 16.1144 8.5 16.1144C4.29458 16.1144 0.885742 12.7055 0.885742 8.50012C0.885742 4.2947 4.29458 0.885864 8.5 0.885864ZM8.5 1.94836C4.88138 1.94836 1.94824 4.88151 1.94824 8.50012C1.94824 12.1187 4.88138 15.0519 8.5 15.0519C12.1186 15.0519 15.0518 12.1187 15.0518 8.50012C15.0518 4.88151 12.1186 1.94836 8.5 1.94836ZM8.5 10.6251C8.89109 10.6251 9.20783 10.9421 9.20801 11.3331C9.20801 11.7243 8.8912 12.0421 8.5 12.0421C8.1088 12.0421 7.79199 11.7243 7.79199 11.3331C7.79217 10.9421 8.10891 10.6251 8.5 10.6251ZM8.5 4.42688C9.5268 4.42688 10.3592 5.2595 10.3594 6.28625C10.3594 6.9685 9.99182 7.56493 9.44629 7.88782C9.30693 7.97027 9.19117 8.06023 9.11621 8.14856C9.04356 8.23422 9.03125 8.29052 9.03125 8.32336V9.20813C9.03125 9.50153 8.7934 9.73938 8.5 9.73938C8.2066 9.73938 7.96875 9.50153 7.96875 9.20813V8.32336C7.96875 7.96503 8.12593 7.674 8.30664 7.46106C8.48515 7.25075 8.70799 7.0895 8.90527 6.97278C9.14081 6.83317 9.29688 6.57754 9.29688 6.28625C9.2967 5.8463 8.93999 5.48938 8.5 5.48938C8.06001 5.48938 7.7033 5.8463 7.70312 6.28625C7.70312 6.57966 7.46528 6.8175 7.17188 6.8175C6.87847 6.8175 6.64062 6.57966 6.64062 6.28625C6.6408 5.2595 7.4732 4.42688 8.5 4.42688Z" fill="#A3A3A3"/> </g> <defs> <clipPath id="clip0_982_3381"> <rect width="17" height="17" fill="white"/> </clipPath> </defs> </svg>
												<div class="address-tooltip-content" style="font-weight: 300; width: max-content; width: -moz-max-content">
													{{ __('See more') }}
												</div>
											</a>
											@endif
										</div>

										<div class="order-choose-item-method-price-time">
											<span class="order-choose-item-method-price p-price-cart">@{{ formatPrice(shippingInfo.selectedShipping.shipping_fee, 0, false) }}</span>

											<div class="order-choose-item-method-time">
												@if ($useBusinessDay)
													<!-- @{{ shippingInfo.selectedShipping.textMinBusinessDays }} - @{{ shippingInfo.selectedShipping.textMaxBusinessDays }} -->
													@{{ shippingInfo.selectedShipping.textBusinessDays }}
												@else
													@{{ shippingInfo.selectedShipping.minDateString }} - @{{ shippingInfo.selectedShipping.maxDateString }}
												@endif
											</div>
										</div>

										<div class="order-choose-item-advantages">
											<small ng-show="shippingInfo.selectedShipping.type == 'standard'">
												<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04555C9.21943 4.20446 9.23816 4.48083 9.07926 4.66285L4.49592 9.91285C4.41284 10.008 4.29268 10.0626 4.16635 10.0626C4.04002 10.0626 3.91985 10.008 3.83677 9.91285L2.00344 7.81285C1.84453 7.63083 1.86327 7.35446 2.04529 7.19555C2.22731 7.03665 2.50368 7.05538 2.66259 7.2374L4.16635 8.95989L8.4201 4.0874C8.57901 3.90538 8.85539 3.88665 9.03741 4.04555Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09481C12.1432 4.26145 12.1499 4.53838 11.9833 4.71334L6.98312 9.96334C6.89475 10.0561 6.77015 10.1055 6.64221 10.0984C6.51427 10.0914 6.39586 10.0286 6.31824 9.92666L6.06838 9.59853C5.922 9.4063 5.95918 9.13179 6.15141 8.98541C6.31656 8.85966 6.54242 8.86937 6.69561 8.99649L11.3497 4.10989C11.5163 3.93492 11.7932 3.92817 11.9682 4.09481Z" fill="#525252"/> </svg>
												{{ __('Delivery date guaranteed') }}
											</small>
											<small ng-show="shippingInfo.selectedShipping.type != 'standard'">
												<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04555C9.21943 4.20446 9.23816 4.48083 9.07926 4.66285L4.49592 9.91285C4.41284 10.008 4.29268 10.0626 4.16635 10.0626C4.04002 10.0626 3.91985 10.008 3.83677 9.91285L2.00344 7.81285C1.84453 7.63083 1.86327 7.35446 2.04529 7.19555C2.22731 7.03665 2.50368 7.05538 2.66259 7.2374L4.16635 8.95989L8.4201 4.0874C8.57901 3.90538 8.85539 3.88665 9.03741 4.04555Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09481C12.1432 4.26145 12.1499 4.53838 11.9833 4.71334L6.98312 9.96334C6.89475 10.0561 6.77015 10.1055 6.64221 10.0984C6.51427 10.0914 6.39586 10.0286 6.31824 9.92666L6.06838 9.59853C5.922 9.4063 5.95918 9.13179 6.15141 8.98541C6.31656 8.85966 6.54242 8.86937 6.69561 8.99649L11.3497 4.10989C11.5163 3.93492 11.7932 3.92817 11.9682 4.09481Z" fill="#525252"/> </svg>
												{{ __('Delivery date not guaranteed') }}
											</small>
											<small>
												<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04555C9.21943 4.20446 9.23816 4.48083 9.07926 4.66285L4.49592 9.91285C4.41284 10.008 4.29268 10.0626 4.16635 10.0626C4.04002 10.0626 3.91985 10.008 3.83677 9.91285L2.00344 7.81285C1.84453 7.63083 1.86327 7.35446 2.04529 7.19555C2.22731 7.03665 2.50368 7.05538 2.66259 7.2374L4.16635 8.95989L8.4201 4.0874C8.57901 3.90538 8.85539 3.88665 9.03741 4.04555Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09481C12.1432 4.26145 12.1499 4.53838 11.9833 4.71334L6.98312 9.96334C6.89475 10.0561 6.77015 10.1055 6.64221 10.0984C6.51427 10.0914 6.39586 10.0286 6.31824 9.92666L6.06838 9.59853C5.922 9.4063 5.95918 9.13179 6.15141 8.98541C6.31656 8.85966 6.54242 8.86937 6.69561 8.99649L11.3497 4.10989C11.5163 3.93492 11.7932 3.92817 11.9682 4.09481Z" fill="#525252"/> </svg>
												{{ __('Tracking number') }}
											</small>
											<small ng-show="shipingLocation.country && shipingLocation.country.iso == 'CA'">
												<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04555C9.21943 4.20446 9.23816 4.48083 9.07926 4.66285L4.49592 9.91285C4.41284 10.008 4.29268 10.0626 4.16635 10.0626C4.04002 10.0626 3.91985 10.008 3.83677 9.91285L2.00344 7.81285C1.84453 7.63083 1.86327 7.35446 2.04529 7.19555C2.22731 7.03665 2.50368 7.05538 2.66259 7.2374L4.16635 8.95989L8.4201 4.0874C8.57901 3.90538 8.85539 3.88665 9.03741 4.04555Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09481C12.1432 4.26145 12.1499 4.53838 11.9833 4.71334L6.98312 9.96334C6.89475 10.0561 6.77015 10.1055 6.64221 10.0984C6.51427 10.0914 6.39586 10.0286 6.31824 9.92666L6.06838 9.59853C5.922 9.4063 5.95918 9.13179 6.15141 8.98541C6.31656 8.85966 6.54242 8.86937 6.69561 8.99649L11.3497 4.10989C11.5163 3.93492 11.7932 3.92817 11.9682 4.09481Z" fill="#525252"/> </svg>
												{{ __('Please note: Canada Post and P.O. Boxes are not accepted') }}
											</small>
											<div class="checkout-buymore-product" ng-bind-html="shippingInfo.selectedShipping.freeShipping"></div>
										</div>
									</div>
									<small class="order-choose-item-method-icon">
										<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none"></path> <path d="M9 6l6 6l-6 6"></path> </svg>
									</small>
								</div>
								<div class="order-item-shiping-popup">
									<ul class="order-item-shiping-list-popup">
										<li class="order-choose-item-method-title">
											<span>{{ __('Shipping') }}</span>
											<span class="close-order-item-shiping-popup order-choose-item-method-icon">
												<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
													<path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="#A3A3A3" stroke-width="2" stroke-linecap="round"/>
												</svg>
											</span>
										</li>
										<li class="order-item-shiping-method order-choose-item-method order-choose-item-method-icon @{{ shippingInfo.selectedShipping.id == shipping.id ? 'order-selected-item' : '' }}" ng-repeat="shipping in shippingInfo.shipping_info" ng-click="changeShippingType(shipping, shippingInfo)">
											<div class="order-item-shiping-method-content flex-b align-c flex-w">
												<div class="shipping-information">
													<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M5.33334 10.945C4.87309 10.945 4.5 11.3108 4.5 11.762C4.5 12.2132 4.87309 12.579 5.33334 12.579C5.79357 12.579 6.16666 12.2132 6.16666 11.762C6.16666 11.3108 5.79357 10.945 5.33334 10.945ZM3.5 11.762C3.5 10.7693 4.3208 9.9646 5.33334 9.9646C6.34586 9.9646 7.16666 10.7693 7.16666 11.762C7.16666 12.7547 6.34586 13.5594 5.33334 13.5594C4.3208 13.5594 3.5 12.7547 3.5 11.762Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M12.0003 10.945C11.5401 10.945 11.167 11.3108 11.167 11.762C11.167 12.2132 11.5401 12.579 12.0003 12.579C12.4606 12.579 12.8337 12.2132 12.8337 11.762C12.8337 11.3108 12.4606 10.945 12.0003 10.945ZM10.167 11.762C10.167 10.7693 10.9878 9.9646 12.0003 9.9646C13.0128 9.9646 13.8337 10.7693 13.8337 11.762C13.8337 12.7547 13.0128 13.5594 12.0003 13.5594C10.9878 13.5594 10.167 12.7547 10.167 11.762Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M0.166992 4.57247C0.166992 4.30173 0.390849 4.08228 0.666993 4.08228H9.60032C10.0974 4.08228 10.5003 4.47732 10.5003 4.96463V12.2522H6.70032C6.4242 12.2522 6.20032 12.0327 6.20032 11.762C6.20032 11.4913 6.4242 11.2718 6.70032 11.2718H9.50032V5.06267H0.666993C0.390849 5.06267 0.166992 4.84319 0.166992 4.57247Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M2 7.677C2.27614 7.677 2.5 7.89648 2.5 8.1672V11.2718H3.76666C4.04282 11.2718 4.26666 11.4912 4.26666 11.762C4.26666 12.0327 4.04282 12.2522 3.76666 12.2522H2.4C1.90294 12.2522 1.5 11.8571 1.5 11.3698V8.1672C1.5 7.89648 1.72386 7.677 2 7.677Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M0.833984 6.53329C0.833984 6.26254 1.05784 6.04309 1.33398 6.04309H4.00065C4.27678 6.04309 4.50065 6.26254 4.50065 6.53329C4.50065 6.804 4.27678 7.02348 4.00065 7.02348H1.33398C1.05784 7.02348 0.833984 6.804 0.833984 6.53329Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 6.53329C9.5 6.26254 9.72387 6.04309 10 6.04309H13.7401C14.0957 6.04309 14.418 6.24842 14.5625 6.56708L15.7558 9.19933C15.8069 9.31214 15.8333 9.43421 15.8333 9.55766V11.3699C15.8333 11.8572 15.4304 12.2522 14.9333 12.2522H13.6667C13.3905 12.2522 13.1667 12.0328 13.1667 11.762C13.1667 11.4913 13.3905 11.2718 13.6667 11.2718H14.8333V9.5785L13.6751 7.02348H10C9.72387 7.02348 9.5 6.804 9.5 6.53329Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.5 11.762C9.5 11.4913 9.72387 11.2719 10 11.2719H10.6667C10.9428 11.2719 11.1667 11.4913 11.1667 11.762C11.1667 12.0328 10.9428 12.2522 10.6667 12.2522H10C9.72387 12.2522 9.5 12.0328 9.5 11.762Z" fill="#525252"/> </svg>
													<span class="order-choose-item-method-shiping" ng-if="shipping.location">@{{ shippingFromText.replace("#type", shipping.name_shipping) }}</span>
													<span class="order-choose-item-method-shiping" ng-if="!shipping.location">@{{ shippingText.replace("#type", shipping.name_shipping) }}</span>
													@if ($shippingPolicyUrl != 'javascript:;')
													<a class="flex-b address-tooltip shipping-policy-help" target="_blank" href="{{ $shippingPolicyUrl }}" onclick="event.stopPropagation();">
														<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none"> <g clip-path="url(#clip0_982_3381)"> <path d="M8.5 0.885864C12.7054 0.885864 16.1143 4.2947 16.1143 8.50012C16.1143 12.7055 12.7054 16.1144 8.5 16.1144C4.29458 16.1144 0.885742 12.7055 0.885742 8.50012C0.885742 4.2947 4.29458 0.885864 8.5 0.885864ZM8.5 1.94836C4.88138 1.94836 1.94824 4.88151 1.94824 8.50012C1.94824 12.1187 4.88138 15.0519 8.5 15.0519C12.1186 15.0519 15.0518 12.1187 15.0518 8.50012C15.0518 4.88151 12.1186 1.94836 8.5 1.94836ZM8.5 10.6251C8.89109 10.6251 9.20783 10.9421 9.20801 11.3331C9.20801 11.7243 8.8912 12.0421 8.5 12.0421C8.1088 12.0421 7.79199 11.7243 7.79199 11.3331C7.79217 10.9421 8.10891 10.6251 8.5 10.6251ZM8.5 4.42688C9.5268 4.42688 10.3592 5.2595 10.3594 6.28625C10.3594 6.9685 9.99182 7.56493 9.44629 7.88782C9.30693 7.97027 9.19117 8.06023 9.11621 8.14856C9.04356 8.23422 9.03125 8.29052 9.03125 8.32336V9.20813C9.03125 9.50153 8.7934 9.73938 8.5 9.73938C8.2066 9.73938 7.96875 9.50153 7.96875 9.20813V8.32336C7.96875 7.96503 8.12593 7.674 8.30664 7.46106C8.48515 7.25075 8.70799 7.0895 8.90527 6.97278C9.14081 6.83317 9.29688 6.57754 9.29688 6.28625C9.2967 5.8463 8.93999 5.48938 8.5 5.48938C8.06001 5.48938 7.7033 5.8463 7.70312 6.28625C7.70312 6.57966 7.46528 6.8175 7.17188 6.8175C6.87847 6.8175 6.64062 6.57966 6.64062 6.28625C6.6408 5.2595 7.4732 4.42688 8.5 4.42688Z" fill="#A3A3A3"/> </g> <defs> <clipPath id="clip0_982_3381"> <rect width="17" height="17" fill="white"/> </clipPath> </defs> </svg>
														<div class="address-tooltip-content" style="font-weight: 300; width: max-content; width: -moz-max-content">
															{{ __('See more') }}
														</div>
													</a>
													@endif
												</div>
												<div class="order-choose-item-method-price-time">
													<span class="order-choose-item-method-price p-price-cart">@{{ formatPrice(shipping.shipping_fee, 0, false) }}</span>
													@if ($useBusinessDay)
													<!-- <span class="order-choose-item-method-time">@{{ shipping.textMinBusinessDays }} - @{{ shipping.textMaxBusinessDays }}</span> -->
													<span class="order-choose-item-method-time">@{{ shipping.textBusinessDays }}</span>
													@else
													<span class="order-choose-item-method-time">@{{ shipping.minDateString }} - @{{ shipping.maxDateString }}</span>
													@endif
												</div>
												<div class="order-choose-item-advantages">
													<small ng-show="shipping.type != 'premium' && shipping.type != 'express'">
														<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04537C9.21943 4.20428 9.23816 4.48065 9.07926 4.66267L4.49592 9.91267C4.41284 10.0078 4.29268 10.0624 4.16635 10.0624C4.04002 10.0624 3.91985 10.0078 3.83677 9.91267L2.00344 7.81267C1.84453 7.63065 1.86327 7.35427 2.04529 7.19537C2.22731 7.03646 2.50368 7.0552 2.66259 7.23722L4.16635 8.9597L8.4201 4.08722C8.57901 3.9052 8.85539 3.88646 9.03741 4.04537Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09463C12.1432 4.26127 12.1499 4.53819 11.9833 4.71316L6.98312 9.96316C6.89475 10.0559 6.77015 10.1053 6.64221 10.0983C6.51427 10.0912 6.39586 10.0284 6.31824 9.92648L6.06838 9.59835C5.922 9.40611 5.95918 9.13161 6.15141 8.98523C6.31656 8.85948 6.54242 8.86919 6.69561 8.99631L11.3497 4.1097C11.5163 3.93474 11.7932 3.92799 11.9682 4.09463Z" fill="#525252"/> </svg>
														<span>{{ __('Delivery date guaranteed') }}</span>
													</small>
													<small ng-show="shipping.type == 'premium' || shipping.type == 'express'">
														<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04537C9.21943 4.20428 9.23816 4.48065 9.07926 4.66267L4.49592 9.91267C4.41284 10.0078 4.29268 10.0624 4.16635 10.0624C4.04002 10.0624 3.91985 10.0078 3.83677 9.91267L2.00344 7.81267C1.84453 7.63065 1.86327 7.35427 2.04529 7.19537C2.22731 7.03646 2.50368 7.0552 2.66259 7.23722L4.16635 8.9597L8.4201 4.08722C8.57901 3.9052 8.85539 3.88646 9.03741 4.04537Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09463C12.1432 4.26127 12.1499 4.53819 11.9833 4.71316L6.98312 9.96316C6.89475 10.0559 6.77015 10.1053 6.64221 10.0983C6.51427 10.0912 6.39586 10.0284 6.31824 9.92648L6.06838 9.59835C5.922 9.40611 5.95918 9.13161 6.15141 8.98523C6.31656 8.85948 6.54242 8.86919 6.69561 8.99631L11.3497 4.1097C11.5163 3.93474 11.7932 3.92799 11.9682 4.09463Z" fill="#525252"/> </svg>
														<span>{{ __('Delivery date not guaranteed') }}</span>
													</small>
													<small>
														<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04537C9.21943 4.20428 9.23816 4.48065 9.07926 4.66267L4.49592 9.91267C4.41284 10.0078 4.29268 10.0624 4.16635 10.0624C4.04002 10.0624 3.91985 10.0078 3.83677 9.91267L2.00344 7.81267C1.84453 7.63065 1.86327 7.35427 2.04529 7.19537C2.22731 7.03646 2.50368 7.0552 2.66259 7.23722L4.16635 8.9597L8.4201 4.08722C8.57901 3.9052 8.85539 3.88646 9.03741 4.04537Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09463C12.1432 4.26127 12.1499 4.53819 11.9833 4.71316L6.98312 9.96316C6.89475 10.0559 6.77015 10.1053 6.64221 10.0983C6.51427 10.0912 6.39586 10.0284 6.31824 9.92648L6.06838 9.59835C5.922 9.40611 5.95918 9.13161 6.15141 8.98523C6.31656 8.85948 6.54242 8.86919 6.69561 8.99631L11.3497 4.1097C11.5163 3.93474 11.7932 3.92799 11.9682 4.09463Z" fill="#525252"/> </svg>
														<span>{{ __('Tracking number') }}</span>
													</small>
													<small ng-show="shipingLocation.country && shipingLocation.country.iso == 'CA'">
														<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.03741 4.04537C9.21943 4.20428 9.23816 4.48065 9.07926 4.66267L4.49592 9.91267C4.41284 10.0078 4.29268 10.0624 4.16635 10.0624C4.04002 10.0624 3.91985 10.0078 3.83677 9.91267L2.00344 7.81267C1.84453 7.63065 1.86327 7.35427 2.04529 7.19537C2.22731 7.03646 2.50368 7.0552 2.66259 7.23722L4.16635 8.9597L8.4201 4.08722C8.57901 3.9052 8.85539 3.88646 9.03741 4.04537Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M11.9682 4.09463C12.1432 4.26127 12.1499 4.53819 11.9833 4.71316L6.98312 9.96316C6.89475 10.0559 6.77015 10.1053 6.64221 10.0983C6.51427 10.0912 6.39586 10.0284 6.31824 9.92648L6.06838 9.59835C5.922 9.40611 5.95918 9.13161 6.15141 8.98523C6.31656 8.85948 6.54242 8.86919 6.69561 8.99631L11.3497 4.1097C11.5163 3.93474 11.7932 3.92799 11.9682 4.09463Z" fill="#525252"/> </svg>
														<span>{{ __('Please note: Canada Post and P.O. Boxes are not accepted') }}</span>
													</small>
													<small style="font-style: italic;" ng-show="shipping.type == 'premium' && false">
														<span>*{{ __('It may take 1-2 days more than expected if the delivery date falls on a weekend') }}</span>
													</small>
												</div>
											</div>
											<small class="order-choose-item-method-icon"></small>
										</li>
										{{-- <li class="order-choose-item-method-bottom">
											<button class="order-choose-item-method-save"> {{ __("Save") }} </button>
										</li> --}}
									</ul>
									<div class="order-item-shiping-bg order-choose-item-method-icon"></div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="gift-packing-box" ng-show="isValidGiftWrap">
					<div class="gift-packing-title">
						{{ __('Gift wrap') }}
					</div>
					<div class="gift-packing-wrap">
						<input class="gift-packing-checkbox" id="gift-packing" type="checkbox" ng-model="isGiftWrap" ng-change="selectGiftWrap()">
						<label class="gift-packing-label" for="gift-packing">
							<div class="wrapp-input">
								<small class="checkbox"></small>
								<span class="gift-title">
									{{ __('Gift wrap your order and send it with a personalized greeting card.') }}
								</span>
							</div>
							<span class="gift-packing-price">@{{ formatPrice(giftWrapFee) }}</span>
						</label>
						<div class="gift-packing-content">
							<div class="gift-packing-image">
								<img src="{{ asset('modules/cart/images/gift-packing.png?v=' . config('sa.version')) }}" class="packing-image">
							</div>
							<div class="gift-form">
								<textarea  ng-model="giftWrapNote" ng-class="class('note', 'gift')" id="gift-packing-form" name="gift-packing-form" type="text" rows="3" class="form-control" placeholder="{{ __('Your greeting card text') }}" autocomplete="off"></textarea>
								<div class="invalid-feedback" ng-if="hasError('note', 'gift')" ng-bind="getErrorMsg('note', 'gift')"></div>
							</div>
						</div>
					</div>
				</div>
				@if ($isShowFreeShippingPackage)
				<ul class="free-shipping-box" ng-show="freeshipPackageProduct && freeshipPackageProduct.id && isBuyFreeshipPackageByEmail">
					<li class="order-item-shiping-method order-selected-shiping">
						<label class="order-item-shiping-method-content flex-b @{{ isBuyFreeshipPackageByEmail || loading || loadingBuyFreeship ? 'inactive' : '' }}" for="freeship-checkbox">
							<div class="input-wrapp flex-b @{{ isBuyFreeshipPackageByEmail || loading || loadingBuyFreeship ? 'inactive' : '' }}">
								<input class="freeship-checkbox" id="freeship-checkbox" type="checkbox" ng-model="isBuyFreeshipPackage" ng-change="changeBuyFreeshipPackage()" ng-disabled="isBuyFreeshipPackageByEmail || loading || loadingBuyFreeship">
								<small class="checkbox"></small>
								<div class="shipping-information" style="display: flex; align-items: flex-start">
									{{ __('Free shipping for a whole year') }} 
								</div>
								<span class="order-choose-item-method-price p-price-cart ng-binding">
									@{{ freesshippingBoxPriceText.replace("#price", formatPrice(freeshipPackageProduct.price)) }}
								</span>
							</div>
							
							<div class="order-choose-item-method-time flex-b flex-s align-c ng-binding">
								<div class="fresship-content">
									<div class="flex-b align-c">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2" viewBox="0 0 16 16">
											<path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
										</svg>
										{{ __('All orders with Standard shipping') }}
									</div>
									<div class="flex-b align-c">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-check2" viewBox="0 0 16 16">
											<path d="M13.854 3.646a.5.5 0 0 1 0 .708l-7 7a.5.5 0 0 1-.708 0l-3.5-3.5a.5.5 0 1 1 .708-.708L6.5 10.293l6.646-6.647a.5.5 0 0 1 .708 0z"/>
										</svg>
										{{ __('No minimum order value') }}
									</div>
								</div>
								<img src="{{ asset('modules/cart/images/free-shipping.png') }}" width="64" height="64">
							</div>
						</label>
					</li>
				</ul>
				@endif				

				<div class="common-title">
					<span class="font-big font-bold mx-lg-5">
						{{ __('Order Summary') }}
					</span>
				</div>
				<div class="shopcart-summary-container order-summary">
					<div class="summary-subtotal-container-wrap">
						<div class="summary-discount-container">
							<div class="input-content flex-box flex-w" style="width: 100%; padding-left: 0px;padding-top: 5px;">
								<div class="subtotal-item flex-box flex-s align-c show-promote-box">
									<a class="tt-reward flex-b align-c" style="grid-gap: 8px">
										<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.93866 3.25024H14.0612C15.9038 3.25023 17.3628 3.25022 18.5046 3.40335C19.6794 3.5609 20.6301 3.8928 21.38 4.64083C22.4096 5.66782 22.6598 7.08209 22.7387 8.95821L22.7397 8.98238C22.7466 9.14623 22.7537 9.31352 22.7475 9.45444C22.7409 9.60433 22.7177 9.82079 22.598 10.0346C22.5152 10.1826 22.4043 10.2849 22.3304 10.3461C22.2502 10.4125 22.1612 10.4726 22.0764 10.5262C21.9126 10.6295 21.6912 10.7531 21.4316 10.8981L21.4125 10.9087C21.0268 11.1241 20.7699 11.5332 20.7699 12.0002C20.7699 12.4673 21.0268 12.8764 21.4125 13.0918L21.4317 13.1025C21.6912 13.2474 21.9127 13.371 22.0764 13.4743C22.1612 13.5278 22.2502 13.588 22.3304 13.6544C22.4043 13.7156 22.5152 13.8179 22.598 13.9659C22.7177 14.1797 22.7409 14.3962 22.7475 14.5461C22.7537 14.687 22.7466 14.8543 22.7397 15.0181L22.7387 15.0423C22.6598 16.9184 22.4096 18.3327 21.38 19.3597C20.6301 20.1077 19.6794 20.4396 18.5046 20.5971C17.3628 20.7503 15.9038 20.7503 14.0612 20.7502H9.93866C8.09611 20.7503 6.63706 20.7503 5.49525 20.5971C4.32045 20.4396 3.36975 20.1077 2.61986 19.3597C1.59031 18.3327 1.34006 16.9184 1.26119 15.0423L1.26017 15.0181C1.25325 14.8543 1.24619 14.687 1.25238 14.5461C1.25898 14.3962 1.28216 14.1797 1.40185 13.9659C1.48468 13.8179 1.59561 13.7156 1.66951 13.6544C1.74966 13.588 1.83867 13.5278 1.92352 13.4743C2.08725 13.371 2.30869 13.2474 2.56827 13.1024L2.58735 13.0918C2.97306 12.8764 3.23002 12.4673 3.23002 12.0002C3.23002 11.5332 2.97306 11.1241 2.58735 10.9087L2.56825 10.898C2.30868 10.7531 2.08725 10.6295 1.92352 10.5262C1.83866 10.4726 1.74966 10.4125 1.66951 10.3461C1.5956 10.2849 1.48468 10.1826 1.40185 10.0346C1.28216 9.82079 1.25898 9.60433 1.25238 9.45443C1.24619 9.31353 1.25325 9.14623 1.26017 8.98239C1.26051 8.97432 1.26085 8.96626 1.26119 8.95821C1.34006 7.08209 1.59031 5.66782 2.61986 4.64083C3.36975 3.8928 4.32046 3.5609 5.49525 3.40335C6.63706 3.25022 8.09611 3.25023 9.93866 3.25024ZM21.2468 14.5845C21.2468 14.5845 21.247 14.5855 21.2473 14.5878L21.2468 14.5845ZM21.2492 14.7262C21.2491 14.7328 21.2489 14.7396 21.2488 14.7467C21.2471 14.8106 21.244 14.885 21.24 14.9793C21.162 16.8353 20.9085 17.7114 20.3207 18.2977C19.8961 18.7212 19.3144 18.9751 18.3053 19.1105C17.2747 19.2487 15.9164 19.2502 14.0049 19.2502H9.99496C8.0835 19.2502 6.72516 19.2487 5.69463 19.1105C4.68549 18.9751 4.10379 18.7212 3.6792 18.2977C3.09141 17.7114 2.83789 16.8353 2.75986 14.9793C2.7559 14.885 2.75279 14.8106 2.75115 14.7467C2.75096 14.7396 2.75081 14.7328 2.75067 14.7262C2.87533 14.6493 3.05437 14.549 3.3187 14.4014C4.15855 13.9324 4.73002 13.0339 4.73002 12.0002C4.73002 10.9666 4.15855 10.0681 3.3187 9.59909C3.05437 9.45147 2.87533 9.35123 2.75066 9.27425C2.7508 9.2677 2.75096 9.2609 2.75115 9.25382C2.75279 9.18985 2.7559 9.11553 2.75986 9.02122C2.83789 7.16518 3.09141 6.28913 3.6792 5.70281C4.10379 5.27927 4.68549 5.02537 5.69463 4.89004C6.72516 4.75183 8.0835 4.75024 9.99496 4.75024H14.0049C15.9164 4.75024 17.2747 4.75183 18.3053 4.89004C19.3144 5.02537 19.8961 5.27927 20.3207 5.70281C20.9085 6.28913 21.162 7.16518 21.24 9.02122C21.244 9.11553 21.2471 9.18985 21.2488 9.25382C21.2489 9.2609 21.2491 9.2677 21.2492 9.27425C21.1246 9.35122 20.9455 9.45147 20.6812 9.59909C19.8413 10.0681 19.2699 10.9666 19.2699 12.0002C19.2699 13.0339 19.8413 13.9324 20.6812 14.4014C20.9455 14.549 21.1246 14.6493 21.2492 14.7262ZM21.3735 9.19096L21.3723 9.19189C21.3766 9.18803 21.3774 9.18773 21.3735 9.19096ZM21.2468 9.41603C21.2468 9.41603 21.2469 9.41485 21.2473 9.41272L21.2468 9.41603ZM2.62643 9.19096C2.62252 9.18773 2.62334 9.18803 2.62756 9.19189L2.62643 9.19096ZM2.75263 9.41272C2.75299 9.41485 2.75309 9.41603 2.75309 9.41603L2.75263 9.41272ZM2.75309 14.5845C2.75309 14.5845 2.75299 14.5856 2.75263 14.5878L2.75309 14.5845ZM2.62757 14.8086C2.62334 14.8125 2.62252 14.8128 2.62643 14.8095L2.62757 14.8086ZM21.3723 14.8086L21.3735 14.8095C21.3774 14.8128 21.3766 14.8125 21.3723 14.8086ZM15.5303 8.46991C15.8232 8.76281 15.8232 9.23768 15.5303 9.53057L9.53028 15.5306C9.23738 15.8235 8.76251 15.8235 8.46962 15.5306C8.17672 15.2377 8.17672 14.7628 8.46962 14.4699L14.4696 8.46991C14.7625 8.17702 15.2374 8.17702 15.5303 8.46991Z" fill="#FF6600"/> <path d="M15.4999 14.5002C15.4999 15.0525 15.0522 15.5002 14.4999 15.5002C13.9477 15.5002 13.4999 15.0525 13.4999 14.5002C13.4999 13.948 13.9477 13.5002 14.4999 13.5002C15.0522 13.5002 15.4999 13.948 15.4999 14.5002Z" fill="#FF6600"/> <path d="M10.4999 9.50024C10.4999 10.0525 10.0522 10.5002 9.49995 10.5002C8.94766 10.5002 8.49995 10.0525 8.49995 9.50024C8.49995 8.94796 8.94766 8.50024 9.49995 8.50024C10.0522 8.50024 10.4999 8.94796 10.4999 9.50024Z" fill="#FF6600"/> </svg>
										<span class="summary-discount-title">{{ __('Use promotion code') }}</span>
									</a>
									{{-- <svg ng-show="!isUsePoint" xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"  class="bi-chevron-down"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 9l6 6l6 -6" /></svg>
									<div class="used-point-order" ng-show="isUsePoint">
										<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 16v.01" /><path d="M12 13a2 2 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483" /></svg>
										<div class="used-point-order-popover">
											{{ __('You have used points for this order.')}}
										</div>
									</div> --}}
								</div>
								<div class="coupon-select-input-container flex-box align-s address-col open-promotion-code">
									<input id="promotion_code" placeholder="{{ __('Promotion Code') }}" type="text" class="form-control wid-100" ng-model="promotionCode" ng-blur="handleBlurPromotion()" ng-disabled="isBulkOrder || isUsePoint">
									<div class="address-tooltip address-tooltip-promotion" style="position: relative; transform: none; margin: 0; right: 0; width: 0;">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill"
											viewBox="0 0 16 16" style="display: block; position:absolute; left: -40px;"
										>
											<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"></path>
										</svg>
										<div class="address-tooltip-content">
											<ul class="list-decimal" style="margin-left: 10px">
												<li>{{ __('Coupon only can be used for Non-promotional products, cannot be used in conjunction with promotion products.') }}</li>
												<li>{{ __('You can use one coupon in one order') }}</li>
												<li>{{ __('Please enter the coupon CODE or select the valid coupon.') }}</li>
											</ul>
										</div>
									</div>
									<button id="submit_promotion_code" type="button" data-loading-text="{{ __('Loading...') }}" class="button secondary subtotal-select-btn coupon-discount-apply-btn" ng-click="submitPromotionCode()">{{ __('Apply') }}</button>
								</div>
								<div class="coupon-message" ng-show="errorPromotionCode || successPromotionCode">
									<span id="error-promotion" ng-show="errorPromotionCode">@{{ errorPromotionCode }}</span>
									<span id="success-promotion" ng-show="successPromotionCode">@{{ successPromotionCode }}</span>
								</div>
								<!--Reward  -->
								<div class="reward-contain" ng-show="customerRewards.showRewards && user && user.id && !isChangeCurrency && customerRewards.validRewards > 0">
									<label class="reward-label" for="reward-point" ng-if="customerRewards.showRewards && user && user.id">
										<span>
											@{{ askUsePointText.replace('#rewards', customerRewards.validRewards) }}
										</span>
										<div class="address-tooltip">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
												<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
											</svg>
											<div class="address-tooltip-content">
												@{{ earnPointText.replace("#point", customerRewards.pointEarn) }}
											</div>
										</div>
									</label>
									<label class="reward-toggle" for="reward-point">
										<input type="checkbox" id="reward-point" ng-model="isUsePoint" ng-change="usePoint()">
										<div class="reward-toggle-box"></div>
									</label>
								</div>
								<!--End reward-->
							</div>
						</div>
						<div class="checkout-item-box">
							<div class="subtotal-item flex-box flex-s align-c">
								<span>{{ __('Subtotal') }}:</span>
								<span class="primary-text p-price-cart fw-500">@{{ formatPrice(cart.sub_total, 0, false) }}</span>
							</div>
							<div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'normal'">
								<span>{{ __('Discount') }}:</span>
								<span class="primary-text p-price-cart fw-500">-@{{ formatPrice(discount, 0, false) }}</span>
							</div>
							<div class="subtotal-item flex-box flex-s align-c" ng-show="discount" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">
								<span>{{ __('Discount') }}:</span>
								<span class="primary-text p-price-cart fw-500">-@{{ formatPrice(customerRewards.rewards, 0, false) }}</span>
							</div>
							<div class="subtotal-item flex-box flex-s align-c">
								<span class="flex-b align-c">
									{{ __('Shipping fee') }}:
								</span>
								<span class="primary-text p-price-cart fw-500" ng-if="discountType == 'normal'">@{{ (shipping_fee && shipping_fee > 0 ? '+' : '') + formatPrice(shipping_fee, 0, false) }}</span>
								<span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards == 0">@{{ (shipping_fee && discount && shipping_fee - discount > 0 ? '+' : '') + shipping_fee - discount > 0 ? formatPrice(shipping_fee - discount, 0, false) : formatPrice(0, 0, false) }}</span>
								<span class="primary-text p-price-cart fw-500" ng-if="discountType == 'freeship' && customerRewards.rewards > 0">@{{ (shipping_fee && discount && shipping_fee - discount + customerRewards.rewards > 0 ? '+' : '') + shipping_fee - discount + customerRewards.rewards > 0 ? formatPrice(shipping_fee - discount + customerRewards.rewards, 0, false) : formatPrice(0, 0, false) }}</span>
							</div>

							@if ($isShowTransactionFee)
							<div class="subtotal-item flex-box flex-s align-c">
								<span class="flex-b align-c">
									<span>
										{{ __('Handling fee') }}
									</span>
									<div class="address-tooltip address-tooltip-left">
										<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"> <g clip-path="url(#clip0_2513_7549)"> <path d="M9.5 0.989502C14.2002 0.989502 18.0107 4.80007 18.0107 9.50024C18.0107 14.2004 14.2002 18.011 9.5 18.011C4.79983 18.011 0.989258 14.2004 0.989258 9.50024C0.989258 4.80007 4.79983 0.989502 9.5 0.989502ZM9.5 2.177C5.45567 2.177 2.17676 5.45591 2.17676 9.50024C2.17676 13.5446 5.45567 16.8235 9.5 16.8235C13.5443 16.8235 16.8232 13.5446 16.8232 9.50024C16.8232 5.45591 13.5443 2.177 9.5 2.177ZM9.5 11.8752C9.93723 11.8752 10.292 12.23 10.292 12.6672C10.2918 13.1043 9.93712 13.4583 9.5 13.4583C9.06288 13.4583 8.70818 13.1043 8.70801 12.6672C8.70801 12.23 9.06277 11.8752 9.5 11.8752ZM9.5 4.94849C10.6477 4.94849 11.5781 5.87889 11.5781 7.02661C11.578 7.78912 11.1664 8.45489 10.5566 8.81567C10.401 8.90778 10.2732 9.00901 10.1895 9.10767C10.1084 9.20322 10.0938 9.26523 10.0938 9.302V10.2922C10.0936 10.62 9.82781 10.886 9.5 10.886C9.17219 10.886 8.90643 10.62 8.90625 10.2922V9.302C8.90634 8.90183 9.0814 8.57701 9.2832 8.33911C9.48261 8.10414 9.73171 7.92465 9.95215 7.79419C10.2157 7.63829 10.3905 7.35229 10.3906 7.02661C10.3906 6.53473 9.99188 6.13599 9.5 6.13599C9.00812 6.13599 8.60938 6.53473 8.60938 7.02661C8.6092 7.35438 8.34344 7.62036 8.01562 7.62036C7.68781 7.62036 7.42205 7.35438 7.42188 7.02661C7.42188 5.87889 8.35228 4.94849 9.5 4.94849Z" fill="#FF6600"/> </g> <defs> <clipPath id="clip0_2513_7549"> <rect width="19" height="19" fill="white" transform="translate(0 0.000244141)"/> </clipPath> </defs> </svg>
										<div class="address-tooltip-content">
											{{ $handlingFeeText }}
										</div>
									</div>
								</span>
								<span class="primary-text p-price-cart fw-500">@{{ (otherFee ? '+' : '') + formatPrice(otherFee, 0, false) }}</span>
							</div>
							@endif
							<div class="subtotal-item flex-box flex-s align-c" ng-show="showTips">
								<span>{{ __('Tips') }}:</span>
								<span class="primary-text p-price-cart fw-500">@{{ (tipsAmount && tipsAmount > 0 ? '+' : '') + formatPrice(tipsAmount, 0, false) }}</span>
							</div>
							@if ($useTaxes)
							<div class="subtotal-item flex-box flex-s align-c" ng-show="shipingLocation.country && shipingLocation.country.iso == 'US'">
								<span>{!! __('Taxes') !!}:</span>
								<span class="primary-text p-price-cart fw-500">@{{ calculateTaxFee() }}</span>
							</div>
							@endif
							<div class="subtotal-item flex-box flex-s align-c" ng-show="validTax">
								<span class="flex-b align-c">
									<span>
										{{ __('Other fee') }}:
									</span>
									<div class="address-tooltip address-tooltip-left">
										<svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 19 19" fill="none"> <g clip-path="url(#clip0_2513_7549)"> <path d="M9.5 0.989502C14.2002 0.989502 18.0107 4.80007 18.0107 9.50024C18.0107 14.2004 14.2002 18.011 9.5 18.011C4.79983 18.011 0.989258 14.2004 0.989258 9.50024C0.989258 4.80007 4.79983 0.989502 9.5 0.989502ZM9.5 2.177C5.45567 2.177 2.17676 5.45591 2.17676 9.50024C2.17676 13.5446 5.45567 16.8235 9.5 16.8235C13.5443 16.8235 16.8232 13.5446 16.8232 9.50024C16.8232 5.45591 13.5443 2.177 9.5 2.177ZM9.5 11.8752C9.93723 11.8752 10.292 12.23 10.292 12.6672C10.2918 13.1043 9.93712 13.4583 9.5 13.4583C9.06288 13.4583 8.70818 13.1043 8.70801 12.6672C8.70801 12.23 9.06277 11.8752 9.5 11.8752ZM9.5 4.94849C10.6477 4.94849 11.5781 5.87889 11.5781 7.02661C11.578 7.78912 11.1664 8.45489 10.5566 8.81567C10.401 8.90778 10.2732 9.00901 10.1895 9.10767C10.1084 9.20322 10.0938 9.26523 10.0938 9.302V10.2922C10.0936 10.62 9.82781 10.886 9.5 10.886C9.17219 10.886 8.90643 10.62 8.90625 10.2922V9.302C8.90634 8.90183 9.0814 8.57701 9.2832 8.33911C9.48261 8.10414 9.73171 7.92465 9.95215 7.79419C10.2157 7.63829 10.3905 7.35229 10.3906 7.02661C10.3906 6.53473 9.99188 6.13599 9.5 6.13599C9.00812 6.13599 8.60938 6.53473 8.60938 7.02661C8.6092 7.35438 8.34344 7.62036 8.01562 7.62036C7.68781 7.62036 7.42205 7.35438 7.42188 7.02661C7.42188 5.87889 8.35228 4.94849 9.5 4.94849Z" fill="#FF6600"/> </g> <defs> <clipPath id="clip0_2513_7549"> <rect width="19" height="19" fill="white" transform="translate(0 0.000244141)"/> </clipPath> </defs> </svg>
										<div class="address-tooltip-content">
											{{ $otherFeeText }}
										</div>
									</div>
								</span>
								<span class="primary-text p-price-cart fw-500">@{{ "+" + formatPrice(calculateTrumpTax(), 0, false) }}</span>
							</div>
							<div class="subtotal-item subtotal-price-item flex-box flex-s align-c">
								<span class="subtotal-price-title">{{ __('Total') }}:</span>
								<span class="subtotal-price p-price-main primary-text">@{{ getCartAmount() }}</span>
							</div>
							<div class="subtotal-item flex-box flex-s align-c not-login" ng-show="customerRewards.showRewards && (!user || !user.id) && customerRewards.pointEarn > 0">
								<span class="points-rewards flex-b align-c">
									<span class="tt-reward flex-b align-c">									
										<a href="{{ route('user:sign-in') }}?continue={{ route('home') }}/checkout?internal_source=login_checkout" style="margin-right:6px;">
											{{ __('Sign in') }}
										</a>
										{{ __(' to get ') }}
										@{{ customerRewards.pointEarn }} CP
									</span>
									<div class="address-tooltip">
										<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-question-circle" viewBox="0 0 16 16">
											<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
											<path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94"/>
										</svg>
										<div class="address-tooltip-content">
											@{{ earnPointText.replace("#point", customerRewards.pointEarn) }}
										</div>
									</div>
									
								</span>
							</div>						
							<div class="subtotal-item flex-box flex-s align-c p-0" ng-show="customerRewards.showRewards && user && user.id && customerRewards.pointEarn > 0">
								<span class="points-rewards flex-b align-c">
									{{ __('Earn') }}
									<span>{{ __('Rewards') }}</span>
									<div class="address-tooltip">
										<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle" viewBox="0 0 16 16">
											<path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
											<path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94"/>
										</svg>
										<div class="address-tooltip-content">
											@{{ earnPointText.replace("#point", customerRewards.pointEarn) }}
										</div>
									</div>
								</span>
								<span class="primary-text p-price-cart fw-500 ng-binding"> @{{ customerRewards.pointEarn }}CP</span>
							</div>
						</div>

						<div class="tips-content-gr" ng-show="showTips">
							<div class="tips-content-head flex-b align-c">
								<?php
									$iconHeart = '<svg style="fill: red" width="16" height="16" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 472.7 472.7" xml:space="preserve"><path id="XMLID_810_" d="M433.5,67c-25.3-25.3-59-39.3-94.8-39.3s-69.6,14-94.9,39.4l-7.3,7.3l-7.5-7.5 c-25.4-25.4-59.1-39.4-95-39.4c-35.8,0-69.4,13.9-94.7,39.3C13.9,92.2,0,125.9,0,161.7s14,69.5,39.4,94.8l182.7,182.7 c3.8,3.8,9,6,14.5,6c5.4,0,10.6-2.2,14.5-6l182.2-182.4c25.4-25.4,39.3-59.1,39.4-94.9S458.8,92.4,433.5,67z M132.5,117.2 c-23.9,0-43.4,19.5-43.4,43.4c0,11-8.9,19.9-19.9,19.9s-19.9-8.9-19.9-19.9c0-45.8,37.3-83.1,83.1-83.1c11,0,19.9,8.9,19.9,19.9 C152.4,108.4,143.5,117.2,132.5,117.2z"/></svg>';
								?>
								<span>{!! formatString(__('Enjoy your purchase? Buy our designers a coffee. Thank you %s'), $iconHeart) !!}</span>
							</div>
							<div class="tips-content-price flex-b align-s">
								<label class="tips-content-price-label change-value" for="tips-@{{ $index }}" ng-repeat="item in tipsValue" ng-click="changeTips('specific', item)">
									<input id="tips-@{{ $index }}" type="radio" name="amount" ng-checked="tips == item.value && tipsType == 'specific'">
									<span class="tips-content-price-txt">@{{ item.key }}</span>
								</label>
								<label class="tips-content-price-label specify-value" for="amount-other" ng-click="changeTips('other')">
									<input id="amount-other" type="radio" name="amount">
									<span class="tips-content-price-txt">{{ __('Other')}}</span>
								</label>
							</div>
							<div class="tips-other-value">
								<input id="tips-other-value" class="form-control" type="number" placeholder="{{ __('Specify an amount')}} (@{{ currency }})" name="tips-other-value" ng-change="changeCustomTips()" ng-model="customTips.value">
							</div>
						</div>

						@if(View::exists('inc.cart.shipping-description'))
						@include('inc.cart.shipping-description')
						@endif
					</div>
					
				</div>
				<style>
					.show-payment-loading .payment-loading-action {border-radius: 4px; background: linear-gradient(45deg, rgba(209,209,209,0.35), rgba(11,11,11,0.1), rgba(209,209,209,0.1), rgba(209,209,209,0.15)); background-size: 400% 400%; animation: gradient 3000ms ease infinite; user-select: none; width: 100%; display: block; min-height: 22px}
					@keyframes gradient { 0% { background-position: 0% 50%; } 50% { background-position: 100% 50%; } 100% { background-position: 0% 50%; } }
					.payment-loading-card { }
				</style>
				 
				<div class="show-payment-loading" ng-class="{'loading-height': !isShowPaymentType}" ng-show="!isShowPaymentType">
					<div class="payment-loading-title payment-loading-action" style="height: 30px;margin-bottom: 12px;margin-top: 12px;"></div>
					<div class="payment-loading-box flex-b" style="gap: 5px">
						<span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
						<span class="payment-loading-action" style="height: 54px; width: 100px;"></span>
					</div>
					<div class="payment-loading-note payment-loading-action" style="height: 21px;margin-top:10px;margin-bottom: 10px;"></div>
					<div class="payment-loading-card flex-b align-s flex-s flex-w" style=" gap: 8px">
						<span class="payment-loading-action" style="width: 100%; height: 52px;"></span>
						<span class="payment-loading-action" style="width: 60%; height: 52px;"></span>
						<span class="payment-loading-action" style="width: 37%"></span>
					</div>
				</div>
				<div id="show-payment-type" ng-show="isShowPaymentType">			
					<div class="common-title" >
						<span class="font-big font-bold mx-lg-5">
							{{ __('Payment Methods') }}
						</span>
					</div>
					<div class="shopcart-summary-container checkout-item-box payment-method">
						<div class="payment-method-button">
							@if ($useCOD)
								<div class="payment-method-item @{{ payment_type == 'cod' ? 'active' : '' }}">
									<input id="cod-method" type="radio" name="" ng-checked="payment_type == 'cod'" checked ng-click="changePayment('cod')" ng-disabled="loading">
									<label for="cod-method" class="input-radio title-btn flex-box">									
										<div class="input-content flex-box align-c flex-w">
											<img src="{{ asset('modules/cart/images/cash-on-delivery.png') }}" height="20">	
											<span class="title-payment-button">{{ __("Cash on delivery") }}</span>
										</div>
									</label>
								</div>
							@endif
							@if ($cardForm == 'stripe')
							<div class="payment-method-item @{{ payment_type == 'stripe' ? 'active' : '' }}">
								<input id="stripe-method" type="radio" ng-checked="payment_type == 'stripe'" checked ng-click="changePayment('stripe')" ng-disabled="loading">
								<label for="stripe-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">									
									<div class="input-content flex-box align-c flex-w">
										<img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">	
										<span class="title-payment-button">{{ __("Card") }}</span>
									</div>
								</label>
							</div>
							@elseif ($cardForm == 'paypal')
							<div class="payment-method-item @{{ payment_type == 'paypal_card' ? 'active' : '' }}">
								<input id="paypal-cart-method" type="radio" ng-checked="payment_type == 'paypal_card'" checked ng-click="changePayment('paypal_card')" ng-disabled="loading">
								<label for="paypal-cart-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">									
									<div class="input-content flex-box align-c flex-w">
										<img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">	
										<span class="title-payment-button">{{ __("Card") }}</span>
									</div>
								</label>
							</div>
							@elseif ($cardForm == 'adyen')
							<div class="payment-method-item @{{ payment_type == 'adyen' ? 'active' : '' }}">
								<input id="adyen-method" type="radio" ng-checked="payment_type == 'adyen'" checked ng-click="changePayment('adyen')" ng-disabled="loading">
								<label for="adyen-method" class="input-radio title-btn flex-box flex-w stripe-form-checkout">									
									<div class="input-content flex-box align-c flex-w">
										<img src="{{ asset('modules/cart/images/card2.svg') }}" height="20" widht="20">	
										<span class="title-payment-button">{{ __("Card") }}</span>
									</div>
								</label>
							</div>
							@endif

							<!-- useKlarna -->
							@if ($useKlarna)
								<div class="payment-method-item @{{ payment_type == 'klarna' ? 'active' : '' }}">
									<input id="klarna-method" type="radio" ng-checked="payment_type == 'klarna'" ng-click="changePayment('klarna')" ng-disabled="loading">
									<label for="klarna-method" class="input-radio title-btn flex-box">
										<div class="input-content flex-box align-c flex-w">
											<img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">
											<div class="title-payment-button">{{ __("Klarna") }}</div>
										</div>
									</label>
								</div>
							@endif

							<!-- useAfterpay -->
							@if ($useAfterpay)
								<div class="payment-method-item @{{ payment_type == 'afterpay' ? 'active' : '' }}" ng-if="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">
									<input id="afterpay-method" type="radio" ng-checked="payment_type == 'afterpay'" ng-click="changePayment('afterpay')" ng-disabled="loading">
									<label for="afterpay-method" class="input-radio title-btn flex-box">
										<div class="input-content flex-box align-c flex-w">										
											<img src="{{ asset('modules/cart/images/afterpay3.png') }}" height="20" widht="20">
											<img src="{{ asset('modules/cart/images/klarna2.svg') }}" height="20" widht="20">					
											<img src="{{ asset('modules/cart/images/affirm.svg') }}" height="18"  widht="18" ng-show="getCartAmount(false) > 50">									
											<div class="title-payment-button">{{ __("Buy now, pay later") }}</div>
										</div>
									</label>
								</div>							
							@endif
							
							<!-- usePaypal -->
							@if ($usePaypalByLimit && $usePaypal && $isValidPaypalByProduct)
								<div class="payment-method-item @{{ payment_type == 'paypal' ? 'active' : '' }}" ng-show="validPaypal">
									<input id="paypal-method" type="radio" ng-checked="payment_type == 'paypal'" ng-click="changePayment('paypal')" ng-disabled="loading">
									<label for="paypal-method" class="input-radio title-btn flex-box">
										<div class="input-content flex-box align-c flex-w">
											<img src="{{ asset('modules/cart/images/paypal-icon.svg') }}?v=1" height="20" widht="20">
											<div class="title-payment-button">{{ __("PayPal") }}</div>
										</div>
									</label>
								</div>								
							@endif

							<!-- useGiropay -->
							@if ($useGiropay)
								<div class="payment-method-item @{{ payment_type == 'giropay' ? 'active' : '' }}">
									<input id="giropay-method" type="radio" ng-checked="payment_type == 'giropay'" ng-click="changePayment('giropay')" ng-disabled="loading">
									<label for="giropay-method" class="input-radio title-btn flex-box">									
										<div class="input-content flex-box align-c flex-w">
											<img src="{{ asset('modules/cart/images/giropay.png') }}" height="20" widht="20">
											<div class="title-payment-button">{{ __("GiroPay") }}</div>
										</div>
									</label>
								</div>
								
							@endif
							<!-- useApplepay -->
							@if ($useApplepay)
								<div class="payment-method-item @{{ payment_type == 'apple_google' ? 'active' : '' }} @{{ validApplePay ? 'valid-apple' : '' }}" ng-show="validApplePay" style="display: none;">
									<input id="applepay-method" type="radio" ng-checked="payment_type == 'apple_google'" ng-click="changePayment('apple_google')" ng-disabled="loading">
									<label for="applepay-method" class="input-radio title-btn flex-box" id="label-applepay" ng-show="validApplePay">									
										<div class="input-content flex-box align-c flex-w">
											<img ng-show="paymentGateway.isApplePay" src="{{ asset('modules/cart/images/apple-pay-logo.png?v=' . config('sa.version')) }}" height="20">
											<img ng-show="paymentGateway.isGooglePay" src="{{ asset('modules/cart/images/google-pay-logo.png?v=' . config('sa.version')) }}" height="20" width="20">
											<div ng-show="paymentGateway.isApplePay" class="title-payment-button">{{ __("Apple") }}</div>
											<div ng-show="paymentGateway.isGooglePay" class="title-payment-button">{{ __("Google") }}</div>
										</div>
									</label>
								</div>								
							@endif
								@if($useLian)
									<div class="payment-method-item @{{ payment_type == 'lian' ? 'active' : '' }}">
										<input id="lian-method" type="radio" ng-checked="payment_type == 'paypal'" ng-click="changePayment('lian')" ng-disabled="loading">
										<label for="lian-method" class="input-radio title-btn flex-box">
											<div class="input-content flex-box align-c flex-w">
												<img src="{{ asset('modules/cart/images/lian.png') }}" height="20" widht="20">
												<div class="title-payment-button">{{ __("Lian Lian") }}</div>
											</div>
										</label>
									</div>
								@endif
						</div>
						<div class="credit-form" id="cod-form" style="display: none;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								@if ($codFee > 0)
								<label for="cod-method">
									<small style="color: #ff7300; font-style:italic">(+<span>{{ $codFee }}%</span> {{ __('Handling fee') }})</small>
								</label>
								@elseif ($codFee == 0)
								<label for="cod-method">
									<small style="color: #ff7300; font-style:italic">({{ __('No handling fee!') }})</small>
								</label>
								@endif
							</div>
						</div>
						<div class="credit-form" id="klarna-form" style="display: none;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								@if ($klarnaFee > 0)
								<label for="klarna-method">
									<small style="color: #ff7300;"><span>{{ $klarnaFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($klarnaFee == 0)
								<label for="klarna-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								<div class="address-tooltip">
									<div class="address-tooltip-info">
										{{ $handlingFeeText }}
									</div>
								</div>
							</div>
						</div>
						<div class="credit-form" id="afterpay-form">
							<div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="isShowAfterPay && shipingLocation.country && shipingLocation.country.iso == 'US'">
								@if ($afterpayFee > 0)
								<label for="afterpay-method">
									<small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
									<small style="color: #ff7300;">Pay in 4 instalments of @{{ getAmountAfterPay() }}</small><br>
									<!-- <small style="color: #ff7300;"><span>{{ $afterpayFee }}%</span> {{ __('Handling fee') }}. </small> -->
								</label>
								@elseif ($afterpayFee == 0)
								<label for="afterpay-method">
									<small style="color: #ff7300;" class="show-note-payment">{{ __('May not be accepted by some locales or users. In this case please choose another payment method') }}</small>
									<!-- <small style="color: #ff7300;">{{ __('No handling fee!') }}</small> -->
								</label>
								@endif
								<div class="address-tooltip" style="display: none;">
									<div class="address-tooltip-info">
										{{ $handlingFeeText }}
									</div>
								</div>
							</div>
						</div>
						<!-- <div class="credit-form" id="paypal-form" style="display: none;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								@if ($paypalFee > 0)
								<label for="paypal-method">
									<small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($paypalFee == 0)
								<label for="paypal-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								@if ($paypalFee > 0)
								<div class="address-tooltip">
									<div class="address-tooltip-info">
									{{ $handlingFeeText }}
									</div>
								</div>
								@endif
							</div>
						</div> -->
						<div class="credit-form" id="giropay-form" style="display: none;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								@if ($giropayFee > 0)
								<label for="giropay-method">
									<small style="color: #ff7300;"><span>{{ $giropayFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($giropayFee == 0)
								<label for="giropay-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								<div class="address-tooltip">
									<div class="address-tooltip-info">
										{{ $handlingFeeText }}
									</div>
								</div>
							</div>
						</div>
						<!-- <div class="credit-form" id="apple-google-form" style="display: none;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp" ng-show="validApplePay">
								@if ($applepayFee > 0)
								<label for="applepay-method">
									<small style="color: #ff7300;"><span>{{ $applepayFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($applepayFee == 0)
								<label for="applepay-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								<div class="address-tooltip">
									<div class="address-tooltip-info">
										{{ $handlingFeeText }}
									</div>
								</div>
							</div>
						</div> -->
						<div class="credit-form" id="paypal-card-form" style="display: <?= $cardForm == 'paypal' ? 'block' : 'none' ?>">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								@if ($paypalFee > 0)
								<label for="paypal-cart-method">
									<small style="color: #ff7300;"><span>{{ $paypalFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($paypalFee == 0)
								<label for="paypal-cart-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								<div class="address-tooltip">
									<div class="address-tooltip-info">{{ $handlingFeeText }}</div>
								</div>
								<div class="flex-box align-c" style="margin-top: 5px;">
									<img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
								</div>
							</div>
							<form id="card-form">
								<label for="card-number">Card Number</label>
								<div id="card-number" class="card_field"></div>
								<div style="display: flex; flex-direction: row; width: 100%;">
									<div style="width: 30%;">
										<label for="card-expiry">Expiration Date</label>
										<div id="card-expiry" class="card_field"></div>
									</div>
									<div style="padding-left: 10px; width:70%;">
										<label for="cvv">CVV</label>
										<div id="card-cvv" class="card_field"></div>
									</div>
								</div>				
								<div id="card-name" class="card_field"></div>
								<div id="paypal-card-errors" class="error invalid-feedback" role="alert">
									<span class="message">
										@{{ errorCard }}
									</span>
								</div>
							</form>
						</div>
						<div class="credit-form" id="payment-form" style="display: <?= $cardForm == 'stripe' ? 'block' : 'none' ?>;">
							<div class="flex-box align-c flex-w address-tooltip-wrapp">
								<!-- @if ($stripeFee > 0)
								<label for="stripe-method">
									<small style="color: #ff7300;"><span>{{ $stripeFee }}%</span> {{ __('Handling fee') }}</small>
								</label>
								@elseif ($stripeFee == 0)
								<label for="stripe-method">
									<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
								</label>
								@endif
								<div class="address-tooltip">
									<div class="address-tooltip-info">{{ $handlingFeeText }}</div>
								</div> -->
								<div class="flex-box align-c" style="margin-top: 5px;">
									<img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
									<img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
								</div>
							</div>
							<form class="form-card-number">
								<div class="card-number">
									<label class="credit-label" for="">
										<span>{{ __('Card Number') }}</span>
										<div class="address-tooltip">
											<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
												<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
											</svg>
											<div class="address-tooltip-content">
												{{ __("We don't store ANY of your card information.") }}
											</div>
										</div>
									</label>
									<div id="credit-card-number" class="field empty credit-control"></div>
								</div>
								<div class="flex-b flex-s card-info">
									<div class="card-expire card-info-item">
										<label class="credit-label" for="">
											<span>{{ __('Expiry date') }}</span>
										</label>
										<div id="credit-card-expiry" class="field empty third-width credit-control"></div>
									</div>
									<div class="card-cvc card-info-item">
										<label class="credit-label" for="">
											<span>CVC</span>
											<div class="address-tooltip">
												<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle-fill" viewBox="0 0 16 16">
													<path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM5.496 6.033h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286a.237.237 0 0 0 .241.247zm2.325 6.443c.61 0 1.029-.394 1.029-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94 0 .533.425.927 1.01.927z"/>
												</svg>
												<div class="address-tooltip-content">
													{{ __('3-digit security code usually found on the back of your card. American Express cards have a 4-digit code located on the front.') }}
												</div>
											</div>
										</label>
										<div id="credit-card-cvc" class="field empty third-width credit-control"></div>
									</div>
								</div>
								<div id="credit-card-errors" class="error invalid-feedback" role="alert">
									<span class="message">
										@{{ errorCard }}
									</span>
								</div>
								<button type="submit" data-tid="elements_examples.form.pay_button" hidden class="hidden">{{ __('Submit Payment') }}</button>
							</form>
						</div>
						<div class="credit-form" id="adyen-form" style="display: <?= $cardForm == 'adyen' ? 'block' : 'none' ?>;">
						<div class="flex-box align-c flex-w address-tooltip-wrapp">
							@if ($adyenFee > 0)
							<label for="paypal-cart-method">
								<small style="color: #ff7300;"><span>{{ $adyenFee }}%</span> {{ __('Handling fee') }}</small>
							</label>
							@elseif ($adyenFee == 0)
							<label for="paypal-cart-method">
								<small style="color: #ff7300;">{{ __('No handling fee!') }}</small>
							</label>
							@endif
							<div class="address-tooltip">
								<div class="address-tooltip-info">{{ $handlingFeeText }}</div>
							</div>
							<div class="flex-box align-c" style="margin-top: 5px;">
								<img src="{{ asset('modules/cart/images/visa.png') }}" style="width: 35px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/master-card.png') }}" style="width: 35px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/amex.png') }}" style="width: 35px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/jcb.png') }}" style="width: 35px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/discover.png') }}" style="width: 35px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/eftpos.png') }}" style="width: 34px; margin-right: 4px;">
								<img src="{{ asset('modules/cart/images/unionpay.png') }}" style="width: 39px; margin-right: 4px;">
							</div>
						</div>
							<div id="dropin-container"></div>
						</div>
					</div>
				</div>
				<div id="credit-card-errors" class="error-payment invalid-feedback" role="alert">
					<span class="message">
						@{{ errorPayment }}
					</span>
				</div>
				<!-- #end show Payment type  -->

				<div class="overflow-hidden shopcart-payment-btn-container">
					<a class="submit-a-ticket" target="_blank" href="{{ clroute('/contact/ticket/flow?mode=creating-an-issue-report') }}">
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"> <g clip-path="url(#clip0_2513_7630)"> <path d="M5.99967 8.00041C5.99967 8.3686 5.7012 8.66707 5.33301 8.66707C4.96482 8.66707 4.66634 8.3686 4.66634 8.00041C4.66634 7.63222 4.96482 7.33374 5.33301 7.33374C5.7012 7.33374 5.99967 7.63222 5.99967 8.00041Z" fill="#525252"/> <path d="M8.66634 8.00041C8.66634 8.3686 8.36786 8.66707 7.99967 8.66707C7.63148 8.66707 7.33301 8.3686 7.33301 8.00041C7.33301 7.63222 7.63148 7.33374 7.99967 7.33374C8.36786 7.33374 8.66634 7.63222 8.66634 8.00041Z" fill="#525252"/> <path d="M11.333 8.00041C11.333 8.3686 11.0345 8.66707 10.6663 8.66707C10.2982 8.66707 9.99967 8.3686 9.99967 8.00041C9.99967 7.63222 10.2982 7.33374 10.6663 7.33374C11.0345 7.33374 11.333 7.63222 11.333 8.00041Z" fill="#525252"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1663 8.00041C15.1663 4.04237 11.9577 0.83374 7.99967 0.83374C4.04163 0.83374 0.833008 4.04237 0.833008 8.00041C0.833008 9.14594 1.10215 10.2301 1.58109 11.1916C1.65256 11.3351 1.66772 11.4816 1.63474 11.6049L1.23767 13.0889C0.965857 14.1048 1.89525 15.0342 2.91114 14.7624L4.39517 14.3653C4.51843 14.3324 4.66495 14.3475 4.80844 14.419C5.77002 14.8979 6.85414 15.1671 7.99967 15.1671C11.9577 15.1671 15.1663 11.9584 15.1663 8.00041ZM7.99967 1.83374C11.4054 1.83374 14.1663 4.59465 14.1663 8.00041C14.1663 11.4062 11.4054 14.1671 7.99967 14.1671C7.0123 14.1671 6.08048 13.9354 5.25428 13.5239C4.92268 13.3587 4.52616 13.2951 4.13669 13.3993L2.65267 13.7964C2.38012 13.8693 2.13076 13.62 2.20369 13.3474L2.60076 11.8634C2.70497 11.4739 2.64137 11.0774 2.47621 10.7458C2.06469 9.9196 1.83301 8.98778 1.83301 8.00041C1.83301 4.59465 4.59392 1.83374 7.99967 1.83374Z" fill="#525252"/> </g> <defs> <clipPath id="clip0_2513_7630"> <rect width="16" height="16" fill="white" transform="translate(0 0.000488281)"/> </clipPath> </defs> </svg>
						{{  __('Having trouble? Submit a ticket and we will get back to you!')}}
						<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M5.67461 2.95412C5.88428 2.77441 6.19993 2.79869 6.37964 3.00835L10.3796 7.67502C10.5401 7.86227 10.5401 8.13857 10.3796 8.32581L6.37964 12.9925C6.19993 13.2021 5.88428 13.2264 5.67461 13.0467C5.46495 12.867 5.44067 12.5513 5.62038 12.3417L9.34147 8.00042L5.62038 3.65914C5.44067 3.44948 5.46495 3.13383 5.67461 2.95412Z" fill="#A3A3A3"/> </svg>
					</a>
					@if ($isShowGuarantee && false)
					<fieldset class="guaranteed-wrapper">
						<!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
						<div class="guaranteed-box">
							<img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
							<img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
							<img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
						</div>
					</fieldset>
					@endif
					@if (config("cart::sa.trustlock", true))
					<fieldset class="guaranteed-wrapper">
						<div class="guaranteed-box">
							<a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-business-TL-873835142792" class="trustlock-img">
								<img width="74" height="55" 
									src="{{ asset('modules/cart/images/business-trust-seal-trust-lock.webp?v=2025') }}"
									alt="">
							</a> 
							<a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-privacy-TL-873835142792" class="trustlock-img">
								<img width="74" height="55" 
									src="{{ asset('modules/cart/images/privacy-trust-seal-trust-lock.webp?v=2025') }}" 
									alt="">
							</a>        
							<a target="_blank" href="https://app.trustlock.co/verification/window/trust-badge-seal-ssl-TL-873835142792" class="trustlock-img">
								<img width="74"
									height="55" 
									src="{{ asset('modules/cart/images/ssl-secure-trust-seal-trust-lock.webp?v=2025') }}"
									alt="">
							</a> 							
							<a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">				
								<img src="{{ asset('modules/cart/images/paypal-verify2.webp?v=2025') }}" width="100">
							</a>
							<a href="{{ getOption('general.payment_method_url', 'payment-methods-n653.html') }}" class="link-guaranteed-img" target="_blank">
								<img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
							</a>
						</div>
					</fieldset>
					@else
					<fieldset class="guaranteed-wrapper">
						<!-- <legend>{!! __('Guaranteed <span style="color: #04eb04;">SAFE</span> Checkout') !!}</legend> -->
						<div class="guaranteed-box guaranteed-box-not-strustlock">
							<img src="{{ asset('modules/cart/images/verify.webp?v=2025') }}" width="100">
							<img src="{{ asset('modules/cart/images/paypal-verify.webp?v=2025') }}" width="100">
							<img src="{{ asset('modules/cart/images/stripe-verify.webp?v=2025') }}" width="100">
						</div>
					</fieldset>
					@endif
					<div class="shopcart-checkout-btn-container order-btn-wrapper">
						{{-- <a class="shopcart-checkout-btn disable-links" style="opacity: 0.5;" ng-if="loading">
							{{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
						</a>
						<a class="shopcart-checkout-btn" ng-click="order()" ng-if="!loading">
							<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-shield-check" viewBox="0 0 16 16" style="margin-right: 8px;">
								<path d="M5.338 1.59a61.44 61.44 0 0 0-2.837.856.481.481 0 0 0-.328.39c-.554 4.157.726 7.19 2.253 9.188a10.725 10.725 0 0 0 2.287 2.233c.346.244.652.42.893.533.12.057.218.095.293.118a.55.55 0 0 0 .101.025.615.615 0 0 0 .1-.025c.076-.023.174-.061.294-.118.24-.113.547-.29.893-.533a10.726 10.726 0 0 0 2.287-2.233c1.527-1.997 2.807-5.031 2.253-9.188a.48.48 0 0 0-.328-.39c-.651-.213-1.75-.56-2.837-.855C9.552 1.29 8.531 1.067 8 1.067c-.53 0-1.552.223-2.662.524zM5.072.56C6.157.265 7.31 0 8 0s1.843.265 2.928.56c1.11.3 2.229.655 2.887.87a1.54 1.54 0 0 1 1.044 1.262c.596 4.477-.787 7.795-2.465 9.99a11.775 11.775 0 0 1-2.517 2.453 7.159 7.159 0 0 1-1.048.625c-.28.132-.581.24-.829.24s-.548-.108-.829-.24a7.158 7.158 0 0 1-1.048-.625 11.777 11.777 0 0 1-2.517-2.453C1.928 10.487.545 7.169 1.141 2.692A1.54 1.54 0 0 1 2.185 1.43 62.456 62.456 0 0 1 5.072.56z"></path>
								<path d="M10.854 5.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647a.5.5 0 0 1 .708 0z"></path>
							</svg>
							{{ __('Place Order Now') }}
						</a> --}}
						<button class="checkout-btn-new" ng-click="order()">
							<span class="checkout-loader" ng-if="loading"></span>
							<span ng-if="!loading">{{ __('Checkout')}}</span>
						</button>

						{{-- <button class="checkout-btn-new paypal-btn">
							<span class="checkout-loader" ng-if="loading"></span>
							<span ng-if="!loading" class="paypal-btn">
								<svg xmlns="http://www.w3.org/2000/svg" width="78" height="20" viewBox="0 0 78 20" fill="none"> <path d="M13.2031 0.971147C12.2255 0.324706 10.9497 0.000701481 9.37587 0.000701481H3.28272C2.80024 0.000701481 2.53368 0.232788 2.48305 0.696403L0.00776948 15.6405C-0.0179552 15.7872 0.0202243 15.9215 0.121959 16.0435C0.223112 16.1659 0.350339 16.2267 0.502708 16.2267H3.39691C3.90454 16.2267 4.18355 15.9951 4.23477 15.5307L4.92014 11.502C4.94517 11.3067 5.03445 11.1479 5.18682 11.0257C5.33907 10.9037 5.5295 10.8237 5.758 10.7872C5.98649 10.7509 6.20195 10.7327 6.40542 10.7327C6.60831 10.7327 6.84938 10.745 7.12909 10.7693C7.40811 10.7937 7.58597 10.8056 7.66221 10.8056C9.84544 10.8056 11.5591 10.2139 12.8033 9.02927C14.0469 7.8451 14.6695 6.20302 14.6695 4.1027C14.6695 2.66204 14.1803 1.61815 13.2031 0.970697V0.971147ZM10.0615 5.45839C9.93413 6.31318 9.60448 6.87454 9.07137 7.14324C8.53813 7.41227 7.77652 7.54595 6.78652 7.54595L5.52974 7.58267L6.17728 3.66338C6.2278 3.39502 6.39274 3.26067 6.67222 3.26067H7.396C8.41102 3.26067 9.14773 3.4014 9.60472 3.68174C10.0615 3.96276 10.2138 4.55523 10.0615 5.45839Z" fill="#003087"/> <path d="M77.5045 0.000488281H74.6866C74.4067 0.000488281 74.2419 0.134839 74.1916 0.403424L71.7161 15.6408L71.6779 15.714C71.6779 15.8367 71.7288 15.9522 71.8305 16.0621C71.9315 16.1717 72.059 16.2268 72.2112 16.2268H74.7249C75.2066 16.2268 75.4733 15.9953 75.5247 15.531L78 0.549975V0.513589C77.9998 0.171784 77.8342 0.000824823 77.5045 0.000824823V0.000488281Z" fill="#009CDE"/> <path d="M43.4594 5.89847C43.4594 5.77666 43.4084 5.66045 43.3074 5.55073C43.2055 5.4409 43.0912 5.3857 42.9646 5.3857H40.0323C39.7525 5.3857 39.5241 5.50841 39.3467 5.75191L35.31 11.4662L33.6345 5.97191C33.507 5.5814 33.2279 5.3857 32.7967 5.3857H29.9402C29.813 5.3857 29.6987 5.44078 29.5977 5.55073C29.4959 5.66045 29.4454 5.77677 29.4454 5.89847C29.4454 5.94773 29.6929 6.66772 30.1879 8.05958C30.6828 9.45165 31.2161 10.9534 31.7874 12.5652C32.3587 14.1767 32.6566 15.0317 32.6822 15.1288C30.6003 17.8639 29.5597 19.3292 29.5597 19.5242C29.5597 19.842 29.7246 20.0005 30.0547 20.0005H32.987C33.2662 20.0005 33.4946 19.8787 33.6726 19.6343L43.3836 6.15462C43.434 6.10615 43.4594 6.02106 43.4594 5.89835V5.89847Z" fill="#003087"/> <path d="M70.7648 5.38561H67.8705C67.5148 5.38561 67.2997 5.78854 67.2234 6.59441C66.5626 5.61814 65.3574 5.12912 63.6053 5.12912C61.7773 5.12912 60.2221 5.78854 58.9403 7.10718C57.658 8.42592 57.0172 9.97675 57.0172 11.7591C57.0172 13.2001 57.455 14.3477 58.3308 15.202C59.2066 16.0573 60.3808 16.484 61.8538 16.484C62.5898 16.484 63.3388 16.3373 64.1004 16.0445C64.8621 15.7515 65.4582 15.361 65.8905 14.8724C65.8905 14.8969 65.8647 15.0065 65.8144 15.2018C65.7632 15.3975 65.7381 15.5444 65.7381 15.6413C65.7381 16.0325 65.9027 16.2273 66.2333 16.2273H68.8612C69.3429 16.2273 69.6226 15.9958 69.6985 15.5314L71.26 5.97148C71.285 5.82493 71.2471 5.69081 71.1458 5.56855C71.0438 5.44685 70.9172 5.38561 70.7648 5.38561ZM65.7952 12.6015C65.1477 13.212 64.367 13.5172 63.4532 13.5172C62.7166 13.5172 62.1205 13.3221 61.6633 12.9312C61.206 12.5412 60.9775 12.004 60.9775 11.3195C60.9775 10.4166 61.295 9.65308 61.9298 9.03038C62.5638 8.40767 63.3516 8.09632 64.2909 8.09632C65.0012 8.09632 65.5916 8.29784 66.0616 8.70055C66.5309 9.10349 66.7664 9.65924 66.7664 10.3674C66.7663 11.2463 66.4425 11.9913 65.7952 12.6015Z" fill="#009CDE"/> <path d="M27.5031 5.38561H24.6089C24.2529 5.38561 24.0376 5.78854 23.9614 6.59441C23.2759 5.61814 22.0698 5.12912 20.3435 5.12912C18.5155 5.12912 16.9603 5.78854 15.6784 7.10718C14.3961 8.42592 13.7553 9.97675 13.7553 11.7591C13.7553 13.2001 14.1933 14.3477 15.0692 15.202C15.9451 16.0573 17.1191 16.484 18.5918 16.484C19.3023 16.484 20.039 16.3373 20.8005 16.0445C21.5621 15.7515 22.1715 15.361 22.6285 14.8724C22.5266 15.1653 22.4761 15.4218 22.4761 15.6413C22.4761 16.0325 22.641 16.2273 22.9711 16.2273H25.5988C26.0808 16.2273 26.3604 15.9958 26.4366 15.5314L27.9979 5.97148C28.023 5.82493 27.9849 5.69081 27.8837 5.56855C27.7821 5.44685 27.6554 5.38561 27.5031 5.38561ZM22.5333 12.6196C21.8858 13.2187 21.0921 13.5172 20.1533 13.5172C19.4166 13.5172 18.8263 13.3221 18.3824 12.9312C17.9378 12.5412 17.7158 12.004 17.7158 11.3195C17.7158 10.4166 18.033 9.65308 18.668 9.03038C19.3023 8.40767 20.0894 8.09632 21.0291 8.09632C21.7396 8.09632 22.3299 8.29784 22.8 8.70066C23.2694 9.1036 23.5045 9.65935 23.5045 10.3675C23.5045 11.2709 23.1808 12.022 22.5333 12.6196Z" fill="#003087"/> <path d="M56.4649 0.971147C55.4873 0.324706 54.2118 0.000701481 52.6377 0.000701481H46.5825C46.0745 0.000701481 45.7951 0.232788 45.7448 0.696403L43.2694 15.6405C43.2437 15.7873 43.2817 15.9216 43.3836 16.0436C43.4843 16.1659 43.6119 16.2267 43.7643 16.2267H46.8869C47.1915 16.2267 47.3945 16.0681 47.4963 15.7506L48.1819 11.502C48.207 11.3067 48.2959 11.1479 48.4484 11.0257C48.6008 10.9037 48.791 10.8238 49.0197 10.7872C49.2481 10.7509 49.4635 10.7327 49.6672 10.7327C49.87 10.7327 50.1111 10.745 50.3905 10.7693C50.6697 10.7937 50.848 10.8056 50.9236 10.8056C53.1073 10.8056 54.8206 10.2139 56.0648 9.02927C57.3089 7.8451 57.9308 6.20302 57.9308 4.1027C57.9311 2.66215 57.4421 1.61826 56.4649 0.97081V0.971147ZM52.5615 6.99668C52.0029 7.3629 51.165 7.54595 50.0481 7.54595L48.8294 7.58267L49.4768 3.66338C49.5271 3.39502 49.6921 3.26067 49.9718 3.26067H50.657C51.2155 3.26067 51.6597 3.28508 51.9903 3.33378C52.3198 3.38304 52.6377 3.53519 52.9423 3.79157C53.2471 4.04807 53.3993 4.42055 53.3993 4.90891C53.3993 5.93443 53.1197 6.63025 52.5615 6.99668Z" fill="#009CDE"/> </svg>
							</span>
						</button>

						<button class="checkout-btn-new card-btn">
							<span class="checkout-loader" ng-if="loading"></span>
							<span ng-if="!loading" class="card-btn">
								<svg xmlns="http://www.w3.org/2000/svg" width="25" height="24" viewBox="0 0 25 24" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M10.4436 3.25049H14.5564C16.3942 3.25047 17.8498 3.25046 18.989 3.40362C20.1614 3.56125 21.1104 3.89337 21.8588 4.64173C22.6071 5.39009 22.9392 6.33904 23.0969 7.51147C23.1873 8.18433 23.2244 8.96759 23.2395 9.87476C23.2464 9.91564 23.25 9.95765 23.25 10.0005C23.25 10.0357 23.2476 10.0704 23.2429 10.1044C23.25 10.6701 23.25 11.2823 23.25 11.9441V12.0569C23.25 13.8947 23.25 15.3503 23.0969 16.4895C22.9392 17.6619 22.6071 18.6109 21.8588 19.3592C21.1104 20.1076 20.1614 20.4397 18.989 20.5974C17.8498 20.7505 16.3942 20.7505 14.5564 20.7505H10.4436C8.60583 20.7505 7.15019 20.7505 6.01098 20.5974C4.83856 20.4397 3.88961 20.1076 3.14124 19.3592C2.39288 18.6109 2.06076 17.6619 1.90314 16.4895C1.74997 15.3503 1.74998 13.8947 1.75 12.0569V11.9441C1.74999 11.2823 1.74999 10.6701 1.75714 10.1044C1.75243 10.0704 1.75 10.0357 1.75 10.0005C1.75 9.95765 1.75359 9.91566 1.76049 9.87478C1.77564 8.9676 1.81267 8.18434 1.90314 7.51147C2.06076 6.33904 2.39288 5.39009 3.14124 4.64173C3.88961 3.89337 4.83856 3.56125 6.01098 3.40362C7.15019 3.25046 8.60582 3.25047 10.4436 3.25049ZM3.25199 10.7505C3.25009 11.1389 3.25 11.5546 3.25 12.0005C3.25 13.9073 3.25159 15.262 3.38976 16.2896C3.52502 17.2957 3.77869 17.8754 4.2019 18.2986C4.62511 18.7218 5.20476 18.9755 6.21085 19.1107C7.23851 19.2489 8.59318 19.2505 10.5 19.2505H14.5C16.4068 19.2505 17.7615 19.2489 18.7892 19.1107C19.7952 18.9755 20.3749 18.7218 20.7981 18.2986C21.2213 17.8754 21.475 17.2957 21.6102 16.2896C21.7484 15.262 21.75 13.9073 21.75 12.0005C21.75 11.5546 21.7499 11.1389 21.748 10.7505H3.25199ZM21.7239 9.25049H3.27607C3.29564 8.66376 3.32987 8.15683 3.38976 7.71134C3.52502 6.70525 3.77869 6.1256 4.2019 5.70239C4.62511 5.27918 5.20476 5.02551 6.21085 4.89025C7.23851 4.75208 8.59318 4.75049 10.5 4.75049H14.5C16.4068 4.75049 17.7615 4.75208 18.7892 4.89025C19.7952 5.02551 20.3749 5.27918 20.7981 5.70239C21.2213 6.1256 21.475 6.70525 21.6102 7.71134C21.6701 8.15683 21.7044 8.66376 21.7239 9.25049ZM5.75 16.0005C5.75 15.5863 6.08579 15.2505 6.5 15.2505H10.5C10.9142 15.2505 11.25 15.5863 11.25 16.0005C11.25 16.4147 10.9142 16.7505 10.5 16.7505H6.5C6.08579 16.7505 5.75 16.4147 5.75 16.0005ZM12.25 16.0005C12.25 15.5863 12.5858 15.2505 13 15.2505H14.5C14.9142 15.2505 15.25 15.5863 15.25 16.0005C15.25 16.4147 14.9142 16.7505 14.5 16.7505H13C12.5858 16.7505 12.25 16.4147 12.25 16.0005Z" fill="white"/> </svg>
								{{ __('Debit or credit card')}}
							</span>
						</button> --}}

						{{-- <div class="cart-check-container" ng-show="items.length > 0 || firstLoadingCart">
							<div class="cart-check-action flex-b align-c flex-e">
								<div class="cart-paymennt-detail js-open-cart-popup" data-target="bottomCheck" ng-click="addBodyClass($event)">
									<div class="cart-check-content">
										<div class="cart-check-content-footer flex-b align-c flex-e cart-checkout-total">
											<small>{{ __('Total:')}}</small>
											<span> @{{ formatPrice(getCartAmount(false), 0, false) }}</span>
										</div>
										<div class="cart-check-content-footer flex-b align-c flex-e">
											<div class="flex-b align-c flex-e" ng-show="discount > 0">
												<small>{{ __('Save:')}}</small>
												<span class="text-checkout">-@{{ formatPrice(discount, 0, false) }}</span>
											</div>
											<strong ng-show="customerRewards.showRewards && pointEarn > 0"></strong>
											<div class="flex-b align-c flex-e" ng-show="customerRewards.showRewards && pointEarn > 0">
												<small>{{ __('Earn %s') }}</small>
												<span>@{{ pointEarn }}CP</span>
											</div>
										</div>
									</div>
									<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none"><path fill-rule="evenodd" clip-rule="evenodd" d="M13.0466 10.8254C12.8669 11.035 12.5513 11.0593 12.3416 10.8796L8.00032 7.15853L3.65905 10.8796C3.44938 11.0593 3.13373 11.035 2.95402 10.8254C2.77431 10.6157 2.79859 10.3001 3.00825 10.1204L7.67492 6.12036C7.86217 5.95987 8.13847 5.95987 8.32571 6.12036L12.9924 10.1204C13.202 10.3001 13.2263 10.6157 13.0466 10.8254Z" fill="currentColor"/></svg>
								</div>
								<button class="checkout-btn-new" ng-click="order()">
									<span class="checkout-loader" ng-if="loading"></span>
									<span ng-if="!loading">{{ __('Place order now')}}</span>
								</button>
							</div>
						</div> --}}

						<div id="express-checkout-element">
						<!-- Express Checkout Element will be inserted here -->
						</div>
						<div id="error-message" style="color: red; margin-top: 5px;">
						<!-- Display error message to your customers here -->
						</div>
						<div id="payment-request-button" style="margin: 12px 0;">
						</div>
						<button id="applePayButton" ng-show="modeCheckout == 'test'" style="display: none;">Pay with Apple Pay</button>
					</div>
					<div style="margin-top: 18px; display: none;">
						<ul class="flex-b align-c flex-s flex-w" style="
							list-style: none; padding-left: 0px; color: var(--primary); font-size: 13px;font-weight: 400;
						">
							<li>
								<a href="{{ clroute(getOption('general.refund_url', 'refund-policy-n650.html')) }}" target="_blank">
									{{ __('Refund policy') }}
								</a>
							</li>
							<li>
								<a href="{{ clroute(getOption('general.return_url', 'returns-exchanges-policy-n651.html')) }}" target="_blank">
									{{__('Returns & Exchanges Policy')}}
								</a>
							</li>
							<li>
								<a href="{{ clroute(getOption('general.shipping_url', 'shipping-delivery-n7.html')) }}" target="_blank">
									{{ __('Shipping policy') }}
								</a>
							</li>
							<li>
								<a href="{{ clroute(getOption('general.privacy_url', 'privacy-policy-n13.html')) }}" target="_blank">
									{{__('Privacy policy')}}
								</a>
							</li>
							<li>
								<a href="{{ clroute(getOption('general.terms_service_url', 'terms-of-service-n5.html')) }}" target="_blank">
									{{__('Terms of service')}}
								</a>
							</li>

						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
	@include('cart::new-theme.includes.make-change')
	@include('cart::new-theme.includes.payment-detail')

	<div class="delete-item-wrapper @{{ showModalRemoveCartItem ? 'show-remove-modal' : '' }}" ng-show="showModalRemoveCartItem">
		<div class="delete-item-content delete-item-content-new">
			<div class="delete-item-content-top">
				<div class="delete-item-title">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
						<path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
						<path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
					</svg>
					<span>{{ __('Remove item') }}</span>
					<span class="close-pop" ng-click="closeModalRemoveCartItem()">
						<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M18 6l-12 12" /><path d="M6 6l12 12" /></svg>
					</span>
				</div>
				<div class="delete-item-content-block">
					<div class="delete-item-desc total-product-sale" ng-if="totalProductSale > 0">
						@{{ totalProductSale }} {{ __('customers purchased this') }}.
					</div>
					<div class="delete-item-desc">
						<span class="delete-item-icon flex-b align-c flex-c">
							<svg  xmlns="http://www.w3.org/2000/svg"  width="20"  height="20"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="1.5"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 7l16 0" /><path d="M10 11l0 6" /><path d="M14 11l0 6" /><path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12" /><path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3" /></svg>
						</span>
						<span>{{ __('Are you sure you want to remove this item?') }}</span>
					</div>
					<div class="delete-item-product">
						<img ng-src="@{{ itemRemove.image_url }}" width="60" height="60" alt="@{{ itemRemove.product_name }}">
						<div class="delete-item-product-info">
							<div>@{{ itemRemove.product_name }}</div>
							<div>@{{ itemRemove.name_variant }}</div>
						</div> 
					</div>
				</div>
				<div class="delete-item-action">
					<a href="javascript:;" class="delete-item-action-button delete-item-action-cancel" ng-click="closeModalRemoveCartItem()">{{ __('Cancel') }}</a>
					<a href="javascript:;" class="delete-item-action-button delete-item-action-delete" ng-click="removeCartItems(itemRemove)">{{ __('Remove') }}</a>
				</div>
			</div>
			{{-- <div class="delete-item-content-bottom">
				<div class="delete-item-title" ng-show="comments.length > 0">
					<svg width="16" height="16" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
						<path fill="#FFB636" d="m252.5 381l-128 49c-5.9 2.2-12.1-2.3-11.8-8.6l7-136.9c.1-2.1-.6-4.2-1.9-5.9L31.6 172c-4-4.9-1.6-12.2 4.5-13.9l132.4-35.6c2.1-.6 3.9-1.9 5-3.7L248.3 4c3.4-5.3 11.2-5.3 14.6 0l74.8 114.9c1.2 1.8 3 3.1 5 3.7l132.4 35.6c6.1 1.6 8.5 9 4.5 13.9l-86.1 106.6c-1.3 1.7-2 3.8-1.9 5.9l7 136.9c.3 6.3-5.9 10.8-11.8 8.6l-128-49c-2.1-.8-4.3-.8-6.3-.1z"/>
						<path fill="#FFD469" d="m456.1 51.7l-41-41c-1.2-1.2-2.8-1.7-4.4-1.5c-1.6.2-3.1 1.2-3.9 2.6l-42.3 83.3c-1.2 2.1-.8 4.6.9 6.3c1 1 2.4 1.5 3.7 1.5c.9 0 1.8-.2 2.6-.7L454.9 60c1.4-.8 2.4-2.2 2.6-3.9c.3-1.6-.3-3.2-1.4-4.4zm-307 43.5l-42.3-83.3c-.8-1.4-2.2-2.4-3.9-2.6c-1.6-.2-3.3.3-4.4 1.5l-41 41c-1.2 1.2-1.7 2.8-1.5 4.4c.2 1.6 1.2 3.1 2.6 3.9l83.3 42.3c.8.5 1.7.7 2.6.7c1.4 0 2.7-.5 3.7-1.5c1.7-1.8 2-4.4.9-6.4zm140.7 410l-29-88.8c-.2-.9-.7-1.7-1.3-2.3c-1-1-2.3-1.5-3.7-1.5c-2.4 0-4.4 1.6-5.1 3.9l-29 88.8c-.4 1.6-.1 3.3.9 4.6c1 1.3 2.5 2.1 4.2 2.1h57.9c1.6 0 3.2-.8 4.2-2.1c1.1-1.4 1.4-3.1.9-4.7z"/>
					</svg>
					<span>{{ __('Product Review Best Practices') }}</span>
				</div>
				<div class="cart-revew-slider" ng-show="comments.length > 0">
					<div class="cart-review-item-list">
						<div class="swiper-wrapper">
							<div class="cart-review-item-item swiper-slide" ng-repeat="comment in comments">
								<img class="cart-review-item-rate" src="{{ asset('modules/cart/images/star-list.svg') }}" height="14" height="78">
								<div class="cart-review-item-title">@{{ comment.name }}</div>
								<div class="cart-review-item-content">@{{ comment.content ? comment.content : comment.title }}</div>
							</div>
						</div>
						<div class="swiper-button-next cart-revew-next"></div>
						<div class="swiper-button-prev cart-revew-prev"></div> 
						<div class="swiper-pagination cart-pagination"></div>
					</div>
				</div>
			</div> --}}
		</div>
		<div class="delete-item-background" ng-click="closeModalRemoveCartItem()"></div>
	</div>

	<!-- The Modal -->
	<div id="addressBookModal" class="modal-address-book">
		<!-- Modal content -->
		<div class="modal-address-book-content ui-dialog-content" style="position: relative;">
			<span class="address-book-close" style="position: absolute; top: 10px; right: 10px; z-index: 5"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 16 16"> <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/> </svg></span>
			<h3 style="position: sticky; top: 0; background-color: #fff;z-index: 4">{{ __('Address Book') }}</h3>
			<div style="overflow: auto; max-height: 360px">
				<div class="address-item" ng-if="addressBook && addressBook.length" ng-repeat="address in addressBook">
					<strong style="margin-right: 10px">@{{ address.full_name }}</strong>
					<button class="ui-button ui-corner-all small-button" ng-click="fillCustomAddressFromAddressBook(address)">{{ __('Ship to this address') }}</button>
					<p>
						{{ __('Address') }}:
						@{{ getFullAddress(address, ['address', 'city_name', 'optional_address']) }}<br>
						@{{ getFullAddress(address) }},
						{{ __('Zip/Portal') }}: @{{ address.zip_code }}
					</p>
					{{ __('Phone') }}: @{{ address.phone }}
				</div>
			</div>
			<div style="position: sticky; top: 100%; background-color: #fff; z-index: 4; padding: 10px 0 0 0">
				<button ng-click="getAddressBook()" class="ui-button ui-corner-all small-button" type="button">{{ __('Reload') }}</button>
				<a class="ui-button ui-corner-all small-button" target="_blank" href="{{ route('user:address-book') }}">{{ __('Open address book') }}</a>
			</div>
		</div>

	</div>


	<!-- Modal Pre-order -->
	<div id="preOrderModal" class="pre-order-modal" ng-show="showModalPreOrder">
		<div class="modal-preorder-content">
			<div class="modal-preorder-close" ng-click="closePreOrderForm()">
                <label>
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
                        <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708z"/>
                    </svg>
                </label>
            </div>
			<div class="modal-wrapper">
				<img src="{{ asset('modules/cart/images/payment-order.png') }}" alt="">
				<div class="preorder-title">
					{{ __('Are you having problems with the payment?') }}
				</div>
				<div class="preorder-title">
					{{ __("Don't worry, you can pre-order and pay later. Our staff will get back to you.") }}
				</div>
				<div class="preorder-col">
					<label for="preorder-note">
						{{ __('Order notes (optional)') }}
					</label>
					<textarea
						id="preorder_note"
						name="preorder_note"
						type="text"
						class="form-control"
						ng-model="preOrderNote"
						ng-change="changePreOrderNote()"
					>
					</textarea>
					<div class="invalid-feedback" ng-if="errorPreOrderNote" ng-bind="errorPreOrderNote"></div>
				</div>	
							
			</div>
			<div class="modal-action">
				<a class="preorder-checkout-btn btn disable-links" style="opacity: 0.5;" ng-show="loading">
					{{ __('Loading') }}<span>&nbsp</span><i class='fa fa-spinner fa-spin'></i>
				</a>
				<div class="preorder-action">
					<button class="btn preorder-accept" ng-show="!loading" ng-click="preOrder()" ng-disabled="loading">{{ __('OK Buy now, pay later') }}</button>
					<button class="btn preoder-cancel" ng-show="!loading" ng-click="closePreOrderForm()" ng-disabled="loading">{{ __('No, Try again') }}</button>
				</div>
			</div>
		</div>
	</div>
	{{-- <div class="delete-item-wrapper @{{ showModalRemoveCartItem ? 'show-remove-modal' : '' }}" ng-show="showModalRemoveCartItem" style="display: none;">
		<div class="delete-item-content">
			<div class="delete-item-content-top">
				<div class="delete-item-title">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
						<path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
						<path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
					</svg>
					<span>{{ __('Remove item') }}</span>
					<span class="close-pop" ng-click="closeModalRemoveCartItem()">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
							<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
						  </svg>
					</span>
				</div>
				<div class="delete-item-desc total-product-sale" ng-if="totalProductSale > 0">@{{ totalProductSale }} {{ __('customers purchased this') }}.</div>
				<div class="delete-item-desc">{{ __('Are you sure you want to remove this item?') }}</div>
				<div class="delete-item-action">
					<a href="javascript:;" class="delete-item-action-cancel" ng-click="closeModalRemoveCartItem()">{{ __('Cancel') }}</a>
					<a href="javascript:;" class="delete-item-action-delete" ng-click="removeCartItems(itemRemove)">{{ __('Remove') }}</a>
				</div>
			</div>
			<div class="delete-item-content-bottom">
				<div class="delete-item-title" ng-show="comments.length > 0">
					<svg width="16" height="16" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg">
						<path fill="#FFB636" d="m252.5 381l-128 49c-5.9 2.2-12.1-2.3-11.8-8.6l7-136.9c.1-2.1-.6-4.2-1.9-5.9L31.6 172c-4-4.9-1.6-12.2 4.5-13.9l132.4-35.6c2.1-.6 3.9-1.9 5-3.7L248.3 4c3.4-5.3 11.2-5.3 14.6 0l74.8 114.9c1.2 1.8 3 3.1 5 3.7l132.4 35.6c6.1 1.6 8.5 9 4.5 13.9l-86.1 106.6c-1.3 1.7-2 3.8-1.9 5.9l7 136.9c.3 6.3-5.9 10.8-11.8 8.6l-128-49c-2.1-.8-4.3-.8-6.3-.1z"/>
						<path fill="#FFD469" d="m456.1 51.7l-41-41c-1.2-1.2-2.8-1.7-4.4-1.5c-1.6.2-3.1 1.2-3.9 2.6l-42.3 83.3c-1.2 2.1-.8 4.6.9 6.3c1 1 2.4 1.5 3.7 1.5c.9 0 1.8-.2 2.6-.7L454.9 60c1.4-.8 2.4-2.2 2.6-3.9c.3-1.6-.3-3.2-1.4-4.4zm-307 43.5l-42.3-83.3c-.8-1.4-2.2-2.4-3.9-2.6c-1.6-.2-3.3.3-4.4 1.5l-41 41c-1.2 1.2-1.7 2.8-1.5 4.4c.2 1.6 1.2 3.1 2.6 3.9l83.3 42.3c.8.5 1.7.7 2.6.7c1.4 0 2.7-.5 3.7-1.5c1.7-1.8 2-4.4.9-6.4zm140.7 410l-29-88.8c-.2-.9-.7-1.7-1.3-2.3c-1-1-2.3-1.5-3.7-1.5c-2.4 0-4.4 1.6-5.1 3.9l-29 88.8c-.4 1.6-.1 3.3.9 4.6c1 1.3 2.5 2.1 4.2 2.1h57.9c1.6 0 3.2-.8 4.2-2.1c1.1-1.4 1.4-3.1.9-4.7z"/>
					</svg>
					<span>{{ __('Product Review Best Practices') }}</span>
				</div>
				<div class="cart-revew-slider" ng-show="comments.length > 0">
					<div class="cart-review-item-list">
						<div class="swiper-wrapper">
							<div class="cart-review-item-item swiper-slide" ng-repeat="comment in comments">
								<img class="cart-review-item-rate" src="{{ asset('modules/cart/images/star-list.svg') }}" height="14" height="78">
								<div class="cart-review-item-title">@{{ comment.name }}</div>
								<div class="cart-review-item-content">@{{ comment.content ? comment.content : comment.title }}</div>
							</div>
						</div>
						<div class="swiper-button-next cart-revew-next"></div>
						<div class="swiper-button-prev cart-revew-prev"></div> 
						<div class="swiper-pagination"></div>
					</div>
				</div>
			</div>
		</div>
		<div class="delete-item-background" ng-click="closeModalRemoveCartItem()"></div>
	</div> --}}
	<div class="popup-new-item-wrapper payment-fail-popup" ng-show="isShowPaymentFail">
		<div class="popup-new-item-content">
			<div class="popup-new-item-content-top">
				<div class="popup-new-item-title">
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="#d2212b" class="bi bi-exclamation-triangle" viewBox="0 0 16 16">
						<path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.15.15 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.2.2 0 0 1-.054.06.1.1 0 0 1-.066.017H1.146a.1.1 0 0 1-.066-.017.2.2 0 0 1-.054-.06.18.18 0 0 1 .002-.183L7.884 2.073a.15.15 0 0 1 .054-.057m1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767z"/>
						<path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0M7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0z"/>
					</svg>
					<span>{{ __('Payment failed') }}</span>
					<span class="close-pop" ng-click="closePopupPaymentFail()">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-x" viewBox="0 0 16 16">
							<path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
						  </svg>
					</span>
				</div>
				<div class="popup-new-item-desc">
					<p>{{ __('The payment was unsuccessful due to an abnormality.') }}</p>
					<p>{{ __('Please check your payment info or use a another payment method') }}</p>
				</div>

				<div class="popup-new-item-action">
					<a href="javascript:;" class="popup-new-action-cancel" ng-click="closePopupPaymentFail()">{{ __('Try again') }}</a>
					<a href="{{ clroute('/contact/ticket') }}" target="_blank" class="popup-new-action-delete">{{ __('Submit a ticket') }}</a>
				</div>
			</div>
		</div>
		<div class="popup-new-item-background" ng-click="closePopupPaymentFail()"></div></div>
	</div>
	<div class="close-body-open-background"></div>
</div>
