<div id="bottomDetail" class="popup-edit"
    ng-show="currentProduct && currentProduct.id"
    ng-controller="MakeChangeController">
    <div class="cart-header-popup">
        <span>{{ __('Edit product variable') }}</span>
        <button class="close-body-open-button" ng-click="removeAllBodyClasses()">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                <path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
            </svg> 
        </button>
    </div>
    <div class="cart-popup-content flex-b">
        <div class="checkout-popup-item">
            <div class="checkout-popup-update-item">
                <div class="checkout-popup-variant-wrapper">

                    <div class="make-change-item-content-col flex-b" ng-repeat="groupVariant in groupVariants" data-slug="@{{ groupVariant.slug }}">
                        <div class="make-change-item-col flex-b align-c type-color" ng-if="groupVariant.type == 'IMAGE'">
                            <div class="make-change-item-variant-title">
                                @{{ groupVariant.name }}
                            </div>
                            <div class="make-change-item-variant-content-wrapper">
                                <div class="make-change-item-variant-content">
                                    <div ng-repeat="option in groupVariant.values" id="js-choose-variant-@{{ option.id }}" class="p-p5 js-choose-variant choose-image-variant variant-image-item @{{ isSelected(option) ? 'active' : '' }}" style="width: 30px" ng-style="option.color_code && {'background-color': option.color_code}" data-variant-id="@{{ groupVariant.id }}" data-variant-option-id="@{{ option.id }}" data-variant-option-slug="@{{ option.slug }}" data-theme-variant-color="@{{ checkThemeVariantColor(option.slug) }}" title="@{{ option.name }}" ng-click="selectVariant(groupVariant, option, currentProduct)">
                                        <img ng-if="!option.color_code" ng-src="@{{ getImageCdn(option.image_url, 100, 100) }}" alt="@{{ option.name }}" title="@{{ option.name }}" class="w-full img-round" referrerpolicy="no-referrer" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="make-change-item-row flex-b align-c type-gender" ng-if="(groupVariant.type != 'IMAGE' && groupVariant.type != 'OPTION')">
                            <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                            <div class="make-change-item-variant-content">
                                <label for="type-@{{ groupVariant.slug }}-@{{ $index }}" class="make-change-item-variant" ng-repeat="variant in groupVariant['values']" ng-click="selectVariant(groupVariant, variant, currentProduct)">
                                    <input type="radio" id="type-@{{ groupVariant.slug }}-@{{ $index }}" name="type-@{{ groupVariant.slug }}" ng-checked="isSelected(variant)">
                                    <span>@{{ variant.name }}</span>
                                </label>
                            </div>
                        </div>
                        
                        <div class="make-change-item-row flex-b align-c type-style" ng-if="groupVariant.type == 'OPTION'">
                            <div class="make-change-item-variant-title">@{{ groupVariant.name }}</div>
                            <div class="make-change-item-variant-content">
                                <select class="select" name="" ng-model="variantOptionSelected[groupVariant.id]" ng-change="selectVariant(groupVariant, null, currentProduct)" ng-options="variant.id as variant.name + getPriceVariant(variant, groupVariant.id, currentProduct) for variant in groupVariant['values']">
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="make-change-location-print make-change-item-content-col flex-b" ng-show="currentProduct.is_valid_print_back">
                        <div class="product-variant-heading">
                            <div class="make-change-item-variant-title">{{ __('Print Location') }}:</div>
                            <div id="selected-print-location">
                                @{{ getByField(printLocations, 'value', currentProduct.tmp_print_location) ? getByField(printLocations, 'value', currentProduct.tmp_print_location).name : "" }}
                            </div>
                        </div>
                        <div class="image-select-wrapper">
                            <div class="image-select-option @{{ currentProduct.tmp_print_location == printLocation.value ? 'active' : '' }}" ng-repeat="printLocation in currentProduct.attributes.print_locations" ng-click="selectPrintLocation(currentProduct, printLocation)">
                                <div class="image-wrapper-inner">
                                    <img class="selected" ng-src="@{{ printLocation.selectImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                                    <img class="default" ng-src="@{{ printLocation.defaultImage }}" alt="@{{ printLocation.name }}" class="image-select-option">
                                </div>
                                <label>@{{ printLocation.name }}</label>
                            </div>
                        </div>
                    </div>
                    <div class="make-change-item-row make-change-item-quantity flex-b align-c type-style">
                        <div class="make-change-item-variant-title">{{ __("Quantity")}}</div>
                        <div class="make-change-item-variant-content">
                            <a rel="nofollow" href="/wholesale" class="link-bulk-order" target="_blank">Buying In Bulk?</a>
                            <div class="shopcart-item shopcart-qty">
                                <div class="shopcart-qty flex-box align-s flex-c button-new ">
                                    <button class="shopcart-button minus" type="button" name="button" ng-click="changeQuantityByButton(newItem.quantity - 1)" ng-disabled="loading">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-dash-lg" viewBox="0 0 16 16">
                                            <path d="M0 8a1 1 0 0 1 1-1h14a1 1 0 1 1 0 2H1a1 1 0 0 1-1-1z" />
                                        </svg>
                                    </button>
                                    <input type="text" ng-value="item.quantity" class="quantity shopcart-input number-input" ng-model="newItem.quantity" autocomplete="off" ng-change="changeQuantity()" ng-model-options="{ debounce: 500 }" ng-disabled="originOrder">
                                    <button class="shopcart-button plus" type="button" name="button" ng-click="changeQuantityByButton(newItem.quantity + 1)" ng-disabled="loading">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                                            <path d="M8 0a1 1 0 0 1 1 1v6h6a1 1 0 1 1 0 2H9v6a1 1 0 1 1-2 0V9H1a1 1 0 0 1 0-2h6V1a1 1 0 0 1 1-1z"></path>
                                        </svg>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="checkout-popup-action-wrapper flex-b align-c">
            <button class="btn update-product" type="button" ng-click="addItemToCart('update')" ng-disabled="loading" ng-show="currentProduct.variant_default.length == 0 || currentVariant.status == 'ACTIVE'">
                {{ __('Update item')}}
            </button>
            <button class="btn add-product" type="button" ng-click="addItemToCart()" ng-disabled="loading" ng-show="currentProduct.variant_default.length == 0 || currentVariant.status == 'ACTIVE'">
                {{ __('Add item')}}
            </button>
            <button id="js-checkout-cancel" class="btn light" type="button">
                {{ __('Cancel')}}
            </button>
        </div>
    </div>
</div>
<span class="checkout-popup-background"></span>