<a class="mini-cart-link flex-b align-c flex-c" href="{{ clroute('/cart') }}" id="mini-cart" rel="nofollow" aria-label="{{ __('View cart') }}">
    <span>
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path fill-rule="evenodd" clip-rule="evenodd" d="M8.92098 7.29287C9.31152 7.15483 9.74001 7.35953 9.87805 7.75007C10.1873 8.62497 11.0217 9.25 12.0002 9.25C12.9787 9.25 13.8131 8.62497 14.1224 7.75007C14.2604 7.35953 14.6889 7.15483 15.0794 7.29287C15.47 7.43091 15.6747 7.8594 15.5366 8.24993C15.0222 9.70541 13.6342 10.75 12.0002 10.75C10.3663 10.75 8.97822 9.70541 8.46379 8.24993C8.32575 7.8594 8.53044 7.43091 8.92098 7.29287ZM12.3606 5.5H11.6394C10.0136 5.5 8.93152 5.50267 8.11199 5.60393C7.33366 5.70009 6.9749 5.86728 6.72313 6.07623C6.47137 6.28517 6.24093 6.60698 6.00297 7.35425C5.75242 8.14109 5.55038 9.20417 5.25076 10.8021C4.83078 13.042 4.5492 14.5634 4.49919 15.7093C4.45098 16.8139 4.63607 17.2835 4.89595 17.5966C5.15583 17.9097 5.58325 18.1782 6.67777 18.3344C7.81328 18.4964 9.3605 18.5 11.6394 18.5H12.3606C14.6395 18.5 16.1868 18.4964 17.3223 18.3344C18.4168 18.1782 18.8442 17.9097 19.1041 17.5966C19.364 17.2835 19.5491 16.8139 19.5008 15.7093C19.4508 14.5634 19.1693 13.042 18.7493 10.8021C18.4497 9.20417 18.2476 8.14109 17.9971 7.35425C17.7591 6.60698 17.5287 6.28517 17.2769 6.07623C17.0251 5.86728 16.6664 5.70009 15.8881 5.60393C15.0685 5.50267 13.9864 5.5 12.3606 5.5ZM5.76518 4.92196C4.65428 5.84393 4.36167 7.40452 3.77645 10.5257C2.95353 14.9146 2.54207 17.1091 3.74169 18.5545C4.94131 20 7.17402 20 11.6394 20H12.3606C16.826 20 19.0587 20 20.2584 18.5545C21.458 17.1091 21.0465 14.9146 20.2236 10.5257C19.6384 7.40452 19.3458 5.84393 18.2349 4.92196C17.124 4 15.5362 4 12.3606 4H11.6394C8.46386 4 6.87608 4 5.76518 4.92196Z" fill="currentColor"/> </svg>
        <span class="js-mini-cart-count" style="display: none;"> 0 </span>
    </span>
</a>

<link rel="stylesheet" href="@asset('cart/css/mini-shopping.css')?v=<?= config('sa.version') ?>">

@section('js')
<script src="//js.stripe.com/v3/"></script>
<?php
$paypalKey = getPaypalKey();
$paypalKeyTest = config('cart::paypal.sandbox_clientId');
$currency = isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit');
$defaultCurrency = config('default.currency_unit');
$locale = env('APP_LOCALE');
if ($locale == '') {
    $locale = 'us';
}
?>
@if ($defaultCurrency == $currency)
    @if (isset($_GET['mode']) && $_GET['mode'] == 'test')
    <script src="https://www.paypal.com/sdk/js?components=buttons&client-id=<?=$paypalKeyTest?>&commit=true&currency=<?=$currency?>&enable-funding=paylater"></script>
    @else
    <script src="https://www.paypal.com/sdk/js?components=buttons&client-id=<?=$paypalKey['clientId']?>&commit=true&currency=<?=$currency?>&enable-funding=paylater"></script>
    @endif
@endif
<script>
    let isMobileHeader = false
    @mobile
        isMisMobileHeaderobile = true
    @endmobile
    var transactionFeeText = "{{ __('Handling fee') }}";
    var betweenFromToText = "{{ __('#key between #from - #to') }}";
    var shippingFeeText = "{{ __('Shipping fee') }}";
    var totalText = "{{ __('Total') }}";
    var subtotalText = "{{ __('Subtotal') }}";
    var printLocationText = "{{ __('Print Location') }}";
    var errorTryAgainText = "{{ __('Error. Please try again later!') }}";
    var viewText = "{{ __('View') }}";
    var keyStripe = "<?=config('cart::stripe.public_key')?>";
    var keyStripeTest = "<?=config('cart::stripe.test_public_key')?>";
    var useCheckoutInSidebar = "<?=config('cart::stripe.use_checkout_in_sidebar', false)?>";
    var usePaypalInSidebar = "<?=config('cart::paypal.use_paypal_in_sidebar', false)?>";
    var isValidPaypalExpressCheckout = usePaypalInSidebar;
    var base_api_url_header = "<?= config('sa.api_url'); ?>";
    var currencyUnitAddToCartHeader = "{{ isset($_COOKIE['currency']) ? $_COOKIE['currency'] : config('default.currency_unit') }}";
    var defaultcurrencyUnitAddToCartHeader = "{{ config('default.currency_unit') }}";
    var prefixLocaleUrlMiniCart = "{{ env('APP_LOCALE') != '' ? '/' . env('APP_LOCALE') . '/' : '/' }}";
    var priceConfigForMiniCart = <?= json_encode(getPriceConfig()) ?>;
    var printLocationsPriceMiniCart = <?= json_encode(getPrintLocationPriceConfig()) ?>;
    var priceTemplate = "{{ getCurrencyTemplate() }}";
    var priceTempate = "{{ getCurrencyTemplate() }}";
    var currentRouteName  = "{{ \Route::currentRouteName() }}";
    var locale = '';
    if (typeof localePrefix !== 'undefined' && localePrefix !== '') {
        locale = '/' + localePrefix;
    }
    var minicart = 255;
    var multiItem = minicart * 1.5;
    var viewportHeight = $(window).height();
    let imageSize = 360;
    if (typeof jsNotMobile !== "undefined" && jsNotMobile) {
        imageSize = 360;
    }
    var printLocationsMiniCartHeader = <?= json_encode(getPrintLocationConfig()) ?>;
    let listRelated = [];
    let isScrollBottomSidebar = false;
    let isScrollBottomSidebarRecommend = false;
    let isTimeOut = false;
    var isValidExpressCheckoutHeader = false;
    let cartItemHeader = [];
    var validCountryHeader = <?= json_encode(config('cart::sa.valid_country', [])) ?>;
    var countryByIpHeader = null;
    var tokenHeader = null
    let modeHeader = null;
    let stripeHeader = null;
    let elementsStripeHeader = null;
    var keepOriginalHeader = <?= json_encode(config('cart::sa.keep_original_price', [])) ?>;
    var stripeElementStyleHeader = {};
    let shippingInfoByPaymentRequestButtonHeader = {};
    let isShowExpressCheckout = false;
    let isShowPaypalExpressCheckout = false;
    var paypalAccountHeader = null;
    let shippingTypeHeader = "standard";
    var cartAmountHeader = 0;
    var stripeFeeHeader = "<?= config("cart::stripe.applepay_include_fee", 0) ?>";
    const monthNamesHeader = [
        "{{ __('Jan. #date') }}", "{{ __('Feb. #date') }}", "{{ __('Mar. #date') }}", "{{ __('Apr. #date') }}", "{{ __('May. #date') }}", "{{ __('Jun. #date') }}",
        "{{ __('Jul. #date') }}", "{{ __('Aug. #date') }}", "{{ __('Sep. #date') }}", "{{ __('Oct. #date') }}", "{{ __('Nov. #date') }}", "{{ __('Dec. #date') }}"
    ];
    var cjeventCookieHeader = "{{ isset($_COOKIE['cje']) ? $_COOKIE['cje'] : '' }}";
    let selectedShippingHeader = [];
    let selectedCountryHeader = null;
    var countriesHeader = [];
    window.HireDesignerCartText = "{{ __('Hire Artist For Customization') }}";
    var otherTaxFeeHeader = "<?= config("cart::sa.other_tax_fee", 0) ?>";
    var otherFeeTextHeader = "{{ __('International Emergency Economic Powers Act (IEEPA)') }}";
    var miniCartTranslateText = {
        front: "{{ __('Front') }}",
        back: "{{ __('Back') }}",
        left: "{{ __('Left') }}",
        right: "{{ __('Right') }}",
        top: "{{ __('Top') }}",
        bottom: "{{ __('Bottom') }}"
    };

    function decimalAdjust(type, value) {
        let matches = priceTemplate.match(/{money}{([^a-zA-z0-9]+)}{([0-9]+)}/);
        let exp = -2;
        if (matches.length == 3) {
            exp = parseInt(matches[2] * (matches[2] ? -1 : 1));
        }
        // If the exp is undefined or zero...
        if (typeof exp === 'undefined' || +exp === 0) {
        return Math[type](value);
        }
        value = +value;
        exp = +exp;
        // If the value is not a number or the exp is not an integer...
        if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
            return NaN;
        }
        // Shift
        value = value.toString().split('e');
        value = Math[type](+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
        // Shift back
        value = value.toString().split('e');
        return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
    }
    function formatPriceByCurrency(amount, $type = 'round') {
        let retval = amount;
        let acceptRound = ['JPY', "KRW", "VND"];
        if (acceptRound.includes(currencyUnitAddToCartHeader) && $type == 'round') {
            retval = Math.round(amount);
        } else if (!keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(((retval * 100) * 100) / 100);
        } else if (keepOriginalHeader.includes(currencyUnitAddToCartHeader) && $type == '*') {
            retval = Math.round(retval);
        }
        return retval;
    }
</script>
<script src="{{ asset('modules/cart/js/mini-cart-header.js') }}?v={{ config('sa.version') }}"></script>
@append

