<div class="payment-detail-box">
    <div class="cart-header-popup">
        <span>
            {{ __('Payment details') }}
        </span>
        <button class="close-body-open-button" ng-click="clearBodyClassAndStyle()">
            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none">
                <path d="M19.9999 4.00006L4 20M3.99993 4L19.9999 19.9999" stroke="currentColor" stroke-width="2"
                    stroke-linecap="round" />
            </svg>
        </button>
    </div>

    <div class="payment-details">
        <div class="payment-details-row">
            <div class="payment-row">
                <div class="payment-label">
                    {!! __('Tạm tính') !!}
                </div>
                <div class="payment-value">
                    @{{ formatPrice(cart.sub_total - totalDesignFee, 0, false) }}
                </div>
            </div>
    
            <div class="payment-row">
                <div class="payment-label">
                    <div class="payment-label">{{ __('Shipping fee') }}</div>
                </div>
                <div class="payment-value">
                    @{{ formatPrice(shipping_fee, 0, false) }}
                </div>
            </div>
    
            <div class="payment-row" ng-show="totalDesignFee > 0">
                <div class="payment-label">
                    {{ __('Original design') }}
                </div>
                <div class="payment-value">@{{ formatPrice(totalDesignFee, 0, false) }}</div>
            </div>
        </div>

        <div class="payment-details-row" ng-show="discountValue > 0">
            <div class="payment-row js-cart-discount" ng-show="discountValue > 0">
                <div class="payment-label">
                    {{ __('Product Discount') }}
                </div>
                <div class="payment-value">
                    @{{ formatPrice(discountValue, 0, false) }}
                </div>
            </div>
    
            @if ($useTaxes)
                <div class="payment-row">
                    <div class="payment-label">
                        {!! __('Taxes') !!}
                    </div>
                    <div class="payment-value">
                        {!! __('Calculated at checkout') !!}
                    </div>
                </div>
            @endif
        </div>

        <div class="payment-details-row">
            <div class="payment-row">
                <div class="payment-label strong-label">
                    {{ __('Total') }}
                </div>
                <div class="payment-value strong-label">
                    @{{ formatPrice(getCartAmount(false), 0, false) }}
                </div>
            </div>
        </div>

        <div class="payment-details-row" ng-show="pointEarn > 0">
            <div class="payment-row">
                <div class="payment-label">
                    <span>{{ __('Earn') }}</span>
                    <strong>
                        {{ __('Rewards') }}
                    </strong>
                    <div class="address-tooltip">
                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor"
                            class="bi bi-question-circle" viewBox="0 0 16 16">
                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16" />
                            <path
                                d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94" />
                        </svg>
                        <div class="address-tooltip-content">
                            @{{ earnPointText.replace("#point", pointEarn) }}
                        </div>
                    </div>
                </div>
                <div class="payment-value">
                    @{{ pointEarn }}
                </div>
            </div>
        </div>

    </div>

    <div class="cart-check-box flex-b align-c flex-e">
        <div class="cart-paymennt-detail js-open-cart-popup">
            <div class="cart-check-content">
                <div class="cart-check-content-footer flex-b align-c flex-e cart-checkout-total">
                    <small>{{ __('Total:') }}</small>
                    <span> @{{ formatPrice(getCartAmount(false), 0, false) }}</span>
                </div>
                <div class="cart-check-content-footer flex-b align-c flex-e">
                    {{-- <div class="flex-b align-c flex-e" ng-show="discountValue > 0">
                        <small>{{ __('Save:') }}</small>
                        <span class="text-checkout">-@{{ formatPrice(discountValue, 0, false) }}</span>
                    </div>
                    <strong ng-show="customerRewards.showRewards && pointEarn > 0"></strong> --}}
                    <div class="flex-b align-c flex-e" ng-show="customerRewards.showRewards && pointEarn > 0">
                        <small>{{ __('Earn') }}</small>
                        <span>@{{ pointEarn }}CP</span>
                    </div>
                </div>
            </div>
            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M13.0466 10.8254C12.8669 11.035 12.5513 11.0593 12.3416 10.8796L8.00032 7.15853L3.65905 10.8796C3.44938 11.0593 3.13373 11.035 2.95402 10.8254C2.77431 10.6157 2.79859 10.3001 3.00825 10.1204L7.67492 6.12036C7.86217 5.95987 8.13847 5.95987 8.32571 6.12036L12.9924 10.1204C13.202 10.3001 13.2263 10.6157 13.0466 10.8254Z"
                    fill="currentColor" />
            </svg>
        </div>
        <button class="checkout-btn-new" ng-click="processCheckout()" ng-disabled="loading">
            <span class="checkout-loader" ng-if="loading"></span>
			<span ng-if="!loading">{{ __('Checkout')}}</span>
        </button>
    </div>
</div>
