<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['middleware' => ['web', 'frontend']], function () {
    Route::get('/cart', 'IndexController@index')->name('cart');
    Route::get('/checkout', ['as' => 'module::cart::checkout', 'uses' => 'CartController@checkout']);
    Route::get('/exchange', ['as' => 'module::cart::exchange', 'uses' => 'CartController@exchange']);
    Route::get('/exchange-shipping', ['as' => 'module::cart::exchange-shipping', 'uses' => 'CartController@exchangeShipping']);
    Route::post('/checkout', ['uses' => 'CartController@order']);
    Route::get('/finish', 'CartController@finish')->name("finish");
    Route::get('/cancel', 'CartController@cancel');
    Route::post('/cart', 'IndexController@addToCartFlow');
    Route::get('/track-order', 'IndexController@indexTrackOrder')->name('track-order');
    Route::get('/cart/get-customer-rewards', [
        'as' => 'cart::get-customer-rewards',
        'uses' => 'IndexController@getCustomerRewards'
    ]);
    Route::get('/cart/get-customer-point', [
        'as' => 'cart::get-customer-point',
        'uses' => 'IndexController@getCustomerPoint'
    ]);
    Route::get('/cart/get-discount-by-refer', [
        'as' => 'cart::get-customer-point',
        'uses' => 'IndexController@getDiscountByRefer'
    ]);
    Route::get('/cart/get-config-range-by-market', [
        'as' => 'cart::get-config-range-by-market',
        'uses' => 'IndexController@getConfigRangeByMarket'
    ]);
});

Route::group(['middleware' => 'web'], function () {
    Route::post('/cart/update-cart-item', [
        'as' => 'update::cart::item',
        'uses' => 'IndexController@updateCartItem'
    ]);
    Route::delete('/cart/remove-cart-item', [
        'as' => 'remove::cart::item',
        'uses' => 'IndexController@removeCartItems'
    ]);
    Route::post('/cart/add-to-cart', [
        'as' => 'add::to::cart',
        'uses' => 'IndexController@addToCart'
    ])->middleware(['bot.default_response']);
    Route::post('/cart/add-all-to-cart', [
        'as' => 'add::to::cart',
        'uses' => 'IndexController@addAllToCart'
    ])->middleware(['bot.default_response']);
    Route::get('/cart/get-cart-items', [
        'as' => 'get::cart::items',
        'uses' => 'IndexController@getCart'
    ])->middleware(['bot.default_response']);

    Route::get('/cart/get-customer-token', [
        'as' => 'get::customer::token',
        'uses' => 'IndexController@getCustomerToken'
    ])->middleware(['bot.default_response']);
    Route::post('/cart/checkout-action', [
        'as' => 'action::cart::checkout',
        'uses' => 'CartController@checkoutAction'
    ]);
    Route::get('/shipping/info', [
        'as' => 'get::shipping::info',
        'uses' => 'IndexController@getShippingInfo'
    ]);
    Route::get('/cart/shipping/info', [
        'as' => 'get::cart::shipping::info',
        'uses' => 'IndexController@getShippingInfoCart'
    ]);
    Route::get('/cart/related-product', [
        'as' => 'cart::related::product',
        'uses' => 'IndexController@getRelatedProducts'
    ]);
    Route::get('/cart/product-variant', [
        'as' => 'cart::producy::variant',
        'uses' => 'IndexController@getProductVariant'
    ]);
    Route::post('/cart/fail-checkout', [
        'as' => 'cart::fail-checkout',
        'uses' => 'IndexController@sendLogFailCheckout'
    ]);
    Route::get('/cart/same-item-in-cart', [
        'as' => 'cart::same-item-in-cart',
        'uses' => 'IndexController@getSameItemInCart'
    ]);
    Route::get('/cart/get-product', [
        'as' => 'cart::get-product',
        'uses' => 'IndexController@findProduct'
    ]);
    Route::get('/cart/get-freeship-package-product', [
        'as' => 'cart::get-freeship-package-product',
        'uses' => 'IndexController@getFreeshipPackageProduct'
    ]);
    Route::get('/cart/get-customer-info', [
        'as' => 'cart::get-customer-info',
        'uses' => 'IndexController@getCustomerInfo'
    ]);
    Route::post('/cart/validate-merchant', [
        'as' => 'cart::validate-merchant',
        'uses' => 'IndexController@validateAppleMerchant'
    ]);

    Route::get('/cart/get-design-fee', [
        'as' => 'cart::get-design-fee',
        'uses' => 'IndexController@getDesignFee'
    ]);

    Route::get('/cart/get-country', 'IndexController@getCountryByIp');
    Route::get('/cart/trademarks', 'IndexController@checkTrademarksPaypal');
    Route::get('/cart/email-verifier', 'Services\VerifyEmailService@verifyEmail');
    Route::get('/cart/event', 'IndexController@getEvent')->middleware(['bot.default_response']);
    Route::post('/order/cancel', 'IndexController@cancelOrder');

    Route::get('/get-product-personalize-url', [
        'as' => 'cart::get-product-personalize-url',
        'uses' => 'IndexController@getProductPersonalizeUrl',
    ]);
    Route::get('/cart/tax-us', [
        'as' => 'cart::tax-us',
        'uses' => 'IndexController@checkTaxUs',
    ]);
    Route::post('/cart/continue-login', [
        'as' => 'cart::continue-login',
        'uses' => 'IndexController@continueLogin',
    ]);
    Route::post('/api/lian/payment-success', [
        'as' => 'update::payment-lian::success',
        'uses' => 'CartController@lianPaymentSuccess'
    ]);

    Route::get('/cart/autocomplete', 'IndexController@autocomplete');
});

Route::post('/save-captured-image', [
    'as' => 'cart::save-captured-image',
    'uses' => 'IndexController@saveCapturedImage'
]);
Route::group(['prefix' => 'product/trademarks', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', 'ProductTrademarksController@index');

});

Route::group(['prefix' => 'service/product/trademarks'], function () {
    Route::get('/find', [
        'uses' => 'Services\ProductTrademarksService@find',
    ]);
    Route::post('/store', [
        'uses' => 'Services\ProductTrademarksService@store',
    ]);
    Route::post('/delete', [
        'uses' => 'Services\ProductTrademarksService@delete',
    ]);
});