<?php

namespace Modules\ConfigDescription\Controllers;

use Cache;
use Module;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Modules\ConfigDescription\Controllers\Controller;
use Modules\ConfigDescription\Models\Option;
use Modules\ConfigDescription\Models\ProductDescription;

class RebuildController extends Controller
{
    public function rebuild(Request $request) {
        $retVal = [
            'status' => 'successful'
        ];

        $option = Option::where('key', 'product_descriptions')->first();
        if ($option) {
            $configs = json_decode($option->value);

            foreach ($configs as $item) {
                $saveData = [
                    'categories' => !empty($item->categories) ? json_encode($item->categories) : null,
                    'types' => !empty($item->types) ? json_encode($item->types) : null,
                    'styles' => !empty($item->styles) ? json_encode($item->styles) : null,
                    'description' => $item->description
                ];

                ProductDescription::create($saveData);
            }
        }

        return $retVal;
    }

    public function rebuildV2()
    {
        $configsDescriptions = DB::table('config_description_product_description')->get();

        foreach ($configsDescriptions as $description) {
            DB::table('config_description_category')->where('config_description_id', $description->id)->delete();
            $categories = json_decode($description->categories);
            DB::table('config_description_category')->insert(array_map(function($category) use($description) {
                return [
                    'category_id' => $category,
                    'config_description_id' => $description->id
                ];
            }, $categories));
        }
    }
}
