<?php

namespace Modules\ConfigDescription\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Modules\ConfigDescription\Models\TagDescription;

class TagDescriptionController extends Controller
{
    public function index(Request $request)
    {
        return view('config-description::system.tag-description');
    }

    public function applyTagDescriptionProduct(Request $request)
    {
        $tagDescriptionId = $request->input('tag_description_id');
        $message = 'OK';

        $tagDescription = TagDescription::query()
            ->select(['id', 'tag_id'])
            ->where('id', $tagDescriptionId)->first();

        if ($tagDescription) {

            // get tag description product configured
            $configuredDescriptionProducts = DB::table('config_description_product_tag_description')
                ->where('tag_id', $tagDescription->tag_id)
                ->select(['product_id', 'tag_id', 'tag_description_id'])
                ->get()
                ->toArray();

            // get product dont have tag description
            $tagProductIds = DB::table('tag_refer')->where('tag_id', $tagDescription->tag_id)
                ->where('refer_type', 'PRODUCT')
                ->select(['refer_id'])
                ->pluck('refer_id')
                ->toArray();

            // get product id need config
            $productIds = $this->getProductNeedConfig($tagProductIds, $configuredDescriptionProducts);

            if (!$productIds || !count($productIds)) {
                $message = 'Can not find any product need to config!';
                goto end;
            }

            // get config description available , count < 100
            // $availableDescriptions = $this->getAvailableDescription($tagDescription->tag_id, $configuredDescriptionProducts);

            // random to get 100 product
            $limitProduct = 100;
            if (count($productIds) < $limitProduct) {
                $limitProduct = count($productIds);
            }

            if (count($productIds) > 1) {
                $indexRandom = array_rand($productIds, $limitProduct);
            } else { // array_rand return int
                $indexRandom = [array_rand($productIds, $limitProduct)];
            }

            $insertData = [];
            foreach ($indexRandom as $index) {
                $insertData[] = [
                    'product_id' => $productIds[$index],
                    'tag_id' => $tagDescription->tag_id,
                    'tag_description_id' => $tagDescription->id,
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ];
            }

            // assign to product
            DB::table('config_description_product_tag_description')->insert($insertData);

            $message = count($insertData) . ' rows affected!';
        }

        end:
        return [
            'status' => 'successful',
            'message' => $message
        ];

    }

    /*
     * rule: not product id in $tagProductIds but not in $configuredDescriptionProducts
     * */
    protected function getProductNeedConfig($tagProductIds, $configuredDescriptionProducts)
    {
        $ids = [];

        foreach ($tagProductIds as $productId) {

            $found = array_filter($configuredDescriptionProducts, function($desProduct) use ($productId) {
                return $desProduct->product_id == $productId;
            });

            if ($found && count($found)) {
                continue;
            }

            $ids[] = $productId;

        }

        return $ids;
    }

    /*
     * rule: count presentation < 100 time
     * */
    protected function getAvailableDescription($tagId, $configuredDescriptionProducts)
    {
        // all tag description
        $tagDescriptions = DB::table('config_description_tag_description')
            ->where('tag_id', $tagId)
            ->pluck('id')
            ->toArray();

        $descriptionCount = [];
        foreach ($configuredDescriptionProducts as $descriptionProduct) {
            if (!isset($descriptionCount[$descriptionProduct->tag_description_id])) {
                $descriptionCount[$descriptionProduct->tag_description_id] = 0;
            }
            $descriptionCount[$descriptionProduct->tag_description_id] ++;
        }

        $limitedDescription = array_filter($descriptionCount, function($value) {
            return $value > 100;
        });

        $limitedDescriptionIds = array_keys($limitedDescription);

        return array_diff($tagDescriptions, $limitedDescriptionIds);
    }

    public function updateTagDescription(Request $request)
    {
        $descriptions = $request->input('descriptions');
        $updatedData = [];

        if ($descriptions && count($descriptions)) {

            foreach ($descriptions as $description) {

                $tagDescription = TagDescription::query()->where('id', $description['id'])->first();
                if ($tagDescription) {
                    $tagDescription->fill($description);
                    if ($tagDescription->save()) {
                        $updatedData[] = $tagDescription;
                    }
                }

            }

        }

        return [
            'status' => 'successful',
            'updated' => $updatedData
        ];
    }

    public function deleteDescription(Request $request)
    {
        $id = $request->input('id');

        // delete description product config
        DB::table('config_description_product_tag_description')
            ->where('tag_description_id', $id)
            ->delete();

        // delete description
        TagDescription::query()->where('id', $id)->delete();

        return [
            'status' => 'successful'
        ];
    }

    public static function getTagDescription($productId)
    {
        $description = DB::table('config_description_product_tag_description')
            ->join('config_description_tag_description', 'config_description_tag_description.id', 'config_description_product_tag_description.tag_description_id')
            ->where('product_id', $productId)
            ->first();

        $html = '';
        if ($description && $description->content) {
            $html = '<p id="tagDescription">';
            $html .= nl2br($description->content);
            $html .= '</p>';
        }

        return $html;
    }
}
