<?php

namespace Modules\ConfigDescription\Models;

use DB;
use  Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Schema;

class Product extends Model
{
    protected $table = 'product';
    public static $cache = [];

    public function getUserAttribute() {
        $userId = null;
        if (Schema::hasTable('product_n_user')) {
            $pNU = DB::table('product_n_user')->where('product_id', $this->id)->first(['user_id']);
            if ($pNU) {
                $userId = $pNU->user_id;
            }
        } else {
            $userMeta = ProductMeta::where('product_id', $this->id)
                ->where('key', 'user_id')
                ->first(['value']);
            $userId = $userMeta && isset($userMeta->value) ? $userMeta->value : 0;
        }
        $result = [];
        if ($userId) {
            $key = 'cache::user::v4::' . $userId;
            $result = $this->getCache($key);
            if (!$result) {
                $columns = ['id', 'name', 'email', 'image_avatar', 'image_background', 'slug'];
                if ($userId) {
                    $user = User::where('id', $userId)->first($columns);
                } else {
                    $user = User::where('email', config('sa.default_seller_email', 'info@megaads.vn'))->first($columns);
                }
                if ($user && $user->id) {
                    $result = $user->toArray();
                } else {
                    $result = [];
                }
                $this->pushCache($key, $result);
            }
        }
        
        return $result;
    }

    public function getCache($key) {
        return isset(self::$cache[$key]) ? self::$cache[$key] : null;
    }

    public function pushCache($key, $value) {
        self::$cache[$key] = $value;
    }
}
