system.controller('ConfigDescriptionController', ConfigDescriptionController);

function ConfigDescriptionController ($scope, $rootScope, $http) {
    this.__proto__ = new PaginationController($scope, $rootScope, $http);
    $scope.types = [];
    $scope.styles = [];
    $scope.categories = [];
    $scope.data = [];
    $scope.meta = {
        page_id: 0
    };
    $scope.filterCategory = null;

    $scope.newConfig = function () {
        $scope.data.push({
            categories: [],
            types: [],
            styles: [],
            description: ''
        });
    }

    $scope.initialize = function () {
        buildTypes();
        buildStyles();
        buildCategories();

        $scope.getConfig().then(function () {
            if (!$scope.data || !$scope.data.length) {
                $scope.newConfig();
            }
        })
    }

    //hoanhlv 18-06
    $scope.addSpecification = function (index) {
        if (!$scope.data[index].configs) {
            $scope.data[index].configs = []
        }
        $scope.data[index].configs.push({
            key: '',
            value: '',
        });
    };

    $scope.configTypes = [
        {
            key: 'fabric_type',
            text: 'Fabric Type'
        },
        {
            key: 'care_instruction',
            text: 'Care Instructions'

        },
        {
            key: 'closure_type',
            text: 'Closure Type'
        }
    ];

    $scope.removeSpecification = function (index, key) {
        $scope.data[index].configs.splice(key, 1);
    };

    $scope.checkSelectedType = function (parentIndex, index, selectedType) {
        var selectedCount = 0;
        angular.forEach($scope.data[parentIndex].configs, function (config, idx) {
            if (config.key === selectedType) {
                selectedCount++;
            }
        });

        if (selectedCount > 1) {
            toastr.error('Mỗi loại cấu hình chỉ được chọn 1 lần. Vui lòng chọn loại cấu hình khác');
            $scope.data[parentIndex].configs[index].key = ''
        }
    };
    //end hoanhlv 18-06

    $scope.getConfig = function () {
        $scope.data = [];

        let categoryQuery='&embeds=specification';
        if ($scope.filterCategory) {
            categoryQuery += ',configDescriptionCategory&filters=configDescriptionCategory.category_id=' + $scope.filterCategory;
        }


        return $http({
            method: 'GET',
            url: $scope.buildUrl('/config_description_product_description?page_size=20&page_id=' + $scope.meta.page_id + categoryQuery)
        }).then(function success(response) {
            if (response.data.status === 'successful' && response.data.result.length > 0) {
                $scope.meta = response.data.meta;
                let items = response.data.result;
                for (let item of items) {
                    item.categories = item.categories ? $scope.safeDecode(item.categories) : [];
                    item.types = item.types ? $scope.safeDecode(item.types) : [];
                    item.styles = item.styles ? $scope.safeDecode(item.styles) : [];
                    item.configs = []
                    if (item.specification.length > 0) {
                        for (let val of item.specification) {
                            let dataSpecification = {
                                key: val.key,
                                value: val.value
                            }
                            item.configs.push(dataSpecification)
                        }
                    }

                    $scope.data.push(item);
                }
            }
        });
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.getConfig();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.getConfig();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.getConfig();
        }
    };

    $scope.safeDecode = function (value, defaultValue = []) {
        try {
            return JSON.parse(value);
        } catch (error) {
            return defaultValue;
        }
    }

    function buildTypes() {
        $http({
            method: 'GET',
            url: base_api_url + '/product_variant_option?page_size=-1&filters=variant_id=5&sorts=name'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.types = response.data.result;
            }
        });
    }

    function buildStyles() {
        $http({
            method: 'GET',
            url: base_api_url + '/product_variant_option?page_size=-1&filters=variant_id=7&sorts=name'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.styles = response.data.result;
            }
        });
    }

    function buildCategories() {
        $http({
            method: 'GET',
            url: base_api_url + '/categories?page_size=1000&type=PRODUCT'
        }).then(function success(response){
            if (response.data.status == 'successful' && response.data.result.length > 0) {
                $scope.categories = response.data.result;
            }
        });
    }

    $scope.changeFilterCategory = () => {
        // console.log($scope.filterCategory)
        $scope.getConfig();
    }

    $scope.remove = function ($index) 
    {
        $scope.callConfirmModal({
            text: 'xoá cấu hình mô tả sản phẩm',
            title: 'xoá cấu hình mô tả sản phẩm',
        }, function () {

            const item = $scope.data[$index];

            if (!item.id) {
                $scope.data.splice($index, 1);
                safeApply();
                return 1;
            }

            $http.delete($scope.buildUrl('/config_description_product_description/' + item.id))
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Xoá cấu hình mô tả sản phẩm thành công');
                        $scope.data.splice($index, 1);
                        safeApply();
                    } else {
                        toastr.error('Xoá cấu hình mô tả sản phẩm thất bại');
                    }
                }, function () {
                    toastr.error('Xoá cấu hình mô tả sản phẩm thất bại');
                });
        })
    }
    
    function validate (item) {
        let retVal = true;
        if (!item.description) {
            toastr.error('Vui lòng không bỏ trống mô tả');
            retVal = false;
        } else {
            check = !item.categories || !item.categories.length;
            if (check) {
                toastr.error('Vui lòng không bỏ trống danh mục');
                retVal = false;
            }
        }

        if (item.configs) {
            for (const val of item.configs) {
                if (val.type === '' || val.value === '') {
                    toastr.error('Vui lòng nhập đủ thông tin cấu hình');
                    retVal = false;
                    break;
                }
            }
        }

        return retVal;
    }

    $scope.save = function (item) {
        if (validate(item)) {
            $http.post('/module/description/save-config', item)
                .then(function success(response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Cấu hình mô tả thành công');
                    } else {
                        toastr.error('Cấu hình mô tả thất bại');
                    }
                }, function () {
                    toastr.error('Cấu hình mô tả thất bại');
                });
        }
    }

    function safeApply() {
        if ($scope.$root.$$phase !== '$apply' && $scope.$root.$$phase !== '$digest') {
            $scope.$apply();
        }
    }

    $scope.initialize();
}

system.directive('ckEditor419', function () {
    return {
        require: '?ngModel',
        link: function (scope, elm, attr, ngModel) {
            const version = 2;
            var ck = CKEDITOR.replace(elm[0], {
                language: 'vi',
                removePlugins : 'resize,exportpdf',
                filebrowserUploadUrl: googleCloudStorageBucket + '/upload?' + (attr['uploadType'] ? 'type=' + attr['uploadType'] : ''),
                height: attr['height'] ? attr['height'] : 200,
                allowedContent: true,
                extraPlugins: 'simplebox'
            });
            ck.on( 'fileUploadResponse', function( evt ) {
                evt.stop();
                var data = evt.data,
                    xhr = data.fileLoader.xhr,
                    response = xhr.responseText;
                if (response) {
                    response = JSON.parse(response);
                    if (response.upload && response.upload[0]) {
                        data.url = response.upload[0];
                    }
                }
            } );
            if (!ngModel) return;
            ck.on('instanceReady', function () {
                ck.setData(ngModel.$viewValue);
            });
            function updateModel() {
                ngModel.$setViewValue(ck.getData());
            }
            ck.on('change', updateModel);
            ck.on('key', updateModel);
            ck.on('dataReady', updateModel);

            ngModel.$render = function (value) {
                ck.setData(ngModel.$viewValue);
            };

            //set version js file
            CKEDITOR.timestamp = version;
        }
    };
});