system.controller('ImportController', ImportController);

function ImportController ($scope, $rootScope, $http) {
    $scope.products = [];
    $scope.saving = false;

    $scope.loadFile = async function ($files) {
        if (!$files || !$files.length) {
            return;
        }
        $scope.$applyAsync(() => {
            $scope.saving = true;
        })
        const file = $files[0];
        var reader = new FileReader();
        $scope.products = await new Promise((resolve, reject) => {
            let fileExt = $scope.getFileExtension(file.name);
            reader.onload = function(e) {
                let content = e.target.result;
                let products = $scope.processData(content, fileExt);
                resolve(products);
            };
            if (fileExt == 'csv') {
                reader.readAsText(file);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                reader.readAsBinaryString(file);
            }
        });
        $scope.$applyAsync(function () {
            $scope.saving = false;
        })
    }

    $scope.getFileExtension = (filename) => {
        var ext = /^.+\.([^.]+)$/.exec(filename);
        return ext == null ? "" : ext[1];
    }

    $scope.processData = (content, fileExt) => {
        let objects = [];
        try {
            if (fileExt == 'csv') {
                objects = $.csv.toObjects(content);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                let workbook = XLSX.read(content, {
                    type: 'binary'
                });
                workbook.SheetNames.forEach(sheet => {
                    let arrayObject = XLSX.utils.sheet_to_row_object_array(
                        workbook.Sheets[sheet]
                    );
                    objects = objects.concat(arrayObject);
                });
            }
        } catch (ex) {
            console.log(ex);
            $scope.showErrorModal('Không thể đọc được file.');
        }
        
        return objects;
    }

    $scope.update = async () => {
        $scope.saving = true;
        let itemsByLocale = {};
        for (let item of $scope.products) {
            let locale = item['locale'].toLowerCase();
            if (locale == 'br') {
                locale = 'uk';
            }
            if (!itemsByLocale[locale]) {
                itemsByLocale[locale] = [];
            }
            itemsByLocale[locale].push(item);
        }

        let siteUrl = window.location.origin;
        let promises = [];
        for (let locale in itemsByLocale) {
            let apiUrl = base_api_url.replace(/(\w+|)(\.|)api/, `${locale}.api`);
            let chunks = $scope.arrayChunks(itemsByLocale[locale], 50);
            for (let chunk of chunks) {
                let promise = $http.post(`${apiUrl}/product/bulk-update-content?ignore_localization=1&service_token=megaads@123`, {
                    products: chunk
                });
    
                promises.push(promise);
            }
        }

        await Promise.all(promises).then(res => {
            $scope.$applyAsync(function () {
                $scope.saving = false;
            })
            toastr.success('Cập nhật thành công');
        }).catch(err => {
            toastr.error('Đã có lỗi xảy ra');
        })
    }

    $scope.arrayChunks = (array, size = 100) => {
        let chunks = [];
        for (let i = 0; i < array.length; i++) {
            let chunk = [];
            let j = i;
            let limit = i + size;
            for (j = i; j < array.length && j < limit; j++) {
                chunk.push(array[j]);
            }
            i = j - 1;
            chunks.push(chunk);
        }
        
        return chunks;
    }
}