let descriptionData = {
    product_id: $('#productId').val(),
    spid: null,
    categoryId: $('#js-category-id').val(),
    featureTagId: $('#feature-tag-id').val()
};

function moreLessContent() {
    $('.product-detail-description').css('visibility', 'visible');
    $('.product-detail-content').css('height', '');
    if ($('#js-product-content').is(':visible') == true) {
        var productContent = $('.product-detail-description').height();
        if (productContent > 135) {
            $('.product-more-content').css('visibility', 'visible');
            if (!$('.product-detail-content').hasClass('extra-content')) {
                $('.product-detail-content').addClass('product-content-effect');
            }
            $('.product-more-content, .product-content-fade-out').css({
                'display': 'flex',
                'position': 'relative'
            });
        } else {
            $('.product-detail-content').removeClass('product-content-effect')
            $('.product-more-content').css('display', 'none');
        }
    }
}

window.matchMedia("(orientation: portrait)").addEventListener("change", function(e) {
    moreLessContent();
});

window.addEventListener('variantChanged', function(event) {

    /* const variantIds = {
        STYLE: 7, TYPE: 5
    }
    let typeId = null, styleId = null; // style 7, type 5
    
    for (let i = 0; i < event.detail.variants.length; i++) {
        const variant = event.detail.variants[i];
        if (variant.variant_id == variantIds.STYLE) styleId = variant.id;
        if (variant.variant_id == variantIds.TYPE) typeId = variant.id;
    } */

    if (descriptionData.spid != event.detail.id) {
        descriptionData = {
            product_id: $('#productId').val(),
            spid: event.detail.id,
            categoryId: $('#js-category-id').val(),
            featureTagId: $('#feature-tag-id').val(),
            variant_default_sku: event.detail.sku
        }
    
        loadDescriptionV2(descriptionData);
    }

});

let autoloadDescription = setTimeout(() => {
    loadDescriptionV2(descriptionData);
}, 15000);

window.addEventListener('tagsLoaded', function(event) {
    clearTimeout(autoloadDescription);
    window.product.tags = event.detail;
    loadDescriptionV2(descriptionData);
});

function loadDescriptionV2(data) 
{
    let url = new URLSearchParams(window.location.search);
    if (url.get('clear_cache')) {
        data.clear_cache = 1;
    }

    clearTimeout(autoloadDescription);

    if (!descriptionData.spid) return;

    const productDetailDescriptionSelector = $('.product-detail-description');
    // const product = window.product;
    const oldDescription = productDetailDescriptionSelector.html();

    $.ajax({
        url: `/module/get-description`,
        method: 'get',
        data: data
    }).done(function (response) {
        $('#js-product-content').removeClass('hidden');
        if (response.status === 'successful' && response.result) {

            $('.product-detail-description').html(response.result);

            moreLessContent();

        } else {
            $('.product-detail-description').html(oldDescription);
            moreLessContent();
        }

        applyShortCode();

    }).catch(function () {
        $('#js-product-content').removeClass('hidden');
        $('.product-detail-description').html(oldDescription);
        moreLessContent();
    })
}

function applyShortCode()
{
    let spId = getParameterByName("spid");

    if (!spId || typeof window.globalVariants !== 'object') {
        return;
    }

    let foundVariant = window.globalVariants.productVariants.find(function(variant) {
        return parseInt(variant.id) === parseInt(spId);
    });

    if (foundVariant) {
        let descriptionElement = $('.product-detail-description');
        let variantOptions = foundVariant.variants;
        let map = {};
        let mapIds = {
            'product_id': foundVariant.product_id
        };

        for (let i = 0; i < variantOptions.length; i++) {
            map[variantOptions[i].variant_slug] = variantOptions[i].name;
            mapIds[variantOptions[i].variant_slug + '_id'] = variantOptions[i].id;
        }

        let shortCodeVariantKey = {
            '{variant_color}': 'color',
            '{variant_type}': 'type',
            '{variant_style}': 'style',
            '{variant_size}': 'size'
        };

        descriptionElement.find('span.short-code-content').each(function() {
            for (const key in shortCodeVariantKey) {
                let elementShortKey = $(this).data('short-code');
                if (elementShortKey === key) {
                    $(this).text(map[shortCodeVariantKey[key]]);
                }
            }

            if ($(this).data('short-code') === '{variant_price}') {
                $(this).text(foundVariant.display_price);
            }

            if ($(this).data('short-code') === '{option_description}') {
                loadConfiguredDescription(mapIds, function(response) {
                    if (response.status === 'successful') {
                        let textDescription = response.result.option_description;
                        if (!textDescription && response.result.description) {
                            textDescription = response.result.description;
                        }
                        $(this).html(textDescription);
                    }
                }.bind(this));
            }

            setTimeout(function() {
                moreLessContent();
            }, 300);

        });
    }
}

function loadConfiguredDescription(mapIds, callback) {
    let locale = '';
    if (typeof window.localePrefix !== 'undefined' && window.localePrefix !== '') {
        locale = '/' + window.localePrefix;
    }

    let url = locale + '/module/get-configured-description';
    const params = new URLSearchParams(mapIds);

    let xhr = new XMLHttpRequest();
    xhr.open('GET', url + '?' + params.toString(), true);
    xhr.responseType = 'json';

    xhr.onload = () => {
        let status = xhr.status;
        if (status === 200) {
            callback(xhr.response);
        }
    };

    xhr.send();
}
