system.controller('ProductDescriptionTagController', ProductDescriptionTagController);

function ProductDescriptionTagController ($scope, $rootScope, $http)
{
    $scope.baseController = this.__proto__ = new BaseController($scope, $http, $rootScope);

    const baseApi = window.base_api_url;
    const prefixLocaleUrl = window.prefixLocaleUrl

    $scope.tags = [];
    $scope.paginationState = {
        current_page: 1,
        number_page: 1,
        limit: 50,
        search: ''
    };
    $scope.tagDescriptions = [];
    $scope.currentTag = null;
    $scope.states = {
        isLoading: true
    }

    /* Scope methods */

    $scope.initialize = function () {

        fetchTags(function() {
            $scope.states.isLoading = false;
        });

    }

    $scope.fetchTags = function(reset = false) {
        if (reset) {
            $scope.paginationState.current_page = 1;
        }
        fetchTags();
    }

    $scope.openTagConfigDescription = function(tag) {
        // show view
        $scope.baseController.openDialogModal('#modalTagDescriptions');

        // load tag description data
        $scope.currentTag = tag;
        $scope.tagDescriptions = [];
        fetchTagDescriptions(tag.id);

    }

    $scope.createNewTagDescription = createTagDescription;

    $scope.updateDescription = function(tagDescription) {
        updateTagDescription([tagDescription]);
    }

    $scope.deleteDescription = function(tagDescription) {
        const param = {
            title: 'Xóa mô tả',
            customText: 'xác nhận xóa mô tả này!',
            confirmButtonText: 'Ok',
            cancelButtonText: 'Hủy',
            arg: {tagDescription}
        };

        $scope.callConfirmModal(param, async function (arg) {
            deleteDescription(tagDescription);
        });
    }

    $scope.range = function (min, max, step) {
        step = step || 1;
        let input = [];
        for (let i = min; i <= max; i += step) {
            input.push(i);
        }
        return input;
    };

    /* Functions */

    function fetchTagDescriptions(tagId) {
        $scope.states.isLoading = true;
        let searchParams = {
            filters: 'tag_id=' + tagId,
            sorts: '-id',
            page_size: '-1'
        }

        let queryString = new URLSearchParams(searchParams);

        $http({
            method: 'GET',
            url: baseApi + '/config_description_tag_description?' + queryString
        }).then(function success(response) {
            $scope.states.isLoading = false;
            if (response.data.status === "successful") {
                $scope.tagDescriptions = response.data.result
            }
        });
    }

    function fetchTags(callback = null)
    {
        let searchParams = {
            scopes: 'search(keyword=' + $scope.paginationState.search + ')',
            sorts: '-id',
            page_size: $scope.paginationState.limit.toString(),
            page_id: $scope.paginationState.current_page - 1
        }

        let queryString = new URLSearchParams(searchParams);

        $http({
            method: 'GET',
            url: baseApi + '/tag?' + queryString
        }).then(function success(response) {
            if (response.data.status === "successful") {
                $scope.tags = response.data.result;
                buildPaginationData(response.data.meta);
            }
            if (callback) callback(response);
        }).catch(function(err) {
            if (callback) callback(err);
        });
    }

    function updateTagDescription(descriptions)
    {
        $scope.states.isLoading = true;
        $http({
            method: 'POST',
            url: prefixLocaleUrl + 'module/config-description/tag-description/update',
            data: {
                descriptions
            }
        }).then(function success(response) {
            $scope.states.isLoading = false;
            if (response.data.status === "successful") {
                for (let i = 0; i < descriptions.length; i++) {
                    applyDescriptionProduct(descriptions[i]);
                }
            }
        }).catch(function() {
            $scope.states.isLoading = false;
        });
    }

    function createTagDescription(tagId)
    {
        $scope.states.isLoading = true;
        $http({
            method: 'POST',
            url: baseApi + '/config_description_tag_description',
            data: {
                tag_id: tagId
            }
        }).then(function (response) {
            $scope.states.isLoading = false;
            if (response.data.status === "successful") {
                applyDescriptionProduct(response.data.result);
            }
        }).catch(function() {
            $scope.states.isLoading = false;
        });
    }

    function applyDescriptionProduct(tagDescription)
    {
        $scope.states.isLoading = true;
        $http({
            method: 'GET',
            url: prefixLocaleUrl + 'module/config-description/tag-description/apply-product?tag_description_id=' + tagDescription.id
        }).then(function (response) {
            $scope.states.isLoading = false;
            if (response.data.status === "successful") {
                fetchTagDescriptions(tagDescription.tag_id);
            }
        }).catch(function() {
            $scope.states.isLoading = false;
        });
    }

    function buildPaginationData(metaData) {
        $scope.paginationState.number_page = metaData.page_count;
        $scope.paginationState.total_count = metaData.total_count;
        $scope.paginationState.has_next = metaData.has_next;
    }

    function deleteDescription(description) {
        $scope.states.isLoading = true;
        $http({
            method: 'DELETE',
            url: prefixLocaleUrl + 'module/config-description/tag-description/delete?id=' + description.id,
        }).then(function (response) {
            $scope.states.isLoading = false;
            if (response.data.status === "successful") {
                console.log(response.data)
                fetchTagDescriptions(description.tag_id);
            }
        }).catch(function() {
            $scope.states.isLoading = false;
        });
    }

    $scope.initialize();
}