@extends('system.layout.main', [
'ngController' => 'ConfigDescriptionController'
])
@section('title')
    <title>Cấu hình mô tả sản phẩm</title>
@endsection
@section('css')
    <style media="screen">
        hr {
            border-top: 1px solid #ccc;
        }
        .chosen-container-single, .chosen-container-multi {
            width: 100%!important;
        }
        .chosen-choices {
            padding: 4px !important;
            line-height: 27px !important;
        }
        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }
        .product-success thead tr td {
            font-weight: bold;
        }

        .col-sm-12:not(:first-child) {
            border-top: 1px solid #dedede;
            padding-top: 10px;
        }

        .d-flex-center {
            display: flex;
            justify-content: center;
            align-items: center;
            vertical-align: middle;
        }
        .config-control {
            display: flex;
            justify-content: center;
            align-items: center;
            vertical-align: middle;
        }

        .btn-save {
            margin-right: 20px;
        }

        .content {
            margin-bottom: 70px;
        }
    </style>
    <link rel="stylesheet" href="/system/css/chosen.min.css">
@endsection
@section('script')
    <script src="<?= Module::asset('config-description/js/config-description-controller.js') ?>?v={{ config('app.version') }}" charset="utf-8"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v={{ config('app.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/ckeditor/ckeditor.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/system/js/scripts/angular-chosen.min.js?v="></script>
@endsection
@section('content')
    <div class="content" ng-cloak>
        <div class="header">
            <h3>Cấu hình mô tả sản phẩm</h3>
            <form>
                <div class="form-group" style="width: 350px; display: block">
                    Lọc theo danh mục: 
                    <select chosen class="form-control chosen-select"
                        ng-model="filterCategory"
                        ng-change="changeFilterCategory()"
                        ng-options="category.id as category.name for category in categories">
                        <option value="">-- Tất cả danh mục --</option>
                    </select>
                </div>
            </form>
        </div>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div class="box-bg-white">
                        <div class="col-sm-12 d-flex-center" ng-repeat="item in data track by $index">
                            <div class="col-sm-4">
                                <div class="form-group">
                                    <label for="">Danh mục: </label>
                                    <select class="form-control chosen-select"
                                            multiple
                                            chosen
                                            ng-model="item.categories"
                                            ng-options="category.id as category.name for category in categories">
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="">Type: </label>
                                    <select class="form-control chosen-select"
                                            multiple
                                            chosen
                                            ng-model="item.types"
                                            ng-options="type.id as type.name for type in types">
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="">Style: </label>
                                    <select class="form-control chosen-select"
                                            multiple
                                            chosen
                                            ng-model="item.styles"
                                            ng-options="style.id as style.name for style in styles">
                                    </select>
                                </div>
                            </div>
                            <div class="col-sm-7" style="padding: 0">
                                <div class="form-group">
                                    <label for="">Mô tả: </label>
                                    <textarea ck-editor-419 ng-model="item.description" rows="9" class="form-control"></textarea>
                                </div>
                                <div ng-repeat="config in item.configs track by $index" class="form-group">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="selectType@{{$index}}">Loại cấu hình:</label>
                                                <select id="selectType@{{$index}}" class="form-control"
                                                        ng-model="config.key"
                                                        ng-change="checkSelectedType($parent.$index, $index, config.key)"
                                                        ng-options="type.key as type.text for type in configTypes">
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <label for="inputValue@{{$index}}">Giá trị:</label>
                                                <input id="inputValue@{{$index}}" type="text" class="form-control"
                                                       ng-model="config.value">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <button type="button" class="btn btn-danger"
                                                        ng-click="removeSpecification($parent.$index, $index)"
                                                        style="margin-top: 2.4rem">
                                                    <i class="fa fa-close"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <button type="button" name="button" class="btn btn-primary btn-add-config"
                                            ng-click="addSpecification($index)" ng-show="!item.configs || item.configs.length <3 ">
                                        <i class="fa fa-plus"></i> Thêm cấu hình
                                    </button>
                                </div>
                            </div>
                            <div class="col-sm-1 config-control">
                                <button type="button" name="button" class="btn btn-success btn-save"
                                        ng-click="save(item)">
                                    <i class="fa fa-save"></i>
                                </button>
                                <button class="btn btn-danger" ng-click="remove($index)">
                                    <i class="fa fa-close"></i>
                                </button>
                            </div>
                        </div>
                        <div class="col-sm-offset-5">
                            <button id="add-size" type="button" name="button" class="btn btn-primary add" ng-click="newConfig()"><i class="fa fa-plus"></i> Thêm mô tả</button>
                        </div>
                    </div>
                </div>
                <div class="box-footer clearfix">
                    @include('system.pagination')
                </div>
            </div>
        </div>
    </div>
@endsection
