@extends('system.layout.main', [
    'ngController' => 'ProductDescriptionTagController'
])
@section('title')
    <title>Cấu hình mô tả Tag</title>
@endsection
@section('css')
    <style media="screen">

    </style>
@endsection
@section('script')
    <script src="<?= Module::asset('config-description/js/product-description-tag-controller.js') ?>?v={{ config('app.version') }}" charset="utf-8"></script>
@endsection
@section('content')

    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Cấu hình mô tả Tag</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>

        <br>

        <div class="filters row">
            <div class="col-md-3">
                <div class="input-group">
                    <input ng-keyup="$event.keyCode === 13 && fetchTags(true)" ng-model="paginationState.search" type="text" class="form-control" placeholder="Nhập tên tag">
                    <div class="input-group-btn">
                        <button type="button" class="btn btn-default " ng-click="fetchTags(true)" style="border-width: 2px 2px 2px 1px;">
                            <i class="fa fa-search"></i>
                            Tìm kiếm
                        </button>
                    </div>
                </div>

            </div>
        </div>

        <br>

        <div class="body" ng-show="!states.isLoading">
            <div class="box no-border">
                <table class="table box-body">
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th class="text-center">#</th>
                    </tr>

                    <tr ng-repeat="tag in tags">
                        <td>@{{ tag.id }}</td>
                        <td>@{{ tag.title }}</td>
                        <td class="text-center">
                            <button ng-click="openTagConfigDescription(tag)" class="btn btn-sm btn-primary">Cấu hình</button>
                        </td>
                    </tr>

                </table>

                <div class="box-footer clearfix" ng-if="paginationState.number_page > 1">
                    <ul class="pagination pull-right" style="margin: 0">
                        <li ng-repeat="n in range(paginationState.current_page - 4, paginationState.current_page - 1)"
                            ng-if="n > 0" class="page-item">
                            <a ng-click="paginationState.current_page = n; fetchTags();" class="page-link"
                               href="#">@{{ n }}</a>
                        </li>
                        <li class="page-item active">
                            <a href="#">@{{ paginationState.current_page }}</a>
                        </li>
                        <li ng-repeat="n in range(paginationState.current_page + 1, paginationState.current_page + 4)"
                            ng-if="n <= paginationState.number_page" class="page-item">
                            <a ng-click="paginationState.current_page = n; fetchTags();" class="page-link"
                               href="#">@{{ n }}</a>
                        </li>
                    </ul>
                </div>

            </div>
        </div>

        <span ng-if="states.isLoading">Đang tải...</span>

    </div>

    @include('config-description::system.includes.tag-description-modal')

@endsection
