<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'module/description', 'middleware' => array_merge(config('app.system_auth_middleware', []), ['system'])], function () {

    Route::get('/', [
        'as' => 'config-description::home',
        'uses' => 'HomeController@index',
    ]);

    Route::get('tag-description', [
        'uses' => 'TagDescriptionController@index',
    ]);

    Route::get('async-get-config', 'HomeController@asyncGetConfig');
    Route::post('save-config', 'HomeController@saveConfig');
});

Route::get('/module/rebuild-description', 'RebuildController@rebuild');
Route::get('/module/rebuild-description-v2', 'RebuildController@rebuildV2');

Route::get('/module/get-description', [
    'as' => 'config-description::getDescription',
    'uses' => 'HomeController@getDescription',
]);
Route::get('/product/get-description', [
    'as' => 'config-description-product::getDescription',
    'uses' => 'HomeController@getDescription',
]);


Route::get('/module/get-style-info', [
    'uses' => 'HomeController@getStyleInfo',
]);

Route::get('/module/get-configured-description', [
    'uses' => 'HomeController@httpGetConfiguredDescription',
]);

Route::get('/module/get-variant-description', [
    'as' => 'config-description::getVariantDescription',
    'uses' => 'HomeController@getVariantDescription',
]);

Route::get('/module/build-product-desciption', [
    'uses' => 'ProductDescriptionController@build',
]);

Route::get('/module/cron-build-product-description', [
    'uses' => 'ProductDescriptionController@cronBuild',
]);

Route::get('/module/description/import', [
    'uses' => 'ImportController@index',
]);