<?php

Module::onVariable('system.menu', function (&$menu) {
    $locale = env('APP_LOCALE', '');
    if ($locale !== '') {
        $locale = '/' . $locale;
    }
    foreach ($menu as &$item) {
        if ($item['url'] == '/admin/products' && isset($item['children'])) {
            $item['children'][] = [
                'icon' => '',
                'title' => 'Cấu hình mô tả sản phẩm',
                'url' => $locale . '/module/description',
            ];
            $item['children'][] = [
                'icon' => '',
                'title' => 'Cấu hình mô tả theo tag',
                'url' => $locale . '/module/description/tag-description',
            ];
            $item['children'][] = [
                'icon' => '',
                'title' => 'Import mô tả sản phẩm',
                'url' => $locale . '/module/description/import',
            ];
            break;
        }
    }
    return $menu;
});

Module::onView('product.anglular_modules_libraries', function ($data) {
    return view('config-description::load-description-script', [
        'product' => $data['product']
    ]);
});

Module::onVariable('display_product_data', function (&$productData) {
    return app()->call('Modules\ConfigDescription\Controllers\HomeController@displayDescription', [&$productData]);
}, 10);