<?php

namespace Modules\CrawlProduct\Controllers\AutoCrawl;

use DB;
use Modules\CrawlProduct\Controllers\Controller;

class BaseAutoCrawlController extends Controller {
    public function getDirection($variants) {
        foreach ($variants as $variant) {
            if ($variant['slug'] == 'size' && count($variant['options'])) {
                foreach ($variant['options'] as $option) {
                    $name = preg_replace("/[^\d\.x\\/\-]/", "", $option['name']);
                    preg_match("/([\d\.]+)\s*x\s*([\d\.]+)/", $name, $matches);
                    if (count($matches) > 2) {
                        $width = doubleval($matches[1]);
                        $height = doubleval($matches[2]);
                        if ($width == $height) {
                            return 'square';
                        }
                        
                        if ($width < $height) {
                            if ($width / $height <= 0.6) {
                                return 'vertical-long';
                            }

                            return 'vertical';
                        } else {
                            if ($height / $width <= 0.6) {
                                return 'horizontal-long';
                            }

                            return 'horizontal';
                        }
                    }
                    break;
                }
            }
        }

        return null;
    }

    public function getTemplateByDirection($categoryIds, $direction) {
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        foreach ($categoryIds as $categoryId) {
            if (config('crawl-product::template.template_by_direction.' . $locale . '.' . $categoryId . '.' . $direction, false)) {
                return config('crawl-product::template.template_by_direction.' . $locale . '.' . $categoryId . '.' . $direction, false);
                break;
            }
        }
    }

    public function getTemplate($categoryIds, $direction = null) {
        $template = null;
        if ($direction) {
            $templateId = $this->getTemplateByDirection($categoryIds, $direction);
            if ($templateId) {
                $template = DB::table('product_template')->where('id', $templateId)->first();
            }
        }
        if (!$template) {
            $defaultProductId = $this->getDefaultProductId($categoryIds);
            if ($defaultProductId) {
                $template = $this->getTemplateByProductId($defaultProductId);
            }
        }

        return $template;
    }

    public function getTemplateByProductId($defaultProductId) {
        return DB::table('product_template')->where('product_id_fake', $defaultProductId)->first();
    }

    public function getDefaultProductId($categories) {
        $locale = env('APP_LOCALE', 'us');
        $locale = $locale ? $locale : 'us';
        $defaultProductId = null;
        if (count($categories)) {
            $config = \DB::table('crawl_product_default_product')->whereIn('category_id', $categories)->first();
            if ($config) {
                $defaultProductId = $config->product_id;
            }
            if (!$defaultProductId) {
                foreach ($categories as $categoryId) {
                    $id = config('crawl-product::default.product_template.' . $locale . '.' . $categoryId);
                    if ($id) {
                        $defaultProductId = $id;
                        break;
                    }
                }
            }
        }

        return $defaultProductId;
    }
}