<?php

namespace Modules\CrawlProduct\Controllers\AutoCrawl;

use DB;
use Illuminate\Http\Request;
use App\Helpers\ApiClient;
use Modules\Pod\Models\User;
use Modules\CrawlProduct\Models\Tag;
use Illuminate\Support\Facades\Input;
use Modules\CrawlProduct\Models\Brand;
use Modules\CrawlProduct\Models\Category;
use Modules\CrawlProduct\Models\ProductMeta;
use Modules\CrawlProduct\Models\ProductNUser;
use Modules\CrawlProduct\Controllers\Controller;
use Modules\CrawlProduct\Controllers\Impl\ProductCreation;
use App\Modules\CrawlProduct\Controllers\Services\EtsyService;
use Modules\CrawlProduct\Controllers\Impl\ProductUseTemplateCreation;

class CrawlController extends BaseAutoCrawlController {
    protected $productCreation;
    protected $productUseTemplateCreation;

    public function __construct(ProductCreation $productCreation, ProductUseTemplateCreation $productUseTemplateCreation) {
        $this->productCreation = $productCreation;
        $this->productUseTemplateCreation = $productUseTemplateCreation;
    }

    public function simpleCrawl(Request $request) {
        ini_set('memory_limit', '2048M');
        set_time_limit(5 * 60);

        $retVal = [
            'status' => 'fail',
            'message' => ''
        ];
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        try {
            if (!$request->get('category_id') && !$request->get('category_slug') && !$request->get('categories')) {
                $retVal['message'] = 'category_id or category_slug or categories is required';
                return $retVal;
            }
            $data = $this->buildData($request->all());
            $categoryIds = [];
            if ($request->get('category_id') && $request->get('category_id') != null) {
                $category = Category::where('id', $request->get('category_id'))
                    ->where('type', 'PRODUCT')
                    ->where('is_hidden', 0)
                    ->first(['id', 'name', 'slug']);
                if (!$category) {
                    $retVal['message'] = 'can not get category';
                    return $retVal;
                }
                $categoryIds = [$category->id];
            } else if ($request->get('category_slug')) {
                $category = Category::where('slug', $request->get('category_slug'))
                    ->where('type', 'PRODUCT')
                    ->where('is_hidden', 0)
                    ->first(['id', 'name', 'slug']);
                if (!$category) {
                    $retVal['message'] = 'can not get category';
                    return $retVal;
                }
                $categoryIds = [$category->id];
            } else {
                $cateNames = $request->get('categories');
                $categoryIds = $this->buildCategoryIds($cateNames);
            }
            
            $tags = $this->getTags($data);
            if (!empty($data['name'])) {
                $newRequest = new Request();
                $newRequest->merge([
                    'brand_id' => $request->get('brand_id', 1),
                    'country_code' => $locale,
                    'remove_size_chart' => false,
                    'generate_variant' => $request->get('generate_variant', 1),
                    'tags' => $tags,
                    'approve_advertising' => 0,
                    'categories' => implode(",", $categoryIds),
                ]);

                if ($request->has('is_overwrite_product')) {
                    $newRequest->merge(['is_overwrite_product' => 1]);
                }
                $data['force_status'] =  $request->get('force_status', 'ACTIVE');
                $data['is_download_image'] = $request->get('is_download_image', false);
                if (isset($data['design_crawl_code'])) {
                    $pdc = DB::table('product_design_crawl_code')->where('value', $data['design_crawl_code'])->first();
                    if ($pdc) {
                        $pnu = ProductNUser::where('product_id', $pdc->product_id)->first();
                        if ($pnu) {
                            $data['user_id'] = $pnu->user_id;
                        } else {
                            $data['user_id'] = $this->getRandomSellerId();
                        }
                    } else {
                        $data['user_id'] = $this->getRandomSellerId();
                    }
                } else {
                    $data['user_id'] = $this->getRandomSellerId();
                }
                if ($request->get('generate_variant', 1)) {
                    $template = $this->getTemplate($categoryIds, $data['direction']);
                }
                if ($request->get('original_product_id')) {
                    $data['metas'] = [
                        [
                            'key' => 'original_related_product_id',
                            'value' => $request->get('original_product_id')
                        ]
                    ];
                }
                if (!empty($template)) {
                    $data['template'] = $template;
                    $response = $this->productUseTemplateCreation->saveCrawlProduct($newRequest, $data);
                } else {
                    $response = $this->productCreation->saveCrawlProduct($newRequest, $data);
                    $dataReturn = [
                        'id' => $response['result']->id,
                        'name' => $response['result']->name,
                        'image_url' => $response['result']->image_url,
                        'price' => $response['result']->price,
                        'high_price' => $response['result']->high_price,
                        'sku' => $response['result']->sku,
                        'price' => $response['result']->price,
                        'slug' => $response['result']->slug,
                    ];
                    
                }
                if (isset($response['status']) && $response['status'] == 'successful') {
                    $retVal['status'] = 'successful';
                    $retVal['result'] = $response['result'];
                } else if (isset($response['status']) && $response['status'] == 'duplicate') {
                    $retVal['status'] = 'duplicate';
                } else {
                    $retVal['status'] = 'fail';
                    $retVal['message'] = $response;
                }

                if(isset($dataReturn)) {
                    return $dataReturn;
                }
            } else {
                $retVal['status'] = 'fail';
                $message = 'cannot get product name';
                $retVal['message'] = $message;
            }
        } catch (\Exception $ex) {
            $message = $ex->getMessage() . ' File: ' . $ex->getFile() . ' Line: ' . $ex->getLine();
            $retVal['status'] = 'fail';
            $retVal['message'] = $message;
        }

        return $retVal;
    }

    public function getRandomSellerId() {
        $user = User::where('role', 'SELLER')->where('status', 'ACTIVE')->whereNull('seller_token')->inRandomOrder()->first();
        if ($user) {
            return $user->id;
        }

        return 1;
    }

    public function buildCategoryIds($cateNames) {
        $categoryIds = [];
        $parentId = null;
        foreach ($cateNames as $name) {
            $slug = strToSlug($name);
            $category = Category::where('slug', $slug)
                ->where('is_hidden', 0)
                ->first();
            if (!$category) {
                $category = $this->storeCategory([
                    'name' => $name,
                    'slug' => $slug,
                    'parent_id' => $parentId ? $parentId : null,
                    'type' => 'PRODUCT'
                ]);
                if (!empty($category['id'])) {
                    $parentId = $category['id'];
                    $categoryIds[] = $category['id'];
                }
            } else {
                $category = json_decode(json_encode($category), true);
                $parentId = $category['id'];
                $categoryIds[] = $category['id'];
            }
        }

        return $categoryIds;
    }

    public function storeCategory($data) {
        $retVal = null;
        $data['is_display_home_page'] = 0;
        $result = ApiClient::buildCustomRequest("/category?service_token=megaads@123", 'POST', $data, [
            "Content-Type: application/json",
        ]);

        if ($result && isset($result['status']) && $result['status'] == 'successful') {
            $retVal = $result['result'];
        }

        return $retVal;
    }

    public function buildData($input) {
        $parseUrl = parse_url($input['url']);
        $gallery = isset($input['gallery']) ? $input['gallery'] : $input['galleries'];
        $imageUrl = $gallery[0];
        array_shift($gallery);

        $retVal = [
            'name'  => $input['name'],
            'slug' => strToSlug($input['name']),
            'description'  => '',
            'content'  => '',
            'image_url'  => $imageUrl,
            'galleries'  => $gallery,
            'price'  => isset($input['price']) ? $input['price'] : 0,
            'high_price'  => isset($input['high_price']) ? $input['high_price'] : 0,
            'note'  => 'Simple Crawl ' . $input['site'] . ' url: ' . $input['url'],
            'crawl_code'  => $input['crawl_code'],
            'site'  => $input['site'],
            'comments'  => '',
            'meta_title'  => $input['name'],
            'meta_description'  => '',
            'meta_keywords'  => '',
            'is_fast_shipment' => '',
            'related_products'  => '',
            'tags' => $input['tags'],
            'store_link' => '',
            'variants' => isset($input['variants']) ? $input['variants'] : [],
            'product_variants' => isset($input['product_variants']) ? $input['product_variants'] : []
        ];
        if (!empty($input['design_crawl_code'])) {
            $retVal['design_crawl_code'] = $input['design_crawl_code'];
        }

        if (!empty($input['custom_design_type'])) {
            $retVal['custom_design_type'] = $input['custom_design_type'];
        }

        if (!empty($input['custom_options'])) {
            $retVal['custom_options'] = $input['custom_options'];
        }

        $retVal['direction'] = $this->getDirection($retVal['variants']);

        return $retVal;
    }

    public function getTags($data) {
        $result = [];

        foreach ($data['tags'] as $tagTitle) {
            $tag = Tag::firstOrCreate(
                [
                    'title' => trim($tagTitle)
                ],
                ['slug' => strToSlug(trim($tagTitle))]
            );

            $result[] = $tag->id;
        }

        return implode(',', $result);
    }
}
