<?php

namespace Modules\CrawlProduct\Controllers\AutoCrawl;

use DB;
use Illuminate\Http\Request;
use Modules\Pod\Models\User;
use Modules\CrawlProduct\Models\Tag;
use Illuminate\Support\Facades\Input;
use Modules\CrawlProduct\Models\Brand;
use Modules\CrawlProduct\Models\Category;
use Modules\CrawlProduct\Models\ProductMeta;
use Modules\CrawlProduct\Models\ProductNUser;
use Modules\CrawlProduct\Controllers\Controller;
use Modules\CrawlProduct\Controllers\Impl\ProductCreation;
use App\Modules\CrawlProduct\Controllers\Services\EtsyService;
use Modules\CrawlProduct\Controllers\Impl\ProductUseTemplateCreation;

class CrawlRelatedProductController extends Controller {
    public function crawlRelatedProduct(Request $request) {
        set_time_limit(3600);

        $hour = $request->get('hour', 2);
        $productIds = DB::table('order_item')
            ->select(DB::raw('distinct product_id'))
            ->where('created_at', '>=', date('Y-m-d 00:00:00', time() - 3600 * $hour))
            ->where('created_at', '<=', date('Y-m-d 00:00:00', time()))
            ->get()
            ->pluck('product_id')
            ->toArray();
        
        $crawlIds = [];
        foreach (array_chunk($productIds, 50) as $partIds) {
            $relatedIds = DB::table('product_meta')
                ->whereIn('product_id', $partIds)
                ->where('key', 'original_related_product_id')
                ->get()
                ->pluck('product_id');
            $diff = array_diff($partIds, $relatedIds);
            $crawlIds = array_merge($crawlIds, $diff);
        }

        foreach ($crawlIds as $id) {
            $crawlCode = DB::table('product_crawl_code')->where('product_id', $id)->first();
            if ($crawlCode) {
                $url = 'https://cdn.printblur.com/crawl';
                $this->syncRequest(
                    $url,
                    "POST",
                    [
                        "original_product_id" => $id,
                        'crawl_id' => $crawlCode->value,
                        'crawl_site' => $crawlCode->site,
                    ],
                    10
                );
            }
        }

        return [
            'status' => 'successful',
            'result' => $crawlIds
        ];
    }
}
