<?php

namespace Modules\CrawlProduct\Controllers\AutoCrawl;

use DB;
use Illuminate\Http\Request;
use Modules\Pod\Models\User;
use Modules\CrawlProduct\Models\Tag;
use Modules\CrawlProduct\Models\Brand;
use Modules\CrawlProduct\Models\ProductMeta;
use Modules\CrawlProduct\Models\ProductNUser;
use Modules\CrawlProduct\Models\CrawlProductData;
use Modules\CrawlProduct\Controllers\Impl\ProductCreation;
use App\Modules\CrawlProduct\Controllers\Services\TeePublicService;
use Modules\CrawlProduct\Controllers\Controller;

class CrawlTeepublicController extends Controller
{
    public function __construct(ProductCreation $productCreation) {
        $this->productCreation = $productCreation;
    }

    public function crawl(Request $request) {
        \Log::useDailyFiles(storage_path() . '/logs/crawl-teepublic.log');
        ini_set('memory_limit', '2048M');
        $query = CrawlProductData::query();
        
        if (!$request->has('crawl_all')) {
            set_time_limit(10 * 3600);
            // if (!$request->get('fromId')) {
            //     $fromDate = date('Y-m-d 00:00:00', time());
            //     if ($query->get('fromDate')) {
            //         $fromDate = $query->get('fromDate') . ' 00:00:00';
            //     }
            //     $query->where('created_at', '>=', $fromDate);
            // }
            // if (!$request->get('toId')) {
            //     $toDate = date('Y-m-d 23:59:59', time());
            //     if ($query->get('toDate')) {
            //         $toDate = $query->get('toDate') . ' 23:59:59';
            //     }
            //     $query->where('created_at', '<=', $toDate);
            // }
            if ($request->get('fromId')) {
                $query->where('id', '>=', $request->get('fromId'));
            }

            if ($request->get('toId')) {
                $query->where('id', '<=', $request->get('toId'));
            }
        } else {
            set_time_limit(24 * 3600);
        }
        if (!$request->get('is_overwrite_product')) {
            $status = $request->get('status', 'PENDING');
            $query->where('status', $status);
        } else {
            if ($request->has('status')) {
                $query->where('status', $request->get('status'));
            } else {
                $query->where('status', '!=', 'IGNORE');
            }
        }
        if ($request->has('contain')) {
            $query->where('url', 'like', '%' . $request->get('contain') . '%');
        }
        $total = $query->count();
        $offset = 0;
        $limit = $request->get('limit', 50);
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        $localePrefix = $locale == 'us' ? '' : "/$locale";
        $retVal = [
            'status' => 'successful',
            'message' => [],
        ];
        $brand = Brand::take(1)->first();
        while($offset < $total) {
            try {
                $products = $query->limit($limit)->offset($offset)->get(['id']);
                foreach ($products as $product) {
                    $this->asyncRequest(
                        config('crawl-product::sa.crawl_teepublic_url') . $localePrefix . '/crawl-product/async-crawl-teepublic', 
                        'POST',
                        [
                            'craw_data_id' => $product->id,
                            'brand_id' => $brand ? $brand->id : null,
                            'generate_variant' => $request->get('generate_variant', 0),
                            'is_overwrite_product' => $request->get('is_overwrite_product', 0),
                            'is_download_image' => $request->get('is_download_image', 0),
                        ], 
                        [],
                        5
                    );
                }
                if (count($products) == $limit) {
                    sleep(20);
                }
            } catch (\Exception $ex) {
                $message = $ex->getMessage() . ' File: ' . $ex->getFile() . ' Line: ' . $ex->getLine();
                $retVal['message'][] = $message;
                \Log::error($message);
            }

            $offset += $limit;
        }

        return $retVal;
    }

    public function asyncCrawl(Request $request) {
        \Log::useDailyFiles(storage_path() . '/logs/crawl-teepublic.log');
        $retVal = [
            'status' => 'error',
            'message' => [],
        ];
        ini_set('memory_limit', '2048M');
        $dataId = $request->get('craw_data_id');
        $product = CrawlProductData::find($dataId);
        if (!$product) {
            $retVal['message'] = 'Product not found: ' . $dataId;
            return $retVal;
        }
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        try {
            $categoryId = $this->getCategory($product->url);
            if (!$categoryId) {
                \Log::error('can not get category : ', [$product->id]);
                return $retVal;
            }
            $service = new TeePublicService($request->all());
            $data = $service->parseHTML($product->data, $product->url);
            $tags = $this->getTags($data);
            if (!empty($data['name'])) {
                $newRequest = new Request();
                $newRequest->merge([
                    'brand_id' => $request->get('brand_id', 1),
                    'country_code' => $locale,
                    'remove_size_chart' => false,
                    'generate_variant' => $request->get('generate_variant', 0),
                    'tags' => $tags,
                ]);

                $newRequest->merge([
                    'categories' => $categoryId
                ]);
                if ($request->has('is_overwrite_product')) {
                    $newRequest->merge(['is_overwrite_product' => 1]);
                }
                if ($request->has('enable_style')) {
                    $newRequest->merge(['enable_style' => explode(",", $request->get('enable_style'))]); 
                }
                $data['force_status'] =  $request->get('force_status', 'ACTIVE');
                $data['is_download_image'] = $request->get('is_download_image', false);
                $pdc = DB::table('product_design_crawl_code')->where('value', $data['design_crawl_code'])->first();
                if ($pdc) {
                    $pnu = ProductNUser::where('product_id', $pdc->product_id)->first();
                    if ($pnu) {
                        $data['user_id'] = $pnu->user_id;
                    } else {
                        $data['user_id'] = $this->getRandomSellerId();
                    }
                } else {
                    $data['user_id'] = $this->getRandomSellerId();
                }
                $response = $this->productCreation->saveCrawlProduct($newRequest, $data);
                if (isset($response['status']) && $response['status'] == 'successful') {
                    $retVal['status'] = 'successful';
                    $product->status = 'FINISHED';
                    $product->save();
                } else if (isset($response['status']) && $response['status'] == 'duplicate') {
                    $retVal['status'] = 'duplicate';
                    $product->status = 'DUPLICATE';
                    $product->save();
                } else {
                    $retVal['status'] = 'error';
                    $product->status = 'ERROR';
                    $product->save();
                    \Log::error('saveCrawlProduct', [$response]);
                }
            } else {
                $retVal['status'] = 'error';
                $product->status = 'ERROR';
                $message = 'Data Id: ' . $product->id . ' cannot get product name';
                \Log::error($message);
                $retVal['message'][] = $message;
                $product->save();
            }
        } catch (\Exception $ex) {
            $retVal['status'] = 'error';
            $product->status = 'ERROR';
            $product->save();
            $message = 'Data Id: ' . $product->id . ' ' . $ex->getMessage() . ' File: ' . $ex->getFile() . ' Line: ' . $ex->getLine();
            $retVal['message'][] = $message;
            \Log::error('CRAWL ERROR', [$message]);
        }

        return $retVal;
    }

    public function getRandomSellerId() {
        $user = User::where('email', 'mactrantung@gmail.com')->first();
        if ($user) {
            return $user->id;
        }

        return 1;
    }

    public function getCategory($crawlUrl) {
        $slug = str_replace('https://www.teepublic.com/', '', $crawlUrl);
        $slug = explode('/', $slug)[0];

        $locale = env('APP_LOCALE');
        if (!$locale) {
            $locale = 'us';
        }
        $categoryId = config('crawl-product::crawl-' . $locale . '.slug-to-category.' . $slug);
        return $categoryId;
    }

    public function getTags($data) {
        $result = [];

        foreach ($data['tags'] as $tagTitle) {
            $tag = Tag::firstOrCreate(
                [
                    'title' => $tagTitle
                ],
                ['slug' => strToSlug($tagTitle)]
            );

            $result[] = $tag->id;
        }

        return implode(',', $result);
    }

    public function rebuildSeller(Request $request) {
        set_time_limit(10 * 3600);
        if ($request->header('token') != 'megaads@123') {
            return [
                'status' => 'fail',
                'message' => 'token mismatch'
            ];
        }
        $productMetas = DB::table('product_design_crawl_code')
            ->where('value', 'like', '%teepublic%')
            ->groupBy('value')
            ->having(DB::raw('count(*)'), '>', 1)
            ->get([DB::raw('`value`, count(*)')]);

        foreach ($productMetas as $item) {
            $productIds = ProductMeta::where('key', 'design_crawl_code')
                ->where('value', $item->value)
                ->get(['product_id'])
                ->pluck('product_id')
                ->toArray();
            $pnu = ProductNUser::whereIn('product_id', $productIds)->first(['user_id']);
            $sellerId = null;
            if ($pnu) {
                $sellerId = $pnu->user_id;
            } else {
                $sellerId = $this->getRandomSellerId();
            }
            $existsIds = ProductMeta::whereIn('product_id', $productIds)
                ->where('key', 'user_id')
                ->get(['product_id'])
                ->pluck('product_id')
                ->toArray();
            $diffIds = array_diff($productIds, $existsIds);
            ProductMeta::whereIn('product_id', $existsIds)
                ->where('key', 'user_id')
                ->update([
                    'value' => $sellerId,
                ]);
            foreach ($diffIds as $productId) {
                ProductMeta::insert([[
                    'product_id' => $productId,
                    'key' => 'user_id',
                    'value' => $sellerId,
                ]]);
            }
            $existsIds = ProductNUser::whereIn('product_id', $productIds)
                ->get(['product_id'])
                ->pluck('product_id')
                ->toArray();
            $diffIds = array_diff($productIds, $existsIds);

            ProductNUser::whereIn('product_id', $existsIds)
                ->update([
                    'user_id' => $sellerId,
                ]);
            foreach ($diffIds as $productId) {
                ProductNUser::insert([[
                    'product_id' => $productId,
                    'user_id' => $sellerId,
                ]]);
            }
        }

        return [
            'status' => 'successful',
        ];
    }

    public function rebuildCategory()
    {
        set_time_limit(10 * 3600);
        $productMetas = ProductMeta::leftJoin('product_n_category', 'product_meta.product_id', 'product_n_category.product_id')
            ->where('key', 'teepublic_crawl_code')
            ->whereNull('product_n_category.product_id')
            ->get(['product_meta.*']);
        $locale = env('APP_LOCALE');
        if (!$locale) {
            $locale = 'us';
        }
        $slugCategory = config('crawl-product::crawl-' . $locale . '.slug-to-category');
        $data = [];
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        foreach ($productMetas as $item) {
            foreach ($slugCategory as $slug => $id) {
                if (strpos($item->value, $slug) === 0) {
                    $data[] = [
                        'product_id' => $item->product_id,
                        'category_id' => $id,
                        'created_at' => date('Y-m-d H:i:s', time()),
                        'updated_at' => date('Y-m-d H:i:s', time())
                    ];
                    $retVal['result'][] = $item->product_id;
                }
            }
        }

        foreach (array_chunk($data, 100) as $partData) {
            \DB::table('product_n_category')->insert($partData);
        }

        return $retVal;
    }
}
