<?php

namespace Modules\CrawlProduct\Controllers;
use Illuminate\Http\Request;
use Modules\CrawlProduct\Controllers\Controller;
use Auth;
use DateTime;
use DB;
use Modules\CrawlProduct\Models\DefaultProduct;
use Modules\CrawlProduct\Models\Product;
use Modules\CrawlProduct\Models\ProductSkuValue;
use Illuminate\Support\Facades\Route;

class DefaultProductController extends Controller {
    public function index() {
        return view('crawl-product::config-default-product');
    }

    public function find(Request $request) {
        $retVal = [
            'status' => 'successful',
            'meta' => [],
            'result' => []
        ];

        $query = DefaultProduct::with(['category', 'product'])
            ->orderBy('id', 'desc');
        $keyword = trim($request->get('keyword'));
        if ($keyword) {
            $productId = null;
            $product = Product::where('sku', $keyword)
                ->orWhere('id', $keyword)
                ->first(['id']);
            if ($product) {
                $productId = $product->id;
            }
            $query->where('product_id', $productId);
        }

        if ($request->has('category_id')) {
            $query->where('category_id', $request->get('category_id'));
        }

        $total = $query->count();

        $pageSize = $request->get('page_size', 20);
        $pageId = $request->get('page_id', 0);
        $retVal['meta'] = $this->getMetaData($total, $pageSize, $pageId);
        $retVal['result'] = $query->limit($pageSize)->offset($pageId * $pageSize)->get();

        return $retVal;
    }

    public function getMetaData($total, $pageSize, $pageId) {
        $pageCount = $pageSize > 0 ? ceil($total / $pageSize) : 1;

        return [
            'has_next' => $pageId < $pageCount - 1,
            'total_count' => $total,
            'page_id' => intval($pageId),
            'page_size' => intval($pageSize),
            'page_count' => $pageCount
        ];
    }

    public function syncConfig() {
        set_time_limit(3600);

        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }

        $config = config('crawl-product::default.product_template.' . $locale, []);
        foreach ($config as $categoryId => $productId) {
            if (!DB::table('crawl_product_default_product')->where('category_id', $categoryId)->exists()) {
                DB::table('crawl_product_default_product')->insert([
                    'category_id' => $categoryId,
                    'product_id' => $productId,
                    'created_at' => date('Y-m-d H:i:s', time()),
                    'updated_at' => date('Y-m-d H:i:s', time())
                ]);
            }
        }

        return [
            'status' => 'successful'
        ];
    }

    public function save(Request $request) {
        $input = $request->all();
        $data = [];
        if (empty($input['category_id']) || empty($input['sku'])) {
            return [
                'status' => 'fail',
                'message' => 'Vui lòng điền đầy đủ các trường'
            ];
        }
        $data['category_id'] = $input['category_id'];
        $product = Product::where('id', $input['sku'])->first(['id']);
        if (!$product) {
            $product = Product::where('sku', $input['sku'])->first(['id']);
        }

        if ($product) {
            $data['product_id'] = $product->id;
        } else {
            return [
                'status' => 'fail',
                'message' => 'Không tìm thấy sản phẩm'
            ];
        }

        if (!DB::table('product_n_category')->where('product_id', $product->id)->where('is_parent', 0)->where('category_id', $data['category_id'])->exists()) {
            return [
                'status' => 'fail',
                'message' => 'Danh mục sản phẩm không khớp với danh mục được cấu hình'
            ];
        }

        if (isset($input['id'])) {
            $input['updated_at'] = date('Y-m-d H:i:s', time());
            DB::table('crawl_product_default_product')->where('id', $input['id'])->update($data);
        } else {
            DB::table('crawl_product_default_product')->insert([
                'category_id' => $data['category_id'],
                'product_id' => $data['product_id'],
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time())
            ]);
        }

        return [
            'status' => 'successful'
        ];
    }

    public function delete(Request $request, $id) {
        $routeParameters = Route::current()->parameters();
        $id = $routeParameters['id'];
        DB::table('crawl_product_default_product')->where('id', $id)->delete();

        return [
            'status' => 'successful'
        ];
    }
}