<?php

namespace Modules\CrawlProduct\Controllers;

use Illuminate\Http\Request;
use Modules\CrawlProduct\Controllers\Controller;
use App\Modules\CrawlProduct\Controllers\Services\EtsyService;
use App\Modules\CrawlProduct\Controllers\Services\AmazonService;
use App\Modules\CrawlProduct\Controllers\Services\RedBubbleService;
use App\Modules\CrawlProduct\Controllers\Services\TeePublicService;
use Modules\CrawlProduct\Models\Product;

class DeleteProductController extends Controller {
    public function deleteProduct(Request $request) {
        set_time_limit(3 * 3600);
        $site = $request->get('site');
        $service = null;
        $result = null;
        if ($site == 'teepublic') {
            $service = new TeePublicService([]);
        }
        if ($site == 'amazon') {
            $service = new AmazonService([]);
        }
        if ($site == 'redbubble') {
            $service = new RedBubbleService([]);
        }
        if ($service) {
            $result = $service->deleteProduct($request->all());
        }

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function hideByKeyword(Request $request) {
        if ($request->token !== 'megaads@123') {
            return 'token invalid';
        }
        set_time_limit(5 * 3600);

        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        $keywords = $request->get('keywords');

        $updateValues = [
            'is_violation' => 1,
            'approve_advertising' => 0
        ];

        if ($request->get('is_hide')) {
            $updateValues['status'] = 'PENDING';
        }

        foreach ($keywords as $keyword) {
            $productIds = Product::where('status', 'ACTIVE')
                ->having('name', 'like', '%' . $keyword . '%')
                ->select(\DB::raw("id, sku, replace(replace(replace(`name`, '.', ''), '_', ''), '+', '') as `name`"))
                ->get(['id'])
                ->pluck('id')
                ->toArray();

            foreach (array_chunk($productIds, 1000) as $partProductIds) {
                Product::whereIn('id', $partProductIds)->update($updateValues);
            }
            \Log::info('hideByKeyword ' . $keyword, [count($productIds)]);
            $retVal['result'][$keyword] = $productIds;
        }

        return $retVal;
    }

    public function showByKeyword(Request $request) {
        if ($request->header('token') !== 'megaads@123') {
            return 'token invalid';
        }
        set_time_limit(5 * 3600);

        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        $keywords = $request->get('keywords');

        $updateValues = [
            'status' => 'ACTIVE',
            'is_violation' => 1,
            'approve_advertising' => 0
        ];

        foreach ($keywords as $keyword) {
            $products = Product::where('status', 'PENDING')
                // ->where('is_violation', '1')
                // ->where('approve_advertising', 0)
                ->having('name', 'like', '%' . $keyword . '%')
                ->select(\DB::raw("id, sku, replace(replace(replace(`name`, '.', ''), '_', ''), '+', '') as `name`"))
                ->get();
            $violateIds = [];
            foreach ($products as $product) {
                if ($this->isViolate($product->name, $keyword)) {
                    $violateIds[] = $product->id;
                }
            }

            foreach (array_chunk($violateIds, 500) as $partProductIds) {
                Product::whereIn('id', $partProductIds)->update($updateValues);
            }
            \Log::info('showByKeyword ' . $keyword, [count($violateIds)]);
            $retVal['result'][$keyword] = $violateIds;
        }

        return $retVal;
    }

    public function isViolate($name, $keyword) {
        $retVal = false;
        $name = strtolower(trim($name));
        $keyword = strtolower(trim($keyword));
        if (
            preg_match(sprintf("/^%s\s|\s%s\s|\s%s$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ss\s|\s%ss\s|\s%ss$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ses\s|\\s%ses\s|\s%ses$/", $keyword, $keyword, $keyword), $name) ||
            $name == $keyword 
        ) {
            $retVal = true;
        }

        return $retVal;
    }
}