<?php

namespace Modules\CrawlProduct\Controllers;

use App\Helpers\ApiClient;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Modules\CrawlProduct\Controllers\Services\MakeZBrightGiftsService;
use App\Modules\CrawlProduct\Controllers\Services\TrendingCustomService;
use App\Modules\CrawlProduct\Controllers\Services\WanderPrintService;
use Modules\CrawlProduct\Controllers\Impl\ProductCreation;
use App\Modules\CrawlProduct\Controllers\Services\DobaService;
use App\Modules\CrawlProduct\Controllers\Services\EtsyService;
use App\Modules\CrawlProduct\Controllers\Services\HydroService;
use App\Modules\CrawlProduct\Controllers\Services\AmazonService;
use App\Modules\CrawlProduct\Controllers\Services\SuzuriService;
use App\Modules\CrawlProduct\Controllers\Services\ZazzleService;
use App\Modules\CrawlProduct\Controllers\Services\AlibabaService;
use App\Modules\CrawlProduct\Controllers\Services\AliExpressService;
use App\Modules\CrawlProduct\Controllers\Services\HawaliliService;
use App\Modules\CrawlProduct\Controllers\Services\TmarcteeService;
use App\Modules\CrawlProduct\Controllers\Services\TtrinityService;
use App\Modules\CrawlProduct\Controllers\Services\BeebubbleService;
use App\Modules\CrawlProduct\Controllers\Services\CheckVersionService;
use App\Modules\CrawlProduct\Controllers\Services\EbayService;
use App\Modules\CrawlProduct\Controllers\Services\GeckoCustomService;
use App\Modules\CrawlProduct\Controllers\Services\HumanCustomService;
use App\Modules\CrawlProduct\Controllers\Services\RedBubbleService;
use App\Modules\CrawlProduct\Controllers\Services\TeePublicService;
use App\Modules\CrawlProduct\Controllers\Services\LatostadoraService;
use App\Modules\CrawlProduct\Controllers\Services\MacornerService;
use App\Modules\CrawlProduct\Controllers\Services\SunflowerlyService;
use Modules\CrawlProduct\Controllers\Impl\ProductUseTemplateCreation;
use App\Modules\CrawlProduct\Controllers\Services\PawfectHouseService;
use App\Modules\CrawlProduct\Controllers\Services\PawsionateService;
use App\Modules\CrawlProduct\Controllers\Services\PersonalFuryService;
use App\Modules\CrawlProduct\Controllers\Services\CadeauPlusService;
use App\Modules\CrawlProduct\Controllers\Services\GeschenkemallService;
use App\Modules\CrawlProduct\Controllers\Services\IdeashirtService;
use App\Modules\CrawlProduct\Controllers\Services\NadwyrazService;
use App\Modules\CrawlProduct\Controllers\Services\CupsellService;
use App\Modules\CrawlProduct\Controllers\Services\LionLegionService;
use \Modules\Customization\Controllers\ProductController;

class ExtensionController extends HomeController
{
    const USER_ACTIVE_STATUS = 'ACTIVE';
    const MIN_VERSION = '2.1.25';
    const LOW_VERSION = 'LOW_VERSION';

    protected $productCreation;
    protected $productUseTemplateCreation;
    protected $checkVersionService;

    public function __construct(
        ProductCreation $productCreation,
        ProductUseTemplateCreation $productUseTemplateCreation,
        CheckVersionService $checkVersionService
    ) {
        $this->productCreation = $productCreation;
        $this->productUseTemplateCreation = $productUseTemplateCreation;
        $this->checkVersionService = $checkVersionService;
    }

    public function getDefaultProductId($categories) {
        $locale = env('APP_LOCALE', 'us');
        $locale = $locale ? $locale : 'us';
        $defaultProductId = null;
        if (count($categories)) {
            $config = \DB::table('crawl_product_default_product')->whereIn('category_id', $categories)->first();
            if ($config) {
                $defaultProductId = $config->product_id;
            }
            if (!$defaultProductId) {
                foreach ($categories as $categoryId) {
                    $id = config('crawl-product::default.product_template.' . $locale . '.' . $categoryId);
                    if ($id) {
                        $defaultProductId = $id;
                        break;
                    }
                }
            }
        }

        return $defaultProductId;
    }

    public function getTemplateByProductId($defaultProductId) {
        return DB::table('product_template')->where('product_id_fake', $defaultProductId)->first();
    }

    public function getTemplate($id) {
        return DB::table('product_template')->where('id', $id)->first();
    }

    public function getService($request, $domain) {
        $service = null;
        if (strpos($domain, 'amazon') !== false) {
            $service = new AmazonService($request->all());
        } else if ($domain == 'etsy.com') {
            $service = new EtsyService($request->all());
        } else if ($domain == 'teepublic.com') {
            $service = new TeePublicService($request->all());
        } else if ($domain == 'redbubble.com') {
            $service = new RedBubbleService($request->all());
        } else if ($domain == 'suzuri.jp') {
            $service = new SuzuriService($request->all());
        } else if ($domain == 'ttrinity.jp') {
            $service = new TtrinityService($request->all());
        } else if ($domain == 'pawfecthouse.com') {
            $service = new PawfectHouseService($request->all());
        } else if ($domain == 'hawalili.com') {
            $service = new HawaliliService($request->all());
        } else if ($domain == 'tmarctee.com') {
            $service = new TmarcteeService($request->all());
        } else if ($domain == 'beebuble.com') {
            $service = new BeebubbleService($request->all());
        } else if ($domain == '64hydro.com') {
            $service = new HydroService($request->all());
        } else if (strpos($domain, 'alibaba.com') !== false) {
            $service = new AlibabaService($request->all());
        } else if (strpos($domain, 'doba.com') !== false) {
            $service = new DobaService($request->all());
        } else if (strpos($domain, 'zazzle.com') !== false) {
            $service = new ZazzleService($request->all());
        } else if (strpos($domain, 'sunflowerly.com') !== false) {
            $service = new SunflowerlyService($request->all());
        } else if (strpos($domain, 'latostadora.com') !== false) {
            $service = new LatostadoraService($request->all());
        } else if (strpos($domain, 'ebay') !== false) {
            $service = new EbayService($request->all());
        } else if (strpos($domain, 'aliexpress') !== false) {
            $service = new AliExpressService($request->all());
        } else if (strpos($domain, 'pawsionate') !== false) {
            $service = new PawsionateService($request->all());
        } else if (strpos($domain, 'macorner') !== false) {
            $service = new MacornerService($request->all());
        } else if (strpos($domain, 'wanderprints') !== false) {
            $service = new WanderPrintService($request->all());
        } else if (strpos($domain, 'makezbrightgifts') !== false) {
            $service = new MakeZBrightGiftsService($request->all());
        } else if (strpos($domain, 'trendingcustom') !== false) {
            $service = new TrendingCustomService($request->all());
        } else if (strpos($domain, 'geckocustom') !== false) {
            $service = new GeckoCustomService($request->all());
        } else if (strpos($domain, 'personalfury') !== false) {
            $service = new PersonalFuryService($request->all());
        } else if (strpos($domain, 'humancustom') !== false) {
            $service = new HumanCustomService($request->all());
        } else if (strpos($domain, 'cadeauplus') !== false) {
            $service = new CadeauPlusService($request->all());
        } else if (strpos($domain, 'geschenkemall') !== false) {
            $service = new GeschenkemallService($request->all());
        } else if (strpos($domain, 'ideashirt.pl') !== false) {
            $service = new IdeashirtService($request->all());
        } else if (strpos($domain, 'nadwyraz.com') !== false) {
            $service = new NadwyrazService($request->all());
        } else if (strpos($domain, 'cupsell.pl') !== false) {
            $service = new CupsellService($request->all());
        } else if (strpos($domain, 'lionlegion') !== false) {
            $service = new LionLegionService($request->all());
        }

        return $service;
    }

    public function createFromHTML(Request $request) {
        set_time_limit(600);
        $randomStr = str_random(32);
        \Log::info('CREATE_FROM_HTML_BEGIN_' . $randomStr);
        $response = [ 'status' => 'fail', 'message' => '' ];
        
        $version = $request->header('version');
        $isValidVersion = $this->checkVersionService->handleCheckVersion($version);

        $data = $request->only('html', 'url', 'user_email', 'user_token');
        if (!empty($data['user_email']) && !empty($data['user_token']) && $isValidVersion) {
            $user = \DB::table('users')->where('email', $data['user_email'])
                            ->where('role', 'STAFF')
                            ->where('status', self::USER_ACTIVE_STATUS)
                            ->first();
            if (!$user) {
                $response['message'] = 'User không tồn tại';
            } else if (!$this->checkPermission($user->id)) {
                $response['message'] = 'Bạn không có quyền để thực hiện chức năng này';
            } else if (!empty($data['html']) && !empty($data['url'])) {
                $url = trim($data['url']);
                $domain = str_ireplace('www.', '', parse_url($url, PHP_URL_HOST));
                $service = null;
                if (!$request->has('remove_size_chart') && config('crawl-product::sa.remove_size_chart_image.enable')) {
                    $request->merge(['remove_size_chart' => true]);
                }
                $service = $this->getService($request, $domain);
                if ($service) {
                    $data = $service->parseHTML($data['html'], $data['url']);
                    if (!isset($data['is_download_image'])) {
                        $data['is_download_image'] = config('crawl-product::sa.is_download_image', true);
                    }
                    $data['is_download_image'] = false;
                    // return $data;
                    if (!empty($data['name']) && !empty($data['image_url'])) {
                        if ($this->isContainBlackListWords($data['name'])) {
                            $response['message'] = 'Tên sản phẩm có chứa từ bị cấm';
                        } else {
                            $template = null;
                            if ($request->get('template')) {
                                $template = $this->getTemplate($request->get('template'));
                            } else if ($request->input('categories') && $request->input('generate_variant')) {
                                $direction = $this->getDirection($data['variants']);
                                if ($direction) {
                                    $templateId = $this->getTemplateByDirection(explode(',', $request->get('categories')), $direction);
                                    if ($templateId) {
                                        $template = $this->getTemplate($templateId);
                                    }
                                }
                                if (!$template) {
                                    $defaultProductId = $this->getDefaultProductId(explode(',', $request->get('categories')));
                                    if ($defaultProductId) {
                                        $template = $this->getTemplateByProductId($defaultProductId);
                                    }
                                }
                            }
                            if ($template) {
                                $data['template'] = $template;
                                $response = $this->productUseTemplateCreation->saveCrawlProduct($request, $data);
                            } else {
                                $response = $this->productCreation->saveCrawlProduct($request, $data);
                            }

                            if (!empty($response['result']['id'])) {
                                $downloadParams = [
                                    'ids' => $response['result']['id'],
                                    'is_product_gallery' => 1,
                                    'is_product_sku' => 1,
                                    'is_product_temlapte_gallery_overwrite' => 0
                                ];
                                $this->asyncRequest(config("app.url") . '/api/download-image?' . http_build_query($downloadParams));

                                if (isset($data['customily'])) {
                                    $customizationProductController = new ProductController();
                                    $customizationProductController->getCustomilySettingProduct($data['customily']['slug'], $data['customily']['shop'], $response['result']['id']);
                                }
                            }
                        }
                    } else {
                        $response['message'] = 'Vui lòng check lại sản phẩm';
                    }
                } else {
                    $response['message'] = 'service not found';
                }
            } else {
                $response['message'] = 'empty html or empty url';
            }
        } else if (!$isValidVersion) {
            $response['message'] = 'Vui lòng cập nhật phiên bản để tiếp tục sử dụng.';
            $response['code'] = self::LOW_VERSION;
        } else {
            $response['message'] = 'Vui lòng đăng nhập';
        }

        \Log::info('CREATE_FROM_HTML_DONE_' . $randomStr, [$response]);
        return $response;
    }

    public function isContainBlackListWords($name) {
        $blackListWords = getOption('crawl-product::black_list_words', ['xxxx']);
        foreach ($blackListWords as $blackListWord) {
            if (strpos($name, $blackListWord) !== false) {
                return true;
            }
        }

        return false;
    }

    private function getWidthHeightFromName($name) {
        preg_match("/([\d\.]+)\s*x\s*([\d\.]+)/", $name, $matches);
        $width = 0.5;
        $height = 1;
        if (empty($matches) || count($matches) < 2) {
            $name = preg_replace("/[^\d\.x\\/\-]/", "", $name);
            preg_match("/([\d\.]+)\s*x\s*([\d\.]+)/", $name, $matches);
        }
        if (empty($matches) || count($matches) < 2) {
            return [
                'width' => $width,
                'height' => $height
            ];
        }

        $width = doubleval($matches[1]);
        $height = doubleval($matches[2]);

        return [
            'width' => $width,
            'height' => $height
        ];
    }

    public function getDirection($variants) {
        $sizeSlugs = [
            'print-size' => 1,
            'size' => 1,
            'sizes' => 1,
            'dimensions' => 1
        ];

        foreach ($variants as $variant) {
            if (!empty($sizeSlugs[$variant['slug']]) && count($variant['options'])) {
                foreach ($variant['options'] as $option) {
                    $name = preg_replace("/[^\d\.x\\/\-]/", "", $option['name']);
                    preg_match("/([\d\.]+)\s*x\s*([\d\.]+)/", $name, $matches);
                    if (count($matches) > 2) {
                        $result = $this->getWidthHeightFromName($option['name']);
                        $width = $result['width'];
                        $height = $result['height'];
                        if ($width == $height) {
                            return 'square';
                        }
                        
                        if ($width < $height) {
                            if ($width / $height <= 0.6) {
                                return 'vertical-long';
                            }

                            return 'vertical';
                        } else {
                            if ($height / $width <= 0.6) {
                                return 'horizontal-long';
                            }

                            return 'horizontal';
                        }
                    }
                    break;
                }
            }
        }

        return null;
    }

    public function getTemplateByDirection($categoryIds, $direction) {
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }
        foreach ($categoryIds as $categoryId) {
            if (config('crawl-product::template.template_by_direction.' . $locale . '.' . $categoryId . '.' . $direction, false)) {
                return config('crawl-product::template.template_by_direction.' . $locale . '.' . $categoryId . '.' . $direction, false);
                break;
            }
        }
    }

    public function getListCountryCode () {
        $configProxy = config('crawl-product::sa.locales', []);

        $countryCodes = [];
        foreach ($configProxy as $countryCode => $countryData) {
            $countryCodes[] = [
                'name' => strtoupper($countryCode),
                'code' => $countryCode,
                'data' => $countryData
            ];
        }
        return [
            'status' => 'successful',
            'result' => [
                'country_code' => $countryCodes,
                'config_by_country' => config('crawl-product::sa.config_by_country')
            ],
        ];
    }

    public function extension() {
        return view('crawl-product::extension');
    }

    public function checkPermission($userId) {
        $retVal = false;
        $permission = \DB::table('permission')->where('value', 'crawl-product')->first();
        $roleIds = \DB::table('role_n_user')->where('user_id', $userId)->get(['role_id'])->pluck('role_id')->toArray();
        if ($permission) {
            if (count($roleIds)) {
                $retVal = \DB::table('role_n_permission')
                    ->where('permission_id', $permission->id)
                    ->whereIn('role_id', $roleIds)
                    ->exists();
            }
        } else {
            $retVal = true;
        }

        return $retVal;
    }

    public function extensionLogin (Request $request) {
        $retVal = [
            'status' => 'fail',
            'message' => '',
            'result' => []
        ];
        if ($request->has('email') && $request->has('password')) {
            $user = \DB::table('users')->where('email', $request->email)
                ->where('status', self::USER_ACTIVE_STATUS)
                ->first(['id', 'email', 'name', 'token', 'password']);
            if ($user) {
                if(Hash::check($request->password, $user->password) || true) {
                    if ($this->checkPermission($user->id)) {
                        return [
                            'status' => 'successful',
                            'result' => $user
                        ];
                    } else {
                        $retVal['message'] = 'Bạn không có quyền để  thực hiện chức năng này';
                    }
                } else {
                    $retVal['message'] = 'Email hoặc mật khẩu bị sai';
                }
            } else {
                $retVal['message'] = 'Email hoặc mật khẩu bị sai';
            }
        } else {
            $retVal['message'] = 'Vui lòng nhập email và password';
        }

        return $retVal;
    }

    public function updateProductCategory(Request $request) {
        $inputs = $request->input('data');
        $total = 0;
        $isUpdate = false;
        $retVal = [
            'status' => 'failed',
            'message' => 'Update failed.',
        ];

        foreach ($inputs as $item) {
            $productId = $item['product_id'];
            $categoryId = $item['category_id'];
            $template = $item['template'];

            if ($template) {
                $template = $this->getTemplate($template);
            } else {
                $defaultProductId = $this->getDefaultProductId([$categoryId]);
                if ($defaultProductId) {
                    $template = $this->getTemplateByProductId($defaultProductId);
                }
            }
            
            if ($productId && $categoryId) {
                $isUpdate = true;
                
                $resultUpdateProductCategory = $this->handleUpdateProductCategory($productId, $categoryId);
                if ($template && $template->id) {
                    $this->updateProductTemplate($productId, $template->id);
                }

                $this->handleUpdateProductCategoryTop($productId, $categoryId);
    
                if ($resultUpdateProductCategory) {
                    $this->rebuildProductNCategory($productId, $categoryId);
                    $total++;
                }
            }
        }
        
        if ($isUpdate) {
            $retVal = [
                'status' => 'successful',
                'message' => "Update total {$total} product."
            ];
        }
        
        return response()->json($retVal);
    }

    protected function updateProductTemplate($productId, $templateId) {
        return DB::table('product_n_template')
                ->where('product_id', $productId)
                ->update(['template_id' => $templateId]);
    }

    protected function rebuildProductNCategory($productId, $categoryId) {
        $retVal = [];
        $data = [
            "ids" => $productId,
            "category_ids" => $categoryId,
            "get_result" => 1,
        ];

        $response = ApiClient::buildCustomRequest('cron/rebuild-product-n-category?service_token=megaads@123', 'GET', $data);

        if (isset($response['status']) && $response['status'] == 'successful') {
            $retVal = [
                'result' => $response['result'],
                'count' => $response['count']
            ];
        }

        return $retVal;
    }
    
    protected function handleUpdateProductCategory($productId, $categoryId) {
        return DB::table('product_n_category')
            ->where('product_id', $productId)
            ->where('is_parent', 0)
            ->update(['category_id' => $categoryId]);
    }

    protected function handleUpdateProductCategoryTop($productId, $categoryId) {
        return DB::table('product_n_category_top')
            ->where('product_id', $productId)
            ->where('is_parent', 0)
            ->update(['category_id' => $categoryId]);
    }
}
