<?php

namespace Modules\CrawlProduct\Controllers\Impl;

use Illuminate\Support\Facades\Cache;


class ImageDownloader {
    public function pathinfo($path, $options = null)
    {
        $path = urlencode($path);
        $parts = is_null($options) ? pathinfo($path) : pathinfo($path, $options);
        if (is_array($parts)) {
            foreach ($parts as $field => $value) {
                $parts[$field] = urldecode($value);
            }
        } else {
            $parts = urldecode($parts);
        }

        return $parts;
    }

    public function downloadImage($url) {
        if (!config('crawl-product::sa.is_download_image', true)) {
            return $url;
        }
        $retVal = $url;
        if ($url) {
            if (Cache::get('link-url::' . $url)) {
                $retVal = Cache::get('link-url::' . $url);
            } else {
                $arrContextOptions = [
                    "ssl"=>[
                        "verify_peer" => false,
                        "verify_peer_name" => false,
                    ],
                    "http" => [
                        "method" => "GET",
                        "header" => "User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36"
                    ]
                ]; 
                $image = file_get_contents(str_replace(' ', '%20', $url), false, stream_context_create($arrContextOptions));

                $fileName = $this->getNewName($url);

                file_put_contents(public_path($fileName), $image);
                if (is_file(public_path($fileName))) {
                    $uploadSuccess = false;
                    if (env('GCS_BUCKET') && config('crawl-product::sa.use_cloud_storage', false)) {
                        $url = app('App\Http\Controllers\GoogleCloudStorageController')->uploadSingleFile(public_path($fileName));
                        if ($url) {
                            unlink(public_path($fileName));
                            $uploadSuccess = true;
                            $retVal = $url;
                        }
                    }
                    if (!$uploadSuccess) {
                        $retVal = config('sa.file_manager_url') . $fileName;
                    }
                    Cache::put('link-url::' . $url, $retVal, 60);
                }
            }
        }
        return $retVal;
    }

    public function getNewName($url)
    {   
        $locale = '';
        if (env('APP_LOCALE') && config('app.upload_by_locale', false)) {
            $locale = env('APP_LOCALE');
            if ($locale == '' || empty($locale)) {
                $locale = '/us';
            } else {
                $locale = '/' . $locale;
            }
        } else if (!env('APP_LOCALE') && config('app.upload_by_locale', false)) {
            $locale = '/us';
        }
        $date = date('d-m-Y', time());
        $url = parse_url($url, PHP_URL_PATH);
        $path = "/files" . $locale . "/product/" . $date;
        $fullPath = public_path($path);
        exec("mkdir -p '$fullPath'");
        $name = "$path/" . uniqid('', true);
        $ext = $this->pathinfo($url, PATHINFO_EXTENSION);
        if (!$ext) {
            $ext = 'png';
        }
        $name = $name . '.' . $ext;

        return $name;
    }
}