<?php

namespace Modules\CrawlProduct\Controllers\Impl;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Input;
use Modules\CrawlProduct\Models\ProductSku;
use Modules\CrawlProduct\Models\ProductMeta;
use Modules\CrawlProduct\Models\ProductNUser;
use Modules\CrawlProduct\Models\ProductGallery;
use Modules\CrawlProduct\Models\ProductSkuValue;
use Modules\CrawlProduct\Models\ProductNCategory;
use Modules\CrawlProduct\Controllers\Impl\ProductCreation;
use Modules\CrawlProduct\Models\ProductTemplateGalleryOverwrite;
use Modules\CrawlProduct\Controllers\Impl\VariantTemplateGenerator;

class ProductUseTemplateCreation extends ProductCreation {
    protected $imageDownloader;
    protected $skuGenerator;
    protected $variantGenerator;
    protected $trademarkChecker;
    
    public function __construct(
        ImageDownloader $imageDownloader, 
        SkuGenerator $skuGenerator,
        VariantTemplateGenerator $variantGenerator,
        TrademarkChecker $trademarkChecker
    ) {
        $this->imageDownloader = $imageDownloader;
        $this->skuGenerator = $skuGenerator;
        $this->variantGenerator = $variantGenerator;
        $this->trademarkChecker = $trademarkChecker;
    }

    public function clearBeforeOverwrite($product, $data) {
        // $this->trademarkChecker->checkWarning($product);
        ProductNCategory::where('product_id', $product->id)->delete();
        ProductSkuValue::where('product_id', $product->id)->delete();
        $skuIds = ProductSku::where('product_id', $product->id)->get(['id'])->pluck('id')->toArray();
        ProductSku::where('product_id', $product->id)->delete();
        ProductGallery::where('product_id', $product->id)->where('type', 'PRODUCT')->delete();
        ProductGallery::whereIn('product_id', $skuIds)->where('type', 'VARIANT')->delete();
        ProductTemplateGalleryOverwrite::where('product_id', $product->id)->delete();
        if (!empty($data['videos'])) {
            DB::table('product_video')->where('product_id', $product->id)->delete();
        }
        ProductMeta::where('product_id', $product->id)->delete();
        ProductNUser::where('product_id', $product->id)->delete();
        DB::table('product_n_template')->where('product_id', $product->id)->delete();
        DB::table('product_template_design_code')->where('product_id', $product->id)->delete();
        DB::table('product_custom')->where('product_id', $product->id)->delete();
        DB::table('product_custom_option')->where('product_id', $product->id)->delete();
    }

    public function storeProductMeta($productId, $data) {
        parent::storeProductMeta($productId, $data);
        DB::table('product_n_template')->insert([
            'template_id' => $data['template']->id,
            'product_id' => $productId,
            'created_at' => date('Y-m-d H:i:s', time()),
            'updated_at' => date('Y-m-d H:i:s', time()),
        ]);

        $defaultSku = DB::table('product_template_sku')->where('template_id', $data['template']->id)->where('is_default', 1)->first();
        if ($defaultSku) {
            $updateData = [
                'price' => $defaultSku->price,
                'updated_at' => date('Y-m-d H:i:s', time()),
            ];
            if (!hasPermission('crawl-product:pending-status')) {
                if (DB::table('product')->where('id', $productId)->where('is_trademark', 0)->exists()) {
                    $updateData['status'] = 'ACTIVE';
                }
            }

            DB::table('product')->where('id', $productId)->update($updateData);

        }

        if (isset($data['design_url'])) {
            $designUrl = $this->imageDownloader->downloadImage($data['design_url']);
            $url = url('/');
            $locale = env('APP_LOCALE', 'us');
            if (!$locale) {
                $locale = 'us';
            }
            $this->syncRequest($url . ($locale != 'us' ? '/' . $locale : '') . '/service/pod/primary-design', "POST", [
                "product_id" => $productId,
                "name" => $data["name"],
                "image_url" => $designUrl
            ], [], 10);
        }

        // if (isset($data['template_design_code'])) {
        //     DB::table('product_template_design_code')->insert([
        //         'product_id' => $productId,
        //         'design_code' => $data['template_design_code']
        //     ]);
        // }
    }

    public function syncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 120) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        $headers[] = 'Content-type: application/json';
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            \Log::info('syncRequest ERROR', [curl_error($channel), curl_errno($channel)]);
        }
        curl_close($channel);
        $response = json_decode($data, true);
        if (!$response) {
            return $data;
        }
        return $response;
    }

    public function storeProductVariant($product, $data) {
        $isDownloadImage = !isset($data['is_download_image']) || !empty($data['is_download_image']);
        $insertItems = [];
        $hasImage = false;
        foreach ($data['product_variants'] as $item) {
            if ($item['image_url']) {
                $url = $item['image_url'];
                $hasImage = true;
                if ($isDownloadImage) {
                    $url = $this->imageDownloader->downloadImage($item['image_url']);
                }
                $insertItems[] = [
                    'product_id' => $product->id,
                    'product_sku_id' => $item['id'],
                    'is_primary' => '1',
                    'image_url' => $url,
                    'created_at' => date('Y-m-d H:i:s', time()),
                    'updated_at' => date('Y-m-d H:i:s', time()),
                ];
                if (count($item['galleries'])) {
                    foreach ($item['galleries'] as $img) {
                        if ($isDownloadImage) {
                            $img = $this->imageDownloader->downloadImage($img);
                        }
                        $insertItems[] = [
                            'product_id' => $product->id,
                            'product_sku_id' => $item['id'],
                            'is_primary' => '0',
                            'image_url' => $img,
                            'created_at' => date('Y-m-d H:i:s', time()),
                            'updated_at' => date('Y-m-d H:i:s', time()),
                        ];
                    }
                }
            }
        }

        if (!$hasImage && !isset($data['template_design_code'])) {
            $insertItems[] = [
                'product_id' => $product->id,
                'product_sku_id' => null,
                'is_primary' => '1',
                'image_url' => $product->image_url,
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time()),
            ];
        }
    }
}