<?php

namespace Modules\CrawlProduct\Controllers\Impl;

use InvalidArgumentException;
use Illuminate\Support\Facades\Redis;
use Modules\CrawlProduct\Models\Product;
use Modules\CrawlProduct\Models\ProductSku;
use Modules\CrawlProduct\Models\ProductSkuValue;
use Modules\CrawlProduct\Models\ProductVariantOption;

class SkuGenerator {
    public function codeGenerator($type = null, $length = 7) {
        if ($type == null)
            throw new InvalidArgumentException('missing argument type');
        $retVal = '';
        $type = strtoupper($type);
        $key = $type;
        if (!Redis::exists($key)) {
            Redis::set($key, 0);
        }
        $nextId = Redis::incr($key);
        $retVal .= str_pad($nextId, $length, '0', STR_PAD_LEFT);
        return $retVal;
    }

    public function generateSku($type = 'product') {
        $retVal = null;

        while (true) {
            $sku = $this->codeGenerator($type, 7);
            $exists = ProductSku::where('sku', $sku)->exists();
            if (!$exists) {
                $exists = Product::where('sku', $sku)->exists();
                if (!$exists) {
                    $retVal = $sku;
                    break;
                }
            }
        }

        return $retVal;
    }

    function checkExists($args = null, $builder = null)
    {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
            
        foreach ($args as $key => $value) {
            if (strpos($key, '!') !== false) {
                $key = str_replace('!', '', $key);
                $builder->where($key, '!=', $value);
            } else {
                $builder->where($key, '=', $value);
            }
        }
        return $builder->exists();
    }

    public function initSkuCode($productId, $productSkuId, $limit = 30) 
    {
        $skuCode = null;
        $check = true;

        // P{PRODUCT_ID}-{COLOR}-{SIZE}-{OTHER_ATTR}(2 ADD ATTR)
        $skuCode = [];
        $skuCode[] = 'P' . str_pad($productId, 5, '0', STR_PAD_LEFT);

        $optionCodes = ProductSkuValue::where('sku_id', $productSkuId)
            ->join('product_variant', 'product_sku_value.variant_id', '=', 'product_variant.id')
            ->join('product_variant_option', 'product_sku_value.variant_option_id', '=', 'product_variant_option.id')
            ->select(['product_variant.name', 'product_variant_option.code'])
            ->get()->toArray();

        $variantAttr = [];
        if($optionCodes && count($optionCodes)) {
            foreach ($optionCodes as $variant) {
                $variantAttr[$variant['name']] = $variant['code']; 
            }
        }

        if(isset($variantAttr['Color'])) {
            $skuCode[] = $variantAttr['Color'];
        }

        if(isset($variantAttr['Size'])) {
            $skuCode[] = $variantAttr['Size'];
        }

        foreach ($variantAttr as $key => $value) {
            if($key != 'Color' && $key != "Size") {
                $skuCode[] = $value;
            }

            if(count($skuCode) > 3) break;
        }
        $microtime = floor(microtime(true) * 1000);
        $index = str_random(3) . substr($microtime, -2) . str_random(3); // 2 số cuối của microtime
        $subLen = $limit - strlen($index) - 1;

        return substr(implode('-', $skuCode), 0, $subLen) . '-' . $index;
    }

    function get_num_of_words($string) 
    {
        $string = preg_replace('/\s+/', ' ', trim($string));
        $words = explode(" ", $string);
        return count($words);
    }

    function generateOptionCode($option)
    {
         /* 
            Đếm số từ: $countWord
            $countWord >= 3 => Lấy các chữ cái đầu của tên
            $countWord = 2 => Lấy 2 chữ cái từ đầu + 1 chữ cái từ 2
            $countWord = 1 => Lấy 3 chữ cái từ đầu

            Nếu đã trùng + thêm ASCII cho tới khi không trùng
            Nếu hết bảng dùng gencode auto incre redis
        */

        $alphas = range('A', 'Z');
        $name = str_replace('-', ' ', $option->slug);
        $name = preg_replace( '/[^A-Za-z0-9 ]/', '', $name);
        $name = preg_replace('/\s+/', ' ', $name);
        $name = trim($name);
        $countWord = $this->get_num_of_words($name);

        $acronym = '';
        if($name) {
            if($countWord >= 3) {

                $words = explode(" ", $name);
                $acronym = "";
                foreach ($words as $k => $w) {
                    $acronym .= $w[0];
                    if($k >= 2) break;
                }

            } else if($countWord == 2) {
                $words = explode(" ", $name);

                $acronym = $words[0];
                if(strlen($words[0]) >= 2)
                    $acronym = substr($words[0], 0, 2);

                $acronym .= $words[1][0];

            } else if($countWord == 1) {
                $acronym = $name;
                if(strlen($name) >= 3)
                    $acronym = substr($name, 0, 3);
            }
        }

        $attrCode = $acronym;
        $checkExist = true;
        $try = null;

        while ($checkExist) {
            
            if($try !== null && isset($alphas[$try])) {
                $attrCode = $acronym . '_' . $alphas[$try];
                $try ++;
            }
                
            $exists = $this->checkExists(['code' => $attrCode], ProductVariantOption::query());
            if(!$exists) {
                $checkExist = false;
            } else if($try === null) {
                $try = 0;
            }

            $redisIncre = 0;
            if($try >= count($alphas)) {
                $redisIncre = $this->codeGenerator('variant_option_' . $option->id, 2);
                $attrCode = $acronym . '_' . $redisIncre;
            }

        }

        $option->code = strtoupper($attrCode);
        $option->save();

        return $option->code;
    }
}