<?php

namespace Modules\CrawlProduct\Controllers\Impl;

use DB;
use Modules\CrawlProduct\Models\ProductSku;
use Modules\CrawlProduct\Models\ProductVariant;
use Modules\CrawlProduct\Models\ProductVariantOption;

class VariantTemplateGenerator extends VariantGenerator {
    public function buildVariants($categories, $data) {
        $locale = env('APP_LOCALE', 'us');
        $locale = $locale ? $locale : 'us';
        $defaultProductId = $this->getDefaultProductId($categories);
        if ($defaultProductId) {
            $result = $this->getProductVariants($defaultProductId);
            $templateVariants = $result['variants'];
            $templateProductVariants = $result['product_variants'];
            foreach ($templateProductVariants as $key => &$item) {
                $item['image_url'] = null;
                $item['galleries'] = [];
            }
            $result = $this->buildVariantsFromTemplate($templateVariants, $templateProductVariants, $data);

            $templateProductVariantByKey = $this->getProductVariantByKey($templateProductVariants, [], true);
            $productVariantByKey = $this->getProductVariantByKey($result['product_variants'], [], true);
            foreach ($productVariantByKey as $key => $item) {
                if (isset($templateProductVariantByKey[$key])) {
                    $templateProductVariantByKey[$key]['image_url'] = $item['image_url'];
                    $templateProductVariantByKey[$key]['galleries'] = $item['galleries'];
                }
            }

            return [
                'variants' => $templateVariants,
                'product_variants' => array_values($templateProductVariantByKey)
            ];
        }

        return null;
    }
}