<?php

namespace Modules\CrawlProduct\Controllers;

use Illuminate\Http\Request;
use Modules\CrawlProduct\Models\ProductMeta;
use DB;

class MatchDesignController extends Controller {
    public function matchDesign(Request $request) {
        set_time_limit(10 * 3600);
        $retVal = [
            'status' => 'fail',
            'message' => '',
            'result' => []
        ];
        $token = $request->header('token');
        if (!$token) {
            $retVal['message'] = 'Token required';
            return $retVal;
        }
        $user = DB::table('users')->where('token', $token)->where('status', 'ACTIVE')->first();
        if (!$user) {
            $retVal['message'] = 'Invalid token';
            return $retVal;
        }

        $sql = "select A.`id`, A.`product_id`, A.`key`, A.`value` from 
        (SELECT `id`, `product_id`, `key`, `value` FROM `sb_product_meta` WHERE `key` = 'teepublic_crawl_code') as A
        left join
        (SELECT `id`, `product_id`, `key`, `value` FROM `sb_product_meta` WHERE `key` = 'design_crawl_code') as B
        on A.`product_id` = B.`product_id`
        where B.`product_id` is null";

        if ($request->get('from_id')) {
            $sql .= " AND A.id >= " . $request->get('from_id');
        }

        if ($request->get('to_id')) {
            $sql .= " AND A.id <= " . $request->get('to_id');
        }

        $productMeta = DB::select($sql);

        foreach ($productMeta as $meta) {
            preg_match("/([a-z\-]+)([a-z\-\d]+)/", $meta->value, $matches);
            if (count($matches) > 2) {
                $code = $matches[2];
                ProductMeta::updateOrCreate(
                    [
                        'product_id' => $meta->product_id,
                        'key' => 'design_crawl_code'
                    ],
                    [
                        'value' => 'teepublic-' . $code
                    ]
                );
            }
        }

        $retVal['status'] = 'successful';
        $retVal['result'] = count($productMeta);
        
        return $retVal;
    }
}
