<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 7/16/21
 * Time: 1:56 PM
 */

namespace Modules\CrawlProduct\Controllers;


use App\Modules\CrawlProduct\Controllers\Services\AmazonService;
use App\Modules\CrawlProduct\Controllers\Services\EtsyService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\CrawlProduct\Controllers\AutoCrawl\CrawlController;
use Modules\CrawlProduct\Models\CrawlSearchedProductLog;
use Modules\CrawlProduct\Models\ProductCrawl;

class NewProductController extends Controller
{
    protected $crawlController;
    public function __construct(CrawlController $crawlController){
        $this->crawlController = $crawlController;
    }
    public function index () {
        $configProxy = config('crawl-product::sa.proxy', []);
        $listCountryCode = array_keys($configProxy);
        $countryCodes = [];
        foreach ($listCountryCode as $countryCode) {
            $countryCodes[] = [
                'name' => strtoupper($countryCode),
                'code' => $countryCode
            ];
        }
        return view('crawl-product::new-product', ['listCountryCode' => json_encode($countryCodes)]);
    }
    public function crawlCategory () {
        set_time_limit(3600);
        $config = config('crawl-product::new_products', []);
        $products = [];
        $data = [];
        foreach ($config as $countryCode => $listUrl) {
            if (!isset($data[$countryCode])) {
                $data[$countryCode] = [];
            }
            foreach ($listUrl as $url) {
                $domain = str_ireplace('www.', '', parse_url($url, PHP_URL_HOST));
                $service = null;
                if (strpos($domain, 'amazon') !== false) {
                    $service = new AmazonService([]);
                } else if ($domain == 'etsy.com') {
                    $service = new EtsyService([]);
                }
                if ($service) {
                    $listProduct = $service->crawlCategory($url, $countryCode);
                    $products = array_merge($products, $listProduct);
                    $data[$countryCode][$url] = count($listProduct);
                }
            }
        }
        foreach ($products as $item) {
            if (empty($item['name']) || empty($item['url'])) {
                continue;
            }
            $product = ProductCrawl::where('site', $item['site'])
                ->where('code', $item['code'])
                ->first();
            if ($product) {
                $product->fill($item);
                $product->save();
            } else {
                ProductCrawl::create($item);
            }
        }
        return response()->json([
            'status' => 'successful',
            'data' => $data
        ]);
    }

    public function getNewProducts (Request $request) {
        $pageId = $request->input('page_id', 0);
        $pageSize = $request->input('page_site', 60);
        $query = ProductCrawl::query();
        if ($request->input('country_code')) {
            $query->where('country_code', $request->input('country_code'));
        }
        $query->orderBy('updated_at', 'desc');
        $totalCount = $query->count();
        $pageCount = $this->recordsCountToPagesCount($totalCount, $pageSize);
        $data = $query->forPage($pageId + 1, $pageSize)->get();
        return response()->json([
            'status' => 'successful',
            'data' => $data,
            'meta' => [
                'page_count' => $pageCount,
                'page_id' => intval($pageId),
                'page_size' => $pageSize,
                'off_set' => $pageId * $pageSize,
                'total_count' => $totalCount,
                'has_next' => $pageId + 1 >= $pageCount ? false : true
            ]
        ]);
    }

    public function getProductSearchedEtsy(Request $request) {
        $retVal = ['status' => 'failed'];
        $keyWord = $request->input('key_word');

        if($keyWord){
            $service = new EtsyService([]);
            $result = $service->getListDataProductByKeyWord($keyWord);
            $arrayProductData = [];
            foreach ($result as $key => $item) {
                if($item['url']) {
                    $record = DB::table('product_crawl_code')->where('value', $item['data_listing_id'])->where('site','etsy')->first();
                    if (!$record) {
                        $productData = $service->crawlProduct($item['url']);
                    } else {
                        $productData = $record;
                    }

                    if ($productData) {
                        $retVal = [];
                       
                        if (!$record) {
                            $request = request();
                            $request->merge($productData);
                            $data = $this->crawlController->simpleCrawl($request);
                            if(isset($data['id'])) {
                                $resultData = $this->createSearchedProductLog($data['id'], $productData);
                                if ($resultData) {
                                    $item['slug'] = $data['slug'];
                                    $item['price'] = $data['price'];
                                    $item['high_price'] = $data['high_price'];
                                    $item['product_id'] = $resultData['product_id'];
                                    array_push($arrayProductData, $item);
                                }
                            }
                        } else {
                            $product = DB::table('product')->where('id', $productData->product_id)->first();
                            $item['slug'] = $product->slug;
                            $item['price'] = $product->price;
                            $item['high_price'] = $product->high_price;
                            $item['product_id'] = $product->id;
                            array_push($arrayProductData, $item);
                        }
                    }
                }
            }
            
            if (\Module::isActive('ZSearch')) {
                try {
                    $dataDecorProducts = \Modules\ZSearch\Controllers\HomeController::decorProducts($arrayProductData, $keyWord);
                } catch (\Exception $ex) {
                    Log::error('decorProducts: ' . json_encode($ex));
                }
            }

            if (isset($dataDecorProducts)) {
                $retVal = [
                    'status' => 'successful',
                    'result' => $dataDecorProducts
                ];
            }
        }
        
        return response()->json($retVal);
    }

    public function saveProductSearchedEtsy(Request $request) {
        $retVal = ['status' => 'failed'];

        $url = $request->input('url');

        if($url) {
            $service = new EtsyService([]);
            $productData = $service->crawlProduct($url);
            $retVal = ['status' => 'failed'];
            if ($productData) {
                $record = DB::table('product_crawl_code')->where('site','etsy')->where('value', $productData['crawl_code'])->first();
                if (!$record) {
                    $request = request();
                    $request->merge($productData);
                    $data = $this->crawlController->simpleCrawl($request);
                    $result = $this->createSearchedProductLog($data['id'], $productData);
                    if ($result) {
                        $retVal = $data;
                    }
                } else {
                    $product = DB::table('product')->where('id', $record->product_id)->select([
                        'id',
                        'name',
                        'slug',
                        'price',
                        'high_price',
                        ])->first();
                    $retVal = [
                        'id' => $product->id,
                        'name' => $product->name,
                        'slug' => $product->slug,
                        'price' => $product->price,
                        'high_price' => $product->high_price,
                    ];
                }
                $retVal = [
                    'status' => 'successful',
                    'result' => [
                        'data' => $retVal,
                        'message' => $record ? __('Record existed in system.') : __('Create product successful.')
                    ]
                ];
            }

        }

        return response()->json($retVal);
    }

    public function createSearchedProductLog($productId, $productData) {
        $data = [
            'product_id' => $productId,
            'crawl_code' => $productData['crawl_code'],
            'crawl_url' => $productData['url'],
            'data' => json_encode($productData),
        ];

        $record = CrawlSearchedProductLog::where('crawl_code', $productData['crawl_code'])->first(['product_id']);
        $retval = null;

        if($record){
            $retval = [
                'product_id' => $record->product_id,
                'message' => 'Product exists in system.'
            ];
        } else {
            $result = CrawlSearchedProductLog::create($data);
            $retval = [
                'product_id' => $result->product_id,
                'message' => 'Create product successful.'
            ];
        }
        
        return $retval;
    }
}
