<?php

namespace Modules\CrawlProduct\Controllers;

use DB;
use Illuminate\Http\Request;
use Modules\CrawlProduct\Controllers\Controller;

class RemoveDuplicateOptionController extends Controller
{
    public function removeUnusedOption(Request $request) {
        set_time_limit(3 * 3600);
        $maxOptionId = DB::table('product_variant_option')
            ->orderBy('id', 'desc')
            ->first();
        $maxOptionId = $maxOptionId->id;
        $fromId = 0;
        $step = 100;
        $result = [];
        while ($fromId <= $maxOptionId) {
            $optionIds = DB::table('product_variant_option')
                ->where('id', '>', $fromId)
                ->where('id', '<=', $fromId + $step)
                ->where(function ($query) {
                    $query->whereNull('image_url')
                        ->orWhere('image_url', '=', '');
                })
                ->orderBy('id', 'asc')
                ->get(['id'])
                ->pluck('id')
                ->toArray();
            $usedOptionIds = DB::table('product_sku_value')
                ->where('variant_option_id', '>', $fromId)
                ->where('variant_option_id', '<=', $fromId + $step)
                ->limit(100)
                ->get([DB::raw('distinct variant_option_id')])
                ->pluck('variant_option_id')
                ->toArray();
            $fromId += $step;
            $diff = array_diff($optionIds, $usedOptionIds);
            $this->deleteOptionByIds($diff);
            $result = array_merge($result, $diff);
        } 

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function removeDuplicateOption(Request $request) {
        $duplicateSlugs = DB::table('product_variant_option')
            ->groupBy('trim_slug', 'variant_id')
            ->having(DB::raw('count(*)'), '>', 1)
            ->get([DB::raw('trim(trim(both \'-\' from `slug`)) as trim_slug, variant_id, count(*)')]);;
        $result = [];
        foreach ($duplicateSlugs as $item) {
            $slug = $item->trim_slug;
            $variantId = $item->variant_id;
            $options = DB::table('product_variant_option')
                ->where(DB::raw('trim(trim(both \'-\' from `slug`))'), '=', $slug)
                ->where('variant_id', $variantId)
                ->orderBy('id', 'asc')
                ->get(['id', 'slug', 'image_url'])
                ->toArray();
            $keepId = null;

            foreach ($options as $option) {
                if ($option->slug == $slug && $option->image_url) {
                    $keepId = $option->id;
                    break;
                }
            }
            
            if (!$keepId) {
                foreach ($options as $option) {
                    if ($option->slug == $slug) {
                        $keepId = $option->id;
                        break;
                    }
                }
            }

            if (!$keepId) {
                $keepId = $options[0]->id;
            }

            $deleteIds = [];
            foreach ($options as $option) {
                if ($option->id !== $keepId) {
                    $deleteIds[] = $option->id;
                }
            }
            $result[$slug . '++++' . $variantId] = [
                'keep' => $keepId,
                'delete' => $deleteIds
            ];
            DB::table('product_sku_value')
                ->whereIn('variant_option_id', $deleteIds)
                ->update([
                    'variant_option_id' => $keepId
                ]);
            $this->deleteOptionByIds($deleteIds);
        }

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function deleteOptionByIds($optionIds) {
        $options = DB::table('product_variant_option')->whereIn('id', $optionIds)->get(['id', 'slug', 'variant_id']);
        foreach ($options as $item) {
            DB::table('slug_manager')
                ->insert([
                    'slug' => $item->slug,
                    'type' => 'delete',
                    'target_id' => $item->id
                ]);
        }
        DB::table('product_n_variant_option')->whereIn('variant_option_id', $optionIds)->delete();
        DB::table('product_variant_option')->whereIn('id', $optionIds)->delete();
    }
}
