<?php

namespace Modules\CrawlProduct\Controllers;

use DB;
use Illuminate\Http\Request;
use Modules\CrawlProduct\Controllers\Controller;

class RemoveDuplicateTagRefer extends Controller {
    public function deleteDuplicate(Request $request) {
        set_time_limit(5 * 3600);
        ini_set('memory_limit', '2048M');

        $result = [];
        
        $refers = DB::table('tag_refer')
            ->select('tag_id', 'refer_id', DB::raw('count(*) as count'))
            ->where('refer_type', 'PRODUCT')
            ->groupBy('tag_id', 'refer_id')
            ->having(DB::raw('count(*)'), '>', 1)
            ->get();
        foreach ($refers as $item) {
            $refer = DB::table('tag_refer')
                ->where('refer_type', 'PRODUCT')
                ->where('tag_id', $item->tag_id)
                ->where('refer_id', $item->refer_id)
                ->first();
            if ($refer) {
                DB::table('tag_refer')->where('id', $refer->id)->delete();
                $result[] = $refer->id;
            }
        }

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function deleteUnusedTag (Request $request) {
        set_time_limit(3 * 3600);
        ini_set('memory_limit', '2048M');

        $result = [];
        $fromId = 0;
        while(true) {
            $tagIds = DB::table('tag')
                ->leftJoin('tag_refer', 'tag.id', 'tag_refer.tag_id')
                ->where('tag.id', '>', $fromId)
                ->whereNull('tag_refer.tag_id')
                ->limit(100)
                ->get(['tag.id'])
                ->pluck('id')
                ->toArray();
            if (count($tagIds)) {
                $result = array_merge($result, $tagIds);
                $fromId = $tagIds[count($tagIds) - 1];
                $this->deleteTagByIds($tagIds);
            } else {
                break;
            }
        }
        
        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function deleteTagByIds($tagIds) {
        DB::table('tag')->whereIn('id', $tagIds)->delete();
        DB::table('slug_manager')->where('type', 'tag')->whereIn('target_id', $tagIds)->delete();
    }

    public function deleteDuplicateTag (Request $request) {
        $duplicateSlugs = DB::table('tag')
            ->groupBy('trim_slug')
            ->having(DB::raw('count(*)'), '>', 1)
            ->get([DB::raw('trim(trim(both \'-\' from `slug`)) as trim_slug, count(*)')])
            ->pluck('trim_slug');
        foreach ($duplicateSlugs as $slug) {
            $tags = DB::table('tag')
                ->where(DB::raw('trim(trim(both \'-\' from `slug`))'), '=', $slug)
                ->orderBy('id', 'asc')
                ->get(['id', 'slug'])
                ->toArray();
            $keepId = null;

            foreach ($tags as $tag) {
                if ($tag->slug == $slug) {
                    $keepId = $tag->id;
                }
            }

            if (!$keepId) {
                $keepId = $tags[0]->id;
            }

            $deleteIds = [];
            foreach ($tags as $tag) {
                if ($tag->id !== $keepId) {
                    $deleteIds[] = $tag->id;
                }
            }
            $this->deleteTagByIds($deleteIds);
            DB::table('tag_refer')
                ->whereIn('tag_id', $deleteIds)
                ->update([
                    'tag_id' => $keepId
                ]);
        }

        return [
            'status' => 'successful',
            'result' => $duplicateSlugs
        ];
    }
}