<?php

namespace Modules\CrawlProduct\Controllers;

use DB;
use Illuminate\Http\Request;
use Modules\CrawlProduct\Models\Product;
use Modules\CrawlProduct\Models\ProductMeta;

class RemoveSizeImageController extends HomeController
{
    public function getRemoveSizeImageProduct(Request $request) {
        set_time_limit(180);
        
        $query = DB::table('product_crawl_code');

        if ($request->has('fromDate')) {
            $query->where('product_crawl_code.created_at', '>=', $request->get('fromDate'));
        }

        if ($request->has('toDate')) {
            $query->where('product_crawl_code.created_at', '<=', $request->get('toDate'));
        }

        if ($request->has('fromId')) {
            $query->where('product_crawl_code.product_id', '>=', $request->get('fromId'));
        }

        if ($request->has('toId')) {
            $query->where('product_crawl_code.product_id', '<=', $request->get('toId'));
        }
        $query->whereIn('product_crawl_code.site', config('crawl-product::remove-size-img.enable-sites', ['amazon', 'etsy', 'suzuri', 'hawalili', '64hydro']));

        $query->leftJoin('pod_generate_image', 'product_crawl_code.product_id', 'pod_generate_image.product_id');
        $query->leftJoin('pod_generate_image_log', 'product_crawl_code.product_id', 'pod_generate_image_log.product_id');
        $query->whereNull('pod_generate_image.product_id');
        $query->whereNull('pod_generate_image_log.product_id');
        $pageSize = $request->get('page_size', 500);
        $pageId = $request->get('page_id', 0);
        if ($pageSize > 0) {
            $query->limit($pageSize)->offset($pageId * $pageSize);
        }

        $result = $query->get(['product_crawl_code.product_id'])
            ->pluck('product_id')
            ->toArray();

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }
}