<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class AliExpressService extends BaseService
{
    public function parseHTML($htmlStr, $url) {
        ini_set('memory_limit', '2048M');
        $html = str_get_html($htmlStr);

        $variants = $this->getVariants($html);

        $crawlCode = $this->getCrawlCode($url);

        $priceEle = $html->find('.product-price-current', 0);
        $price = 0;
        if ($priceEle) {
            $price = preg_replace("/[^\d\.]+/", '', $priceEle->plaintext);
        }
        $name = $html->find('.pdp-info-right h1', 0);
        $gallery = $this->getGallery($html);
        $result = [
            'name'  => $this->replaceDomain($name->plaintext),
            'slug' => $this->toFriendlyString($this->replaceDomain($name->plaintext)),
            'description'  => $this->getProductMeta($html, 'meta[name="description"]'),
            'content'  => '',
            'image_url'  => array_shift($gallery),
            'galleries'  => $gallery,
            'price'  => $price,
            'high_price'  => '',
            'note'  => 'aliexpress url: ' . $url,
            'crawl_code'  => $crawlCode,
            'site'  => 'aliexpress',
            'comments'  => '',
            'meta_title'  => $name->plaintext,
            'meta_description'  => $this->getProductMeta($html, 'meta[name="description"]'),
            'meta_keywords'  => $this->getProductMeta($html, 'meta[name="keywords"]'),
            'is_fast_shipment' => '',
            'related_products'  => '',
            'variants' => $variants,
            'product_variants' => $this->getProductVariants($variants, $price),
            'tags' => [],
            'store_link' => $this->getStoreLink($html)
        ];

        return $result;
    }

    public function isIgnoreDescription($title) {
        $title = strtolower($title);
        $ignoreKeywords = ['faq', 'feedback', 'ship', 'company', 'certifi'];

        foreach ($ignoreKeywords as $keyword) {
            if (strpos($title, $keyword) !== false) {
                return true;
            }
        }

        return false;
    }


    public function getCrawlCode($url) {
        $url = trim($url);
        preg_match("/\/item\/(\d+)/", $url, $matches);
        $crawlCode = '';
        if (count($matches) > 1) {
            $crawlCode = $matches[1];
        }

        return $crawlCode;
    }

    public function getGallery($html) {
        $retVal = [];
        $items = $html->find('.images-view-list .images-view-item');
        if (!count($items)) {
            $items = $html->find('div[class|="slider--img"]');
        }

        foreach ($items as $item) {
            $img = $item->find('img', 0);
            if ($img && $img->src) {
                $retVal[] = $this->getImageUrl($img->src);
            }
        }

        return $retVal;
    }

    public function getImageUrl($src) {
        $retVal = $src;
        $retVal = preg_replace("/_(\d+)x(\d+)\.jpg_\.webp/", "", $src);

        if (strpos($retVal, '//') === 0) {
            $retVal = 'https:' . $retVal;
        } else if (strpos($retVal, 'http') === false) {
            $retVal = 'https://' . $retVal;
        }

        return $retVal;
    }

    public function getStoreLink($html) {
        $retVal = '';
        $companyEle = $html->find('.company-name', 0);
        if ($companyEle) {
            $href = $companyEle->href;
            if (strpos($href, '?') !== false) {
                $href = substr($href, 0, strpos($href, '?'));
            }
            $retVal = $href;
        }

        return $retVal;
    }

    public function getVariants($html) {
        $variants = [];
        $skuWrap = $html->find('div[class|="sku--wrap"]', 0);
        if ($skuWrap) {
            $variantEles = $html->find('div[class|="sku-item--property"]');
            foreach ($variantEles as $variantEle) {
                $nameEle = $variantEle->find('div[class|="sku-item--title"] span', 0);
                $name = strpos($nameEle->innertext, ':') !== false ? substr($nameEle->innertext, 0, strpos($nameEle->innertext, ':')) : $nameEle->innertext;
                $name = trim($name);
                $variant = [
                    'name' => $name,
                    'slug' => $this->toFriendlyString($name),
                    'type' => strpos(strtolower($name), 'color') !== false ? 'IMAGE' : 'RADIOBOX',
                    'options' => []
                ];
    
                if ($variant['type'] == 'IMAGE') {
                    $optionEles = $variantEle->find('div[class|="sku-item--skus"] div[class|="sku-item--"]');
                    foreach ($optionEles as $optionEle) {
                        $imageEle = $optionEle->find('img', 0);
                        if (!$imageEle) {
                            continue;
                        }
                        $option = [
                            'name' => $imageEle->alt,
                            'slug' => $this->toFriendlyString($imageEle->alt),
                            'image_url' => $this->getImageUrl($imageEle->src),
                            'variant_slug' => $variant['slug']
                        ];
                        $variant['options'][] = $option;
                    }
                } else {
                    $optionEles = $variantEle->find('div[class|="sku-item--skus"] div[class|="sku-item--"]');
                    foreach ($optionEles as $optionEle) {
                        $name = trim($optionEle->title);
                        $option = [
                            'name' => $name,
                            'slug' => $this->toFriendlyString($name),
                            'image_url' => null,
                            'variant_slug' => $variant['slug']
                        ];
                        $variant['options'][] = $option;
                    }
                }
                $variants[] = $variant;
            }
        }

        return $variants;
    }

    public function getProductVariants($variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                if (!empty($option['image_url'])) {
                    $itemVariant['image_url'] = $option['image_url'];
                }
                $options[] = $option;
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('product on aliexpress.com', '', $content);
        $content = str_ireplace('aliexpress.com', '', $content);
        $retVal = str_ireplace('aliexpress', '', $content);
        return trim($retVal);
    }
}