<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

use Modules\CrawlProduct\Controllers\Impl\ImageDownloader;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class AlibabaService extends BaseService
{
    private $imageDownloader;
    
    public function __construct($input) {
        parent::__construct($input);
        $this->imageDownloader = new ImageDownloader();
    }

    public function parseHTML($htmlStr, $url) {
        ini_set('memory_limit', '2048M');
        $html = str_get_html($htmlStr);

        $variants = $this->getVariants($html);

        $crawlCode = $this->getCrawlCode($html, $url);

        $priceEle = $html->find('.product-price .price-item .price .promotion', 0);
        if ($priceEle) {
            $price = preg_replace("/[^\d\.]+/", '', $priceEle->plaintext);
        } else {
            $priceEle = $html->find('#ladderPrice .ma-ladder-price-item .ma-price-promotion', 0);
            if ($priceEle) {
                $priceStr = $priceEle->plaintext;
                if (strpos($priceStr, '-') !== false) {
                    $priceStr = substr($priceEle->plaintext, 0, strpos($priceEle->plaintext, '-'));
                }
                $price = preg_replace("/[^\d\.]+/", '', $priceStr);
            } else {
                $priceEle = $html->find('.product-price .price', 0);
                $priceStr = $priceEle->plaintext;
                if (strpos($priceStr, '-') !== false) {
                    $priceStr = substr($priceEle->plaintext, 0, strpos($priceEle->plaintext, '-'));
                }
                $price = preg_replace("/[^\d\.]+/", '', $priceStr);
            }
        }
        $name = $html->find('h1', 0);
        $gallery = $this->getGallery($html);
        $result = [
            'name'  => $this->replaceDomain($name->plaintext),
            'slug' => $this->toFriendlyString($this->replaceDomain($name->plaintext)),
            'description'  => $this->getDescription($html),
            'content'  => '',
            'image_url'  => array_shift($gallery),
            'galleries'  => $gallery,
            'price'  => $price,
            'high_price'  => '',
            'note'  => 'Alibaba url: ' . $url,
            'crawl_code'  => $crawlCode,
            'site'  => 'alibaba',
            'comments'  => '',
            'meta_title'  => $name->plaintext,
            'meta_description'  => $this->getProductMeta($html, 'meta[name="description"]'),
            'meta_keywords'  => $this->getProductMeta($html, 'meta[name="keywords"]'),
            'is_fast_shipment' => '',
            'related_products'  => '',
            'variants' => $variants,
            'product_variants' => $this->getProductVariants($variants, $price),
            'tags' => [],
            'store_link' => $this->getStoreLink($html)
        ];

        if (!$this->getGallery) {
            $data['galleries'] = [];
        }

        $videoEle = $html->find('#module_main_image video', 0);
        if (!$videoEle) {
            $videoEle = $html->find('#main-video video', 0);
        }
        if ($videoEle) {
            $source = $videoEle->find('source', 0);
            if ($source) {
                $videoSrc = $this->getVideoSrc($source->src);
            } else {
                $videoSrc = $this->getVideoSrc($videoEle->src);
            }
            $result['videos'] = [];
            $result['videos'][] = [
                'src' => $videoSrc,
                'image_url' => $this->getImageUrl($videoEle->poster)
            ];
        }

        return $result;
    }

    public function isIgnoreDescription($title) {
        $title = strtolower($title);
        $ignoreKeywords = ['faq', 'feedback', 'ship', 'company', 'certifi'];

        foreach ($ignoreKeywords as $keyword) {
            if (strpos($title, $keyword) !== false) {
                return true;
            }
        }

        return false;
    }

    public function getDescription($html) {
        $description = '';
        $descriptionEles = $html->find('#detail_decorate_root > div');
        if (count($descriptionEles)) {
            foreach ($descriptionEles as $descriptionEle) {
                $links = $descriptionEle->find('a');
                foreach ($links as &$link) {
                    $link->outertext = $link->innertext;
                }
                if (
                    $descriptionEle->{'module-title'} 
                    && $descriptionEle->{'module-title'} != 'detailSellerRecommend'
                    && $descriptionEle->{'module-title'} != 'detailProductNavigation'
                ) {
                    $description .= $descriptionEle->outertext; 
                }
            }
        } else {
            $descriptionEle = $html->find('#J-rich-text-description', 0);
            if ($descriptionEle) {
                $children = $descriptionEle->children();
                foreach ($children as $child) {
                    if (
                        !$child->{'data-section-title'}
                        || !$this->isIgnoreDescription($child->{'data-section-title'})
                    ) {
                        $description .= $child->outertext; 
                    }
                }
            } else {
                $descriptionEle = $html->find('#module_product_specification', 0);
                if ($descriptionEle) {
                    $description = $descriptionEle->outertext;
                }
            }
        }

        $description = $this->replaceDescriptionClass($description);

        if (config('crawl-product::sa.is_download_image', true)) {
            $description = $this->downloadDescriptionImage($description);
        }

        return $description;
    }

    public function replaceDescriptionClass($descriptionHtml) {
        $html = str_get_html($descriptionHtml);
        $elements = $html->find('*');
        foreach ($elements as $element) {
            if ($element->getAttribute('class')) {
                $classNames = explode(' ', $element->getAttribute('class'));
                foreach ($classNames as &$className) {
                    $className = 'product_description_prefix_' . $className;
                }
                $element->setAttribute('class', implode(' ', $classNames));
            }
        }

        return $html->save();
    }

    public function downloadDescriptionImage($descriptionHtml) {
        $html = str_get_html($descriptionHtml);
        $elements = $html->find('img');
        foreach ($elements as &$element) {
            if ($element->{'data-src'}) {
                $imageUrl = $this->getImageUrl($element->{'data-src'});
                $imageUrl = $this->imageDownloader->downloadImage($imageUrl);
                if ($imageUrl) {
                    $element->{'data-src'} = $imageUrl;
                    $element->{'src'} = $imageUrl;
                }
            } else if ($element->src) {
                $imageUrl = $this->getImageUrl($element->src);
                $imageUrl = $this->imageDownloader->downloadImage($imageUrl);
                if ($imageUrl) {
                    $element->src = $imageUrl;
                }
            }

        }

        return $html->save();
    }

    public function getCrawlCode($html, $url) {
        $url = trim($url);
        preg_match("/_(\d+).html/", $url, $matches);
        $crawlCode = '';
        if (count($matches) > 1) {
            $crawlCode = $matches[1];
        }

        if (!$crawlCode) {
            preg_match("/\/product\/([\d-]+)\//", $url, $matches);
            if (count($matches) > 1) {
                $crawlCode = $matches[1];
            }
        }

        return $crawlCode;
    }

    public function getGallery($html) {
        $retVal = [];
        $items = $html->find('.main-image-thumb-item');
        if (!count($items)) {
            $items = $html->find('.main-list > .main-item');
        }
        foreach ($items as $item) {
            if (!$item->find('.mask', 0)
                && !$item->find('.video-icon', 0)
            ) {
                $img = $item->find('img', 0);
                if ($img) {
                    $retVal[] = $this->getImageUrl($img->src);
                }
            }
        }

        return $retVal;
    }

    public function getVideoSrc($src) {
        $retVal = $src;
        if (strpos($src, '.mp4?') !== false) {
            $retVal = substr($src, 0, strpos($src, '.mp4?')) . '.mp4';
        } 

        if (strpos($retVal, '//') === 0) {
            $retVal = 'https:' . $retVal;
        } else if (strpos($retVal, 'http') === false) {
            $retVal = 'https://' . $retVal;
        }

        return $retVal;
    }

    public function getImageUrl($src) {
        $retVal = $src;
        if (strpos($src, '.jpg_') !== false) {
            $retVal = substr($src, 0, strpos($src, '.jpg_')) . '.jpg';
        } else if (strpos($src, '.jpeg_') !== false) {
            $retVal = substr($src, 0, strpos($src, '.jpeg_')) . '.jpeg';
        } else if (strpos($src, '.png_') !== false) {
            $retVal = substr($src, 0, strpos($src, '.png_')) . '.png';
        } 

        if (strpos($retVal, '//') === 0) {
            $retVal = 'https:' . $retVal;
        } else if (strpos($retVal, 'http') === false) {
            $retVal = 'https://' . $retVal;
        }

        return $retVal;
    }

    public function getStoreLink($html) {
        $retVal = '';
        $companyEle = $html->find('.company-name', 0);
        if ($companyEle) {
            $href = $companyEle->href;
            if (strpos($href, '?') !== false) {
                $href = substr($href, 0, strpos($href, '?'));
            }
            $retVal = $href;
        }

        return $retVal;
    }

    public function getVariants($html) {
        $variants = [];
        $skuWrap = $html->find('#skuWrap', 0);
        if ($skuWrap) {
            $variantEles = $html->find('.sku-attr-dl');
            foreach ($variantEles as $variantEle) {
                $name = $variantEle->find('.name', 0);
                $variant = [
                    'name' => $name->title,
                    'slug' => $this->toFriendlyString($name->title),
                    'type' => strpos($variantEle->class, 'IMAGE') !== false ? 'IMAGE' : 'RADIOBOX',
                    'options' => []
                ];
    
                if ($variant['type'] == 'IMAGE') {
                    $optionEles = $variantEle->find('.sku-attr-val-item');
                    foreach ($optionEles as $optionEle) {
                        $nameEle = $optionEle->find('.sku-attr-val-frame', 0);
                        $imageEle = $optionEle->find('img', 0);
                        $option = [
                            'name' => $nameEle->title,
                            'slug' => $this->toFriendlyString($nameEle->title),
                            'image_url' => $this->getImageUrl($imageEle->src),
                            'variant_slug' => $variant['slug']
                        ];
                        $variant['options'][] = $option;
                    }
                } else {
                    $optionEles = $variantEle->find('.sku-attr-val-frame');
                    foreach ($optionEles as $optionEle) {
                        $nameEle = $optionEle->find('span', 0);
                        $option = [
                            'name' => $nameEle->plaintext,
                            'slug' => $this->toFriendlyString($nameEle->plaintext),
                            'image_url' => null,
                            'variant_slug' => $variant['slug']
                        ];
                        $variant['options'][] = $option;
                    }
                }
                $variants[] = $variant;
            }
        } else {
            $variantEles = $html->find('.main-attr .sku-item');
            foreach ($variantEles as $variantEle) {
                $nameEle = $variantEle->find('label', 0);
                $variant = [
                    'name' => $nameEle->plaintext,
                    'slug' => $this->toFriendlyString($nameEle->plaintext),
                    'type' => 'RADIOBOX',
                    'options' => []
                ];

                $optionEles = $variantEle->find('.sku-option');
                foreach ($optionEles as $optionEle) {
                    $img = $optionEle->find('img', 0);
                    if ($img) {
                        $variant['type'] = 'IMAGE';
                        $option = [
                            'name' => $img->title,
                            'slug' => $this->toFriendlyString($img->title),
                            'image_url' => substr($img->src, 0, strpos($img->src, '_100x100')),
                            'variant_slug' => $variant['slug']
                        ];
                        $variant['options'][] = $option;
                    } else {
                        $nameEle = $optionEle->find('.txt', 0);
                        if ($nameEle) {
                            $option = [
                                'name' => $nameEle->plaintext,
                                'slug' => $this->toFriendlyString($nameEle->plaintext),
                                'image_url' => null,
                                'variant_slug' => $variant['slug']
                            ];
                            $variant['options'][] = $option;
                        }
                    }
                }
                $variants[] = $variant;
            }
        }

        return $variants;
    }

    public function getProductVariants($variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                if (!empty($option['image_url'])) {
                    $itemVariant['image_url'] = $option['image_url'];
                }
                $options[] = $option;
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('product on alibaba.com', '', $content);
        $content = str_ireplace('alibaba.com', '', $content);
        $retVal = str_ireplace('alibaba', '', $content);
        return trim($retVal);
    }
}