<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 5/26/21
 * Time: 3:11 PM
 */

namespace App\Modules\CrawlProduct\Controllers\Services;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use Modules\CrawlProduct\Models\Product;
use Modules\CrawlProduct\Models\CrawlLog;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class AmazonService extends BaseService
{
    public $config = [];
    public $strClickReplace = ['Click to select', 'Wählen Sie ', ' durch Klicken aus', 'Cliquez pour sélectionner', 'Haz clic para seleccionar', 'Clicca per selezionare', 'Clique para selecionar', 'を選択するにはクリックしてください', 'を選択するにはクリックしてください'];
    public $input = [];
    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function crawl ($url) {
//        $url = 'http://lumtest.com/myip.json';
        $parsed = parse_url($url);
        if (isset($parsed['query'])) {
            $partUrl = strtok($url, '?');
            $query = $parsed['query'];
            parse_str($query, $params);
            foreach ($params as $key => $param) {
                if (strpos($key, '__mk_') !== false) {
                    unset($params[$key]);
                }
            }
            if (Input::get('country_code') == 'pt') {
                $params['language'] = 'pt_PT';
            }
            $url = $partUrl . '?' . http_build_query($params);
        } else {
            if (Input::get('country_code') == 'pt') {
                $url .= '?language=pt_PT';
            }
        }
//        $context = $this->getContext();
//        $html = file_get_html($url, false, $context);
        $htmlStr = $this->getHtml($url);
//        try {
//            $html = file_get_html($url, false, $context);
//        } catch (\Exception $exception) {
//            return [
//                'message' => 'File: ' . $exception->getFile() . '. Line: ' . $exception->getLine() . '. Message: ' . $exception->getMessage()
//            ];
//        }
        return $this->parseHTML($htmlStr, $url);
    }

    public function parseHTML($htmlStr, $url) {
        $this->config = $this->getConfig();
        $domain = $this->parseUrl($url);
        $html = str_get_html($htmlStr);
        $comments = $this->getComment($html);
        $arrayImage = $this->getImages($html);
        $imageUrl = '';
        if ($html->find('div[id=imgTagWrapperId] img', 0)) {
            if ($html->find('div[id=imgTagWrapperId] img', 0)->{"data-old-hires"}) {
                $imageUrl = $html->find('div[id=imgTagWrapperId] img', 0)->{"data-old-hires"};
            } else {
                $imageUrl = $html->find('div[id=imgTagWrapperId] img', 0)->src;
                if ($imageUrl) {
                    $arrImage = explode('.', $imageUrl);
                    if (count($arrImage) >= 5) {
                        unset($arrImage[count($arrImage) - 2]);
                    }
                    $imageUrl = implode('.', $arrImage);
                }
            }
        }
        if ($arrayImage['mainColor'] && isset($arrayImage['colorImages'][$arrayImage['mainColor']])) {
            $imageUrl = $this->getMaxSizeImage($arrayImage['colorImages'][$arrayImage['mainColor']][0]);
        }
        $content = $html->find('div[id=productDescription]', 0) ? trim($html->find('div[id=productDescription]', 0)->plaintext) : '';
        $content .= $html->find('div[id=detailBullets_feature_div]', 0) ? $html->find('div[id=detailBullets_feature_div]', 0)->outertext : '';
        $content = trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', mb_convert_encoding( $content, "UTF-8" )));
        $asin = $this->getAsin($html);
        $name = $html->find('span[id=productTitle]', 0) ? trim($html->find('span[id=productTitle]', 0)->plaintext) : '';
        $name = trim(htmlspecialchars_decode(preg_replace('/(\([^(]+\))/', '', $name)));
        $name = $this->replaceDomain($name);
        $allAsin = $this->getAllAsin($html);
        $allAsin[] = $asin;
        $data = [
            'name' => $name,
            'description' => $this->getDescription($html),
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => $this->getImageBlock($html),
            'price' => $this->getPrice($html),
            'high_price' => 0,
            'note' => 'Amazon url: ' . $url,
            'crawl_code' => $asin,
            'site' => 'amazon',
            'comments' => $comments,
            'meta_title' => $this->getProductMeta($html, 'meta[name=title]'),
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'is_fast_shipment' => 0,
            'related_products' => [],
            'store_link' => $this->getStoreLink($html),
        ];
        if (!$this->getGallery) {
            $data['galleries'] = [];
        }
        if ($name) {
//            $data['is_fast_shipment'] = $this->getIsFastShipment($name, $allAsin, $domain);
            if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                $data['slug'] = $this->toFriendlyString($name);
            }
        }
        if (Input::get('is_crawl_related')) {
            $data['related_products'] = $this->getRelatedProducts($html, $domain);
        }
        $attributes = [
            [
                'name' => 'Type',
                'slug' => 'type',
                'options' => $this->getFitTypes($html)
            ],
            [
                'name' => 'Color',
                'slug' => 'color',
                'options' => $this->getColors($html)
            ],
            [
                'name' => 'Style',
                'slug' => 'style',
                'options' => $this->getStyles($html)
            ],
            [
                'name' => 'Size',
                'slug' => 'size',
                'options' => $this->getSizes($html)
            ],
            [
                'name' => 'Material Type',
                'slug' => 'material-type',
                'options' => $this->getMaterialTypes($html)
            ]
        ];
        $variantsKey = [];
        $variants = [];
        $data['variants'] = [];
        foreach ($attributes as $attribute) {
            if ($attribute['options']) {
                $data['variants'][] = $attribute;
                $variantsKey[] = array_keys($attribute['options']);
                $variants[] = $attribute;
            }
        }
        $productVariants = [];
        $combinations = $this->combinations($variantsKey);
        foreach ($combinations as $listKey) {
            if (!is_array($listKey)) {
                $listKey = [$listKey];
            }
            $keyImage = [];
            $arrVariants = [];
            $variantPrice = $data['price'];
            foreach ($listKey as $key => $value) {
                $variant = $variants[$key]['options'][$value];
                if (!empty($variant['key_image'])) {
                    $keyImage[] = $variant['name'];
                }
                $arrVariants[] = [
                    'variant_slug' => $variants[$key]['slug'],
                    'slug' => $variant['slug'],
                ];
                if (!empty($variant['price'])) {
                    $variantPrice = $variant['price'];
                }
            }
            $galleries = [];
            if ($keyImage) {
                $keyImages = $this->combinationOneArray($keyImage);
                $keyImages = array_reverse($keyImages);
                foreach($keyImages as $keys) {
                    $galleries = $this->getGalleryByKey($arrayImage['colorImages'], $keys);
                    if (count($galleries)) {
                        break;
                    }
                }
            }
            $itemVariant = [
                'image_url' => array_shift($galleries),
                'galleries' => $galleries,
                'price' => $variantPrice,
                'high_price' => 0,
                'variants' => $arrVariants
            ];
            if (!$this->getGallery) {
                $itemVariant['galleries'] = [];
            }
            if (!$itemVariant['image_url']) {
                $itemVariant['image_url'] = $data['image_url'];
            }
            $productVariants[] = $itemVariant;
        }
        $data['product_variants'] = $productVariants;
        $data['videos'] = $this->getVideos($html);
        return $data;
    }

    private function combinationOneArray($array) {
        // initialize by adding the empty set
        $results = array(array( ));
    
        foreach ($array as $element) {
            foreach ($results as $combination) {
                array_push($results, array_merge($combination, array($element)));
            }
        }

        array_shift($results);
    
        return $results;
    }

    private function getRelatedProducts ($html, $domain) {
        $retVal = [];
        $items = $html->find('div[id=sims-consolidated-1_feature_div] ol.a-carousel li.a-carousel-card');
        if (count($items) == 0) {
            $items = $html->find('div[id=sims-consolidated-2_feature_div] ol.a-carousel li.a-carousel-card');
        }
        if (count($items) == 0) {
            $items = $html->find('div[id=sims-consolidated-3_feature_div] ol.a-carousel li.a-carousel-card');
        }
        foreach ($items as $item) {
            $link = $item->find('a.a-link-normal', 0);
            if ($link && $link->href) {
                $url = $link->href;
                if (strpos($url, $domain) !== 0) {
                    $url = $domain . $url;
                }
                $url = str_replace('&amp;', '&', $url);
                $retVal[] = $url;
            }
        }
        return $retVal;
    }

    private function getIsFastShipment ($name, $allAsin, $domain) {
        $retVal = 0;
        $urlSearch = $domain . '/s?' . http_build_query(['k' => $name]);
        //$htmlSearch = file_get_html($urlSearch, false, $context);
        $htmlSearch = $this->getHtml($urlSearch);
        $htmlSearch = str_get_html($htmlSearch);
        $elementSearchs = $htmlSearch->find('div[data-component-type=s-search-result]');
        foreach ($elementSearchs as $elementSearch) {
            $dataAsin = $elementSearch->attr['data-asin'];
            if (in_array($dataAsin, $allAsin)) {
                if ($elementSearch->find('i.a-icon-prime', 0)) {
                    $retVal = 1;
                }
                break;
            }
        }
        return $retVal;
    }

    private function getAllAsin ($html) {
        $retVal = [];
        $elementScript = $html->find('#twisterJsInitializer_feature_div', 0);
        if ($elementScript) {
            $asinText = $elementScript->outertext;
            $re = '/"dimensionToAsinMap" : {([^{]+)}/m';
            preg_match_all($re, $asinText, $matches, PREG_SET_ORDER, 0);
            if (isset($matches[0][1])) {
                $arr = explode(',', $matches[0][1]);
                foreach ($arr as $item) {
                    $arrItem = explode(':', $item);
                    if (isset($arrItem[1])) {
                        $retVal[] = str_replace('"', '', $arrItem[1]);
                    }
                }
            }
        }
        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $arrPrefix = ['Amazon.com:', 'Amazon:', 'amazon.com:', 'amazon:', 'Amazon.fr:', 'amazon.fr:', 'Amazon.co.uk:', 'amazon.co.uk:', 'Amazon.ca:', 'amazon.ca:', 'Amazon.com.au:', 'amazon.com.au:',
            'Amazon.de:', 'amazon.de:', 'Amazon.es:', 'amazon.es:', 'Amazon.it:', 'amazon.it:', 'Amazon.co.jp:', 'amazon.co.jp:'];
        foreach ($arrPrefix as $prefix) {
            if (substr($content, 0, strlen($prefix)) == $prefix) {
                $content = substr($content, strlen($prefix));
            }
        }
        $content = str_ireplace('amazon.com', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.fr', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.co.uk', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.ca', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.com.au', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.de', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.es', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.it', $_SERVER['SERVER_NAME'], $content);
        $content = str_ireplace('amazon.co.jp', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('amazon', $_SERVER['SERVER_NAME'], $content);
        return trim($retVal);
    }

    private function getDescription ($html) {
        $description = $html->find('div[id=feature-bullets] .a-unordered-list', 0) ? trim($html->find('div[id=feature-bullets] .a-unordered-list', 0)->outertext) : '';
        $description = $this->replaceDomain($description);
        $description = preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", $description);
        return trim($description);
    }

    private function getContext ($countryCode = '') {
        if (!$countryCode) {
            $countryCode = Input::get('country_code', 'us');
        }
        $configProxy = config('crawl-product::sa.proxy');
        $context = [];
        if ($configProxy) {
            $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
            $auth = base64_encode($proxy['username'] . ':' . $proxy['password']);
            $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36';
            if (Schema::hasTable('user_agent')) {
                $rand = mt_rand(1, 1000);
                $userAgentObj = DB::table('user_agent')->where('id', '=', $rand)->first();
                if ($userAgentObj) {
                    $userAgent = $userAgentObj->user_agent;
                }
            }

            $context = array(
                'http'=>array(
                    'method' => 'GET',
                    'proxy'           => $proxy['url'],
                    'request_fulluri' => true,
                    'header'          => "Proxy-Authorization: Basic $auth\r\n" .
                        "User-Agent: $userAgent\r\n"
                ),
            );
        }
        return $context;
    }

    private function getGalleryByKey ($listImage, $key) {
        $galleries = [];
        $keyImageStr = implode(' ', $key);
        $keyImageStr = str_replace('&quot;', '"', $keyImageStr);
        $keyImageStr = str_replace('&amp;', '&', $keyImageStr);
        if (isset($listImage[$keyImageStr])) {
            $galleries = $this->getGalleries($listImage[$keyImageStr]);
        } else {
            $keyImageStr = str_replace('/', '\/', $keyImageStr);
            if (isset($listImage[$keyImageStr])) {
                $galleries = $this->getGalleries($listImage[$keyImageStr]);
            }
        }
        if (!empty($this->input['remove_size_chart'])) {
            $galleries = $this->removeSizeGalleries($galleries);
        }
        return $galleries;
    }

    private function getPrice ($html) {
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '$';
        $elements = [
            'span[id=priceblock_ourprice]',
            'span[id=priceblock_saleprice]',
            'span[id=priceblock_dealprice]',
            'span.a-text-price > span.a-offscreen',
            'span.a-text-price'
        ];

        $retVal = 0;
        foreach ($elements as $element) {
            $priceElm = $html->find($element, 0);
            if ($priceElm) {
                $priceStr = $priceElm->plaintext;
                if ($priceStr) {
                    $explodePrice = explode(' - ', $priceStr);
                    $price = str_replace($currency, '', $explodePrice[0]);
                    if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                        $price = str_replace(',', '', $price);
                    } else {
                        $price = str_replace(',', '.', $price);
                    }
                    $price = preg_replace("/[^0-9.,]/", "", $price);
                    $retVal = floatval($price);
                    if ($retVal > 0) {
                        break;
                    }
                }
            }
        }
        return $retVal;
    }

    private function getSizes ($html) {
        $retVal = [];
        $options = $html->find('select[id=native_dropdown_selected_size_name] option');
        foreach ($options as $key => $option) {
            if ($key > 0) {
                $retVal[] = [
                    'name' => htmlspecialchars_decode(trim($option->plaintext)),
                    'slug' => $this->toFriendlyString(trim($option->plaintext)),
                    'type' => 'RADIOBOX'
                ];
            }
        }
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        if (!$retVal) {
            $sizes = $html->find('div[id=variation_size_name] ul li');
            foreach ($sizes as $key => $size) {
                $sizeName = trim(str_replace($this->strClickReplace, '', $size->title));
                $price = 0;
                if ($size->find('.twisterSwatchPrice', 0)) {
                    $price = $size->find('.twisterSwatchPrice', 0)->plaintext;
                    $price = str_replace($currency, '', $price);
                    $price = floatval($price);
                }
                $retVal[] = [
                    'name' => htmlspecialchars_decode($sizeName),
                    'slug' => $this->toFriendlyString($sizeName),
                    'type' => 'RADIOBOX',
                    'key_image' => 1,
                    'price' => $price
                ];
            }
            if (!$retVal) {
                $sizeDefault = $html->find('div[id=variation_size_name] span[class=selection]', 0);
                if ($sizeDefault) {
                    $sizeName = $sizeDefault->plaintext;
                    $retVal[] = [
                        'name' => htmlspecialchars_decode($sizeDefault->plaintext),
                        'slug' => $this->toFriendlyString($sizeName),
                        'type' => 'RADIOBOX',
                        'key_image' => 1
                    ];
                }
            }
        }

        if (!count($retVal)) {
            $elements = $html->find('div[id=inline-twister-expander-content-size_name] div[id=tp-inline-twister-dim-values-container] ul li.swatch-list-item-text-selector');
            if ($elements) {
                foreach($elements as $element) {
                    $ele = $element->find('.swatch-title-text-display', 0);
                    if ($ele) {
                        $name = htmlspecialchars_decode(trim($ele->plaintext));
                        if ($name) {
                            $retVal[] = [
                                'name' => $name,
                                'slug' => $this->toFriendlyString($name),
                                'type' => 'RADIOBOX',
                                'key_image' => 1
                            ];
                        }
                    }
                }
            }
            if (!count($retVal)) {
                $elements = $html->find('div[id=inline-twister-expander-content-size_name] div[id=tp-inline-twister-dim-values-container] ul li.swatch-list-item-text');
                if ($elements) {
                    foreach($elements as $element) {
                        $ele = $element->find('.swatch-title-text-display', 0);
                        if ($ele) {
                            $name = htmlspecialchars_decode(trim($ele->plaintext));
                            if ($name) {
                                $retVal[] = [
                                    'name' => $name,
                                    'slug' => $this->toFriendlyString($name),
                                    'type' => 'RADIOBOX',
                                    'key_image' => 1
                                ];
                            }
                        }
                    }
                }
            }
            if (!count($retVal)) {
                $element = $html->find('span[id=inline-twister-expanded-dimension-text-fit_type]', 0);
                if ($element) {
                    $name = htmlspecialchars_decode(trim($element->plaintext));
                    if ($name) {
                        $retVal[] = [
                            'name' => $name,
                            'slug' => $this->toFriendlyString($name),
                            'type' => 'RADIOBOX',
                            'key_image' => 1
                        ];
                    }
                }
            }
        }

        return $retVal;
    }

    private function getGalleries ($arrayImage) {
        $retVal = [];
        foreach ($arrayImage as $item) {
            $retVal[] = $this->getMaxSizeImage($item);
        }
        return $retVal;
    }

    private function getColors ($html) {
        $retVal = [];
        $colors = $html->find('div[id=variation_color_name] ul li');
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        foreach ($colors as $key => $color) {
            if ($color->find('img.imgSwatch', 0)) {
                $colorName = trim($color->find('img.imgSwatch', 0)->alt);
            } else {
                $colorName = trim(str_replace($this->strClickReplace, '', $color->title));
            }
            $colorName = htmlspecialchars_decode($colorName);
            $imageElm = $color->find('img', 0);
            $price = 0;
            if ($color->find('.addTwisterPadding p', 0)) {
                $price = $color->find('.addTwisterPadding p', 0)->plaintext;
                $price = str_replace($currency, '', $price);
                $price = floatval($price);
            }

            $imageUrl = '';
            if ($imageElm) {
                $imageUrl = $imageElm->src;
                $imageUrl = $this->replaceImageUrl($imageUrl);
            }
            if ($colorName) {
                $retVal[] = [
                    'name' => $colorName,
                    'slug' => $this->toFriendlyString($colorName),
                    'type' => 'IMAGE',
                    'image_url' => $imageUrl,
                    'key_image' => 1,
                    'price' => $price
                ];
            }
        }
        if (!count($retVal)) {
            $element = $html->find('div[id=variation_color_name] .selection', 0);
            if ($element) {
                $colorName = htmlspecialchars_decode($element->plaintext);
                if ($colorName) {
                    $retVal[] = [
                        'name' => $colorName,
                        'slug' => $this->toFriendlyString($colorName),
                        'type' => 'IMAGE',
                        'image_url' => '',
                        'key_image' => 1,
                        'price' => 0
                    ];
                }

            }
        }

        if (!$retVal) {
            $colors = $html->find('div[id=tp-inline-twister-dim-values-container] ul li');

            foreach ($colors as $color) {
                $img = $color->find('img.swatch-image', 0);
                if ($img) {
                    $colorName = htmlspecialchars_decode($img->alt);
                    $imageUrl = $this->replaceImageUrl($img->src);
                    if ($colorName) {
                        $retVal[] = [
                            'name' => $colorName,
                            'slug' => $this->toFriendlyString($colorName),
                            'type' => 'IMAGE',
                            'image_url' => $imageUrl,
                            'key_image' => 1,
                            'price' => 0
                        ];
                    }
                }
            }

            if (!count($retVal)) {
                $element = $html->find('div[id=inline-twister-expanded-dimension-text-color_name]', 0);
                if ($element) {
                    $name = htmlspecialchars_decode(trim($element->plaintext));
                    if ($name) {
                        $retVal[] = [
                            'name' => $name,
                            'slug' => $this->toFriendlyString($name),
                            'type' => 'IMAGE',
                            'image_url' => '',
                            'key_image' => 1,
                            'price' => 0
                        ];
                    }
                }
            }
        }
        return $retVal;
    }

    public function replaceImageUrl($imageUrl) {
        $imageUrl = trim($imageUrl);
        $imageUrl = str_replace('._SX38_SY50_CR,0,0,38,50_', '', $imageUrl);
        $imageUrl = str_replace('._SS36_.', '.', $imageUrl);
        return $imageUrl;
    }

    private function getStyles ($html) {
        $retVal = [];
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        $styles = $html->find('div[id=variation_style_name] ul li');
        foreach ($styles as $key => $style) {
            $styleName = trim(str_replace($this->strClickReplace, '', $style->title));
            $price = 0;
            if ($style->find('.twisterSwatchPrice', 0)) {
                $price = $style->find('.twisterSwatchPrice', 0)->plaintext;
                $price = str_replace($currency, '', $price);
                $price = floatval($price);
            }
            $retVal[] = [
                'name' => htmlspecialchars_decode($styleName),
                'slug' => $this->toFriendlyString($styleName),
                'type' => 'RADIOBOX',
                'key_image' => 1,
                'price' => $price
            ];

        }
        return $retVal;
    }

    private function getMaterialTypes ($html) {
        $retVal = [];
        $options = $html->find('select[id=native_dropdown_selected_material_type] option');
        foreach ($options as $key => $option) {
            $retVal[] = [
                'name' => htmlspecialchars_decode(trim($option->plaintext)),
                'slug' => $this->toFriendlyString(trim($option->plaintext)),
                'type' => 'RADIOBOX',
                'key_image' => 1,
            ];
        }
        return $retVal;
    }

    private function getFitTypes ($html) {
        $retVal = [];
        $fitTypesText = [];
        $fitType = $html->find('div[id=variation_fit_type]', 0);
        if ($fitType) {
            $ulFitType = $fitType->find('ul', 0);
            if ($ulFitType) {
                $liFitTypes = $ulFitType->find('li');
                foreach ($liFitTypes as $li) {
                    $fitTypesText[] = trim($li->plaintext);
                }
            } else {
                $fitTypesText[] = $fitType->find('span[class=selection]', 0)->plaintext;
            }
            foreach ($fitTypesText as $item) {
                $retVal[] = [
                    'name' => htmlspecialchars_decode($item),
                    'slug' => $this->toFriendlyString($item),
                    'type' => 'RADIOBOX',
                    'key_image' => 1
                ];
            }
        }

        if (!count($retVal)) {
            $elements = $html->find('div[id=inline-twister-expander-content-fit_type] div[id=tp-inline-twister-dim-values-container] ul li.swatch-list-item-text-selector');
            if ($elements) {
                foreach($elements as $element) {
                    $ele = $element->find('.swatch-title-text-display', 0);
                    if ($ele) {
                        $name = htmlspecialchars_decode(trim($ele->plaintext));
                        if ($name) {
                            $retVal[] = [
                                'name' => $name,
                                'slug' => $this->toFriendlyString($name),
                                'type' => 'RADIOBOX',
                                'key_image' => 1
                            ];
                        }
                    }
                }
            }
            if (!count($retVal)) {
                $elements = $html->find('div[id=inline-twister-expander-content-fit_type] div[id=tp-inline-twister-dim-values-container] ul li.swatch-list-item-text');
                if ($elements) {
                    foreach($elements as $element) {
                        $ele = $element->find('.swatch-title-text-display', 0);
                        if ($ele) {
                            $name = htmlspecialchars_decode(trim($ele->plaintext));
                            if ($name) {
                                $retVal[] = [
                                    'name' => $name,
                                    'slug' => $this->toFriendlyString($name),
                                    'type' => 'RADIOBOX',
                                    'key_image' => 1
                                ];
                            }
                        }
                    }
                }
            }
            if (!count($retVal)) {
                $element = $html->find('span[id=inline-twister-expanded-dimension-text-fit_type]', 0);
                if ($element) {
                    $name = htmlspecialchars_decode(trim($element->plaintext));
                    if ($name) {
                        $retVal[] = [
                            'name' => $name,
                            'slug' => $this->toFriendlyString($name),
                            'type' => 'RADIOBOX',
                            'key_image' => 1
                        ];
                    }
                }
            }
        }

        return $retVal;
    }

    private function getMaxSizeImage ($arr) {
        if (isset($arr['hiRes'])) {
            return $arr['hiRes'];
        } else if (isset($arr['large'])) {
            return $arr['large'];
        }
        return '';
    }

    private function getImages ($html) {
        $retVal = [
            'mainColor' => '',
            'colorImages' => []
        ];
        try {
            $re = '/var obj = jQuery.parseJSON\(\'(.*)\'\)/m';
            $str = $html->find('div[id=imageBlockVariations_feature_div] script', 0)->innertext;
            $str = str_replace('\\\\\\', '\\', $str);
            $str = str_replace('&quot;', '\"', $str);
            preg_match_all($re, $str, $matches, PREG_SET_ORDER, 0);
            $arrayInJson = $matches[0][1];
            $array = json_decode($arrayInJson, true);
            if ($array === null && json_last_error() !== JSON_ERROR_NONE) {
                $arrayInJson = str_replace('\\', '', $arrayInJson);
                $array = json_decode($arrayInJson, true);
            }
            $retVal = [
                'mainColor' => $array['landingAsinColor'],
                'colorImages' => $array['colorImages']
            ];
        } catch (\Exception $exception) {
        }
        return $retVal;

    }

    private function getImageBlock ($html) {
        $retVal = [];
        $scripts = $html->find('div[id=imageBlock_feature_div] script');

        foreach ($scripts as $script) {
            if (strpos($script->innertext, "'colorImages'") > -1) {
                $re = '/hiRes":"([^"]+)"/';
                $str = $script->innertext;
                $retVal = $this->regexGetImageBlock($str, $re);
                if (!$retVal) {
                    $re = '/large":"([^"]+)"/';
                    $retVal = $this->regexGetImageBlock($str, $re);
                }
                break;
            }
        }
        array_shift($retVal);
        if (!empty($this->input['remove_size_chart'])) {
            $retVal = $this->removeSizeGalleries($retVal);
        }
        return $retVal;
    }

    private function regexGetImageBlock ($text, $regex) {
        $retVal = [];
        $str = $text;
        preg_match_all($regex, $str, $matches, PREG_SET_ORDER, 0);
        foreach ($matches as $item) {
            if (isset($item[1])) {
                $retVal[] = $item[1];
            }
        }

        return $retVal;
    }

    public function crawlAsin ($url) {
        try {
            $html = file_get_html($url);
        } catch (\Exception $exception) {
            return '';
        }
        $asin = $this->getAsin($html);
        return  $asin;
    }

    private function getAsin ($html) {
        $asin = $html->find('input[name=ASIN]', 0) ? trim($html->find('input[name=ASIN]', 0)->value) : '';
        if (!$asin) {
            $asin = $html->find('input[name=askAsin]', 0) ? trim($html->find('input[name=askAsin]', 0)->value) : '';
        }
        return $asin;
    }

    private function getComment ($html) {
        $formatDate = isset($this->config['comment_format_date']) ? $this->config['comment_format_date'] : '';
        $retVal = [];
        $commentElements = $html->find('div[id=cm-cr-dp-review-list] .review');

        foreach ($commentElements as $commentElement) {
            $content = $commentElement->find('.review-text-content span', 0) ? $commentElement->find('.review-text-content span', 0)->plaintext : '';
            $content = trim($content);
            $content = $this->replaceDomain($content);
            $ratingElement = $commentElement->find('i[data-hook=review-star-rating] span', 0);
            $rating = 0;
            if ($ratingElement) {
                $rating = intval(str_replace(' out of 5 stars', '', $ratingElement->plaintext));
            }
            if (!$rating) {
                $rating = rand(4, 5);
            }
            $createDateElement = $commentElement->find('.review-date', 0);
            $createDate = $this->randomDateTime();
            if ($createDateElement) {
                $createDateExplode = explode(' on ', $createDateElement->plaintext);
                if (isset($createDateExplode[1])) {
                    $createDateText = $createDateExplode[1];
                    $createDateObj = \DateTime::createFromFormat($formatDate . ' H:i:s', $createDateText . ' ' . $this->randomTime());
                    if ($createDateObj) {
                        $createDate = $createDateObj->format('Y-m-d H:i:s');
                    }
                }
            }
            $fullName = $commentElement->find('.a-profile-name', 0) ? $commentElement->find('.a-profile-name', 0)->plaintext : '';
            $title = $commentElement->find('.review-title span', 0)? $commentElement->find('.review-title span', 0)->plaintext : '';
            $comment = [
                'full_name' => $this->replaceDomain($fullName),
                'title' => $this->replaceDomain($title),
                'content' => $content,
                'rating' => $rating,
                'created_at' => $createDate
            ];
            $retVal[] = $comment;
        }
        return $retVal;
    }

    private function randomTime () {
        return str_pad(rand(0,23), 2, "0", STR_PAD_LEFT) . ":" . str_pad(rand(0,59), 2, "0", STR_PAD_LEFT) . ":" . str_pad(rand(0,59), 2, "0", STR_PAD_LEFT);
    }

    private function randomDateTime () {
        $time = mt_rand(time() - 3600 * 24 * 30 * 6, time());
        return date('Y-m-d H:i:s', $time);
    }

    public function crawlDescription ($url) {
        $context = $this->getContext();
        try {
            $html = file_get_html($url, false, $context);
        } catch (\Exception $exception) {
            return '';
        }
        $description = $this->getDescription($html);
        return  $description;
    }

    public function crawlProductMeta ($url) {
        $context = $this->getContext();
        try {
            $html = file_get_html($url, false, $context);
        } catch (\Exception $exception) {
            return [];
        }
        return [
            'meta_title' => $this->getProductMeta($html, 'meta[name=title]'),
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]')
        ];
    }

    public function crawlColor ($url) {
        $retVal = false;
        $context = $this->getContext();
        try {
            $html = file_get_html($url, false, $context);
        } catch (\Exception $exception) {
            return [];
        }

        $element = $html->find('div[id=variation_color_name] .selection', 0);
        if ($element && $element->plaintext) {
            $color = trim($element->plaintext);
            $arrayImage = $this->getImages($html);
            if ($arrayImage['colorImages'] && !isset($arrayImage['colorImages'][$color])) {
                $retVal = true;
            }
        }
        return $retVal;
    }

    public function crawlCategory ($url, $countryCode) {
        $this->config = $this->getConfig();
        $retVal = [];
        $i = 3;
        while ($i > 0) {
            try {
                $htmlStr = $this->getHtml($url, $countryCode);
                $html = str_get_html($htmlStr);
                if ($html) {
                    $i = 0;
                } else {
                    --$i;
                }
            } catch (\Exception $exception) {
                --$i;
            }
        }
        if (!empty($html)) {
            $elements = $html->find('div[data-component-type=s-search-result]');
            $parse = parse_url($url);
            $domain = !empty($parse['host']) ? $parse['host'] : 'amazon.com';
            foreach ($elements as $elementSearch) {
                if ($elementSearch->find('div[data-component-type=sp-sponsored-result]', 0)) {
                    continue;
                }
                $item = [
                    'image_url' => $this->getImage($elementSearch),
                    'name' => $this->getName($elementSearch),
                    'url' => $this->getUrl($elementSearch, $domain),
                    'price' => $this->getPriceCategory($elementSearch),
                    'country_code' => $countryCode,
                    'site' => $domain,
                    'code' => $elementSearch->{'data-asin'}
                ];
                $retVal[] = $item;
            }
        }
        return $retVal;
    }

    private function getImage ($element) {
        $retVal = '';
        $elementImg = $element->find('img.s-image', 0);
        if ($elementImg) {
            $url = $elementImg->src;
            $arr = explode('.', $url);
            unset($arr[count($arr) -2]);
            $retVal = implode('.', $arr);
        }
        return $retVal;
    }

    private function getName ($element) {
        $retVal = '';
        $elm = $element->find('h2 a span', 0);
        if ($elm) {
            $retVal = $elm->plaintext;
        }
        $retVal = trim($retVal);
        return htmlspecialchars_decode($retVal);
    }

    private function getUrl ($element, $domain) {
        $retVal = '';
        $elm = $element->find('h2 a', 0);
        if ($elm) {
            $retVal = 'https://' . $domain . $elm->href;
        }
        return $retVal;
    }

    private function getPriceCategory ($element) {
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        $retVal = 0;
        $elm = $element->find('.a-price .a-offscreen', 0);
        if ($elm) {
            $retVal = trim($elm->plaintext);
            $retVal = str_replace($currency, '', $retVal);
            if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                $retVal = str_replace(',', '', $retVal);
            } else {
                $retVal = str_replace(',', '.', $retVal);
            }
            $retVal = floatval($retVal);
        }
        return $retVal;
    }

    function parseUrl($url) {
        $result = parse_url($url);
        return $result['scheme']."://".$result['host'];
    }

    private function getHtml($url, $countryCode = '') {
        if (!$countryCode) {
            $countryCode = Input::get('country_code', 'us');
        }
        $configProxy = config('crawl-product::sa.proxy');
        $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
        $proxy['url'] = str_replace('tcp://', '', $proxy['url']);
        $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36';
        $ch = curl_init();                                              //creates a new cURL resource handle
        curl_setopt($ch, CURLOPT_URL, $url);               // Set URL to download
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                 //  TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);               // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true );                // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        curl_setopt($ch, CURLOPT_PROXY, $proxy['url']);
        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxy['username'] . ':' . $proxy['password']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        $output = curl_exec($ch);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            dd($error_msg);
        }
        $size = curl_getinfo($ch, CURLINFO_SIZE_DOWNLOAD);
        $log = new CrawlLog();
        $log->size = $size ? intval($size/(1024*8)) : 0;
        $log->url = $url;
        $log->email = Auth::user() && !empty(Auth::user()->email) ? Auth::user()->email : null;
        $log->save();
        return $output;
    }

    public function deleteProduct($input) {
        $result = [];
        foreach (array_chunk($input['codes'], 100) as $codes) {
            $productIds = DB::table('product_crawl_code')
                ->whereIn('value', $codes)
                ->where('site', 'amazon')
                ->get(['product_id'])
                ->pluck('product_id')
                ->toArray();
            $result = array_merge($result, $productIds);
            foreach (array_chunk($productIds, 500) as $partIds) {
                Product::whereIn('id', $partIds)
                    ->update([
                        'status' => 'PENDING'
                    ]);
            }
        }

        return $result;
    }

    private function getStoreLink($html) {
        $retVal = '';

        $element = $html->find('#bylineInfo', 0);
        if ($element) {
            $retVal = trim($element->href);
            if ($retVal && $retVal[0] == '/') {
                $retVal = 'https://www.amazon.com' . $retVal;
            }
        }

        return $retVal;
    }

    private function getVideos($html) {
        $retVal = [];

        $elements = $html->find('#main-video-container video');
        if (!empty($elements)) {
            foreach ($elements as $ele) {
                if (strpos($ele->src, 'http') === 0) {
                    $retVal[] = [
                        'src' => $ele->src,
                        'image_url' => $ele->poster
                    ];
                }
            }
        }
        if (!count($retVal)) {
            $script = $html->find('#main-image-container script', 0);
            if ($script) {
                $data = json_decode($script->innertext, true);
                if (!empty($data['videoUrl'])) {
                    $videoUrl = str_replace('.hls.m3u8', '.mp4.480.mp4', $data['videoUrl']);
                    $retVal[] = [
                        'src' => $videoUrl,
                        'image_url' => $data['imageUrl']
                    ];
                }
            }
        }

        return $retVal;
    }
}
