<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

use Illuminate\Support\Facades\Input;
use Modules\CrawlProduct\Models\Category;

class BaseService {
    protected $cacheTranslate;
    protected $getGallery = true;
    protected $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/127.0.0.0 Safari/537.36';

    public function generateAsin ($url) {
        $url = explode('?', $url)[0];
        return $url;
    }

    public function __construct($input) {
        $this->cacheTranslate = [];
        if (!empty($input['categories'])) {
            $this->getGallery = $this->isGetGallery($input);
        }
    }

    protected function getDomain($input) {
        $url = trim($input['url']);
        return str_ireplace('www.', '', parse_url($url, PHP_URL_HOST));
    }

    protected function getIgnoreByLocale($locale, $domain) {
        $config = [
            'us' => [
                'category_ids' => [
                    7, 8, 48, 54, 68,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'uk' => [
                'category_ids' => [
                    7, 8, 48, 54, 68,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'ca' => [
                'category_ids' => [
                    7, 8, 48, 54, 68,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'au' => [
                'category_ids' => [
                    7, 8, 48, 54, 68,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'fr' => [
                'category_ids' => [
                    7, 8, 48, 54, 63, 66,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'jp' => [
                'category_ids' => [
                    7, 8, 48, 54, 59, 45, 81
                ],
                'site' => [
                    '*'
                ]
            ],
            'de' => [
                'category_ids' => [
                    7, 8, 48, 54, 63,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'it' => [
                'category_ids' => [
                    7, 63, 66, 62, 70,
                ],
                'site' => [
                    'etsy'
                ]
            ],
            'es' => [
                'category_ids' => [
                    7, 8, 48, 54, 63,
                ],
                'site' => [
                    '*'
                ]
            ],
            'pt' => [
                'category_ids' => [
                    7, 8, 48, 69, 54,
                ],
                'site' => [
                    'etsy'
                ]
            ]
        ];

        if (isset($config[$locale])) {
            foreach ($config[$locale]['site'] as $site) {
                if ($site == '*' || strpos($domain, $site) !== false) {
                    return $config[$locale]['category_ids'];
                }
            }
        }

        return [];
    }

    public function isGetGallery($input) {
        $categoryIds = $input['categories'];
        $domain = $this->getDomain($input);
        $locale = env("APP_LOCALE", 'us');
        if (!$locale) {
            $locale = 'us';
        }
        $ignoreGetCateIds = $this->getIgnoreByLocale($locale, $domain);

        $cateIds = Category::whereIn('id', explode(',', $categoryIds))
            ->whereNotNull('parent_id')
            ->get(['id'])->pluck('id')
            ->toArray();
        if (count($cateIds) == 1) {
            foreach ($ignoreGetCateIds as $ignoreCateId) {
                if (in_array($ignoreCateId, $cateIds)) {
                    return false;
                    break;
                }
            }
        }

        return true;
    }
    
    public function syncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 120) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        $headers[] = 'Content-type: application/json';
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            \Log::info('syncRequest ERROR', [curl_error($channel), curl_errno($channel)]);
        }
        curl_close($channel);
        return json_decode($data, true);
    }

    public function asyncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 120) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, 120);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        curl_close($channel);
        return json_decode($data, true);
    }
    
    public function removeSizeGalleries($gallery) {
        $locale = env('APP_LOCALE', 'us');
        if (empty($locale)) {
            $locale = 'us';
        }
        if (!config('crawl-product::sa.remove_size_chart_image.remove_gallery_url.' . $locale)) {
            return $gallery;
        }
        $retVal = [];

        $cacheKey = 'CACHE::IMAGE_HAS_SIZE::';
        $needCheckGallery = [];
        foreach ($gallery as $key => $img) {
            $cacheImg = \Cache::get($cacheKey . '::' . md5($img));
            if ($cacheImg && isset($cacheImg['has_size'])) {
                if (!$cacheImg['has_size']) {
                    $retVal['img' . $key] = $img;
                }
            } else {
                $needCheckGallery['img' . $key] = $img;
            }
        }
        if (count($needCheckGallery)) {
            $response = $this->syncRequest(config('crawl-product::sa.remove_size_chart_image.remove_gallery_url.' . $locale), 'POST', ['locale' => $locale, 'gallery' => $needCheckGallery]);
    
            if ($response && !empty($response['status']) && $response['status'] == 'successful') {
                $result = $response['result'];
                foreach ($result as $key => $item) {
                    if ($item && isset($item['has_size'])) {
                        if (!$item['has_size']) {
                            $retVal['img' . $key] = $item['image_url'];
                        }
    
                        \Cache::forever($cacheKey . '::' . md5($item['image_url']), $item);
                    }
                }
            } else {
                foreach ($needCheckGallery as $key => $item) {
                    $retVal[$key] = $item;
                }
            }
        }

        ksort($retVal);

        return array_values($retVal);
    }


    protected function toFriendlyString ($string) {
        $originalString = $string;
        if (isset($this->cacheTranslate[$originalString])) {
            return $this->cacheTranslate[$originalString];
        }
        $string = trim($string);
        $countryCode = Input::get('country_code', 'us');
        if (in_array($countryCode, ['jp', 'kr'])) {
            $string = japaneseToEnglish($string);
        }
        $retVal = preg_replace('/\W+/', '-', strtolower(trim($string)));

        $retVal = trim($retVal, '-');
        $this->cacheTranslate[$originalString] = $retVal;

        return $retVal;
    }

    protected function getConfig () {
        $config = config('crawl-product::sa.config_by_country');
        $countryCode = Input::get('country_code', 'us');
        return isset($config[$countryCode]) ? $config[$countryCode] : [];
    }

    protected function combinations($arrays, $i = 0) {
        if (!isset($arrays[$i])) {
            return array();
        }
        if ($i == count($arrays) - 1) {
            return $arrays[$i];
        }

        // get combinations from subsequent arrays
        $tmp = $this->combinations($arrays, $i + 1);

        $result = array();

        // concat each array from tmp with each element from $arrays[$i]
        foreach ($arrays[$i] as $v) {
            foreach ($tmp as $t) {
                $result[] = is_array($t) ?
                    array_merge(array($v), $t) :
                    array($v, $t);
            }
        }

        return $result;
    }
}
