<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class CupsellService extends BaseService
{
    public $input = [];
    
    public function __construct($input) {
        $this->input = $input;
        parent::__construct($input);
    }

    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        $productObj = $this->getProductData($html, $url);
        $asin = $this->generateAsin($url);
        $data = [
            'name' => $productObj['name'],
            'description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'content' => $productObj['content'],
            'image_url' => $productObj['image'],
            'galleries' => $productObj['gallery'],
            'price' => $productObj['price'],
            'high_price' => 0,
            'note' => 'cupsell url: ' . $url,
            'crawl_code' => md5($asin),
            'site' => 'cupsell.pl',
            'comments' => [],
            'meta_title' => $productObj['name'],
            'meta_description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'meta_keywords' => '',
            'variants' => [],
            'product_variants' => []
        ];
        
        return $data;
    }

    private function getProductData($html, $originalUrl) 
    {
        $parsedUrl = parse_url($originalUrl);
        $product = [];
        $nameEle = $html->find('h1.title', 0);
        if (empty($nameEle)) {
            $nameEle = $html->find('meta[property="og:title"]', 0);
        }
        $product['name'] = trim(strip_tags($nameEle->innertext));
        $priceEle = $html->find('span.productCard__price', 0);
        $product['price'] = str_replace(',', '.', preg_replace("/[^0-9\.\,]/", "", $priceEle->innertext));
        $product['gallery'] = [];
        $product['variants'] = [];
        $product['content'] = trim($html->find('div.panelToggle__description', 0)->innertext);

        $gallery = $html->find('.productGallery__thumbnails .productGallery__thumbnailWrapper img');
        $dataSrc = 'src';
        foreach ($gallery as $key => $image) {
            $url = $image->$dataSrc;
            if ($url) {
                if (strpos($url, '//') === false) {
                    $url = $parsedUrl['scheme'] . '://' . $parsedUrl['host'] . $url;
                }
                array_push($product['gallery'], explode('?', $url)[0]);
            }
        }
        $product['image'] = array_shift($product['gallery']);

        return $product;
    }

    private function getProductMeta($html, $meta) {
        $retval = '';
        $metaTitleElements = $html->find($meta, 0);
        if ($metaTitleElements) {
            $retval = $metaTitleElements->attr['content'];
        }
        return $retval;
    }
}
