<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class EbayService extends BaseService
{
    public function parseHTML($htmlStr, $url) {
        ini_set('memory_limit', '2048M');
        $html = str_get_html($htmlStr);

        $crawlCode = $this->getCrawlCode($url);

        $priceEle = $html->find('.x-price-primary .ux-textspans', 0);
        $price = 0;
        if ($priceEle) {
            $price = preg_replace("/[^\d\.]+/", '', $priceEle->plaintext);
        }
        $variants = $this->getVariants($html);

        $name = $html->find('h1 span', 0);
        $gallery = $this->getGallery($html);
        $result = [
            'name'  => $this->replaceDomain($name->plaintext),
            'slug' => $this->toFriendlyString($this->replaceDomain($name->plaintext)),
            'description'  => $this->getProductMeta($html, 'meta[name="description"]'),
            'content'  => '',
            'image_url'  => array_shift($gallery),
            'galleries'  => $gallery,
            'price'  => $price,
            'high_price'  => '',
            'note'  => 'ebay url: ' . $url,
            'crawl_code'  => $crawlCode,
            'site'  => 'ebay',
            'comments'  => '',
            'meta_title'  => $name->plaintext,
            'meta_description'  => $this->getProductMeta($html, 'meta[name="description"]'),
            'meta_keywords'  => $this->getProductMeta($html, 'meta[name="keywords"]'),
            'is_fast_shipment' => '',
            'related_products'  => '',
            'variants' => $variants,
            'product_variants' => $this->getProductVariants($variants, $price),
            'tags' => [],
            'store_link' => $this->getStoreLink($html)
        ];

        if (!$this->getGallery) {
            $result['galleries'] = [];
        }

        return $result;
    }

    public function getCrawlCode($url) {
        $url = trim($url);
        preg_match("/\/itm\/(\d+)/", $url, $matches);
        $crawlCode = '';
        if (count($matches) > 1) {
            $crawlCode = $matches[1];
        }

        return $crawlCode;
    }

    public function getGallery($html) {
        $retVal = [];
        $items = $html->find('.x-photos-max-view .ux-image-carousel-container .ux-image-carousel-item.image');

        if (!count($items)) {
            $items = $html->find('.x-photos-min-view .ux-image-carousel-container .ux-image-carousel-item.image');
        }

        if (!count($items)) {
            $items = $html->find('.ux-image-carousel-container .ux-image-carousel-item.image');
        }
 
        foreach ($items as $item) {
            $img = $item->find('img', 0);
            if ($img) {
                $src = $img->{'src'} ? $img->{'src'} : ($img->{'data-src'} ? $img->{'data-src'} : '');
                if ($src) {
                    $retVal[] = $this->getImageUrl($src);
                }
            }
        }

        return $retVal;
    }

    public function getImageUrl($src) {
        $retVal = $src;

        if (strpos($retVal, '//') === 0) {
            $retVal = 'https:' . $retVal;
        } else if (strpos($retVal, 'http') === false) {
            $retVal = 'https://' . $retVal;
        }

        return $retVal;
    }

    public function getStoreLink($html) {
        $retVal = '';
        $companyEle = $html->find('.ux-seller-section__item--seller a', 0);
        if ($companyEle) {
            $href = $companyEle->href;
            if (strpos($href, '?') !== false) {
                $href = substr($href, 0, strpos($href, '?'));
            }
            $retVal = $href;
        }

        return $retVal;
    }

    public function getVariants($html) {
        $variants = [];
        $skuWrap = $html->find('.x-msku', 0);
        if ($skuWrap) {
            $variantEles = $html->find('.x-msku__box-cont');
            foreach ($variantEles as $variantEle) {
                $name = $variantEle->find('.x-msku__label .x-msku__label-text', 0);
                $variant = [
                    'name' => trim($name->plaintext),
                    'slug' => $this->toFriendlyString($name->plaintext),
                    'type' => 'OPTION',
                    'options' => []
                ];
    
                $optionEles = $variantEle->find('.x-msku__select-box-wrapper .x-msku__select-box option');
                foreach ($optionEles as $optionEle) {
                    if (intval($optionEle->value) < 0) {
                        continue;
                    }
                    $optionName = trim($optionEle->plaintext);
                    $option = [
                        'name' => $optionName,
                        'slug' => $this->toFriendlyString($optionName),
                        'image_url' => null,
                        'variant_slug' => $variant['slug']
                    ];
                    $variant['options'][] = $option;
                }
                
                $variants[] = $variant;
            }
        }

        return $variants;
    }

    public function getProductVariants($variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                if (!empty($option['image_url'])) {
                    $itemVariant['image_url'] = $option['image_url'];
                }
                $options[] = $option;
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('product on ebay.com', '', $content);
        $content = str_ireplace('ebay.com', '', $content);
        $retVal = str_ireplace('ebay', '', $content);
        return trim($retVal);
    }
}