<?php
/**
 * Created by PhpStorm.
 * User: DiemND
 * Date: 5/26/21
 * Time: 3:11 PM
 */

namespace App\Modules\CrawlProduct\Controllers\Services;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Schema;
use Modules\CrawlProduct\Models\Category;
use Modules\CrawlProduct\Models\CrawlLog;
use App\Modules\CrawlProduct\Controllers\Services\BaseService;
use Carbon\Carbon;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class EtsyService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        parent::__construct($input);
        $this->input = $input;
    }

    public function crawl ($url) {
//        $url = 'https://lumtest.com/myip.json';
//        $context = $this->getContext();
        $htmlStr = $this->getHtml($url);
//        $html = file_get_html($url, false, $context);
//        try {
//            $html = file_get_html($url, false, $context);
//        } catch (\Exception $exception) {
//            return [];
//        }
        return $this->parseHTML($htmlStr, $url);
        
    }

    protected function getCategorySlug($html) {
        $slug = null;
        $breadCrumbsItems = $html->find('li[data-ui=list-item-breadcrumbs]');
        foreach ($breadCrumbsItems as $item) {
            if(isset($item->find('a[role=menuitem]', 0)->plaintext)) {
                $slugBreadCrumbsItem = str_slug($item->find('a[role=menuitem]', 0)->plaintext);
                $category = DB::table('category')->where('slug', $slugBreadCrumbsItem)->where('depth', 0)->first();
                if ($category) {
                    $slug = $category->slug;
                }
            }
        }

        return $slug ?? 'home-living';
    }

    protected function matchCategory() {

    }

    public function parseHTML($htmlStr, $url) {
        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $comments = $this->getComment($html);
        $arrayImage = $this->getImages($html);
        $listImage = array_values($arrayImage);
        if (!empty($this->input['remove_size_chart'])) {
            $listImage = $this->removeSizeGalleries($listImage);
        }
        $imageUrl = $listImage ? $listImage[0] : '';
        $asin = $this->getAsinFromUrl($url);
        if (!$asin) {
            $asin = $this->getAsin($html);
        }
        $name = $html->find('#listing-page-cart h1', 0) ? trim($html->find('#listing-page-cart h1', 0)->plaintext) : '';
        $name = trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', mb_convert_encoding( htmlspecialchars_decode($name), "UTF-8" )));
        $name = $this->replaceDomain($name);
        $data = [
            'name' => $name,
            'description' => $this->getDescription($html),
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => $listImage,
            'price' => $this->getPrice($html),
            'high_price' => 0,
            'note' => 'Etsy url: ' . $url,
            'url' => $url,
            'crawl_code' => $asin,
            'category_slug' => $this->getCategorySlug($html),
            'site' => 'etsy',
            'comments' => $comments,
            'meta_title' => $this->getProductMeta($html, 'meta[name=title]'),
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'tags' => $this->getTags($html),
            'store_link' => $this->getStoreLink($html)
        ];
        if (!$this->getGallery) {
            $data['galleries'] = [];
        }
        $attributes = $this->getAttributes($html);
        $variantsKey = [];
        $variants = [];
        $data['variants'] = [];
        foreach ($attributes as $attribute) {
            if ($attribute['options']) {
                $data['variants'][] = $attribute;
                $variantsKey[] = array_keys($attribute['options']);
                $variants[] = $attribute;
            }
        }
        $getVariantImageById = $this->getVariantImageById($html);
        $productVariants = [];
        $combinations = $this->combinations($variantsKey);
        foreach ($combinations as $listKey) {
            if (!is_array($listKey)) {
                $listKey = [$listKey];
            }
            $keyImage = '';
            $arrVariants = [];
            $variantPrice = $data['price'];
            foreach ($listKey as $key => $value) {
                $variant = $variants[$key]['options'][$value];
                if (!empty($getVariantImageById[$variant['id']])) {
                    $keyImage = $getVariantImageById[$variant['id']];
                }
                $arrVariants[] = [
                    'variant_slug' => $variants[$key]['slug'],
                    'slug' => $variant['slug'],
                ];
                if (!empty($variant['price'])) {
                    $variantPrice = $variant['price'];
                }
            }
            $galleries = [];
            $imageUrl = '';
            if ($keyImage && !empty($arrayImage[$keyImage])) {
                $galleries = $arrayImage;
                if (!empty($this->input['remove_size_chart'])) {
                    $galleries = $this->removeSizeGalleries($galleries);
                }
                $imageUrl = $arrayImage[$keyImage];
                unset($galleries[$keyImage]);
            }
            $itemVariant = [
                'image_url' => $imageUrl,
                'galleries' => $galleries,
                'price' => $variantPrice,
                'high_price' => 0,
                'variants' => $arrVariants
            ];
            if (!$this->getGallery) {
                $itemVariant['galleries'] = [];
            }
            $productVariants[] = $itemVariant;
        }
        $data['product_variants'] = $productVariants;
        $data['videos'] = $this->getVideos($html);
        return $data;
    }

    private function getHtml($url) {
        $countryCode = Input::get('country_code', 'us');
        $configProxy = config('crawl-product::sa.proxy');
        // $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
        // $proxy['url'] = str_replace('tcp://', '', $proxy['url']);
        $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36';
        $ch = curl_init();                                              //creates a new cURL resource handle
        curl_setopt($ch, CURLOPT_URL, $url);               // Set URL to download
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);                 //  TRUE to return the transfer as a string of the return value of curl_exec() instead of outputting it out directly.
        // curl_setopt($ch, CURLOPT_USERAGENT, $userAgent);               // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true );                // Should cURL return or print out the data? (true = return, false = print)
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 100);
        // curl_setopt($ch, CURLOPT_PROXY, $proxy['url']);
        // curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxy['username'] . ':' . $proxy['password']);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'authority: www.etsy.com',
            'accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'accept-language: en-US,en;q=0.9',
            'cache-control: max-age=0',
            'cookie: uaid=X-1KLXf_L20_5ubRAvtOQLn9c3VjZACC1LTFmTC6Wqk0MTNFyUqpyjkoJbHUtMI3qDIixdPJsTwqKdDIxdUnNyvDWamWAQA.; fve=1701225321.0; _fbp=fb.1.1701225321215.2129336860853161; num_listings_clicked_from_search=a50_yWkvk0rQNNmTPf9XzAgobcBjZACC1LTFmTC6WikxJz8jUcnKoJYBAA..; exp_ebid=m=lLSOHihR57fLAwIQCgeIutTD4vyEtedJ0MO6D0WKPKI%3D,v=Raa1w34KfWhCCBAecybkROZWheShAeqf; ua=531227642bc86f3b5fd7103a0c0b4fd6; _gcl_au=1.1.1915608143.1701225323; _ga=GA1.1.1862267415.1701225323; lantern=5243127d-6622-406e-b4a7-a48c6cab63c7; _pin_unauth=dWlkPU5USXhPREk1WkRJdE1XTXdaQzAwTnpNNExXSXlNamt0WldZMlpqUm1OREl5T1RBMw; _uetsid=f21750308e5f11eebd4f03fbb1d935a1; _uetvid=f21748108e5f11ee9c1f05ab0123b40e; _ga_KR3J610VYM=GS1.1.1701225322.1.1.1701225353.29.0.0; datadome=RCjVbNJxL0cPI3cnWJ0lwrn2GRww3T4Ev0nayOyNwdy9yCFhTB3pCXjfXgPej2DypIXIUv4BH1_ouTF8X9GSnGx5p1FFisYrcnncjpNwUrz86N9bPbBdTWOI8ZROd7x4; user_prefs=gVBGZqKCOxxnzbR63oNZm_Ubb1hjZACC1LTFmVB6QrRSaLCLkk5eaU6OjlJqnm5osJKOUpgfVMQIQuEiYhkA; _fbp=fb.1.1701225321215.2129336860853161; datadome=3uEMoFDw6TmYFK6dOQAtl2x7AQEeB7GmYhJSnYTuDXScBdoQXh6J1MN0za81iQpO6djDoZL~zRpM3c32W01OhK_lMN6uUcwn5oyJhFCT96R8Ms9InbkYVASJitZh78py; exp_ebid=m=V6FQGDvohxQqBw2wR6vwkXIfhjoApjKLPNI%2FbiIAGMw%3D,v=XQY11Gfnd6VOLO7eCJXfaPpFlp4hbBnc; fve=1701225321.0; num_listings_clicked_from_search=DRsX0rR-AwsimTZ-1HrWghrvg9ljZACCVGfRIjCduuhytVJaYklGapGSlUEtAwA.; search_history_v2=rWUWscwc5h7kcZFzv7SpJKGtoqljZACCVBf_C2A6ddHlaqXi1MSi5IzUYiWr6GqlwtLUokolK6W0xJKM1CIlHaWSzNzU-OKSxNwCJStDcwNDQ1NLM2MzHaWMxOL4otTi0pwSoMaSotLUWh2E7sSc_IxEdM1mlhaW5qbmRkbYNMfWMgAA; uaid=_pAoN1bpvwIhVSOWHreIOXs2_1BjZACClIPvFoLo1NRFl6uVShMzU5SslFzdk3RTA1ONDVyTUwMrUtMKDVwq_I2qPKOSnJKVahkA',
            'sec-ch-ua: "Google Chrome";v="119", "Chromium";v="119", "Not?A_Brand";v="24"',
            'sec-ch-ua-mobile: ?0',
            'sec-ch-ua-platform: "Windows"',
            'sec-fetch-dest: document',
            'sec-fetch-mode: navigate',
            'sec-fetch-site: same-origin',
            'sec-fetch-user: ?1',
            'upgrade-insecure-requests: 1',
            'user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36'
          ));
        
        $output = curl_exec($ch);
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            dd($error_msg);
        }
        $size = curl_getinfo($ch, CURLINFO_SIZE_DOWNLOAD);
        $log = new CrawlLog();
        $log->size = $size ? intval($size/(1024*8)) : 0;
        $log->url = $url;
        $log->email = Auth::user() && !empty(Auth::user()->email) ? Auth::user()->email : null;
        $log->save();

        return $output;
    }

    private function getVariantImageById ($html) {
        $retVal = [];
        $re = '/"image_ids_by_listing_variation_ids":{(["\d:,]+)}/m';
        preg_match_all($re, $html->outertext, $matches, PREG_SET_ORDER, 0);
        if ($matches) {
            $str = $matches[0][1];
            $explode = explode(',', $str);
            foreach ($explode as $item) {
                $item = str_replace('"', '', $item);
                $explodeItem = explode(':', $item);
                if (!empty($explodeItem[1])) {
                    $retVal[$explodeItem[0]] = $explodeItem[1];
                }
            }
        }
        return $retVal;
    }

    private function getAttributes ($html) {
        $retVal = [];
        $elements = $html->find('div[id=variations] div[data-buy-box-region=variation]');
        if (!$elements) {
            $elements = $html->find('div[id=listing-page-cart] div.wt-validation');
        }
        if ($elements) {
            $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
            foreach ($elements as $element) {
                $name = $element->find('label.wt-label', 0) ? trim($element->find('label.wt-label', 0)->plaintext) : '';
                $name = htmlspecialchars_decode($name, ENT_QUOTES);
                $optionElements = $element->find('select.variation-selector option');
                if (!$optionElements) {
                    $optionElements = $element->find('select.wt-select__element option');
                }
                if ($optionElements) {
                    $options = [];
                    foreach ($optionElements as $optionElement) {
                        if ($optionElement->value) {
                            $optionName = trim($optionElement->plaintext);
                            $optionName = htmlspecialchars_decode($optionName, ENT_QUOTES);
                            $optionName = str_replace('&euro;', '€', $optionName);
                            $optionName = str_replace('USD', '$', $optionName);
                            $optionPrice = 0;
                            $re = "/\(\\" . $currency . "[ \d.,-]+\)/m";
                            preg_match_all($re, $optionName, $matches, PREG_SET_ORDER, 0);
                            if (!$matches && $currency) {
                                $re = "/\([ \d.,-]+\\" . $currency . "\)/m";
                                preg_match_all($re, $optionName, $matches, PREG_SET_ORDER, 0);
                            }
                            if ($matches) {
                                $priceStr = $matches[count($matches) - 1][0];
                                $price = str_replace(['(', ')', $currency], '', $priceStr);
                                $price = explode(' - ', $price)[0];
                                if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                                    $price = str_replace(',', '', $price);
                                } else {
                                    $price = str_replace(',', '.', $price);
                                }
                                $price = floatval($price);
                                if ($price) {
                                    $optionPrice = $price;
                                }
                            }

                            $optionName = preg_replace("/(\(.+\))/m", '', $optionName);
                            $optionName = trim($optionName);
                            $dataOption = [
                                'name' => $optionName,
                                'slug' => $this->toFriendlyString($optionName),
                                'type' => 'RADIOBOX',
                                'id' => $optionElement->value
                            ];
                            if ($optionPrice) {
                                $dataOption['price'] = $optionPrice;
                            }
                            $options[] = $dataOption;
                        }
                    }
                    if ($options) {
                        $retVal[] = [
                            'name' => $name,
                            'slug' => $this->toFriendlyString($name),
                            'options' => $options
                        ];
                    }
                }
            }
        }
        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', mb_convert_encoding( $retVal, "UTF-8" )));;
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $retVal = str_ireplace('etsy.com', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('etsy', $_SERVER['SERVER_NAME'], $retVal);
        return $retVal;
    }

    private function getDescription ($html) {
        $description = $html->find('p[data-product-details-description-text-content]', 0) ? trim($html->find('p[data-product-details-description-text-content]', 0)->innertext) : '';
        $description = $this->replaceDomain($description);
        $description = preg_replace('/<script\b[^>]*>(.*?)<\/script>/is', "", $description);
        return trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', mb_convert_encoding( $description, "UTF-8" )));
    }

    private function getContext () {
        $countryCode = Input::get('country_code', 'us');
        $configProxy = config('crawl-product::sa.proxy');
        $context = [];
        if ($configProxy) {
            $proxy = isset($configProxy[$countryCode]) ? $configProxy[$countryCode] : $configProxy['us'];
            $auth = base64_encode($proxy['username'] . ':' . $proxy['password']);
            $userAgent = 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36';
            if (Schema::hasTable('user_agent')) {
                $rand = mt_rand(1, 1000);
                $userAgentObj = DB::table('user_agent')->where('id', '=', $rand)->first();
                if ($userAgentObj) {
                    $userAgent = $userAgentObj->user_agent;
                }
            }
            $context = array(
                'http'=>array(
                    'method' => 'GET',
                    'proxy'           => $proxy['url'],
                    'request_fulluri' => true,
                    'header'          => "Proxy-Authorization: Basic $auth" . "\r\n"
                                           . "User-Agent: $userAgent\r\n"
                ),
                "ssl"=>array(
                    "allow_self_signed"=>true,
                    "verify_peer"=>false,
                    "verify_peer_name"=>false,
                ),
            );
        }
        return $context;
    }


    private function getPrice ($html) {
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        $retVal = 0;
        $element = $html->find('div[data-buy-box-region=price] p.wt-mr-xs-1', 0);
        if ($element) {
            $price = str_replace(' ', '', trim($element->plaintext));
            $price = str_replace(['Price:$', 'Preço:', 'Price:£', '価格：￥', 'Precio:', 'US$'], '', $price);
            $price = preg_replace("/[^0-9.,]/", "", $price);
            $price = str_replace($currency, '', $price);
            $price = str_replace('+', '', $price);
            if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                $price = str_replace(',', '', $price);
            } else {
                $price = str_replace(',', '.', $price);
            }
            $retVal = floatval($price);
        }

        return $retVal;
    }

    private function getImages ($html) {
        $retVal = [];
        $imageElements = $html->find('img.carousel-image');
        if ($imageElements) {
            foreach ($imageElements as $imageElement) {
                $url = $imageElement->{'data-src-zoom-image'};
                $url = str_replace('_75x75.', '_2000xN.', $url);
                $url = str_replace('/d/il', '/r/il', $url);
                $retVal[] = $url;
            }
        }
        if (!$retVal) {
            $imageElements = $html->find('li.carousel-pagination-item-v2');
            if ($imageElements) {
                foreach ($imageElements as $imageElement) {
                    if (!$imageElement->find('div', 0)) {
                        $id = $imageElement->{'data-image-id'};
                        $image = $imageElement->find('img', 0);
                        if ($image) {
                            $url = $image->{'data-src-delay'};
                            $url = str_replace('_75x75.', '_2000xN.', $url);
                            $url = str_replace('/d/il', '/r/il', $url);
                            if ($url && $id) {
                                $retVal[$id] = $url;
                            }
                        }
                    }
                }
            }
        }
        if (!$retVal) {
            $imageElement = $html->find('img[data-carousel-first-image]', 0);
            if ($imageElement) {
                $id = $imageElement->parent()->{'data-image-id'};
                $url = $imageElement->src;
                $url = str_replace('_794xN.', '_2000xN.', $url);
                $url = str_replace('/d/il', '/r/il', $url);
                if ($url && $id) {
                    $retVal[$id] = $url;
                }
            }
        }

        return $retVal;

    }

    public function crawlAsin ($url) {
        try {
            $html = file_get_html($url);
        } catch (\Exception $exception) {
            return '';
        }
        $asin = $this->getAsin($html);
        return  $asin;
    }

    private function getAsinFromUrl($url) {
        $url = parse_url($url);
        $path = $url['path'];
        preg_match("/listing\/(\d+)\//", $path, $matches);

        if (!empty($matches[1])) {
            return $matches[1];
        }

        return;
    }

    private function getAsin ($html) {
        $asin = $html->find('input[name=listing_id]', 0) ? trim($html->find('input[name=listing_id]', 0)->value) : '';
        if (!$asin) {
            $asin = $html->find('input[name=target_id]', 0) ? trim($html->find('input[name=target_id]', 0)->value) : '';
        }
        return $asin;
    }

    private function getComment ($html) {
        $retVal = [];
        $commentElements = $html->find('div[id=same-listing-reviews-panel] .wt-grid__item-xs-12');
        foreach ($commentElements as $commentElement) {
            $content = $commentElement->find('.wt-text-truncate--multi-line', 0) ? $commentElement->find('.wt-text-truncate--multi-line', 0)->plaintext : '';
            $content = trim( preg_replace('/[\x00-\x1F\x80-\xFF]/', '', mb_convert_encoding( $content, "UTF-8" )));
            $ratingElements = $commentElement->find('path[d=M20.83,9.15l-6-.52L12.46,3.08h-.92L9.18,8.63l-6,.52L2.89,10l4.55,4L6.08,19.85l.75.55L12,17.3l5.17,3.1.75-.55L16.56,14l4.55-4Z]');
            $rating = $ratingElements ? count($ratingElements) : 0;
            $headElement = $commentElement->find('.wt-text-caption', 0);
            $name = '';
            $createDate = date('Y-m-d H:i:s');
            if ($headElement) {
                $nameElement = $headElement->find('.wt-text-link', 0);
                if ($nameElement) {
                    $name = trim($nameElement->plaintext);
                }
                $createDateText = trim(str_replace($name, '', $headElement->plaintext));
                $createDate = \DateTime::createFromFormat('M j, Y H:i:s', $createDateText . ' ' . $this->randomTime());
                $createDate = $createDate ? $createDate->format('Y-m-d H:i:s') : date('Y-m-d H:i:s');
            }
            $name = $this->replaceDomain($name);
            $content = $this->replaceDomain($content);
            $comment = [
                'full_name' => htmlspecialchars_decode($name, ENT_QUOTES),
                'title' => '',
                'content' => htmlspecialchars_decode($content, ENT_QUOTES),
                'rating' => $rating,
                'created_at' => $createDate
            ];
            $retVal[] = $comment;
        }
        return $retVal;
    }

    private function randomTime () {
        return str_pad(rand(0,23), 2, "0", STR_PAD_LEFT) . ":" . str_pad(rand(0,59), 2, "0", STR_PAD_LEFT) . ":" . str_pad(rand(0,59), 2, "0", STR_PAD_LEFT);
    }

    private function getTags($html) {
        $retVal = [];
        $elements = $html->find('.tag-cards-section-container-with-images .tag-card-with-image');

        foreach ($elements as $element) {
            $nameElement = $element->find('.tag-card-title', 0);
            if ($nameElement) {
                $name = trim($nameElement->title);
                if ($name) {
                    $retVal[] = $name;
                }
            }
        }

        return $retVal;
    }

    private function getStoreLink($html) {
        $retVal = '';
        $element = $html->find('#listing-page-cart [data-action="follow-shop-listing-header"]', 0);
        if ($element) {
            $store = $element->find('.wt-text-link-no-underline', 0);
            if ($store) {
                $retVal = trim($store->href);
                if ($retVal && $retVal[0] == '/') {
                    $retVal = 'https://www.etsy.com' . $retVal;
                }
            }
        }

        return $retVal;
    }

    public function crawlProduct ($url) {
        $htmlStr = $this->getHtml($url);
        $retVal = null;
        if (!str_contains($htmlStr,'Add your personalization')) {
            $asin = $this->getAsin(str_get_html($htmlStr));

            $record = DB::table('product_crawl_code')->where('value', $asin)->where('site','etsy')->first();
            if (!$record) {
                $retVal = $this->parseHTML($htmlStr, $url);
            } else {
                $retVal = $record;
            }
        }
        return $retVal;
    }

    public function getListDataProductByKeyWord ($keyWord) {
        $startTime =  Carbon::now()->timestamp;
        $currentTime = Carbon::now()->timestamp;

        $dataProducts = [];
        $html = $this->getHtmlByKey($keyWord);
        $html = str_get_html($html);
        $result = $html->find('.listing-link');

        foreach ($result as $index => $item) {
            $currentTime = Carbon::now()->timestamp;
            if($currentTime - $startTime >= config('crawl-product::sa.time_out_search_product_data', 3)) {
                break;
            }
            if(!empty($item->children)) {
                $dataProducts[] = [
                    'code' => Carbon::now()->timestamp . str_random(4),
                    'url' => $item->href,
                    'image_url' => getImageCdn($item->find('img', 0)->src, 630, 630, false),
                    'clroute_url' => clroute($item->href),
                    'name' => $item->find('.wt-text-caption', 0)->title,
                    'price' => $this->getPriceOnListProduct($item, $index),
                    'author' => $this->getAuthorOnListProduct($item),
                    'data_listing_id' => $item->attr['data-listing-id'] ?? null
                ];
            }
        }

        return $dataProducts;
    }

    protected function getAuthorOnListProduct($itemHtml){
        $element = $itemHtml->find('p.wt-text-caption', 0);
        $name = '';
        if($element) {
            if(isset($element->children[1])) {
                $name = $element->children[1]->plaintext;
            } else if($element->children[0]) {
                $name = $element->children[0]->plaintext;
            }
        }

        return $name;
    }

    protected function getPriceOnListProduct($itemHtml, $index){
        $currency = isset($this->config['currency']) ? $this->config['currency'] : '';
        $retVal = 0;
        $element = $itemHtml->find('div.lc-price p.lc-price span.currency-value', 0);

        if ($element) {
            $price = str_replace(' ', '', trim($element->plaintext));
            $price = str_replace(['Price:$', 'Preço:', 'Price:£', '価格：￥', 'Precio:', 'US$'], '', $price);
            $price = preg_replace("/[^0-9.,]/", "", $price);
            $price = str_replace($currency, '', $price);
            $price = str_replace('+', '', $price);
            if (in_array(Input::get('country_code'), ['jp', 'kr'])) {
                $price = str_replace(',', '', $price);
            } else {
                $price = str_replace(',', '.', $price);
            }
            $retVal = round($price, 2);
        }

        return $retVal;
    }

    public function getHtmlByKey($keyWord){
        $keyWord = $this->customUrlEncode($keyWord);
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
        CURLOPT_URL => "https://www.etsy.com/search?q={$keyWord}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'authority: www.etsy.com',
            'accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
            'accept-language: en-US,en;q=0.9',
            'cache-control: max-age=0',
            'cookie: uaid=X-1KLXf_L20_5ubRAvtOQLn9c3VjZACC1LTFmTC6Wqk0MTNFyUqpyjkoJbHUtMI3qDIixdPJsTwqKdDIxdUnNyvDWamWAQA.; fve=1701225321.0; _fbp=fb.1.1701225321215.2129336860853161; num_listings_clicked_from_search=a50_yWkvk0rQNNmTPf9XzAgobcBjZACC1LTFmTC6WikxJz8jUcnKoJYBAA..; exp_ebid=m=lLSOHihR57fLAwIQCgeIutTD4vyEtedJ0MO6D0WKPKI%3D,v=Raa1w34KfWhCCBAecybkROZWheShAeqf; ua=531227642bc86f3b5fd7103a0c0b4fd6; _gcl_au=1.1.1915608143.1701225323; _ga=GA1.1.1862267415.1701225323; lantern=5243127d-6622-406e-b4a7-a48c6cab63c7; _pin_unauth=dWlkPU5USXhPREk1WkRJdE1XTXdaQzAwTnpNNExXSXlNamt0WldZMlpqUm1OREl5T1RBMw; _uetsid=f21750308e5f11eebd4f03fbb1d935a1; _uetvid=f21748108e5f11ee9c1f05ab0123b40e; _ga_KR3J610VYM=GS1.1.1701225322.1.1.1701225353.29.0.0; datadome=RCjVbNJxL0cPI3cnWJ0lwrn2GRww3T4Ev0nayOyNwdy9yCFhTB3pCXjfXgPej2DypIXIUv4BH1_ouTF8X9GSnGx5p1FFisYrcnncjpNwUrz86N9bPbBdTWOI8ZROd7x4; user_prefs=gVBGZqKCOxxnzbR63oNZm_Ubb1hjZACC1LTFmVB6QrRSaLCLkk5eaU6OjlJqnm5osJKOUpgfVMQIQuEiYhkA; _fbp=fb.1.1701225321215.2129336860853161; datadome=3uEMoFDw6TmYFK6dOQAtl2x7AQEeB7GmYhJSnYTuDXScBdoQXh6J1MN0za81iQpO6djDoZL~zRpM3c32W01OhK_lMN6uUcwn5oyJhFCT96R8Ms9InbkYVASJitZh78py; exp_ebid=m=V6FQGDvohxQqBw2wR6vwkXIfhjoApjKLPNI%2FbiIAGMw%3D,v=XQY11Gfnd6VOLO7eCJXfaPpFlp4hbBnc; fve=1701225321.0; num_listings_clicked_from_search=DRsX0rR-AwsimTZ-1HrWghrvg9ljZACCVGfRIjCduuhytVJaYklGapGSlUEtAwA.; search_history_v2=rWUWscwc5h7kcZFzv7SpJKGtoqljZACCVBf_C2A6ddHlaqXi1MSi5IzUYiWr6GqlwtLUokolK6W0xJKM1CIlHaWSzNzU-OKSxNwCJStDcwNDQ1NLM2MzHaWMxOL4otTi0pwSoMaSotLUWh2E7sSc_IxEdM1mlhaW5qbmRkbYNMfWMgAA; uaid=_pAoN1bpvwIhVSOWHreIOXs2_1BjZACClIPvFoLo1NRFl6uVShMzU5SslFzdk3RTA1ONDVyTUwMrUtMKDVwq_I2qPKOSnJKVahkA',
            'sec-ch-ua: "Google Chrome";v="119", "Chromium";v="119", "Not?A_Brand";v="24"',
            'sec-ch-ua-mobile: ?0',
            'sec-ch-ua-platform: "Windows"',
            'sec-fetch-dest: document',
            'sec-fetch-mode: navigate',
            'sec-fetch-site: same-origin',
            'sec-fetch-user: ?1',
            'upgrade-insecure-requests: 1',
            'user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36'
          ),
        ));

        $html = curl_exec($curl);
        
        curl_close($curl);

        

        return $html;
    }

    protected function customUrlEncode($inputString) {
        // Mảng các ký tự đặc biệt cần mã hóa (trừ '%')
        $specialChars = array('!', '@', '#', '$', '^', '&', '%');
    
        // Mã hóa chuỗi với urlencode()
    
        // Thay thế các ký tự đặc biệt trong mảng bằng mã hóa tương ứng
        foreach ($specialChars as $char) {
            $encodedChar = urlencode($char);
            $inputString = str_replace($char, $encodedChar, $inputString);
        }
        
        // Thay thế dấu cách thành dấu "+"
        return str_replace(' ', '+', $inputString);
    }

    protected function getVideos($html) {
        $retVal = [];

        $videoElements = $html->find('.listing-page-image-carousel-component video.listing-video-responsive-container');
        $videoThumbnailElements = $html->find('.listing-page-image-carousel-component li[data-carousel-thumbnail-video] img[data-carousel-thumbnail-image]');

        if (!empty($videoElements) && !empty($videoThumbnailElements) && count($videoElements) == count($videoThumbnailElements)) {
            foreach ($videoElements as $key => $videoElement) {
                $video = $videoElement->find('source', 0);
                $thumbnailEle = $videoThumbnailElements[$key];
                $thumbnail = $thumbnailEle->src;
                $thumbnail = str_replace("/,h_(\d+),/", ',h_900,', $thumbnail);
                $thumbnail = str_replace("/,h_(\d+)\//", ',h_900/', $thumbnail);
                $thumbnail = str_replace("/,w_(\d+),/", ',w_900,', $thumbnail);
                $thumbnail = str_replace("/,w_(\d+)\//", ',w_900/', $thumbnail);
                if ($video) {
                    if (strpos($video->src, 'http') === 0) {
                        $retVal[] = [
                            'src' => $video->src,
                            'image_url' => $thumbnail
                        ];
                    }
                }
            }
        }


        return $retVal;
    }
}

