<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class HydroService extends BaseService
{
    static $config = [];
    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        self::$config = $this->getConfig();
        $designCrawlCode = substr(parse_url($url)['path'], strrpos(parse_url($url)['path'], '-') + 1);
        $nameEle = $html->find('.product_name', 0);
        if ($nameEle) {
            $name = strip_tags($nameEle->innertext);
        }

        $galleries = $this->getGalleries($html);
        $imageUrl = array_shift($galleries);
        if (!$this->getGallery) {
            $galleries = [];
        }
        $variants = $this->getVariants($html);
        $price = $this->getProductMeta($html, 'meta[property="product:price:amount"]');
        $productVariants = $this->getProductVariants($variants, $price);

        return [
            'name' => $name,
            'description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => $galleries,
            'price' => $price,
            'high_price' => 0,
            'note' => '64hydro url: ' . $url,
            'crawl_code' => $designCrawlCode,
            'site' => '64hydro',
            'comments' => [],
            'meta_title' => $this->getProductMeta($html, 'meta[property="og:title"]'),
            'meta_description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'is_fast_shipment' => 0,
            'related_products' => [],
            'tags' => [],
            'design_crawl_code' => $designCrawlCode,
            'store_link' => '',
            'variants' => $variants,
            'product_variants' => $productVariants,
        ];
    }

    public function getVariants($html) {
        $variants = [];
        $elements = $html->find('.swatch');
        if ($elements && count($elements)) {
            foreach ($elements as $element) {
                $nameEle = $element->find('.option_title', 0);
                $name = trim($nameEle->innertext);
                if ($name) {
                    $variantSlug = $this->toFriendlyString($name);
                    $variant = [
                        'name' => $name,
                        'slug' => $variantSlug,
                        'options' => [],
                        'type' => 'OPTION'
                    ];

                    $optionEles = $element->find('.swatch-element');
                    foreach ($optionEles as $optionEle) {
                        $optionName = $optionEle->getAttribute('data-value');
                        if ($optionName) {
                            $option = [
                                'name' => $optionName,
                                'slug' => $this->toFriendlyString($optionName),
                                'variant_slug' => $variantSlug
                            ];
                            $variant['options'][] = $option;
                        }
                    }

                    if (count($variant['options'])) {
                        $variants[] = $variant;
                    }
                }
            }
        }

        return $variants;
    }

    public function getProductVariants($variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                if (!empty($option['image_url'])) {
                    $itemVariant['image_url'] = str_replace('50x50', '670x890', $option['image_url']);
                }
                $options[] = $option;
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('beebubble.com', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('beebubble', $_SERVER['SERVER_NAME'], $content);
        return trim($retVal);
    }

    public function getGalleries($html) {
        $retVal = [];

        $elements = $html->find('.gallery-cell');
        if ($elements && count($elements)) {
            foreach ($elements as $element) {
                $img = $element->find('.image__container > img', 0);
                if ($img && $img->getAttribute('data-zoom-src')) {
                    $retVal[] = 'https:' . $img->getAttribute('data-zoom-src');
                }
            }
        }

        return $retVal;
    }
}
