<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class LatostadoraService extends BaseService
{
    static $config = [];
    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        self::$config = $this->getConfig();
        preg_match("/\\/(\d+)$/", explode("?", $url)[0], $matches);
        $crawlCode = '';
        if (count($matches) > 1) {
            $crawlCode = $matches[1];
            $parseUrl = parse_url($url);
            if (isset($parseUrl['query'])) {
                parse_str($parseUrl['query'], $query);
                if (isset($query['s'])) {
                    $crawlCode .= '|' . $query['s'];
                }
            }
        }
        $nameEle = $html->find('h1', 0);
        if ($nameEle) {
            $name = strip_tags($nameEle->innertext);
        }

        $galleries = $this->getGalleries($html);
        $imageUrl = array_shift($galleries);
        if (!$this->getGallery) {
            $galleries = [];
        }
        $variants = $this->getVariants($html);
        $priceEle = $html->find('#price-container', 0);
        $price = $priceEle ? str_replace(",", ".", trim(preg_replace("/[^\d\.\,]+/", "", trim($priceEle->innertext)))) : 0;
        $productVariants = $this->getProductVariants($variants, $price);

        return [
            'name' => $name,
            'description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => $galleries,
            'price' => $price,
            'high_price' => 0,
            'note' => 'latostadora url: ' . $url,
            'crawl_code' => $crawlCode,
            'site' => 'latostadora',
            'comments' => [],
            'meta_title' => $this->getProductMeta($html, 'meta[property="og:title"]'),
            'meta_description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'is_fast_shipment' => 0,
            'related_products' => [],
            'tags' => [],
            'design_crawl_code' => '',
            'store_link' => '',
            'variants' => $variants,
            'product_variants' => $productVariants,
        ];
    }

    private function getColorVariant($html) {
        $variant = [
            'name' => 'Color',
            'slug' => 'color',
            'options' => [],
            'type' => 'IMAGE'
        ];

        $elements = $html->find('#list_colors .a-bubble-color');
        foreach ($elements as $element) {
            $optionName = $element->title;
            if ($optionName) {
                $option = [
                    'name' => $optionName,
                    'slug' => $this->toFriendlyString($optionName),
                    'variant_slug' => $variant['slug'],
                ];
                $variant['options'][] = $option;
            }
        }

        return $variant;
    }

    private function getSizeVariant($html) {
        $variant = [
            'name' => 'Size',
            'slug' => 'size',
            'options' => [],
            'type' => 'OPTION'
        ];

        $sizeWrapper = $html->find('[data-ray-component="PDPShowSizesComponent"]', 0);
        if (!$sizeWrapper) {
            return $variant;
        }
        $sizeList = $sizeWrapper->find('.m-sizes-list', 0);
        if (!$sizeList) {
            return $variant;
        }
        $elements = $sizeList->find('.m-sizes-list__size');

        foreach ($elements as $element) {
            $nameEle = $element->find('span', 0);
            if (!$nameEle) {
                continue;
            }
            $optionName = trim($nameEle->innertext);
            if ($optionName) {
                $option = [
                    'name' => $optionName,
                    'slug' => $this->toFriendlyString($optionName),
                    'variant_slug' => $variant['slug'],
                ];
                $variant['options'][] = $option;
            }
        }

        return $variant;
    }

    public function getVariants($html) {
        $variants = [];
        if ($html->find('#list_colors', 0)) {
            $variant = $this->getColorVariant($html);
            if (count($variant['options'])) {
                $variants[] = $variant;
            }
        }
        if ($html->find('[data-ray-component="PDPColorsDivComponent"]', 0)) {
            $variant = $this->getSizeVariant($html);
            if (count($variant['options'])) {
                $variants[] = $variant;
            }
        }

        return $variants;
    }

    public function getProductVariants($variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                $options[] = $option;
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('latostadora.com', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('latostadora', $_SERVER['SERVER_NAME'], $content);
        return trim($retVal);
    }

    public function getGalleries($html) {
        $retVal = [];

        $elements = $html->find('#js-pdpSliderWrapper .c-pdp-slider__thumbnail');
        if ($elements && count($elements)) {
            foreach ($elements as $element) {
                $img = $element->find('img', 0);
                if ($img && $img->getAttribute('src')) {
                    $retVal[] = str_replace('w:120', 'w:520', $img->getAttribute('src'));
                }
            }
        }

        if (count($retVal) > 1) {
            $imageUrl = $retVal[1];
            unset($retVal[1]);
            array_unshift($retVal, $imageUrl);
        }

        return $retVal;
    }
}
