<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class LionLegionService extends BaseService
{
    static $config = [];
    public function parseHTML($htmlStr, $url) {
        $html = str_get_html($htmlStr);
        self::$config = $this->getConfig();
        $crawlCode = str_replace('/', '', parse_url($url)['path']);
        $designCrawlCode = $this->getDesignCrawlCode($html);
        $nameEle = $html->find('.product-title', 0);
        if ($nameEle) {
            $name = strip_tags($nameEle->innertext);
        }

        $galleries = $this->getGalleries($html);
        $imageUrl = array_shift($galleries);
        if (!$this->getGallery) {
            $galleries = [];
        }
        $variants = $this->getVariants($html);
        $price = $this->getProductMeta($html, 'meta[property="product:price:amount"]');
        $productVariants = $this->getProductVariants($html, $variants, $price);

        return [
            'name' => $name,
            'description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'content' => '',
            'image_url' => $imageUrl,
            'galleries' => $galleries,
            'price' => $price,
            'high_price' => 0,
            'note' => 'lionlegion url: ' . $url,
            'crawl_code' => $crawlCode,
            'site' => 'lionlegion',
            'comments' => [],
            'meta_title' => $this->getProductMeta($html, 'meta[property="og:title"]'),
            'meta_description' => $this->getProductMeta($html, 'meta[property="og:description"]'),
            'meta_keywords' => $this->getProductMeta($html, 'meta[name=keywords]'),
            'is_fast_shipment' => 0,
            'related_products' => [],
            'tags' => [],
            'design_crawl_code' => $designCrawlCode,
            'store_link' => '',
            'variants' => $variants,
            'product_variants' => $productVariants,
        ];
    }

    public function getDesignCrawlCode($html) {
        $elements = $html->find('#productType type-button');
        $retVal = '';
        if ($elements && count($elements)) {
            $map = [];
            foreach ($elements as $element) {
                $text = trim($element->getAttribute('data-handle'));
                if ($text) {
                    $arr = explode('-', $text);
                    for ($i = 0; $i < count($arr); $i++) {
                        $tmpArr = array_slice($arr, 0, $i + 1);
                        $tmpStr = implode('-', $tmpArr);
                        if (!isset($map[$tmpStr])) {
                            $map[$tmpStr] = 0;
                        }
                        $map[$tmpStr]++;
                    }
                }
            }
            uksort($map, function ($a, $b) use ($map) {
                if ($map[$b] == $map[$a]) {
                    return strlen($b) - strlen($a);
                }
                return $map[$b] - $map[$a];
            });
            foreach ($map as $key => $value) {
                $retVal = $key;
                break;
            }
        }

        return $retVal;
    }

    public function getVariants($html) {
        $variants = [];
        $elements = $html->find('.swatch-type');
        if ($elements && count($elements)) {
            foreach ($elements as $element) {
                $nameEle = $element->find('.product-form-label', 0);
                if (!$nameEle) {
                    continue;
                }
                $name = trim(strip_tags($nameEle->innertext));
                if ($name) {
                    $variantSlug = $this->toFriendlyString($name);
                    $variant = [
                        'name' => $name,
                        'slug' => $variantSlug,
                        'options' => [],
                        'type' => 'OPTION'
                    ];

                    $optionEles = $element->find('.swatch-element');
                    foreach ($optionEles as $optionEle) {
                        $optionName = $optionEle->getAttribute('data-swatch');
                        if ($optionName) {
                            $option = [
                                'name' => $optionName,
                                'slug' => $this->toFriendlyString($optionName),
                                'variant_slug' => $variantSlug
                            ];
                            $variant['options'][] = $option;
                        }
                    }

                    if (count($variant['options'])) {
                        $variants[] = $variant;
                    }
                }
            }
        }

        return $variants;
    }

    public function getProductVariants($html, $variants, $price) {
        $retVal = [];

        $variantOptionSlugs = [];
        $optionBySlugs = [];
        foreach ($variants as $variant) {
            $slugs = [];
            foreach ($variant['options'] as $option) {
                $slugs[] = $option['slug'];
                $optionBySlugs[$option['slug']] = $option;
            }
            $variantOptionSlugs[] = $slugs;
        }
        $allSkuEles = $html->find('#all-product-variants option');
        $imageUrlByOptionSlug = [];
        foreach ($allSkuEles as $ele) {
            $optionKey = str_replace(' ', '-', strtolower(trim($ele->getAttribute('data-options'))));
            $imageUrlByOptionSlug[$optionKey] = 'https://lionlegion.co.uk/cdn/shop/' . $ele->getAttribute('data-image');
        }

        $combinations = $this->combinations($variantOptionSlugs);
        foreach ($combinations as $listSlug) {
            if (!is_array($listSlug)) {
                $listSlug = [$listSlug];
            }
            $itemVariant = [
                'image_url' => '',
                'galleries' => [],
                'price' => $price,
                'high_price' => 0,
                'variants' => []
            ];
            $options = [];
            $optionKey = [];
            foreach ($listSlug as $slug) {
                $option = $optionBySlugs[$slug];
                if (!empty($option['image_url'])) {
                    $itemVariant['image_url'] = str_replace('50x50', '670x890', $option['image_url']);
                }
                $optionKey[] = str_replace(' ', '-', strtolower(trim($option['name'])));
                $options[] = $option;
            }
            if (isset($imageUrlByOptionSlug[implode(',', $optionKey)])) {
                $itemVariant['image_url'] = $imageUrlByOptionSlug[implode(',', $optionKey)];
            }

            $itemVariant['variants'] = $options;

            if (count($options)) {
                $retVal[] = $itemVariant;
            }
        }

        return $retVal;
    }

    private function getProductMeta ($html, $element) {
        $retVal = '';
        $metaTitleElements = $html->find($element, 0);
        if ($metaTitleElements) {
            $retVal = $metaTitleElements->attr['content'];
            $retVal = $this->replaceDomain($retVal);
            $retVal = trim($retVal);
        }
        return $retVal;
    }

    private function replaceDomain ($content) {
        $content = str_ireplace('beebubble.com', $_SERVER['SERVER_NAME'], $content);
        $retVal = str_ireplace('beebubble', $_SERVER['SERVER_NAME'], $content);
        return trim($retVal);
    }

    public function getGalleries($html) {
        $retVal = [];

        $element = $html->find('.product-slider .slick-active', 0);
        if ($element) {
            $img = $element->find('img', 0);
            if ($img && $img->getAttribute('src')) {
                $retVal[] = 'https:' . substr($img->getAttribute('src'), 0, strpos($img->getAttribute('src'), '?'));
            }
        }

        return $retVal;
    }
}
