<?php
namespace App\Modules\CrawlProduct\Controllers\Services;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class PawfectHouseService extends BaseService
{
    public $config = [];
    public $input = [];

    public function __construct($input)
    {
        $this->input = $input;
        parent::__construct($input);
    }

    public function crawl ($url) {
        $htmlStr = $this->getHtml($url);
        return $this->parseHTML($htmlStr, $url);
    }

    private function getHtml($url) {
        $html = file_get_html($url, false, stream_context_create([
            'http' => [
                'method' => 'GET',
                'header' => 'Accept-language: en\r\n' . 'User-Agent: ' . $this->userAgent . '\r\n'
            ]
        ]));
        return $html;
    }

    public function parseHTML($htmlStr, $url) {
        $partUrl = parse_url($url);
        $paths = explode('/', $partUrl['path']);
        $slug = end($paths);

        $this->config = $this->getConfig();
        $html = str_get_html($htmlStr);
        $productObj = $this->getProductData($html);
        if (!$this->getGallery) {
            $productObj['gallery'] = [];
        }
        $asin = $this->generateAsin($url);
        $productObj['gallery'] = array_slice($productObj['gallery'], 0, 2);

        $data = [
            'name' => $productObj['name'],
            'description' => '',
            'content' => '',
            'image_url' => $productObj['image'],
            'galleries' => $productObj['gallery'],
            'price' => $productObj['price'],
            'high_price' => 0,
            'note' => 'Pawfecthouse url: ' . $url,
            'crawl_code' => md5($asin),
            'site' => 'pawfecthouse',
            'comments' => [],
            'meta_title' => $productObj['name'],
            'meta_description' => $this->getProductMeta($html, 'meta[name=description]'),
            'meta_keywords' => '',
            'ex_tags' => ['Personalization'],
            'metas' => [
                [
                    'key' => 'is_custom_design',
                    'value' => 1
                ]
            ],
            'custom_design_type' => 'customily',
            'customily' => [
                'slug' => $slug,
                'shop' => (!empty($productObj['shop_url'])) ? $productObj['shop_url'] : 'thepawfecthouse.myshopify.com'
            ],
            'variants' => $productObj['variants'],
            'product_variants' => $productObj['product_variants']
        ];

        return $data;
    }

    private function getProductData ($html) {
        $retval = null;
        $nameEle = $html->find('.product_name', 0);
        $product = array();
        $product['name'] = '';
        if ($nameEle) {
            if ($nameEle->find('a', 0)) {
                $product['name'] = trim($nameEle->find('a', 0)->innertext);
            } else {
                $product['name'] = trim($nameEle->innertext);
            }
        }
        if (!$product['name']) {
            $product['name'] = $this->getProductMeta($html, 'meta[name="title"]');
        }
        if (!$product['name']) {
            $product['name'] = $this->getProductMeta($html, 'meta[name="og:title"]');
        }
        $priceEle = $html->find('.modal_price .price-ui .price .money', 0);
        if ($priceEle) {
            $product['price'] = $priceEle->content;
        }
        preg_match('/Shopify.shop = "(.*)"/', $html, $shopUrlMatches);
        if (!empty($shopUrlMatches[1])) {
            $product['shop_url'] = $shopUrlMatches[1];
        }
        $product['gallery'] = [];
        $product['variants'] = $this->getDataVariants($html);
        $gallery = $html->find('.gallery-cell');
        foreach ($gallery as $key => $image) {
            if ($image->children(0)->hasAttribute('href')) {
                $url = $image->children(0)->href;
                if ($key == 0) {
                    $product['image'] = $this->upcloudImage($url);
                } else {
                    array_push($product['gallery'], $this->upcloudImage($url));
                }
            }
        }
        $product['product_variants'] = $this->getProductVariants($product);
        $retval = $product;
        return $retval;
    }

    public function upcloudImage ($url) {
        $url = 'https:' . $url;
        $url = explode('?', $url)[0];
        $crawlController = new \Modules\Customization\Controllers\CrawlerController();
        $response = $crawlController->getFile($url);
        return $response;
    }

    private function getProductMeta ($html, $meta) {
        $retval = '';
        $metaTitleElements = $html->find($meta, 0);
        if ($metaTitleElements) {
            $retval = $metaTitleElements->attr['content'];
        }
        return $retval;
    }
    
    public function getDataVariants ($html) {
        $retval = [];
        $keys = $html->find('.option_title div span');
        $check = [true, true, true, true];
        $count = 0;
        foreach ($keys as $value) {
            if (str_contains($value->innertext, 'Size') ||
                str_contains($value->innertext, 'size')
                && $check[0]) 
            {
                $check[0] = false;
                $size = [
                    'name' => 'Size',
                    'slug' => 'size',
                    'options' => $this->getDataVariant($html, $count),
                ];
                array_push($retval, $size);
                $count++;
            } else if (str_contains($value->innertext, 'Color') ||
                    str_contains($value->innertext, 'color')
                    && $check[1]) 
            {
                $check[1] = false;
                $color = [
                    'name' => 'Color',
                    'slug' => 'color',
                    'options' => $this->getDataVariant($html, $count),
                ];
                array_push($retval, $color);
                $count++;
            } else if (str_contains($value->innertext, 'Product') ||
                    str_contains($value->innertext, 'product') 
                    && $check[2]) {
                $check[2] = false;
                $style = [
                    'name' => 'Style',
                    'slug' => 'style',
                    'options' => $this->getDataVariant($html, $count),
                ];
                array_push($retval, $style);
                $count++;
            } else if ($check[3] && $check[2]) {
                $check[3] = false;
                $type = [
                    'name' => 'Type',
                    'slug' => 'type',
                    'display_name' => trim($value->innertext),
                    'options' => $this->getDataVariant($html, $count),
                ];
                array_push($retval, $type);
                $count++;
            }
        }
        return $retval;
    }

    public function getDataVariant ($html, $count) {
        $retval = [];
        $items = $html->find('input[type=radio][name=option-' . $count . ']');
        foreach ($items as $item) {
            $data = [
                'name' => $item->attr['value'],
                'slug' => $this->convertToSlug($item->attr['value']),
                'type' => 'RADIOBOX'
            ];
            array_push($retval, $data);
        }
        return $retval;
    }

    public function convertToSlug ($str) {
        $str = str_replace(' ', '-', $str);
        $str = str_replace('---', '-', $str);
        $str = mb_strtolower($str);
        return $str;
    }

    public function getProductVariants ($product) {
        $retval = [];
        $arr = [];
        foreach ($product['variants'] as $key => $variant) {
            $temp = [];
            foreach ($variant['options'] as $value) {
                array_push($temp, $value['slug']);
            }
            array_push($arr, $temp);
        }
        $variants = $this->combinations($arr);
        foreach ($variants as $choice) {
            $newChoice = [];
            if (is_array($choice)) {
                foreach ($choice as $element) {
                    $temp = [
                        'variant_slug' => $this->getVariantSlug($product, $element),
                        'slug' => $this->convertToSlug($element)
                    ];
                    array_push($newChoice, $temp);
                }
            } else {
                $temp = [
                    'variant_slug' => $this->getVariantSlug($product, $choice),
                    'slug' => $this->convertToSlug($choice)
                ];
                array_push($newChoice, $temp);
            }
            $item = [
                'galleries' => [],
                'high_price' => 0,
                'price' => $product['price'],
                'image_url' => '',
                'variants' => $newChoice
            ];
            array_push($retval, $item);
        }
        return $retval;
    }

    public function getVariantSlug($product, $slug) {
        $retval = '';
        $variants = $product['variants'];
        foreach ($variants as $variant) {
            foreach ($variant['options'] as $option) {
                if ($option['slug'] == $slug) {
                    return $variant['slug'];
                }
            }
        }
        return $retval;
    }

}