<?php

namespace App\Modules\CrawlProduct\Controllers\Services;

use Modules\CrawlProduct\Models\Product;

include_once '../app/Modules/CrawlProduct/Helpers/simple_html_dom.php';

class RedBubbleService extends BaseService
{
    public function parseHTML($htmlStr, $url) {
        ini_set('memory_limit', '2048M');
        preg_match("/window\.__APOLLO_STATE__=([^<\/]+);\s*<\/script>/", $htmlStr, $matches);
        $html = str_get_html($htmlStr);
        $script = $html->find('#__NEXT_DATA__', 0);
        if ($script) {
            return $this->parseHTMLV2($htmlStr, $url);
        }
        $parseUrl = parse_url($url);
        if (!($matches && count($matches) > 1)) {
            return [
                'name' => ''
            ];
        }
        $data = $matches[1];
        $data = preg_replace("/(\s+)([\w]+):/", "$1\"$2\"", $data);
        $data = json_decode($data, true);
        $crawlCode = substr($parseUrl['path'], strpos($parseUrl['path'], '/i/') + 3);
        $crawlCode = substr($crawlCode, 0, strripos($crawlCode, '.') - 1);
        $result = [
            'name'  => '',
            'slug' => '',
            'description'  => '',
            'content'  => '',
            'image_url'  => '',
            'galleries'  => [],
            'price'  => '',
            'high_price'  => '',
            'note'  => 'Redbuble url: ' . $url,
            'crawl_code'  => md5($crawlCode),
            'design_crawl_code' => '',
            'site'  => 'redbubble',
            'comments'  => '',
            'meta_title'  => '',
            'meta_description'  => '',
            'meta_keywords'  => '',
            'is_fast_shipment' => '',
            'related_products'  => '',
            'tags' => [],
            'store_link' => $this->getStoreLink($html)
        ];
        $workId = 0;
        $categoryId = null;
        foreach ($data as $key => $value) {
            if (strpos($key, 'Work') === 0) {
                $workId = $value['id'];
                $data['design_crawl_code'] = $workId;
                $result['name'] = $this->parseText($value['title']);
                $result['meta_title'] = $result['name'];
                $tags = $value['tags']['json'];
                $result['tags'] = [];
                foreach ($tags as $item) {
                    $result['tags'][] = $this->parseText($item);
                }
                $result['meta_keywords'] = implode(',', $result['tags']);
                $result['description'] = $this->parseText($value['description']);
                $result['meta_description'] = $this->parseText($value['description']);
                break;
            }
        }
        foreach ($data['ROOT_QUERY'] as $key => $item) {
            if (strpos($key, 'defaultCategoryId') === 0) {
                $categoryId = $item;
            }
        }

        if (!$workId || !$categoryId) {
            return $result;
        }

        $variantDataKey = 'inventory_CategorySet' . $workId . '_' . $categoryId;
        
        $variantData = $data[$variantDataKey];
        $categoryName = $this->parseText($variantData['categoryName']);
        $result['name'] .= ' ' . $categoryName;
        $result['slug'] = strToSlug($result['name']);

        $configurationSet = $variantData['configurationSet'];
        $variantItems = $variantData['items'];
        $variants = [];
        $ignoreVariants = [
            'configuration', 'printLocation'
        ];
        foreach($configurationSet as $item) {
            $variant = $data[$item['id']];
            $name = $this->parseText($variant['name']);
            if (in_array($name, $ignoreVariants)) {
                continue;
            }
            $slug = $this->toFriendlyString($name);
            $name = $this->translateName($slug, $name);
            $name = ucfirst($name);
            if (!isset($variants[$name])) {
                $slug = $this->toFriendlyString($name);
                $variants[$slug] = [
                    'name' => $name,
                    'slug' => $slug,
                    'type' => 'OPTION',
                    'options' => []
                ];
            }
        }

        $productVariants = [];
        $defaultItem = $variantData['defaultItem'];
        foreach ($variantData['items'] as $item) {
            if (
                !empty($item['productPageUrl']) 
                && $item['productPageUrl'] == $url
            ) {
                $defaultItem = $item;
            }
        }
        $defaultVariant = null;
        foreach ($variantItems as $item) {
            $sku = $data[$item['id']];
            $productVariant = [
                'galleries' => [],
                'price' => $data[$sku['price']['id']]['amount'],
                'high_price' => 0,
                'image_url' => '',
                'is_default' => 0,
                'variants' => []
            ];

            $attributes = $sku['attributes'];
            $previewSet = $data[$sku['previewSet']['id']]['previews'];
            $isIgnore = false;
            foreach ($attributes as $attribute) {
                $variantNameRaw = $this->parseText($data[$attribute['id']]['name']);
                $isValid = true;
                if (in_array($variantNameRaw, $ignoreVariants)) {
                    $isValid = false;
                }
                $slug = $this->toFriendlyString($variantNameRaw);
                $variantName = $this->translateName($slug, $variantNameRaw);
                $variantName = ucfirst($variantName);
                $optionData = $data[$attribute['id']];
                if ($variantNameRaw == 'printLocation' && $optionData['value'] == 'back') {
                    $isIgnore = true;
                    break;
                }
                $attrs = $optionData['attributes'];
                $option = [
                    'name' => '',
                    'slug' => '',
                    'variant_slug' => $this->toFriendlyString($variantName)
                ];
                foreach ($attrs as $attr) {
                    if ($data[$attr['id']]['name'] == 'defaultText') {
                        $optionName = $this->parseText($data[$attr['id']]['value']);
                        $optionSlug = $this->toFriendlyString($optionName);
                        $option['name'] = $this->translateName($option['variant_slug'] . '.' . $optionSlug, $optionName);
                        $option['slug'] = $this->toFriendlyString($option['name']);
                        if ($isValid) {
                            $productVariant['variants'][] = $option;
                            if (isset($variants[$option['variant_slug']]['options'])) {
                                $variants[$option['variant_slug']]['options'][$option['slug']] = $option;
                            }
                            
                        }
                        break;
                    }
                }
            }
            if ($isIgnore) { 
                continue;
            }
            $gallery = [];
            foreach ($previewSet as $previewId) {
                $preview = $data[$previewId['id']];
                if(
                    strpos($preview['previewTypeId'], 'primary_square') !== false ||
                    $preview['previewTypeId'] == 'artwork' || 
                    strpos($preview['previewTypeId'], 'supplementary') !== false
                ) {
                    $sorder = strpos($preview['previewTypeId'], 'primary_square') !== false ? -1 : 
                        str_replace('supplementary', '', $preview['previewTypeId']);
                    if (!$sorder || !is_numeric($sorder)) {
                        $sorder = 0;
                    }
                    $gallery[] = [
                        'image_url' => $this->parseText($preview['url']),
                        'sorder' => $sorder
                    ];
                }
            }

            usort($gallery, function ($a, $b) {
                return $a['sorder'] - $b['sorder'];
            });

            $images = array_map(function ($image) { return $image['image_url']; }, $gallery);
            $productVariant['image_url'] = array_shift($images);
            $productVariant['galleries'] = $images;

            if (!$this->getGallery) {
                $productVariant['galleries'] = [];
            }

            if($item['id'] == $defaultItem['id']) {
                $defaultVariant = $productVariant;
            }

            $productVariants[] = $productVariant;
        }

        if (!$defaultVariant && count($productVariants)) {
            $defaultVariant = $productVariants[0];
        }

        if (!empty($defaultVariant)) {
            $result['price'] = $defaultVariant['price'];
            $result['high_price'] = $defaultVariant['high_price'];
            $result['image_url'] = $defaultVariant['image_url'];
            $result['galleries'] = $defaultVariant['galleries'];
            if (!$this->getGallery) {
                $result['galleries'] = [];
            }
        }

        $result['variants'] = $variants;
        $result['product_variants'] = $productVariants;

        return $result;
    }

    public function parseHTMLV2($htmlStr, $url) {
        ini_set('memory_limit', '2048M');
        $html = str_get_html($htmlStr);
        $script = $html->find('#__NEXT_DATA__', 0);
        $parseUrl = parse_url($url);
        if (!$script) {
            return [
                'name' => ''
            ];
        }
        $data = json_decode(trim($script->innertext), true);
        if (empty($data) || empty($data['props']['pageProps'])) {
            return [
                'name' => ''
            ];
        }
        $data = $data['props']['pageProps'];
        $crawlCode = substr($parseUrl['path'], strpos($parseUrl['path'], '/i/') + 3);
        $crawlCode = substr($crawlCode, 0, strripos($crawlCode, '.') - 1);
        $variantData = $data['inventoryCategorySet'];
        $defaultItem = $variantData['defaultItem'];
        $crawlCode = isset($defaultItem['gaCode']) > 0 ? $defaultItem['gaCode'] . '_' . $crawlCode : $crawlCode;
        $result = [
            'name'  => '',
            'slug' => '',
            'description'  => '',
            'content'  => '',
            'image_url'  => '',
            'galleries'  => [],
            'price'  => '',
            'high_price'  => '',
            'note'  => 'Redbuble url: ' . $url,
            'crawl_code'  => md5($crawlCode),
            'design_crawl_code' => '',
            'site'  => 'redbubble',
            'comments'  => '',
            'meta_title'  => '',
            'meta_description'  => '',
            'meta_keywords'  => '',
            'is_fast_shipment' => '',
            'related_products'  => '',
            'tags' => [],
            'store_link' => $this->getStoreLink($html)
        ];

        foreach ($variantData['items'] as $item) {
            if (
                !empty($item['productPageUrl']) 
                && $item['productPageUrl'] == $url
            ) {
                $item['work'] = $defaultItem['work'];
                $defaultItem = $item;
            }
        }
        $result['design_crawl_code'] = $defaultItem['workId'];
        $categoryName = $this->parseText($variantData['categoryName']);
        $result['name'] = $defaultItem['work']['title'] . ' ' . $categoryName;
        $result['slug'] = strToSlug($result['name']);

        $configurationSet = $variantData['configurationSet'];
        $variantItems = $variantData['items'];
        $variants = [];
        $ignoreVariants = [
            'configuration', 'printLocation'
        ];
        foreach($configurationSet as $item) {
            $name = $this->parseText($item['name']);
            if (in_array($name, $ignoreVariants)) {
                continue;
            }
            $slug = $this->toFriendlyString($name);
            $name = $this->translateName($slug, $name);
            $name = ucfirst($name);
            if (!isset($variants[$name])) {
                $slug = $this->toFriendlyString($name);
                $variants[$slug] = [
                    'name' => $name,
                    'slug' => $slug,
                    'type' => 'OPTION',
                    'options' => []
                ];
            }
        }

        $productVariants = [];

        $defaultVariant = null;
        foreach ($variantItems as $sku) {
            $productVariant = [
                'galleries' => [],
                'price' => $sku['price']['amount'],
                'high_price' => 0,
                'image_url' => '',
                'is_default' => 0,
                'variants' => []
            ];

            $attributes = $sku['attributes'];
            $previewSet = $sku['previewSet'];
            $isIgnore = false;
            foreach ($attributes as $attribute) {
                $variantNameRaw = $this->parseText($attribute['name']);
                $isValid = true;
                if (in_array($variantNameRaw, $ignoreVariants)) {
                    $isValid = false;
                }
                $slug = $this->toFriendlyString($variantNameRaw);
                $variantName = $this->translateName($slug, $variantNameRaw);
                $variantName = ucfirst($variantName);
                if ($variantNameRaw == 'printLocation' && $attribute['value'] == 'back') {
                    $isIgnore = true;
                    break;
                }
                $attrs = $attribute['attributes'];
                $option = [
                    'name' => '',
                    'slug' => '',
                    'variant_slug' => $this->toFriendlyString($variantName)
                ];
                foreach ($attrs as $attr) {
                    if ($attr['name'] == 'defaultText') {
                        $optionName = $this->parseText($attr['value']);
                        $optionSlug = $this->toFriendlyString($optionName);
                        $option['name'] = $this->translateName($option['variant_slug'] . '.' . $optionSlug, $optionName);
                        $option['slug'] = $this->toFriendlyString($option['name']);
                        if ($isValid) {
                            $productVariant['variants'][] = $option;
                            if (isset($variants[$option['variant_slug']]['options'])) {
                                $variants[$option['variant_slug']]['options'][$option['slug']] = $option;
                            }
                            
                        }
                        break;
                    }
                }
            }
            if ($isIgnore) { 
                continue;
            }
            $gallery = [];
            foreach ($previewSet['previews'] as $preview) {
                if(
                    strpos($preview['previewTypeId'], 'primary_square') !== false ||
                    $preview['previewTypeId'] == 'artwork' || 
                    strpos($preview['previewTypeId'], 'supplementary') !== false
                ) {
                    $sorder = strpos($preview['previewTypeId'], 'primary_square') !== false ? -1 : 
                        str_replace('supplementary', '', $preview['previewTypeId']);
                    if (!$sorder || !is_numeric($sorder)) {
                        $sorder = 0;
                    }
                    $gallery[] = [
                        'image_url' => $this->parseText($preview['url']),
                        'sorder' => $sorder
                    ];
                }
            }

            usort($gallery, function ($a, $b) {
                return $a['sorder'] - $b['sorder'];
            });

            $images = array_map(function ($image) { return $image['image_url']; }, $gallery);
            $productVariant['image_url'] = array_shift($images);
            $productVariant['galleries'] = $images;

            if (!$this->getGallery) {
                $productVariant['galleries'] = [];
            }

            if($sku['id'] == $defaultItem['id']) {
                $defaultVariant = $productVariant;
            }

            $productVariants[] = $productVariant;
        }

        if (!$defaultVariant && count($productVariants)) {
            $defaultVariant = $productVariants[0];
        }

        if (!empty($defaultVariant)) {
            $result['price'] = $defaultVariant['price'];
            $result['high_price'] = $defaultVariant['high_price'];
            $result['image_url'] = $defaultVariant['image_url'];
            $result['galleries'] = $defaultVariant['galleries'];

            if (!$this->getGallery) {
                $result['galleries'] = [];
            }
        }

        $result['variants'] = $variants;
        $result['product_variants'] = $productVariants;

        return $result;
    }

    public function translateName($key, $name) {
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }

        $value = config('crawl-product::crawl-' . $locale . '.' . $key);
        if ($value) {
            if (!is_array($value)) {
                return $value;
            }

            return $name;
        }
        $option = \DB::table('option')->where('key', 'crawl-product::translate-name')->first();
        if ($option) {
            $config = json_decode($option->value, true);
            if (!empty($config)) {
                $slugs = explode('.', $key);
                if (count($slugs) == 2 && isset($config[$slugs[0]]) && isset($config[$slugs[0]][$slugs[1]]) && $config[$slugs[0]][$slugs[1]]) {
                    $name = $config[$slugs[0]][$slugs[1]];
                }
            }
        }

        return $name;
    }

    public function parseText($text, $uc = false) {
        preg_match_all("/{{([^}]+)}}/", $text, $matches);
        if (count($matches) > 1) {
            $retVal = $text;
            foreach ($matches[1] as $str) {
                $retVal = str_replace("{{" . $str . "}}", urldecode($str), $retVal);
            }
        }

        if ($uc) {
            $retVal = ucfirst($retVal);
        }

        return $retVal;
    }

    public function deleteProduct($input) {
        $hashCodes = [];
        foreach ($input['codes'] as $code) {
            $hashCodes = md5($code);
        }
        $productIds = DB::table('product_crawl_code')
            ->where('site', 'redbubble')
            ->whereIn('value', $hashCodes)
            ->get(['product_id'])
            ->pluck('product_id')
            ->toArray();

        foreach (array_chunk($productIds, 500) as $partIds) {
            Product::whereIn('id', $partIds)
                ->update([
                    'status' => 'PENDING'
                ]);
        }

        return $productIds;
    }

    public function getStoreLink($html) {
        $retVal = '';

        $element = $html->find('[class*=ProductConfiguration__artistLink]', 0);
        
        if ($element) {
            $retVal = trim($element->href);
            if ($retVal && $retVal[0] == '/') {
                $retVal = 'https://www.redbubble.com' . $retVal;
            }
        }

        return $retVal;
    }
}